// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing Action Group for Amazon Bedrock Agent
func (c *Client) UpdateAgentActionGroup(ctx context.Context, params *UpdateAgentActionGroupInput, optFns ...func(*Options)) (*UpdateAgentActionGroupOutput, error) {
	if params == nil {
		params = &UpdateAgentActionGroupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAgentActionGroup", params, optFns, c.addOperationUpdateAgentActionGroupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAgentActionGroupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Update Action Group Request
type UpdateAgentActionGroupInput struct {

	// Id generated at the server side when an Action Group is created under Agent
	//
	// This member is required.
	ActionGroupId *string

	// Name for a resource.
	//
	// This member is required.
	ActionGroupName *string

	// Id generated at the server side when an Agent is created
	//
	// This member is required.
	AgentId *string

	// Draft Version of the Agent.
	//
	// This member is required.
	AgentVersion *string

	// Type of Executors for an Action Group
	ActionGroupExecutor types.ActionGroupExecutor

	// State of the action group
	ActionGroupState types.ActionGroupState

	// Contains information about the API Schema for the Action Group
	ApiSchema types.APISchema

	// Description of the Resource.
	Description *string

	// Action Group Signature for a BuiltIn Action
	ParentActionGroupSignature types.ActionGroupSignature

	noSmithyDocumentSerde
}

// Update Action Group Response
type UpdateAgentActionGroupOutput struct {

	// Contains the information of an Agent Action Group
	//
	// This member is required.
	AgentActionGroup *types.AgentActionGroup

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAgentActionGroupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateAgentActionGroup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateAgentActionGroup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAgentActionGroup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateAgentActionGroupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAgentActionGroup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateAgentActionGroup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAgentActionGroup",
	}
}
