// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// input to lambda used in action group
type ActionGroupInvocationInput struct {

	// Agent Trace Action Group Name
	ActionGroupName *string

	// Agent Trace Action Group API path
	ApiPath *string

	// list of parameters included in action group invocation
	Parameters []Parameter

	// Request Body Content Map
	RequestBody *RequestBody

	// Agent Trace Action Group Action verb
	Verb *string

	noSmithyDocumentSerde
}

// output from lambda used in action group
type ActionGroupInvocationOutput struct {

	// Agent Trace Action Group Lambda Invocation Output String
	Text *string

	noSmithyDocumentSerde
}

// Citations associated with final agent response
type Attribution struct {

	// List of citations
	Citations []Citation

	noSmithyDocumentSerde
}

// Citation associated with the agent response
type Citation struct {

	// Generate response part
	GeneratedResponsePart *GeneratedResponsePart

	// list of retrieved references
	RetrievedReferences []RetrievedReference

	noSmithyDocumentSerde
}

// Trace Part which is emitted when agent trace could not be generated
type FailureTrace struct {

	// Agent Trace Failed Reason String
	FailureReason *string

	// Identifier for trace
	TraceId *string

	noSmithyDocumentSerde
}

// Agent finish output
type FinalResponse struct {

	// Agent Trace Action Group Lambda Invocation Output String
	Text *string

	noSmithyDocumentSerde
}

// Generate response part
type GeneratedResponsePart struct {

	// Text response part
	TextResponsePart *TextResponsePart

	noSmithyDocumentSerde
}

// Configurations for controlling the inference response of an InvokeAgent API call
type InferenceConfiguration struct {

	// Maximum length of output
	MaximumLength *int32

	// List of stop sequences
	StopSequences []string

	// Controls randomness, higher values increase diversity
	Temperature *float32

	// Sample from the k most likely next tokens
	TopK *int32

	// Cumulative probability cutoff for token selection
	TopP *float32

	noSmithyDocumentSerde
}

// Trace Part which contains input details for action group or knowledge base
type InvocationInput struct {

	// input to lambda used in action group
	ActionGroupInvocationInput *ActionGroupInvocationInput

	// types of invocations
	InvocationType InvocationType

	// Input to lambda used in action group
	KnowledgeBaseLookupInput *KnowledgeBaseLookupInput

	// Identifier for trace
	TraceId *string

	noSmithyDocumentSerde
}

// Input to lambda used in action group
type KnowledgeBaseLookupInput struct {

	// Agent Trace Action Group Knowledge Base Id
	KnowledgeBaseId *string

	// Agent Trace Action Group Lambda Invocation Output String
	Text *string

	noSmithyDocumentSerde
}

// Input to lambda used in action group
type KnowledgeBaseLookupOutput struct {

	// list of retrieved references
	RetrievedReferences []RetrievedReference

	noSmithyDocumentSerde
}

// Knowledge base input query.
type KnowledgeBaseQuery struct {

	// Knowledge base input query in text
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Search parameters for retrieving from knowledge base.
type KnowledgeBaseRetrievalConfiguration struct {

	// Knowledge base vector search configuration
	//
	// This member is required.
	VectorSearchConfiguration *KnowledgeBaseVectorSearchConfiguration

	noSmithyDocumentSerde
}

// Result item returned from a knowledge base retrieval.
type KnowledgeBaseRetrievalResult struct {

	// Content of a retrieval result.
	//
	// This member is required.
	Content *RetrievalResultContent

	// The source location of a retrieval result.
	Location *RetrievalResultLocation

	// The relevance score of a result.
	Score *float64

	noSmithyDocumentSerde
}

// Configurations for retrieval and generation for knowledge base.
type KnowledgeBaseRetrieveAndGenerateConfiguration struct {

	// Identifier of the KnowledgeBase
	//
	// This member is required.
	KnowledgeBaseId *string

	// Arn of a Bedrock model.
	//
	// This member is required.
	ModelArn *string

	// Search parameters for retrieving from knowledge base.
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// Knowledge base vector search configuration
type KnowledgeBaseVectorSearchConfiguration struct {

	// Top-K results to retrieve from knowledge base.
	NumberOfResults *int32

	// Override the type of query to be performed on data store
	OverrideSearchType SearchType

	noSmithyDocumentSerde
}

// Trace Part which contains information used to call Invoke Model
type ModelInvocationInput struct {

	// Configurations for controlling the inference response of an InvokeAgent API call
	InferenceConfiguration *InferenceConfiguration

	// ARN of a Lambda.
	OverrideLambda *string

	// indicates if agent uses default prompt or overriden prompt
	ParserMode CreationMode

	// indicates if agent uses default prompt or overriden prompt
	PromptCreationMode CreationMode

	// Prompt Message
	Text *string

	// Identifier for trace
	TraceId *string

	// types of prompts
	Type PromptType

	noSmithyDocumentSerde
}

// Trace Part which contains output details for action group or knowledge base or
// final response
type Observation struct {

	// output from lambda used in action group
	ActionGroupInvocationOutput *ActionGroupInvocationOutput

	// Agent finish output
	FinalResponse *FinalResponse

	// Input to lambda used in action group
	KnowledgeBaseLookupOutput *KnowledgeBaseLookupOutput

	// Observation information if there were reprompts
	RepromptResponse *RepromptResponse

	// Identifier for trace
	TraceId *string

	// types of observations
	Type Type

	noSmithyDocumentSerde
}

// Trace contains intermidate response during orchestration
//
// The following types satisfy this interface:
//
//	OrchestrationTraceMemberInvocationInput
//	OrchestrationTraceMemberModelInvocationInput
//	OrchestrationTraceMemberObservation
//	OrchestrationTraceMemberRationale
type OrchestrationTrace interface {
	isOrchestrationTrace()
}

// Trace Part which contains input details for action group or knowledge base
type OrchestrationTraceMemberInvocationInput struct {
	Value InvocationInput

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberInvocationInput) isOrchestrationTrace() {}

// Trace Part which contains information used to call Invoke Model
type OrchestrationTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberModelInvocationInput) isOrchestrationTrace() {}

// Trace Part which contains output details for action group or knowledge base or
// final response
type OrchestrationTraceMemberObservation struct {
	Value Observation

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberObservation) isOrchestrationTrace() {}

// Trace Part which contains information related to reasoning
type OrchestrationTraceMemberRationale struct {
	Value Rationale

	noSmithyDocumentSerde
}

func (*OrchestrationTraceMemberRationale) isOrchestrationTrace() {}

// parameters included in action group invocation
type Parameter struct {

	// Name of parameter
	Name *string

	// Type of parameter
	Type *string

	// Value of parameter
	Value *string

	noSmithyDocumentSerde
}

// Base 64 endoded byte response
type PayloadPart struct {

	// Citations associated with final agent response
	Attribution *Attribution

	// PartBody of the payload in bytes
	Bytes []byte

	noSmithyDocumentSerde
}

// Trace Part which contains information related to postprocessing
type PostProcessingModelInvocationOutput struct {

	// Trace Part which contains information if preprocessing was successful
	ParsedResponse *PostProcessingParsedResponse

	// Identifier for trace
	TraceId *string

	noSmithyDocumentSerde
}

// Trace Part which contains information if preprocessing was successful
type PostProcessingParsedResponse struct {

	// Agent Trace Output String
	Text *string

	noSmithyDocumentSerde
}

// Trace Part which contains information related to post processing step
//
// The following types satisfy this interface:
//
//	PostProcessingTraceMemberModelInvocationInput
//	PostProcessingTraceMemberModelInvocationOutput
type PostProcessingTrace interface {
	isPostProcessingTrace()
}

// Trace Part which contains information used to call Invoke Model
type PostProcessingTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*PostProcessingTraceMemberModelInvocationInput) isPostProcessingTrace() {}

// Trace Part which contains information related to postprocessing
type PostProcessingTraceMemberModelInvocationOutput struct {
	Value PostProcessingModelInvocationOutput

	noSmithyDocumentSerde
}

func (*PostProcessingTraceMemberModelInvocationOutput) isPostProcessingTrace() {}

// Trace Part which contains information related to preprocessing
type PreProcessingModelInvocationOutput struct {

	// Trace Part which contains information if preprocessing was successful
	ParsedResponse *PreProcessingParsedResponse

	// Identifier for trace
	TraceId *string

	noSmithyDocumentSerde
}

// Trace Part which contains information if preprocessing was successful
type PreProcessingParsedResponse struct {

	// Boolean value
	IsValid *bool

	// Agent Trace Rationale String
	Rationale *string

	noSmithyDocumentSerde
}

// Trace Part which contains information related to preprocessing step
//
// The following types satisfy this interface:
//
//	PreProcessingTraceMemberModelInvocationInput
//	PreProcessingTraceMemberModelInvocationOutput
type PreProcessingTrace interface {
	isPreProcessingTrace()
}

// Trace Part which contains information used to call Invoke Model
type PreProcessingTraceMemberModelInvocationInput struct {
	Value ModelInvocationInput

	noSmithyDocumentSerde
}

func (*PreProcessingTraceMemberModelInvocationInput) isPreProcessingTrace() {}

// Trace Part which contains information related to preprocessing
type PreProcessingTraceMemberModelInvocationOutput struct {
	Value PreProcessingModelInvocationOutput

	noSmithyDocumentSerde
}

func (*PreProcessingTraceMemberModelInvocationOutput) isPreProcessingTrace() {}

// Trace Part which contains information related to reasoning
type Rationale struct {

	// Agent Trace Rationale String
	Text *string

	// Identifier for trace
	TraceId *string

	noSmithyDocumentSerde
}

// Observation information if there were reprompts
type RepromptResponse struct {

	// Parsing error source
	Source Source

	// Reprompt response text
	Text *string

	noSmithyDocumentSerde
}

// Request Body Content Map
type RequestBody struct {

	// Content type paramter map
	Content map[string][]Parameter

	noSmithyDocumentSerde
}

// Response body of is a stream
//
// The following types satisfy this interface:
//
//	ResponseStreamMemberChunk
//	ResponseStreamMemberTrace
type ResponseStream interface {
	isResponseStream()
}

// Base 64 endoded byte response
type ResponseStreamMemberChunk struct {
	Value PayloadPart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberChunk) isResponseStream() {}

// Trace Part which contains intermidate response for customer
type ResponseStreamMemberTrace struct {
	Value TracePart

	noSmithyDocumentSerde
}

func (*ResponseStreamMemberTrace) isResponseStream() {}

// Content of a retrieval result.
type RetrievalResultContent struct {

	// Content of a retrieval result in text
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// The source location of a retrieval result.
type RetrievalResultLocation struct {

	// The location type of a retrieval result.
	//
	// This member is required.
	Type RetrievalResultLocationType

	// The S3 location of a retrieval result.
	S3Location *RetrievalResultS3Location

	noSmithyDocumentSerde
}

// The S3 location of a retrieval result.
type RetrievalResultS3Location struct {

	// URI of S3 location
	Uri *string

	noSmithyDocumentSerde
}

// Configures the retrieval and generation for the session.
type RetrieveAndGenerateConfiguration struct {

	// The type of RetrieveAndGenerate.
	//
	// This member is required.
	Type RetrieveAndGenerateType

	// Configurations for retrieval and generation for knowledge base.
	KnowledgeBaseConfiguration *KnowledgeBaseRetrieveAndGenerateConfiguration

	noSmithyDocumentSerde
}

// Customer input of the turn
type RetrieveAndGenerateInput struct {

	// Customer input of the turn in text
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Service response of the turn
type RetrieveAndGenerateOutput struct {

	// Service response of the turn in text
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Configures common parameters of the session.
type RetrieveAndGenerateSessionConfiguration struct {

	// The KMS key arn to encrypt the customer data of the session.
	//
	// This member is required.
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Retrieved reference
type RetrievedReference struct {

	// Content of a retrieval result.
	Content *RetrievalResultContent

	// The source location of a retrieval result.
	Location *RetrievalResultLocation

	noSmithyDocumentSerde
}

// Session state provided
type SessionState struct {

	// Prompt Session Attributes
	PromptSessionAttributes map[string]string

	// Session Attributes
	SessionAttributes map[string]string

	noSmithyDocumentSerde
}

// Span of text
type Span struct {

	// End of span
	End *int32

	// Start of span
	Start *int32

	noSmithyDocumentSerde
}

// Text response part
type TextResponsePart struct {

	// Span of text
	Span *Span

	// Response part in text
	Text *string

	noSmithyDocumentSerde
}

// Trace contains intermidate response for customer
//
// The following types satisfy this interface:
//
//	TraceMemberFailureTrace
//	TraceMemberOrchestrationTrace
//	TraceMemberPostProcessingTrace
//	TraceMemberPreProcessingTrace
type Trace interface {
	isTrace()
}

// Trace Part which is emitted when agent trace could not be generated
type TraceMemberFailureTrace struct {
	Value FailureTrace

	noSmithyDocumentSerde
}

func (*TraceMemberFailureTrace) isTrace() {}

// Trace contains intermidate response during orchestration
type TraceMemberOrchestrationTrace struct {
	Value OrchestrationTrace

	noSmithyDocumentSerde
}

func (*TraceMemberOrchestrationTrace) isTrace() {}

// Trace Part which contains information related to post processing step
type TraceMemberPostProcessingTrace struct {
	Value PostProcessingTrace

	noSmithyDocumentSerde
}

func (*TraceMemberPostProcessingTrace) isTrace() {}

// Trace Part which contains information related to preprocessing step
type TraceMemberPreProcessingTrace struct {
	Value PreProcessingTrace

	noSmithyDocumentSerde
}

func (*TraceMemberPreProcessingTrace) isTrace() {}

// Trace Part which contains intermidate response for customer
type TracePart struct {

	// Identifier of the agent alias.
	AgentAliasId *string

	// Identifier of the agent.
	AgentId *string

	// Identifier of the session.
	SessionId *string

	// Trace contains intermidate response for customer
	Trace Trace

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isOrchestrationTrace()  {}
func (*UnknownUnionMember) isPostProcessingTrace() {}
func (*UnknownUnionMember) isPreProcessingTrace()  {}
func (*UnknownUnionMember) isResponseStream()      {}
func (*UnknownUnionMember) isTrace()               {}
