// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagentruntime

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagentruntime/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpInvokeAgent struct {
}

func (*validateOpInvokeAgent) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpInvokeAgent) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*InvokeAgentInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpInvokeAgentInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRetrieveAndGenerate struct {
}

func (*validateOpRetrieveAndGenerate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRetrieveAndGenerate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RetrieveAndGenerateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRetrieveAndGenerateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRetrieve struct {
}

func (*validateOpRetrieve) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRetrieve) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RetrieveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRetrieveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpInvokeAgentValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpInvokeAgent{}, middleware.After)
}

func addOpRetrieveAndGenerateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRetrieveAndGenerate{}, middleware.After)
}

func addOpRetrieveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRetrieve{}, middleware.After)
}

func validateKnowledgeBaseQuery(v *types.KnowledgeBaseQuery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseQuery"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBaseRetrievalConfiguration(v *types.KnowledgeBaseRetrievalConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseRetrievalConfiguration"}
	if v.VectorSearchConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VectorSearchConfiguration"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateKnowledgeBaseRetrieveAndGenerateConfiguration(v *types.KnowledgeBaseRetrieveAndGenerateConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "KnowledgeBaseRetrieveAndGenerateConfiguration"}
	if v.KnowledgeBaseId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KnowledgeBaseId"))
	}
	if v.ModelArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ModelArn"))
	}
	if v.RetrievalConfiguration != nil {
		if err := validateKnowledgeBaseRetrievalConfiguration(v.RetrievalConfiguration); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetrieveAndGenerateConfiguration(v *types.RetrieveAndGenerateConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateConfiguration"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.KnowledgeBaseConfiguration != nil {
		if err := validateKnowledgeBaseRetrieveAndGenerateConfiguration(v.KnowledgeBaseConfiguration); err != nil {
			invalidParams.AddNested("KnowledgeBaseConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetrieveAndGenerateInput(v *types.RetrieveAndGenerateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateInput"}
	if v.Text == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Text"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetrieveAndGenerateSessionConfiguration(v *types.RetrieveAndGenerateSessionConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateSessionConfiguration"}
	if v.KmsKeyArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KmsKeyArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpInvokeAgentInput(v *InvokeAgentInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "InvokeAgentInput"}
	if v.AgentId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentId"))
	}
	if v.AgentAliasId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AgentAliasId"))
	}
	if v.SessionId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SessionId"))
	}
	if v.InputText == nil {
		invalidParams.Add(smithy.NewErrParamRequired("InputText"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRetrieveAndGenerateInput(v *RetrieveAndGenerateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveAndGenerateInput"}
	if v.Input == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Input"))
	} else if v.Input != nil {
		if err := validateRetrieveAndGenerateInput(v.Input); err != nil {
			invalidParams.AddNested("Input", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetrieveAndGenerateConfiguration != nil {
		if err := validateRetrieveAndGenerateConfiguration(v.RetrieveAndGenerateConfiguration); err != nil {
			invalidParams.AddNested("RetrieveAndGenerateConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.SessionConfiguration != nil {
		if err := validateRetrieveAndGenerateSessionConfiguration(v.SessionConfiguration); err != nil {
			invalidParams.AddNested("SessionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRetrieveInput(v *RetrieveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetrieveInput"}
	if v.KnowledgeBaseId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KnowledgeBaseId"))
	}
	if v.RetrievalQuery == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RetrievalQuery"))
	} else if v.RetrievalQuery != nil {
		if err := validateKnowledgeBaseQuery(v.RetrievalQuery); err != nil {
			invalidParams.AddNested("RetrievalQuery", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetrievalConfiguration != nil {
		if err := validateKnowledgeBaseRetrievalConfiguration(v.RetrievalConfiguration); err != nil {
			invalidParams.AddNested("RetrievalConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
