// Code generated by smithy-go-codegen DO NOT EDIT.

package clouddirectory

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/clouddirectory/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns all of the ObjectIdentifiers to which a given policy is attached.
func (c *Client) ListPolicyAttachments(ctx context.Context, params *ListPolicyAttachmentsInput, optFns ...func(*Options)) (*ListPolicyAttachmentsOutput, error) {
	if params == nil {
		params = &ListPolicyAttachmentsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPolicyAttachments", params, optFns, c.addOperationListPolicyAttachmentsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPolicyAttachmentsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPolicyAttachmentsInput struct {

	// The Amazon Resource Name (ARN) that is associated with the Directory where
	// objects reside. For more information, see arns .
	//
	// This member is required.
	DirectoryArn *string

	// The reference that identifies the policy object.
	//
	// This member is required.
	PolicyReference *types.ObjectReference

	// Represents the manner and timing in which the successful write or update of an
	// object is reflected in a subsequent read operation of that same object.
	ConsistencyLevel types.ConsistencyLevel

	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	MaxResults *int32

	// The pagination token.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPolicyAttachmentsOutput struct {

	// The pagination token.
	NextToken *string

	// A list of ObjectIdentifiers to which the policy is attached.
	ObjectIdentifiers []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPolicyAttachmentsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPolicyAttachments{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPolicyAttachments{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPolicyAttachments"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListPolicyAttachmentsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPolicyAttachments(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPolicyAttachmentsAPIClient is a client that implements the
// ListPolicyAttachments operation.
type ListPolicyAttachmentsAPIClient interface {
	ListPolicyAttachments(context.Context, *ListPolicyAttachmentsInput, ...func(*Options)) (*ListPolicyAttachmentsOutput, error)
}

var _ ListPolicyAttachmentsAPIClient = (*Client)(nil)

// ListPolicyAttachmentsPaginatorOptions is the paginator options for
// ListPolicyAttachments
type ListPolicyAttachmentsPaginatorOptions struct {
	// The maximum number of items to be retrieved in a single call. This is an
	// approximate number.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPolicyAttachmentsPaginator is a paginator for ListPolicyAttachments
type ListPolicyAttachmentsPaginator struct {
	options   ListPolicyAttachmentsPaginatorOptions
	client    ListPolicyAttachmentsAPIClient
	params    *ListPolicyAttachmentsInput
	nextToken *string
	firstPage bool
}

// NewListPolicyAttachmentsPaginator returns a new ListPolicyAttachmentsPaginator
func NewListPolicyAttachmentsPaginator(client ListPolicyAttachmentsAPIClient, params *ListPolicyAttachmentsInput, optFns ...func(*ListPolicyAttachmentsPaginatorOptions)) *ListPolicyAttachmentsPaginator {
	if params == nil {
		params = &ListPolicyAttachmentsInput{}
	}

	options := ListPolicyAttachmentsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPolicyAttachmentsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPolicyAttachmentsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPolicyAttachments page.
func (p *ListPolicyAttachmentsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPolicyAttachmentsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListPolicyAttachments(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListPolicyAttachments(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPolicyAttachments",
	}
}
