// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The data type for AccountRecoverySetting .
type AccountRecoverySettingType struct {

	// The list of RecoveryOptionTypes .
	RecoveryMechanisms []RecoveryOptionType

	noSmithyDocumentSerde
}

// Account takeover actions type.
type AccountTakeoverActionsType struct {

	// Action to take for a high risk.
	HighAction *AccountTakeoverActionType

	// Action to take for a low risk.
	LowAction *AccountTakeoverActionType

	// Action to take for a medium risk.
	MediumAction *AccountTakeoverActionType

	noSmithyDocumentSerde
}

// Account takeover action type.
type AccountTakeoverActionType struct {

	// The action to take in response to the account takeover action. Valid values are
	// as follows:
	//   - BLOCK Choosing this action will block the request.
	//   - MFA_IF_CONFIGURED Present an MFA challenge if user has configured it, else
	//   allow the request.
	//   - MFA_REQUIRED Present an MFA challenge if user has configured it, else block
	//   the request.
	//   - NO_ACTION Allow the user to sign in.
	//
	// This member is required.
	EventAction AccountTakeoverEventActionType

	// Flag specifying whether to send a notification.
	//
	// This member is required.
	Notify bool

	noSmithyDocumentSerde
}

// Configuration for mitigation actions and notification for different levels of
// risk detected for a potential account takeover.
type AccountTakeoverRiskConfigurationType struct {

	// Account takeover risk configuration actions.
	//
	// This member is required.
	Actions *AccountTakeoverActionsType

	// The notify configuration used to construct email notifications.
	NotifyConfiguration *NotifyConfigurationType

	noSmithyDocumentSerde
}

// The configuration for creating a new user profile.
type AdminCreateUserConfigType struct {

	// Set to True if only the administrator is allowed to create user profiles. Set
	// to False if users can sign themselves up via an app.
	AllowAdminCreateUserOnly bool

	// The message template to be used for the welcome message to new users. See also
	// Customizing User Invitation Messages (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-message-customizations.html#cognito-user-pool-settings-user-invitation-message-customization)
	// .
	InviteMessageTemplate *MessageTemplateType

	// The user account expiration limit, in days, after which a new account that
	// hasn't signed in is no longer usable. To reset the account after that time
	// limit, you must call AdminCreateUser again, specifying "RESEND" for the
	// MessageAction parameter. The default value for this parameter is 7. If you set a
	// value for TemporaryPasswordValidityDays in PasswordPolicy , that value will be
	// used, and UnusedAccountValidityDays will be no longer be an available parameter
	// for that user pool.
	UnusedAccountValidityDays int32

	noSmithyDocumentSerde
}

// The Amazon Pinpoint analytics configuration necessary to collect metrics for a
// user pool. In Regions where Amazon Pinpoint isn't available, user pools only
// support sending events to Amazon Pinpoint projects in us-east-1. In Regions
// where Amazon Pinpoint is available, user pools support sending events to Amazon
// Pinpoint projects within that same Region.
type AnalyticsConfigurationType struct {

	// The Amazon Resource Name (ARN) of an Amazon Pinpoint project. You can use the
	// Amazon Pinpoint project to integrate with the chosen user pool Client. Amazon
	// Cognito publishes events to the Amazon Pinpoint project that the app ARN
	// declares.
	ApplicationArn *string

	// The application ID for an Amazon Pinpoint application.
	ApplicationId *string

	// The external ID.
	ExternalId *string

	// The ARN of an Identity and Access Management role that authorizes Amazon
	// Cognito to publish events to Amazon Pinpoint analytics.
	RoleArn *string

	// If UserDataShared is true , Amazon Cognito includes user data in the events that
	// it publishes to Amazon Pinpoint analytics.
	UserDataShared bool

	noSmithyDocumentSerde
}

// An Amazon Pinpoint analytics endpoint. An endpoint uniquely identifies a mobile
// device, email address, or phone number that can receive messages from Amazon
// Pinpoint analytics. For more information about Amazon Web Services Regions that
// can contain Amazon Pinpoint resources for use with Amazon Cognito user pools,
// see Using Amazon Pinpoint analytics with Amazon Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-pinpoint-integration.html)
// .
type AnalyticsMetadataType struct {

	// The endpoint ID.
	AnalyticsEndpointId *string

	noSmithyDocumentSerde
}

// Specifies whether the attribute is standard or custom.
type AttributeType struct {

	// The name of the attribute.
	//
	// This member is required.
	Name *string

	// The value of the attribute.
	Value *string

	noSmithyDocumentSerde
}

// The authentication result.
type AuthenticationResultType struct {

	// A valid access token that Amazon Cognito issued to the user who you want to
	// authenticate.
	AccessToken *string

	// The expiration period of the authentication result in seconds.
	ExpiresIn int32

	// The ID token.
	IdToken *string

	// The new device metadata from an authentication result.
	NewDeviceMetadata *NewDeviceMetadataType

	// The refresh token.
	RefreshToken *string

	// The token type.
	TokenType *string

	noSmithyDocumentSerde
}

// The authentication event type.
type AuthEventType struct {

	// The challenge responses.
	ChallengeResponses []ChallengeResponseType

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// The user context data captured at the time of an event request. This value
	// provides additional information about the client from which event the request is
	// received.
	EventContextData *EventContextDataType

	// A flag specifying the user feedback captured at the time of an event request is
	// good or bad.
	EventFeedback *EventFeedbackType

	// The event ID.
	EventId *string

	// The event response.
	EventResponse EventResponseType

	// The event risk.
	EventRisk *EventRiskType

	// The event type.
	EventType EventType

	noSmithyDocumentSerde
}

// The challenge response type.
type ChallengeResponseType struct {

	// The challenge name.
	ChallengeName ChallengeName

	// The challenge response.
	ChallengeResponse ChallengeResponse

	noSmithyDocumentSerde
}

// The CloudWatch logging destination of a user pool detailed activity logging
// configuration.
type CloudWatchLogsConfigurationType struct {

	// The Amazon Resource Name (arn) of a CloudWatch Logs log group where your user
	// pool sends logs. The log group must not be encrypted with Key Management Service
	// and must be in the same Amazon Web Services account as your user pool. To send
	// logs to log groups with a resource policy of a size greater than 5120
	// characters, configure a log group with a path that starts with /aws/vendedlogs .
	// For more information, see Enabling logging from certain Amazon Web Services
	// services (https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AWS-logs-and-resource-policy.html)
	// .
	LogGroupArn *string

	noSmithyDocumentSerde
}

// The delivery details for an email or SMS message that Amazon Cognito sent for
// authentication or verification.
type CodeDeliveryDetailsType struct {

	// The name of the attribute that Amazon Cognito verifies with the code.
	AttributeName *string

	// The method that Amazon Cognito used to send the code.
	DeliveryMedium DeliveryMediumType

	// The email address or phone number destination where Amazon Cognito sent the
	// code.
	Destination *string

	noSmithyDocumentSerde
}

// The compromised credentials actions type.
type CompromisedCredentialsActionsType struct {

	// The event action.
	//
	// This member is required.
	EventAction CompromisedCredentialsEventActionType

	noSmithyDocumentSerde
}

// The compromised credentials risk configuration type.
type CompromisedCredentialsRiskConfigurationType struct {

	// The compromised credentials risk configuration actions.
	//
	// This member is required.
	Actions *CompromisedCredentialsActionsType

	// Perform the action for these events. The default is to perform all events if no
	// event filter is specified.
	EventFilter []EventFilterType

	noSmithyDocumentSerde
}

// Contextual user data type used for evaluating the risk of an unexpected event
// by Amazon Cognito advanced security.
type ContextDataType struct {

	// HttpHeaders received on your server in same order.
	//
	// This member is required.
	HttpHeaders []HttpHeader

	// The source IP address of your user's device.
	//
	// This member is required.
	IpAddress *string

	// Your server endpoint where this API is invoked.
	//
	// This member is required.
	ServerName *string

	// Your server path where this API is invoked.
	//
	// This member is required.
	ServerPath *string

	// Encoded device-fingerprint details that your app collected with the Amazon
	// Cognito context data collection library. For more information, see Adding user
	// device and session data to API requests (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint)
	// .
	EncodedData *string

	noSmithyDocumentSerde
}

// The configuration for a custom domain that hosts the sign-up and sign-in
// webpages for your application.
type CustomDomainConfigType struct {

	// The Amazon Resource Name (ARN) of an Certificate Manager SSL certificate. You
	// use this certificate for the subdomain of your custom domain.
	//
	// This member is required.
	CertificateArn *string

	noSmithyDocumentSerde
}

// The properties of a custom email sender Lambda trigger.
type CustomEmailLambdaVersionConfigType struct {

	// The Amazon Resource Name (ARN) of the function that you want to assign to your
	// Lambda trigger.
	//
	// This member is required.
	LambdaArn *string

	// The user pool trigger version of the request that Amazon Cognito sends to your
	// Lambda function. Higher-numbered versions add fields that support new features.
	// You must use a LambdaVersion of V1_0 with a custom sender function.
	//
	// This member is required.
	LambdaVersion CustomEmailSenderLambdaVersionType

	noSmithyDocumentSerde
}

// The properties of a custom SMS sender Lambda trigger.
type CustomSMSLambdaVersionConfigType struct {

	// The Amazon Resource Name (ARN) of the function that you want to assign to your
	// Lambda trigger.
	//
	// This member is required.
	LambdaArn *string

	// The user pool trigger version of the request that Amazon Cognito sends to your
	// Lambda function. Higher-numbered versions add fields that support new features.
	// You must use a LambdaVersion of V1_0 with a custom sender function.
	//
	// This member is required.
	LambdaVersion CustomSMSSenderLambdaVersionType

	noSmithyDocumentSerde
}

// The device-remembering configuration for a user pool. A  DescribeUserPool (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_DescribeUserPool.html)
// request returns a null value for this object when the user pool isn't configured
// to remember devices. When device remembering is active, you can remember a
// user's device with a ConfirmDevice (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html)
// API request. Additionally. when the property DeviceOnlyRememberedOnUserPrompt
// is true , you must follow ConfirmDevice with an UpdateDeviceStatus (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html)
// API request that sets the user's device to remembered or not_remembered . To
// sign in with a remembered device, include DEVICE_KEY in the authentication
// parameters in your user's InitiateAuth (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html)
// request. If your app doesn't include a DEVICE_KEY parameter, the response (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_InitiateAuth.html#API_InitiateAuth_ResponseSyntax)
// from Amazon Cognito includes newly-generated DEVICE_KEY and DEVICE_GROUP_KEY
// values under NewDeviceMetadata . Store these values to use in future
// device-authentication requests. When you provide a value for any property of
// DeviceConfiguration , you activate the device remembering for the user pool.
type DeviceConfigurationType struct {

	// When true, a remembered device can sign in with device authentication instead
	// of SMS and time-based one-time password (TOTP) factors for multi-factor
	// authentication (MFA). Whether or not ChallengeRequiredOnNewDevice is true,
	// users who sign in with devices that have not been confirmed or remembered must
	// still provide a second factor in a user pool that requires MFA.
	ChallengeRequiredOnNewDevice bool

	// When true, Amazon Cognito doesn't automatically remember a user's device when
	// your app sends a ConfirmDevice (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_ConfirmDevice.html)
	// API request. In your app, create a prompt for your user to choose whether they
	// want to remember their device. Return the user's choice in an UpdateDeviceStatus (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateDeviceStatus.html)
	// API request. When DeviceOnlyRememberedOnUserPrompt is false , Amazon Cognito
	// immediately remembers devices that you register in a ConfirmDevice API request.
	DeviceOnlyRememberedOnUserPrompt bool

	noSmithyDocumentSerde
}

// The device verifier against which it is authenticated.
type DeviceSecretVerifierConfigType struct {

	// The password verifier.
	PasswordVerifier *string

	// The salt (https://en.wikipedia.org/wiki/Salt_(cryptography))
	Salt *string

	noSmithyDocumentSerde
}

// The device type.
type DeviceType struct {

	// The device attributes.
	DeviceAttributes []AttributeType

	// The creation date of the device.
	DeviceCreateDate *time.Time

	// The device key.
	DeviceKey *string

	// The date when the device was last authenticated.
	DeviceLastAuthenticatedDate *time.Time

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	DeviceLastModifiedDate *time.Time

	noSmithyDocumentSerde
}

// A container for information about a domain.
type DomainDescriptionType struct {

	// The Amazon Web Services ID for the user pool owner.
	AWSAccountId *string

	// The Amazon CloudFront endpoint that you use as the target of the alias that you
	// set up with your Domain Name Service (DNS) provider.
	CloudFrontDistribution *string

	// The configuration for a custom domain that hosts the sign-up and sign-in
	// webpages for your application.
	CustomDomainConfig *CustomDomainConfigType

	// The domain string. For custom domains, this is the fully-qualified domain name,
	// such as auth.example.com . For Amazon Cognito prefix domains, this is the prefix
	// alone, such as auth .
	Domain *string

	// The Amazon S3 bucket where the static files for this domain are stored.
	S3Bucket *string

	// The domain status.
	Status DomainStatusType

	// The user pool ID.
	UserPoolId *string

	// The app version.
	Version *string

	noSmithyDocumentSerde
}

// The email configuration of your user pool. The email configuration type sets
// your preferred sending method, Amazon Web Services Region, and sender for
// messages from your user pool. Amazon Cognito can send email messages with Amazon
// Simple Email Service resources in the Amazon Web Services Region where you
// created your user pool, and in alternate Regions in some cases. For more
// information on the supported Regions, see Email settings for Amazon Cognito
// user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html)
// .
type EmailConfigurationType struct {

	// The set of configuration rules that can be applied to emails sent using Amazon
	// Simple Email Service. A configuration set is applied to an email by including a
	// reference to the configuration set in the headers of the email. Once applied,
	// all of the rules in that configuration set are applied to the email.
	// Configuration sets can be used to apply the following types of rules to emails:
	// Event publishing Amazon Simple Email Service can track the number of send,
	// delivery, open, click, bounce, and complaint events for each email sent. Use
	// event publishing to send information about these events to other Amazon Web
	// Services services such as and Amazon CloudWatch IP pool management When leasing
	// dedicated IP addresses with Amazon Simple Email Service, you can create groups
	// of IP addresses, called dedicated IP pools. You can then associate the dedicated
	// IP pools with configuration sets.
	ConfigurationSet *string

	// Specifies whether Amazon Cognito uses its built-in functionality to send your
	// users email messages, or uses your Amazon Simple Email Service email
	// configuration. Specify one of the following values: COGNITO_DEFAULT When Amazon
	// Cognito emails your users, it uses its built-in email functionality. When you
	// use the default option, Amazon Cognito allows only a limited number of emails
	// each day for your user pool. For typical production environments, the default
	// email limit is less than the required delivery volume. To achieve a higher
	// delivery volume, specify DEVELOPER to use your Amazon SES email configuration.
	// To look up the email delivery limit for the default option, see Limits (https://docs.aws.amazon.com/cognito/latest/developerguide/limits.html)
	// in the Amazon Cognito Developer Guide. The default FROM address is
	// no-reply@verificationemail.com . To customize the FROM address, provide the
	// Amazon Resource Name (ARN) of an Amazon SES verified email address for the
	// SourceArn parameter. DEVELOPER When Amazon Cognito emails your users, it uses
	// your Amazon SES configuration. Amazon Cognito calls Amazon SES on your behalf to
	// send email from your verified email address. When you use this option, the email
	// delivery limits are the same limits that apply to your Amazon SES verified email
	// address in your Amazon Web Services account. If you use this option, provide the
	// ARN of an Amazon SES verified email address for the SourceArn parameter. Before
	// Amazon Cognito can email your users, it requires additional permissions to call
	// Amazon SES on your behalf. When you update your user pool with this option,
	// Amazon Cognito creates a service-linked role, which is a type of role in your
	// Amazon Web Services account. This role contains the permissions that allow you
	// to access Amazon SES and send email messages from your email address. For more
	// information about the service-linked role that Amazon Cognito creates, see
	// Using Service-Linked Roles for Amazon Cognito (https://docs.aws.amazon.com/cognito/latest/developerguide/using-service-linked-roles.html)
	// in the Amazon Cognito Developer Guide.
	EmailSendingAccount EmailSendingAccountType

	// Either the sender’s email address or the sender’s name with their email
	// address. For example, testuser@example.com or Test User . This address appears
	// before the body of the email.
	From *string

	// The destination to which the receiver of the email should reply.
	ReplyToEmailAddress *string

	// The ARN of a verified email address or an address from a verified domain in
	// Amazon SES. You can set a SourceArn email from a verified domain only with an
	// API request. You can set a verified email address, but not an address in a
	// verified domain, in the Amazon Cognito console. Amazon Cognito uses the email
	// address that you provide in one of the following ways, depending on the value
	// that you specify for the EmailSendingAccount parameter:
	//   - If you specify COGNITO_DEFAULT , Amazon Cognito uses this address as the
	//   custom FROM address when it emails your users using its built-in email account.
	//   - If you specify DEVELOPER , Amazon Cognito emails your users with this
	//   address by calling Amazon SES on your behalf.
	// The Region value of the SourceArn parameter must indicate a supported Amazon
	// Web Services Region of your user pool. Typically, the Region in the SourceArn
	// and the user pool Region are the same. For more information, see Amazon SES
	// email configuration regions (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-email.html#user-pool-email-developer-region-mapping)
	// in the Amazon Cognito Developer Guide (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html)
	// .
	SourceArn *string

	noSmithyDocumentSerde
}

// Specifies the user context data captured at the time of an event request.
type EventContextDataType struct {

	// The user's city.
	City *string

	// The user's country.
	Country *string

	// The user's device name.
	DeviceName *string

	// The source IP address of your user's device.
	IpAddress *string

	// The user's time zone.
	Timezone *string

	noSmithyDocumentSerde
}

// Specifies the event feedback type.
type EventFeedbackType struct {

	// The authentication event feedback value. When you provide a FeedbackValue value
	// of valid , you tell Amazon Cognito that you trust a user session where Amazon
	// Cognito has evaluated some level of risk. When you provide a FeedbackValue
	// value of invalid , you tell Amazon Cognito that you don't trust a user session,
	// or you don't believe that Amazon Cognito evaluated a high-enough risk level.
	//
	// This member is required.
	FeedbackValue FeedbackValueType

	// The provider.
	//
	// This member is required.
	Provider *string

	// The event feedback date.
	FeedbackDate *time.Time

	noSmithyDocumentSerde
}

// The event risk type.
type EventRiskType struct {

	// Indicates whether compromised credentials were detected during an
	// authentication event.
	CompromisedCredentialsDetected *bool

	// The risk decision.
	RiskDecision RiskDecisionType

	// The risk level.
	RiskLevel RiskLevelType

	noSmithyDocumentSerde
}

// The group type.
type GroupType struct {

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// A string containing the description of the group.
	Description *string

	// The name of the group.
	GroupName *string

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	LastModifiedDate *time.Time

	// A non-negative integer value that specifies the precedence of this group
	// relative to the other groups that a user can belong to in the user pool. Zero is
	// the highest precedence value. Groups with lower Precedence values take
	// precedence over groups with higher ornull Precedence values. If a user belongs
	// to two or more groups, it is the group with the lowest precedence value whose
	// role ARN is given in the user's tokens for the cognito:roles and
	// cognito:preferred_role claims. Two groups can have the same Precedence value.
	// If this happens, neither group takes precedence over the other. If two groups
	// with the same Precedence have the same role ARN, that role is used in the
	// cognito:preferred_role claim in tokens for users in each group. If the two
	// groups have different role ARNs, the cognito:preferred_role claim isn't set in
	// users' tokens. The default Precedence value is null.
	Precedence *int32

	// The role Amazon Resource Name (ARN) for the group.
	RoleArn *string

	// The user pool ID for the user pool.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The HTTP header.
type HttpHeader struct {

	// The header name.
	HeaderName *string

	// The header value.
	HeaderValue *string

	noSmithyDocumentSerde
}

// A container for information about an IdP.
type IdentityProviderType struct {

	// A mapping of IdP attributes to standard and custom user pool attributes.
	AttributeMapping map[string]string

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// A list of IdP identifiers.
	IdpIdentifiers []string

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	LastModifiedDate *time.Time

	// The scopes, URLs, and identifiers for your external identity provider. The
	// following examples describe the provider detail keys for each IdP type. These
	// values and their schema are subject to change. Social IdP authorize_scopes
	// values must match the values listed here. OpenID Connect (OIDC) Amazon Cognito
	// accepts the following elements when it can't discover endpoint URLs from
	// oidc_issuer : attributes_url , authorize_url , jwks_uri , token_url . Create or
	// update request: "ProviderDetails": { "attributes_request_method": "GET",
	// "attributes_url": "https://auth.example.com/userInfo", "authorize_scopes":
	// "openid profile email", "authorize_url": "https://auth.example.com/authorize",
	// "client_id": "1example23456789", "client_secret": "provider-app-client-secret",
	// "jwks_uri": "https://auth.example.com/.well-known/jwks.json", "oidc_issuer":
	// "https://auth.example.com", "token_url": "https://example.com/token" } Describe
	// response: "ProviderDetails": { "attributes_request_method": "GET",
	// "attributes_url": "https://auth.example.com/userInfo",
	// "attributes_url_add_attributes": "false", "authorize_scopes": "openid profile
	// email", "authorize_url": "https://auth.example.com/authorize", "client_id":
	// "1example23456789", "client_secret": "provider-app-client-secret", "jwks_uri":
	// "https://auth.example.com/.well-known/jwks.json", "oidc_issuer":
	// "https://auth.example.com", "token_url": "https://example.com/token" } SAML
	// Create or update request with Metadata URL: "ProviderDetails": { "IDPInit":
	// "true", "IDPSignout": "true", "EncryptedResponses" : "true", "MetadataURL":
	// "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm":
	// "rsa-sha256" } Create or update request with Metadata file: "ProviderDetails":
	// { "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true",
	// "MetadataFile": "[metadata XML]", "RequestSigningAlgorithm": "rsa-sha256" } The
	// value of MetadataFile must be the plaintext metadata document with all quote
	// (") characters escaped by backslashes. Describe response: "ProviderDetails": {
	// "IDPInit": "true", "IDPSignout": "true", "EncryptedResponses" : "true",
	// "ActiveEncryptionCertificate": "[certificate]", "MetadataURL":
	// "https://auth.example.com/sso/saml/metadata", "RequestSigningAlgorithm":
	// "rsa-sha256", "SLORedirectBindingURI": "https://auth.example.com/slo/saml",
	// "SSORedirectBindingURI": "https://auth.example.com/sso/saml" } LoginWithAmazon
	// Create or update request: "ProviderDetails": { "authorize_scopes": "profile
	// postal_code", "client_id": "amzn1.application-oa2-client.1example23456789",
	// "client_secret": "provider-app-client-secret" Describe response:
	// "ProviderDetails": { "attributes_url": "https://api.amazon.com/user/profile",
	// "attributes_url_add_attributes": "false", "authorize_scopes": "profile
	// postal_code", "authorize_url": "https://www.amazon.com/ap/oa", "client_id":
	// "amzn1.application-oa2-client.1example23456789", "client_secret":
	// "provider-app-client-secret", "token_request_method": "POST", "token_url":
	// "https://api.amazon.com/auth/o2/token" } Google Create or update request:
	// "ProviderDetails": { "authorize_scopes": "email profile openid", "client_id":
	// "1example23456789.apps.googleusercontent.com", "client_secret":
	// "provider-app-client-secret" } Describe response: "ProviderDetails": {
	// "attributes_url": "https://people.googleapis.com/v1/people/me?personFields=",
	// "attributes_url_add_attributes": "true", "authorize_scopes": "email profile
	// openid", "authorize_url": "https://accounts.google.com/o/oauth2/v2/auth",
	// "client_id": "1example23456789.apps.googleusercontent.com", "client_secret":
	// "provider-app-client-secret", "oidc_issuer": "https://accounts.google.com",
	// "token_request_method": "POST", "token_url":
	// "https://www.googleapis.com/oauth2/v4/token" } SignInWithApple Create or update
	// request: "ProviderDetails": { "authorize_scopes": "email name", "client_id":
	// "com.example.cognito", "private_key": "1EXAMPLE", "key_id": "2EXAMPLE",
	// "team_id": "3EXAMPLE" } Describe response: "ProviderDetails": {
	// "attributes_url_add_attributes": "false", "authorize_scopes": "email name",
	// "authorize_url": "https://appleid.apple.com/auth/authorize", "client_id":
	// "com.example.cognito", "key_id": "1EXAMPLE", "oidc_issuer":
	// "https://appleid.apple.com", "team_id": "2EXAMPLE", "token_request_method":
	// "POST", "token_url": "https://appleid.apple.com/auth/token" } Facebook Create or
	// update request: "ProviderDetails": { "api_version": "v17.0",
	// "authorize_scopes": "public_profile, email", "client_id": "1example23456789",
	// "client_secret": "provider-app-client-secret" } Describe response:
	// "ProviderDetails": { "api_version": "v17.0", "attributes_url":
	// "https://graph.facebook.com/v17.0/me?fields=", "attributes_url_add_attributes":
	// "true", "authorize_scopes": "public_profile, email", "authorize_url":
	// "https://www.facebook.com/v17.0/dialog/oauth", "client_id": "1example23456789",
	// "client_secret": "provider-app-client-secret", "token_request_method": "GET",
	// "token_url": "https://graph.facebook.com/v17.0/oauth/access_token" }
	ProviderDetails map[string]string

	// The IdP name.
	ProviderName *string

	// The IdP type.
	ProviderType IdentityProviderTypeType

	// The user pool ID.
	UserPoolId *string

	noSmithyDocumentSerde
}

// Specifies the configuration for Lambda triggers.
type LambdaConfigType struct {

	// Creates an authentication challenge.
	CreateAuthChallenge *string

	// A custom email sender Lambda trigger.
	CustomEmailSender *CustomEmailLambdaVersionConfigType

	// A custom Message Lambda trigger.
	CustomMessage *string

	// A custom SMS sender Lambda trigger.
	CustomSMSSender *CustomSMSLambdaVersionConfigType

	// Defines the authentication challenge.
	DefineAuthChallenge *string

	// The Amazon Resource Name (ARN) of an KMS key . Amazon Cognito uses the key to
	// encrypt codes and temporary passwords sent to CustomEmailSender and
	// CustomSMSSender .
	KMSKeyID *string

	// A post-authentication Lambda trigger.
	PostAuthentication *string

	// A post-confirmation Lambda trigger.
	PostConfirmation *string

	// A pre-authentication Lambda trigger.
	PreAuthentication *string

	// A pre-registration Lambda trigger.
	PreSignUp *string

	// The Amazon Resource Name (ARN) of the function that you want to assign to your
	// Lambda trigger. Set this parameter for legacy purposes. If you also set an ARN
	// in PreTokenGenerationConfig , its value must be identical to PreTokenGeneration
	// . For new instances of pre token generation triggers, set the LambdaArn of
	// PreTokenGenerationConfig . You can set
	PreTokenGeneration *string

	// The detailed configuration of a pre token generation trigger. If you also set
	// an ARN in PreTokenGeneration , its value must be identical to
	// PreTokenGenerationConfig .
	PreTokenGenerationConfig *PreTokenGenerationVersionConfigType

	// The user migration Lambda config type.
	UserMigration *string

	// Verifies the authentication challenge response.
	VerifyAuthChallengeResponse *string

	noSmithyDocumentSerde
}

// The logging parameters of a user pool.
type LogConfigurationType struct {

	// The source of events that your user pool sends for detailed activity logging.
	//
	// This member is required.
	EventSource EventSourceName

	// The errorlevel selection of logs that a user pool sends for detailed activity
	// logging.
	//
	// This member is required.
	LogLevel LogLevel

	// The CloudWatch logging destination of a user pool.
	CloudWatchLogsConfiguration *CloudWatchLogsConfigurationType

	noSmithyDocumentSerde
}

// The logging parameters of a user pool.
type LogDeliveryConfigurationType struct {

	// The detailed activity logging destination of a user pool.
	//
	// This member is required.
	LogConfigurations []LogConfigurationType

	// The ID of the user pool where you configured detailed activity logging.
	//
	// This member is required.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The message template structure.
type MessageTemplateType struct {

	// The message template for email messages. EmailMessage is allowed only if
	// EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailMessage *string

	// The subject line for email messages. EmailSubject is allowed only if
	// EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER.
	EmailSubject *string

	// The message template for SMS messages.
	SMSMessage *string

	noSmithyDocumentSerde
}

// This data type is no longer supported. Applies only to SMS multi-factor
// authentication (MFA) configurations. Does not apply to time-based one-time
// password (TOTP) software token MFA configurations.
type MFAOptionType struct {

	// The attribute name of the MFA option type. The only valid value is phone_number .
	AttributeName *string

	// The delivery medium to send the MFA code. You can use this parameter to set
	// only the SMS delivery medium value.
	DeliveryMedium DeliveryMediumType

	noSmithyDocumentSerde
}

// The new device metadata type.
type NewDeviceMetadataType struct {

	// The device group key.
	DeviceGroupKey *string

	// The device key.
	DeviceKey *string

	noSmithyDocumentSerde
}

// The notify configuration type.
type NotifyConfigurationType struct {

	// The Amazon Resource Name (ARN) of the identity that is associated with the
	// sending authorization policy. This identity permits Amazon Cognito to send for
	// the email address specified in the From parameter.
	//
	// This member is required.
	SourceArn *string

	// Email template used when a detected risk event is blocked.
	BlockEmail *NotifyEmailType

	// The email address that is sending the email. The address must be either
	// individually verified with Amazon Simple Email Service, or from a domain that
	// has been verified with Amazon SES.
	From *string

	// The multi-factor authentication (MFA) email template used when MFA is
	// challenged as part of a detected risk.
	MfaEmail *NotifyEmailType

	// The email template used when a detected risk event is allowed.
	NoActionEmail *NotifyEmailType

	// The destination to which the receiver of an email should reply to.
	ReplyTo *string

	noSmithyDocumentSerde
}

// The notify email type.
type NotifyEmailType struct {

	// The email subject.
	//
	// This member is required.
	Subject *string

	// The email HTML body.
	HtmlBody *string

	// The email text body.
	TextBody *string

	noSmithyDocumentSerde
}

// The minimum and maximum values of an attribute that is of the number data type.
type NumberAttributeConstraintsType struct {

	// The maximum value of an attribute that is of the number data type.
	MaxValue *string

	// The minimum value of an attribute that is of the number data type.
	MinValue *string

	noSmithyDocumentSerde
}

// The password policy type.
type PasswordPolicyType struct {

	// The minimum length of the password in the policy that you have set. This value
	// can't be less than 6.
	MinimumLength *int32

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one lowercase letter in their password.
	RequireLowercase bool

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one number in their password.
	RequireNumbers bool

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one symbol in their password.
	RequireSymbols bool

	// In the password policy that you have set, refers to whether you have required
	// users to use at least one uppercase letter in their password.
	RequireUppercase bool

	// The number of days a temporary password is valid in the password policy. If the
	// user doesn't sign in during this time, an administrator must reset their
	// password. Defaults to 7 . If you submit a value of 0 , Amazon Cognito treats it
	// as a null value and sets TemporaryPasswordValidityDays to its default value.
	// When you set TemporaryPasswordValidityDays for a user pool, you can no longer
	// set a value for the legacy UnusedAccountValidityDays parameter in that user
	// pool.
	TemporaryPasswordValidityDays int32

	noSmithyDocumentSerde
}

// The properties of a pre token generation Lambda trigger.
type PreTokenGenerationVersionConfigType struct {

	// The Amazon Resource Name (ARN) of the function that you want to assign to your
	// Lambda trigger. This parameter and the PreTokenGeneration property of
	// LambdaConfig have the same value. For new instances of pre token generation
	// triggers, set LambdaArn .
	//
	// This member is required.
	LambdaArn *string

	// The user pool trigger version of the request that Amazon Cognito sends to your
	// Lambda function. Higher-numbered versions add fields that support new features.
	//
	// This member is required.
	LambdaVersion PreTokenGenerationLambdaVersionType

	noSmithyDocumentSerde
}

// A container for IdP details.
type ProviderDescription struct {

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// The date the provider was last modified.
	LastModifiedDate *time.Time

	// The IdP name.
	ProviderName *string

	// The IdP type.
	ProviderType IdentityProviderTypeType

	noSmithyDocumentSerde
}

// A container for information about an IdP for a user pool.
type ProviderUserIdentifierType struct {

	// The name of the provider attribute to link to, such as NameID .
	ProviderAttributeName *string

	// The value of the provider attribute to link to, such as xxxxx_account .
	ProviderAttributeValue *string

	// The name of the provider, such as Facebook, Google, or Login with Amazon.
	ProviderName *string

	noSmithyDocumentSerde
}

// A map containing a priority as a key, and recovery method name as a value.
type RecoveryOptionType struct {

	// The recovery method for a user.
	//
	// This member is required.
	Name RecoveryOptionNameType

	// A positive integer specifying priority of a method with 1 being the highest
	// priority.
	//
	// This member is required.
	Priority *int32

	noSmithyDocumentSerde
}

// A resource server scope.
type ResourceServerScopeType struct {

	// A description of the scope.
	//
	// This member is required.
	ScopeDescription *string

	// The name of the scope.
	//
	// This member is required.
	ScopeName *string

	noSmithyDocumentSerde
}

// A container for information about a resource server for a user pool.
type ResourceServerType struct {

	// The identifier for the resource server.
	Identifier *string

	// The name of the resource server.
	Name *string

	// A list of scopes that are defined for the resource server.
	Scopes []ResourceServerScopeType

	// The user pool ID for the user pool that hosts the resource server.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The risk configuration type.
type RiskConfigurationType struct {

	// The account takeover risk configuration object, including the
	// NotifyConfiguration object and Actions to take if there is an account takeover.
	AccountTakeoverRiskConfiguration *AccountTakeoverRiskConfigurationType

	// The app client ID.
	ClientId *string

	// The compromised credentials risk configuration object, including the EventFilter
	// and the EventAction .
	CompromisedCredentialsRiskConfiguration *CompromisedCredentialsRiskConfigurationType

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	LastModifiedDate *time.Time

	// The configuration to override the risk decision.
	RiskExceptionConfiguration *RiskExceptionConfigurationType

	// The user pool ID.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The type of the configuration to override the risk decision.
type RiskExceptionConfigurationType struct {

	// Overrides the risk decision to always block the pre-authentication requests.
	// The IP range is in CIDR notation, a compact representation of an IP address and
	// its routing prefix.
	BlockedIPRangeList []string

	// Risk detection isn't performed on the IP addresses in this range list. The IP
	// range is in CIDR notation.
	SkippedIPRangeList []string

	noSmithyDocumentSerde
}

// A list of the user attributes and their properties in your user pool. The
// attribute schema contains standard attributes, custom attributes with a custom:
// prefix, and developer attributes with a dev: prefix. For more information, see
// User pool attributes (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html)
// . Developer-only attributes are a legacy feature of user pools, are read-only to
// all app clients. You can create and update developer-only attributes only with
// IAM-authenticated API operations. Use app client read/write permissions instead.
type SchemaAttributeType struct {

	// The data format of the values for your attribute. When you choose an
	// AttributeDataType , Amazon Cognito validates the input against the data type. A
	// custom attribute value in your user's ID token is always a string, for example
	// "custom:isMember" : "true" or "custom:YearsAsMember" : "12" .
	AttributeDataType AttributeDataType

	// You should use WriteAttributes (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UserPoolClientType.html#CognitoUserPools-Type-UserPoolClientType-WriteAttributes)
	// in the user pool client to control how attributes can be mutated for new use
	// cases instead of using DeveloperOnlyAttribute . Specifies whether the attribute
	// type is developer only. This attribute can only be modified by an administrator.
	// Users won't be able to modify this attribute using their access token. For
	// example, DeveloperOnlyAttribute can be modified using AdminUpdateUserAttributes
	// but can't be updated using UpdateUserAttributes.
	DeveloperOnlyAttribute *bool

	// Specifies whether the value of the attribute can be changed. Any user pool
	// attribute whose value you map from an IdP attribute must be mutable, with a
	// parameter value of true . Amazon Cognito updates mapped attributes when users
	// sign in to your application through an IdP. If an attribute is immutable, Amazon
	// Cognito throws an error when it attempts to update the attribute. For more
	// information, see Specifying Identity Provider Attribute Mappings for Your User
	// Pool (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html)
	// .
	Mutable *bool

	// The name of your user pool attribute. When you create or update a user pool,
	// adding a schema attribute creates a custom or developer-only attribute. When you
	// add an attribute with a Name value of MyAttribute , Amazon Cognito creates the
	// custom attribute custom:MyAttribute . When DeveloperOnlyAttribute is true ,
	// Amazon Cognito creates your attribute as dev:MyAttribute . In an operation that
	// describes a user pool, Amazon Cognito returns this value as value for standard
	// attributes, custom:value for custom attributes, and dev:value for
	// developer-only attributes..
	Name *string

	// Specifies the constraints for an attribute of the number type.
	NumberAttributeConstraints *NumberAttributeConstraintsType

	// Specifies whether a user pool attribute is required. If the attribute is
	// required and the user doesn't provide a value, registration or sign-in will
	// fail.
	Required *bool

	// Specifies the constraints for an attribute of the string type.
	StringAttributeConstraints *StringAttributeConstraintsType

	noSmithyDocumentSerde
}

// The SMS configuration type is the settings that your Amazon Cognito user pool
// must use to send an SMS message from your Amazon Web Services account through
// Amazon Simple Notification Service. To send SMS messages with Amazon SNS in the
// Amazon Web Services Region that you want, the Amazon Cognito user pool uses an
// Identity and Access Management (IAM) role in your Amazon Web Services account.
type SmsConfigurationType struct {

	// The Amazon Resource Name (ARN) of the Amazon SNS caller. This is the ARN of the
	// IAM role in your Amazon Web Services account that Amazon Cognito will use to
	// send SMS messages. SMS messages are subject to a spending limit (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html)
	// .
	//
	// This member is required.
	SnsCallerArn *string

	// The external ID provides additional security for your IAM role. You can use an
	// ExternalId with the IAM role that you use with Amazon SNS to send SMS messages
	// for your user pool. If you provide an ExternalId , your Amazon Cognito user pool
	// includes it in the request to assume your IAM role. You can configure the role
	// trust policy to require that Amazon Cognito, and any principal, provide the
	// ExternalID . If you use the Amazon Cognito Management Console to create a role
	// for SMS multi-factor authentication (MFA), Amazon Cognito creates a role with
	// the required permissions and a trust policy that demonstrates use of the
	// ExternalId . For more information about the ExternalId of a role, see How to
	// use an external ID when granting access to your Amazon Web Services resources to
	// a third party (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html)
	ExternalId *string

	// The Amazon Web Services Region to use with Amazon SNS integration. You can
	// choose the same Region as your user pool, or a supported Legacy Amazon SNS
	// alternate Region. Amazon Cognito resources in the Asia Pacific (Seoul) Amazon
	// Web Services Region must use your Amazon SNS configuration in the Asia Pacific
	// (Tokyo) Region. For more information, see SMS message settings for Amazon
	// Cognito user pools (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-sms-settings.html)
	// .
	SnsRegion *string

	noSmithyDocumentSerde
}

// The SMS text message multi-factor authentication (MFA) configuration type.
type SmsMfaConfigType struct {

	// The SMS authentication message that will be sent to users with the code they
	// must sign in. The message must contain the ‘{####}’ placeholder, which is
	// replaced with the code. If the message isn't included, and default message will
	// be used.
	SmsAuthenticationMessage *string

	// The SMS configuration with the settings that your Amazon Cognito user pool must
	// use to send an SMS message from your Amazon Web Services account through Amazon
	// Simple Notification Service. To request Amazon SNS in the Amazon Web Services
	// Region that you want, the Amazon Cognito user pool uses an Identity and Access
	// Management (IAM) role that you provide for your Amazon Web Services account.
	SmsConfiguration *SmsConfigurationType

	noSmithyDocumentSerde
}

// The type used for enabling SMS multi-factor authentication (MFA) at the user
// level. Phone numbers don't need to be verified to be used for SMS MFA. If an MFA
// type is activated for a user, the user will be prompted for MFA during all
// sign-in attempts, unless device tracking is turned on and the device has been
// trusted. If you would like MFA to be applied selectively based on the assessed
// risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive
// Authentication for the user pool.
type SMSMfaSettingsType struct {

	// Specifies whether SMS text message MFA is activated. If an MFA type is
	// activated for a user, the user will be prompted for MFA during all sign-in
	// attempts, unless device tracking is turned on and the device has been trusted.
	Enabled bool

	// Specifies whether SMS is the preferred MFA method.
	PreferredMfa bool

	noSmithyDocumentSerde
}

// The type used for enabling software token MFA at the user pool level.
type SoftwareTokenMfaConfigType struct {

	// Specifies whether software token MFA is activated.
	Enabled bool

	noSmithyDocumentSerde
}

// The type used for enabling software token MFA at the user level. If an MFA type
// is activated for a user, the user will be prompted for MFA during all sign-in
// attempts, unless device tracking is turned on and the device has been trusted.
// If you want MFA to be applied selectively based on the assessed risk level of
// sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication
// for the user pool.
type SoftwareTokenMfaSettingsType struct {

	// Specifies whether software token MFA is activated. If an MFA type is activated
	// for a user, the user will be prompted for MFA during all sign-in attempts,
	// unless device tracking is turned on and the device has been trusted.
	Enabled bool

	// Specifies whether software token MFA is the preferred MFA method.
	PreferredMfa bool

	noSmithyDocumentSerde
}

// The constraints associated with a string attribute.
type StringAttributeConstraintsType struct {

	// The maximum length.
	MaxLength *string

	// The minimum length.
	MinLength *string

	noSmithyDocumentSerde
}

// The data type TokenValidityUnits specifies the time units you use when you set
// the duration of ID, access, and refresh tokens.
type TokenValidityUnitsType struct {

	// A time unit of seconds , minutes , hours , or days for the value that you set
	// in the AccessTokenValidity parameter. The default AccessTokenValidity time unit
	// is hours. AccessTokenValidity duration can range from five minutes to one day.
	AccessToken TimeUnitsType

	// A time unit of seconds , minutes , hours , or days for the value that you set
	// in the IdTokenValidity parameter. The default IdTokenValidity time unit is
	// hours. IdTokenValidity duration can range from five minutes to one day.
	IdToken TimeUnitsType

	// A time unit of seconds , minutes , hours , or days for the value that you set
	// in the RefreshTokenValidity parameter. The default RefreshTokenValidity time
	// unit is days. RefreshTokenValidity duration can range from 60 minutes to 10
	// years.
	RefreshToken TimeUnitsType

	noSmithyDocumentSerde
}

// A container for the UI customization information for a user pool's built-in app
// UI.
type UICustomizationType struct {

	// The CSS values in the UI customization.
	CSS *string

	// The CSS version number.
	CSSVersion *string

	// The client ID for the client app.
	ClientId *string

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// The logo image for the UI customization.
	ImageUrl *string

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	LastModifiedDate *time.Time

	// The user pool ID for the user pool.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The settings for updates to user attributes. These settings include the
// property AttributesRequireVerificationBeforeUpdate , a user-pool setting that
// tells Amazon Cognito how to handle changes to the value of your users' email
// address and phone number attributes. For more information, see Verifying
// updates to email addresses and phone numbers (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates)
// .
type UserAttributeUpdateSettingsType struct {

	// Requires that your user verifies their email address, phone number, or both
	// before Amazon Cognito updates the value of that attribute. When you update a
	// user attribute that has this option activated, Amazon Cognito sends a
	// verification message to the new phone number or email address. Amazon Cognito
	// doesn’t change the value of the attribute until your user responds to the
	// verification message and confirms the new value. You can verify an updated email
	// address or phone number with a VerifyUserAttribute (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerifyUserAttribute.html)
	// API request. You can also call the AdminUpdateUserAttributes (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_AdminUpdateUserAttributes.html)
	// API and set email_verified or phone_number_verified to true. When
	// AttributesRequireVerificationBeforeUpdate is false, your user pool doesn't
	// require that your users verify attribute changes before Amazon Cognito updates
	// them. In a user pool where AttributesRequireVerificationBeforeUpdate is false,
	// API operations that change attribute values can immediately update a user’s
	// email or phone_number attribute.
	AttributesRequireVerificationBeforeUpdate []VerifiedAttributeType

	noSmithyDocumentSerde
}

// Contextual data, such as the user's device fingerprint, IP address, or
// location, used for evaluating the risk of an unexpected event by Amazon Cognito
// advanced security.
type UserContextDataType struct {

	// Encoded device-fingerprint details that your app collected with the Amazon
	// Cognito context data collection library. For more information, see Adding user
	// device and session data to API requests (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint)
	// .
	EncodedData *string

	// The source IP address of your user's device.
	IpAddress *string

	noSmithyDocumentSerde
}

// The user import job type.
type UserImportJobType struct {

	// The role Amazon Resource Name (ARN) for the Amazon CloudWatch Logging role for
	// the user import job. For more information, see "Creating the CloudWatch Logs IAM
	// Role" in the Amazon Cognito Developer Guide.
	CloudWatchLogsRoleArn *string

	// The date when the user import job was completed.
	CompletionDate *time.Time

	// The message returned when the user import job is completed.
	CompletionMessage *string

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// The number of users that couldn't be imported.
	FailedUsers int64

	// The number of users that were successfully imported.
	ImportedUsers int64

	// The job ID for the user import job.
	JobId *string

	// The job name for the user import job.
	JobName *string

	// The pre-signed URL to be used to upload the .csv file.
	PreSignedUrl *string

	// The number of users that were skipped.
	SkippedUsers int64

	// The date when the user import job was started.
	StartDate *time.Time

	// The status of the user import job. One of the following:
	//   - Created - The job was created but not started.
	//   - Pending - A transition state. You have started the job, but it has not begun
	//   importing users yet.
	//   - InProgress - The job has started, and users are being imported.
	//   - Stopping - You have stopped the job, but the job has not stopped importing
	//   users yet.
	//   - Stopped - You have stopped the job, and the job has stopped importing users.
	//   - Succeeded - The job has completed successfully.
	//   - Failed - The job has stopped due to an error.
	//   - Expired - You created a job, but did not start the job within 24-48 hours.
	//   All data associated with the job was deleted, and the job can't be started.
	Status UserImportJobStatusType

	// The user pool ID for the user pool that the users are being imported into.
	UserPoolId *string

	noSmithyDocumentSerde
}

// The username configuration type.
type UsernameConfigurationType struct {

	// Specifies whether user name case sensitivity will be applied for all users in
	// the user pool through Amazon Cognito APIs. For most use cases, set case
	// sensitivity to False (case insensitive) as a best practice. When usernames and
	// email addresses are case insensitive, users can sign in as the same user when
	// they enter a different capitalization of their user name. Valid values include:
	// True Enables case sensitivity for all username input. When this option is set to
	// True , users must sign in using the exact capitalization of their given
	// username, such as “UserName”. This is the default value. False Enables case
	// insensitivity for all username input. For example, when this option is set to
	// False , users can sign in using username , USERNAME , or UserName . This option
	// also enables both preferred_username and email alias to be case insensitive, in
	// addition to the username attribute.
	//
	// This member is required.
	CaseSensitive *bool

	noSmithyDocumentSerde
}

// User pool add-ons. Contains settings for activation of advanced security
// features. To log user security information but take no action, set to AUDIT . To
// configure automatic security responses to risky traffic to your user pool, set
// to ENFORCED . For more information, see Adding advanced security to a user pool (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html)
// .
type UserPoolAddOnsType struct {

	// The operating mode of advanced security features in your user pool.
	//
	// This member is required.
	AdvancedSecurityMode AdvancedSecurityModeType

	noSmithyDocumentSerde
}

// The description of the user pool client.
type UserPoolClientDescription struct {

	// The ID of the client associated with the user pool.
	ClientId *string

	// The client name from the user pool client description.
	ClientName *string

	// The user pool ID for the user pool where you want to describe the user pool
	// client.
	UserPoolId *string

	noSmithyDocumentSerde
}

// Contains information about a user pool client.
type UserPoolClientType struct {

	// The access token time limit. After this limit expires, your user can't use
	// their access token. To specify the time unit for AccessTokenValidity as seconds
	// , minutes , hours , or days , set a TokenValidityUnits value in your API
	// request. For example, when you set AccessTokenValidity to 10 and
	// TokenValidityUnits to hours , your user can authorize access with their access
	// token for 10 hours. The default time unit for AccessTokenValidity in an API
	// request is hours. Valid range is displayed below in seconds. If you don't
	// specify otherwise in the configuration of your app client, your access tokens
	// are valid for one hour.
	AccessTokenValidity *int32

	// The allowed OAuth flows. code Use a code grant flow, which provides an
	// authorization code as the response. This code can be exchanged for access tokens
	// with the /oauth2/token endpoint. implicit Issue the access token (and,
	// optionally, ID token, based on scopes) directly to your user. client_credentials
	// Issue the access token from the /oauth2/token endpoint directly to a non-person
	// user using a combination of the client ID and client secret.
	AllowedOAuthFlows []OAuthFlowType

	// Set to true to use OAuth 2.0 features in your user pool app client.
	// AllowedOAuthFlowsUserPoolClient must be true before you can configure the
	// following features in your app client.
	//   - CallBackURLs : Callback URLs.
	//   - LogoutURLs : Sign-out redirect URLs.
	//   - AllowedOAuthScopes : OAuth 2.0 scopes.
	//   - AllowedOAuthFlows : Support for authorization code, implicit, and client
	//   credentials OAuth 2.0 grants.
	// To use OAuth 2.0 features, configure one of these features in the Amazon
	// Cognito console or set AllowedOAuthFlowsUserPoolClient to true in a
	// CreateUserPoolClient or UpdateUserPoolClient API request. If you don't set a
	// value for AllowedOAuthFlowsUserPoolClient in a request with the CLI or SDKs, it
	// defaults to false .
	AllowedOAuthFlowsUserPoolClient *bool

	// The OAuth scopes that your app client supports. Possible values that OAuth
	// provides are phone , email , openid , and profile . Possible values that Amazon
	// Web Services provides are aws.cognito.signin.user.admin . Amazon Cognito also
	// supports custom scopes that you create in Resource Servers.
	AllowedOAuthScopes []string

	// The Amazon Pinpoint analytics configuration for the user pool client. Amazon
	// Cognito user pools only support sending events to Amazon Pinpoint projects in
	// the US East (N. Virginia) us-east-1 Region, regardless of the Region where the
	// user pool resides.
	AnalyticsConfiguration *AnalyticsConfigurationType

	// Amazon Cognito creates a session token for each API request in an
	// authentication flow. AuthSessionValidity is the duration, in minutes, of that
	// session token. Your user pool native user must respond to each authentication
	// challenge before the session expires.
	AuthSessionValidity *int32

	// A list of allowed redirect (callback) URLs for the IdPs. A redirect URI must:
	//   - Be an absolute URI.
	//   - Be registered with the authorization server.
	//   - Not include a fragment component.
	// See OAuth 2.0 - Redirection Endpoint (https://tools.ietf.org/html/rfc6749#section-3.1.2)
	// . Amazon Cognito requires HTTPS over HTTP except for http://localhost for
	// testing purposes only. App callback URLs such as myapp://example are also
	// supported.
	CallbackURLs []string

	// The ID of the client associated with the user pool.
	ClientId *string

	// The client name from the user pool request of the client type.
	ClientName *string

	// The client secret from the user pool request of the client type.
	ClientSecret *string

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// The default redirect URI. Must be in the CallbackURLs list. A redirect URI
	// must:
	//   - Be an absolute URI.
	//   - Be registered with the authorization server.
	//   - Not include a fragment component.
	// See OAuth 2.0 - Redirection Endpoint (https://tools.ietf.org/html/rfc6749#section-3.1.2)
	// . Amazon Cognito requires HTTPS over HTTP except for http://localhost for
	// testing purposes only. App callback URLs such as myapp://example are also
	// supported.
	DefaultRedirectURI *string

	// When EnablePropagateAdditionalUserContextData is true, Amazon Cognito accepts
	// an IpAddress value that you send in the UserContextData parameter. The
	// UserContextData parameter sends information to Amazon Cognito advanced security
	// for risk analysis. You can send UserContextData when you sign in Amazon Cognito
	// native users with the InitiateAuth and RespondToAuthChallenge API operations.
	// When EnablePropagateAdditionalUserContextData is false, you can't send your
	// user's source IP address to Amazon Cognito advanced security with
	// unauthenticated API operations. EnablePropagateAdditionalUserContextData
	// doesn't affect whether you can send a source IP address in a ContextData
	// parameter with the authenticated API operations AdminInitiateAuth and
	// AdminRespondToAuthChallenge . You can only activate
	// EnablePropagateAdditionalUserContextData in an app client that has a client
	// secret. For more information about propagation of user context data, see Adding
	// user device and session data to API requests (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-adaptive-authentication.html#user-pool-settings-adaptive-authentication-device-fingerprint)
	// .
	EnablePropagateAdditionalUserContextData *bool

	// Indicates whether token revocation is activated for the user pool client. When
	// you create a new user pool client, token revocation is activated by default. For
	// more information about revoking tokens, see RevokeToken (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_RevokeToken.html)
	// .
	EnableTokenRevocation *bool

	// The authentication flows that you want your user pool client to support. For
	// each app client in your user pool, you can sign in your users with any
	// combination of one or more flows, including with a user name and Secure Remote
	// Password (SRP), a user name and password, or a custom authentication process
	// that you define with Lambda functions. If you don't specify a value for
	// ExplicitAuthFlows , your user client supports ALLOW_REFRESH_TOKEN_AUTH ,
	// ALLOW_USER_SRP_AUTH , and ALLOW_CUSTOM_AUTH . Valid values include:
	//   - ALLOW_ADMIN_USER_PASSWORD_AUTH : Enable admin based user password
	//   authentication flow ADMIN_USER_PASSWORD_AUTH . This setting replaces the
	//   ADMIN_NO_SRP_AUTH setting. With this authentication flow, your app passes a
	//   user name and password to Amazon Cognito in the request, instead of using the
	//   Secure Remote Password (SRP) protocol to securely transmit the password.
	//   - ALLOW_CUSTOM_AUTH : Enable Lambda trigger based authentication.
	//   - ALLOW_USER_PASSWORD_AUTH : Enable user password-based authentication. In
	//   this flow, Amazon Cognito receives the password in the request instead of using
	//   the SRP protocol to verify passwords.
	//   - ALLOW_USER_SRP_AUTH : Enable SRP-based authentication.
	//   - ALLOW_REFRESH_TOKEN_AUTH : Enable authflow to refresh tokens.
	// In some environments, you will see the values ADMIN_NO_SRP_AUTH ,
	// CUSTOM_AUTH_FLOW_ONLY , or USER_PASSWORD_AUTH . You can't assign these legacy
	// ExplicitAuthFlows values to user pool clients at the same time as values that
	// begin with ALLOW_ , like ALLOW_USER_SRP_AUTH .
	ExplicitAuthFlows []ExplicitAuthFlowsType

	// The ID token time limit. After this limit expires, your user can't use their ID
	// token. To specify the time unit for IdTokenValidity as seconds , minutes , hours
	// , or days , set a TokenValidityUnits value in your API request. For example,
	// when you set IdTokenValidity as 10 and TokenValidityUnits as hours , your user
	// can authenticate their session with their ID token for 10 hours. The default
	// time unit for IdTokenValidity in an API request is hours. Valid range is
	// displayed below in seconds. If you don't specify otherwise in the configuration
	// of your app client, your ID tokens are valid for one hour.
	IdTokenValidity *int32

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	LastModifiedDate *time.Time

	// A list of allowed logout URLs for the IdPs.
	LogoutURLs []string

	// Errors and responses that you want Amazon Cognito APIs to return during
	// authentication, account confirmation, and password recovery when the user
	// doesn't exist in the user pool. When set to ENABLED and the user doesn't exist,
	// authentication returns an error indicating either the username or password was
	// incorrect. Account confirmation and password recovery return a response
	// indicating a code was sent to a simulated destination. When set to LEGACY ,
	// those APIs return a UserNotFoundException exception if the user doesn't exist
	// in the user pool. Valid values include:
	//   - ENABLED - This prevents user existence-related errors.
	//   - LEGACY - This represents the old behavior of Amazon Cognito where user
	//   existence related errors aren't prevented.
	PreventUserExistenceErrors PreventUserExistenceErrorTypes

	// The list of user attributes that you want your app client to have read-only
	// access to. After your user authenticates in your app, their access token
	// authorizes them to read their own attribute value for any attribute in this
	// list. An example of this kind of activity is when your user selects a link to
	// view their profile information. Your app makes a GetUser (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_GetUser.html)
	// API request to retrieve and display your user's profile data. When you don't
	// specify the ReadAttributes for your app client, your app can read the values of
	// email_verified , phone_number_verified , and the Standard attributes of your
	// user pool. When your user pool has read access to these default attributes,
	// ReadAttributes doesn't return any information. Amazon Cognito only populates
	// ReadAttributes in the API response if you have specified your own custom set of
	// read attributes.
	ReadAttributes []string

	// The refresh token time limit. After this limit expires, your user can't use
	// their refresh token. To specify the time unit for RefreshTokenValidity as
	// seconds , minutes , hours , or days , set a TokenValidityUnits value in your
	// API request. For example, when you set RefreshTokenValidity as 10 and
	// TokenValidityUnits as days , your user can refresh their session and retrieve
	// new access and ID tokens for 10 days. The default time unit for
	// RefreshTokenValidity in an API request is days. You can't set
	// RefreshTokenValidity to 0. If you do, Amazon Cognito overrides the value with
	// the default value of 30 days. Valid range is displayed below in seconds. If you
	// don't specify otherwise in the configuration of your app client, your refresh
	// tokens are valid for 30 days.
	RefreshTokenValidity int32

	// A list of provider names for the IdPs that this client supports. The following
	// are supported: COGNITO , Facebook , Google , SignInWithApple , LoginWithAmazon ,
	// and the names of your own SAML and OIDC providers.
	SupportedIdentityProviders []string

	// The time units used to specify the token validity times of each token type: ID,
	// access, and refresh.
	TokenValidityUnits *TokenValidityUnitsType

	// The user pool ID for the user pool client.
	UserPoolId *string

	// The list of user attributes that you want your app client to have write access
	// to. After your user authenticates in your app, their access token authorizes
	// them to set or modify their own attribute value for any attribute in this list.
	// An example of this kind of activity is when you present your user with a form to
	// update their profile information and they change their last name. Your app then
	// makes an UpdateUserAttributes (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UpdateUserAttributes.html)
	// API request and sets family_name to the new value. When you don't specify the
	// WriteAttributes for your app client, your app can write the values of the
	// Standard attributes of your user pool. When your user pool has write access to
	// these default attributes, WriteAttributes doesn't return any information.
	// Amazon Cognito only populates WriteAttributes in the API response if you have
	// specified your own custom set of write attributes. If your app client allows
	// users to sign in through an IdP, this array must include all attributes that you
	// have mapped to IdP attributes. Amazon Cognito updates mapped attributes when
	// users sign in to your application through an IdP. If your app client does not
	// have write access to a mapped attribute, Amazon Cognito throws an error when it
	// tries to update the attribute. For more information, see Specifying IdP
	// Attribute Mappings for Your user pool (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html)
	// .
	WriteAttributes []string

	noSmithyDocumentSerde
}

// A user pool description.
type UserPoolDescriptionType struct {

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// The ID in a user pool description.
	Id *string

	// The Lambda configuration information in a user pool description.
	LambdaConfig *LambdaConfigType

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	LastModifiedDate *time.Time

	// The name in a user pool description.
	Name *string

	// The user pool status in a user pool description.
	//
	// Deprecated: This property is no longer available.
	Status StatusType

	noSmithyDocumentSerde
}

// The policy associated with a user pool.
type UserPoolPolicyType struct {

	// The password policy.
	PasswordPolicy *PasswordPolicyType

	noSmithyDocumentSerde
}

// A container for information about the user pool.
type UserPoolType struct {

	// The available verified method a user can use to recover their password when
	// they call ForgotPassword . You can use this setting to define a preferred method
	// when a user has more than one method available. With this setting, SMS doesn't
	// qualify for a valid password recovery mechanism if the user also has SMS
	// multi-factor authentication (MFA) activated. In the absence of this setting,
	// Amazon Cognito uses the legacy behavior to determine the recovery method where
	// SMS is preferred through email.
	AccountRecoverySetting *AccountRecoverySettingType

	// The configuration for AdminCreateUser requests.
	AdminCreateUserConfig *AdminCreateUserConfigType

	// The attributes that are aliased in a user pool.
	AliasAttributes []AliasAttributeType

	// The Amazon Resource Name (ARN) for the user pool.
	Arn *string

	// The attributes that are auto-verified in a user pool.
	AutoVerifiedAttributes []VerifiedAttributeType

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was created.
	CreationDate *time.Time

	// A custom domain name that you provide to Amazon Cognito. This parameter applies
	// only if you use a custom domain to host the sign-up and sign-in pages for your
	// application. An example of a custom domain name might be auth.example.com . For
	// more information about adding a custom domain to your user pool, see Using Your
	// Own Domain for the Hosted UI (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html)
	// .
	CustomDomain *string

	// When active, DeletionProtection prevents accidental deletion of your user pool.
	// Before you can delete a user pool that you have protected against deletion, you
	// must deactivate this feature. When you try to delete a protected user pool in a
	// DeleteUserPool API request, Amazon Cognito returns an InvalidParameterException
	// error. To delete a protected user pool, send a new DeleteUserPool request after
	// you deactivate deletion protection in an UpdateUserPool API request.
	DeletionProtection DeletionProtectionType

	// The device-remembering configuration for a user pool. A null value indicates
	// that you have deactivated device remembering in your user pool. When you provide
	// a value for any DeviceConfiguration field, you activate the Amazon Cognito
	// device-remembering feature.
	DeviceConfiguration *DeviceConfigurationType

	// The domain prefix, if the user pool has a domain associated with it.
	Domain *string

	// The email configuration of your user pool. The email configuration type sets
	// your preferred sending method, Amazon Web Services Region, and sender for
	// messages from your user pool.
	EmailConfiguration *EmailConfigurationType

	// Deprecated. Review error codes from API requests with
	// EventSource:cognito-idp.amazonaws.com in CloudTrail for information about
	// problems with user pool email configuration.
	EmailConfigurationFailure *string

	// This parameter is no longer used. See VerificationMessageTemplateType (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html)
	// .
	EmailVerificationMessage *string

	// This parameter is no longer used. See VerificationMessageTemplateType (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html)
	// .
	EmailVerificationSubject *string

	// A number estimating the size of the user pool.
	EstimatedNumberOfUsers int32

	// The ID of the user pool.
	Id *string

	// The Lambda triggers associated with the user pool.
	LambdaConfig *LambdaConfigType

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	LastModifiedDate *time.Time

	// Can be one of the following values:
	//   - OFF - MFA tokens aren't required and can't be specified during user
	//   registration.
	//   - ON - MFA tokens are required for all user registrations. You can only
	//   specify required when you're initially creating a user pool.
	//   - OPTIONAL - Users have the option when registering to create an MFA token.
	MfaConfiguration UserPoolMfaType

	// The name of the user pool.
	Name *string

	// The policies associated with the user pool.
	Policies *UserPoolPolicyType

	// A list of the user attributes and their properties in your user pool. The
	// attribute schema contains standard attributes, custom attributes with a custom:
	// prefix, and developer attributes with a dev: prefix. For more information, see
	// User pool attributes (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html)
	// . Developer-only attributes are a legacy feature of user pools, are read-only to
	// all app clients. You can create and update developer-only attributes only with
	// IAM-authenticated API operations. Use app client read/write permissions instead.
	SchemaAttributes []SchemaAttributeType

	// The contents of the SMS authentication message.
	SmsAuthenticationMessage *string

	// The SMS configuration with the settings that your Amazon Cognito user pool must
	// use to send an SMS message from your Amazon Web Services account through Amazon
	// Simple Notification Service. To send SMS messages with Amazon SNS in the Amazon
	// Web Services Region that you want, the Amazon Cognito user pool uses an Identity
	// and Access Management (IAM) role in your Amazon Web Services account.
	SmsConfiguration *SmsConfigurationType

	// The reason why the SMS configuration can't send the messages to your users.
	// This message might include comma-separated values to describe why your SMS
	// configuration can't send messages to user pool end users.
	// InvalidSmsRoleAccessPolicyException The Identity and Access Management role that
	// Amazon Cognito uses to send SMS messages isn't properly configured. For more
	// information, see SmsConfigurationType (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_SmsConfigurationType.html)
	// . SNSSandbox The Amazon Web Services account is in the SNS SMS Sandbox and
	// messages will only reach verified end users. This parameter won’t get populated
	// with SNSSandbox if the user creating the user pool doesn’t have SNS permissions.
	// To learn how to move your Amazon Web Services account out of the sandbox, see
	// Moving out of the SMS sandbox (https://docs.aws.amazon.com/sns/latest/dg/sns-sms-sandbox-moving-to-production.html)
	// .
	SmsConfigurationFailure *string

	// This parameter is no longer used. See VerificationMessageTemplateType (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html)
	// .
	SmsVerificationMessage *string

	// This parameter is no longer used.
	//
	// Deprecated: This property is no longer available.
	Status StatusType

	// The settings for updates to user attributes. These settings include the
	// property AttributesRequireVerificationBeforeUpdate , a user-pool setting that
	// tells Amazon Cognito how to handle changes to the value of your users' email
	// address and phone number attributes. For more information, see Verifying
	// updates to email addresses and phone numbers (https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates)
	// .
	UserAttributeUpdateSettings *UserAttributeUpdateSettingsType

	// User pool add-ons. Contains settings for activation of advanced security
	// features. To log user security information but take no action, set to AUDIT . To
	// configure automatic security responses to risky traffic to your user pool, set
	// to ENFORCED . For more information, see Adding advanced security to a user pool (https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html)
	// .
	UserPoolAddOns *UserPoolAddOnsType

	// The tags that are assigned to the user pool. A tag is a label that you can
	// apply to user pools to categorize and manage them in different ways, such as by
	// purpose, owner, environment, or other criteria.
	UserPoolTags map[string]string

	// Specifies whether a user can use an email address or phone number as a username
	// when they sign up.
	UsernameAttributes []UsernameAttributeType

	// Case sensitivity of the username input for the selected sign-in option. For
	// example, when case sensitivity is set to False , users can sign in using either
	// "username" or "Username". This configuration is immutable once it has been set.
	// For more information, see UsernameConfigurationType (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html)
	// .
	UsernameConfiguration *UsernameConfigurationType

	// The template for verification messages.
	VerificationMessageTemplate *VerificationMessageTemplateType

	noSmithyDocumentSerde
}

// A user profile in a Amazon Cognito user pool.
type UserType struct {

	// A container with information about the user type attributes.
	Attributes []AttributeType

	// Specifies whether the user is enabled.
	Enabled bool

	// The MFA options for the user.
	MFAOptions []MFAOptionType

	// The creation date of the user.
	UserCreateDate *time.Time

	// The date and time, in ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
	// format, when the item was modified.
	UserLastModifiedDate *time.Time

	// The user status. This can be one of the following:
	//   - UNCONFIRMED - User has been created but not confirmed.
	//   - CONFIRMED - User has been confirmed.
	//   - EXTERNAL_PROVIDER - User signed in with a third-party IdP.
	//   - UNKNOWN - User status isn't known.
	//   - RESET_REQUIRED - User is confirmed, but the user must request a code and
	//   reset their password before they can sign in.
	//   - FORCE_CHANGE_PASSWORD - The user is confirmed and the user can sign in
	//   using a temporary password, but on first sign-in, the user must change their
	//   password to a new value before doing anything else.
	UserStatus UserStatusType

	// The user name of the user you want to describe.
	Username *string

	noSmithyDocumentSerde
}

// The template for verification messages.
type VerificationMessageTemplateType struct {

	// The default email option.
	DefaultEmailOption DefaultEmailOptionType

	// The template for email messages that Amazon Cognito sends to your users. You
	// can set an EmailMessage template only if the value of  EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER . When your EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER , your user pool sends email messages with your own Amazon SES
	// configuration.
	EmailMessage *string

	// The email message template for sending a confirmation link to the user. You can
	// set an EmailMessageByLink template only if the value of  EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER . When your EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER , your user pool sends email messages with your own Amazon SES
	// configuration.
	EmailMessageByLink *string

	// The subject line for the email message template. You can set an EmailSubject
	// template only if the value of EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER . When your EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER , your user pool sends email messages with your own Amazon SES
	// configuration.
	EmailSubject *string

	// The subject line for the email message template for sending a confirmation link
	// to the user. You can set an EmailSubjectByLink template only if the value of
	// EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER . When your EmailSendingAccount (https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_EmailConfigurationType.html#CognitoUserPools-Type-EmailConfigurationType-EmailSendingAccount)
	// is DEVELOPER , your user pool sends email messages with your own Amazon SES
	// configuration.
	EmailSubjectByLink *string

	// The template for SMS messages that Amazon Cognito sends to your users.
	SmsMessage *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
