// Code generated by smithy-go-codegen DO NOT EDIT.

package lexmodelsv2

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/lexmodelsv2/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpBatchCreateCustomVocabularyItem struct {
}

func (*awsRestjson1_serializeOpBatchCreateCustomVocabularyItem) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchCreateCustomVocabularyItem) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchCreateCustomVocabularyItemInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchcreate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchCreateCustomVocabularyItemInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchCreateCustomVocabularyItemInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchCreateCustomVocabularyItemInput(v *BatchCreateCustomVocabularyItemInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchCreateCustomVocabularyItemInput(v *BatchCreateCustomVocabularyItemInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomVocabularyItemList != nil {
		ok := object.Key("customVocabularyItemList")
		if err := awsRestjson1_serializeDocumentCreateCustomVocabularyItemsList(v.CustomVocabularyItemList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchDeleteCustomVocabularyItem struct {
}

func (*awsRestjson1_serializeOpBatchDeleteCustomVocabularyItem) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteCustomVocabularyItem) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteCustomVocabularyItemInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchdelete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDeleteCustomVocabularyItemInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteCustomVocabularyItemInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteCustomVocabularyItemInput(v *BatchDeleteCustomVocabularyItemInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteCustomVocabularyItemInput(v *BatchDeleteCustomVocabularyItemInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomVocabularyItemList != nil {
		ok := object.Key("customVocabularyItemList")
		if err := awsRestjson1_serializeDocumentDeleteCustomVocabularyItemsList(v.CustomVocabularyItemList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchUpdateCustomVocabularyItem struct {
}

func (*awsRestjson1_serializeOpBatchUpdateCustomVocabularyItem) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchUpdateCustomVocabularyItem) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchUpdateCustomVocabularyItemInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/batchupdate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchUpdateCustomVocabularyItemInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchUpdateCustomVocabularyItemInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchUpdateCustomVocabularyItemInput(v *BatchUpdateCustomVocabularyItemInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchUpdateCustomVocabularyItemInput(v *BatchUpdateCustomVocabularyItemInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomVocabularyItemList != nil {
		ok := object.Key("customVocabularyItemList")
		if err := awsRestjson1_serializeDocumentUpdateCustomVocabularyItemsList(v.CustomVocabularyItemList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBuildBotLocale struct {
}

func (*awsRestjson1_serializeOpBuildBotLocale) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBuildBotLocale) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BuildBotLocaleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBuildBotLocaleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBuildBotLocaleInput(v *BuildBotLocaleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBot struct {
}

func (*awsRestjson1_serializeOpCreateBot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBotInput(v *CreateBotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBotInput(v *CreateBotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotMembers != nil {
		ok := object.Key("botMembers")
		if err := awsRestjson1_serializeDocumentBotMembers(v.BotMembers, ok); err != nil {
			return err
		}
	}

	if v.BotName != nil {
		ok := object.Key("botName")
		ok.String(*v.BotName)
	}

	if v.BotTags != nil {
		ok := object.Key("botTags")
		if err := awsRestjson1_serializeDocumentTagMap(v.BotTags, ok); err != nil {
			return err
		}
	}

	if len(v.BotType) > 0 {
		ok := object.Key("botType")
		ok.String(string(v.BotType))
	}

	if v.DataPrivacy != nil {
		ok := object.Key("dataPrivacy")
		if err := awsRestjson1_serializeDocumentDataPrivacy(v.DataPrivacy, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.IdleSessionTTLInSeconds != nil {
		ok := object.Key("idleSessionTTLInSeconds")
		ok.Integer(*v.IdleSessionTTLInSeconds)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TestBotAliasTags != nil {
		ok := object.Key("testBotAliasTags")
		if err := awsRestjson1_serializeDocumentTagMap(v.TestBotAliasTags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBotAlias struct {
}

func (*awsRestjson1_serializeOpCreateBotAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBotAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBotAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botaliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBotAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBotAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBotAliasInput(v *CreateBotAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBotAliasInput(v *CreateBotAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotAliasLocaleSettings != nil {
		ok := object.Key("botAliasLocaleSettings")
		if err := awsRestjson1_serializeDocumentBotAliasLocaleSettingsMap(v.BotAliasLocaleSettings, ok); err != nil {
			return err
		}
	}

	if v.BotAliasName != nil {
		ok := object.Key("botAliasName")
		ok.String(*v.BotAliasName)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.ConversationLogSettings != nil {
		ok := object.Key("conversationLogSettings")
		if err := awsRestjson1_serializeDocumentConversationLogSettings(v.ConversationLogSettings, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.SentimentAnalysisSettings != nil {
		ok := object.Key("sentimentAnalysisSettings")
		if err := awsRestjson1_serializeDocumentSentimentAnalysisSettings(v.SentimentAnalysisSettings, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBotLocale struct {
}

func (*awsRestjson1_serializeOpCreateBotLocale) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBotLocale) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBotLocaleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBotLocaleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBotLocaleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBotLocaleInput(v *CreateBotLocaleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBotLocaleInput(v *CreateBotLocaleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.GenerativeAISettings != nil {
		ok := object.Key("generativeAISettings")
		if err := awsRestjson1_serializeDocumentGenerativeAISettings(v.GenerativeAISettings, ok); err != nil {
			return err
		}
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	if v.NluIntentConfidenceThreshold != nil {
		ok := object.Key("nluIntentConfidenceThreshold")
		switch {
		case math.IsNaN(*v.NluIntentConfidenceThreshold):
			ok.String("NaN")

		case math.IsInf(*v.NluIntentConfidenceThreshold, 1):
			ok.String("Infinity")

		case math.IsInf(*v.NluIntentConfidenceThreshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.NluIntentConfidenceThreshold)

		}
	}

	if v.VoiceSettings != nil {
		ok := object.Key("voiceSettings")
		if err := awsRestjson1_serializeDocumentVoiceSettings(v.VoiceSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateBotReplica struct {
}

func (*awsRestjson1_serializeOpCreateBotReplica) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBotReplica) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBotReplicaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/replicas")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBotReplicaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBotReplicaInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBotReplicaInput(v *CreateBotReplicaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBotReplicaInput(v *CreateBotReplicaInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReplicaRegion != nil {
		ok := object.Key("replicaRegion")
		ok.String(*v.ReplicaRegion)
	}

	return nil
}

type awsRestjson1_serializeOpCreateBotVersion struct {
}

func (*awsRestjson1_serializeOpCreateBotVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateBotVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBotVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateBotVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateBotVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateBotVersionInput(v *CreateBotVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateBotVersionInput(v *CreateBotVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotVersionLocaleSpecification != nil {
		ok := object.Key("botVersionLocaleSpecification")
		if err := awsRestjson1_serializeDocumentBotVersionLocaleSpecification(v.BotVersionLocaleSpecification, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpCreateExport struct {
}

func (*awsRestjson1_serializeOpCreateExport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateExport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateExportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/exports")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateExportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateExportInput(v *CreateExportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateExportInput(v *CreateExportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.FileFormat) > 0 {
		ok := object.Key("fileFormat")
		ok.String(string(v.FileFormat))
	}

	if v.FilePassword != nil {
		ok := object.Key("filePassword")
		ok.String(*v.FilePassword)
	}

	if v.ResourceSpecification != nil {
		ok := object.Key("resourceSpecification")
		if err := awsRestjson1_serializeDocumentExportResourceSpecification(v.ResourceSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateIntent struct {
}

func (*awsRestjson1_serializeOpCreateIntent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIntent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIntentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIntentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIntentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIntentInput(v *CreateIntentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIntentInput(v *CreateIntentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DialogCodeHook != nil {
		ok := object.Key("dialogCodeHook")
		if err := awsRestjson1_serializeDocumentDialogCodeHookSettings(v.DialogCodeHook, ok); err != nil {
			return err
		}
	}

	if v.FulfillmentCodeHook != nil {
		ok := object.Key("fulfillmentCodeHook")
		if err := awsRestjson1_serializeDocumentFulfillmentCodeHookSettings(v.FulfillmentCodeHook, ok); err != nil {
			return err
		}
	}

	if v.InitialResponseSetting != nil {
		ok := object.Key("initialResponseSetting")
		if err := awsRestjson1_serializeDocumentInitialResponseSetting(v.InitialResponseSetting, ok); err != nil {
			return err
		}
	}

	if v.InputContexts != nil {
		ok := object.Key("inputContexts")
		if err := awsRestjson1_serializeDocumentInputContextsList(v.InputContexts, ok); err != nil {
			return err
		}
	}

	if v.IntentClosingSetting != nil {
		ok := object.Key("intentClosingSetting")
		if err := awsRestjson1_serializeDocumentIntentClosingSetting(v.IntentClosingSetting, ok); err != nil {
			return err
		}
	}

	if v.IntentConfirmationSetting != nil {
		ok := object.Key("intentConfirmationSetting")
		if err := awsRestjson1_serializeDocumentIntentConfirmationSetting(v.IntentConfirmationSetting, ok); err != nil {
			return err
		}
	}

	if v.IntentName != nil {
		ok := object.Key("intentName")
		ok.String(*v.IntentName)
	}

	if v.KendraConfiguration != nil {
		ok := object.Key("kendraConfiguration")
		if err := awsRestjson1_serializeDocumentKendraConfiguration(v.KendraConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OutputContexts != nil {
		ok := object.Key("outputContexts")
		if err := awsRestjson1_serializeDocumentOutputContextsList(v.OutputContexts, ok); err != nil {
			return err
		}
	}

	if v.ParentIntentSignature != nil {
		ok := object.Key("parentIntentSignature")
		ok.String(*v.ParentIntentSignature)
	}

	if v.SampleUtterances != nil {
		ok := object.Key("sampleUtterances")
		if err := awsRestjson1_serializeDocumentSampleUtterancesList(v.SampleUtterances, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateResourcePolicy struct {
}

func (*awsRestjson1_serializeOpCreateResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policy/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateResourcePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateResourcePolicyInput(v *CreateResourcePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateResourcePolicyInput(v *CreateResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("policy")
		ok.String(*v.Policy)
	}

	return nil
}

type awsRestjson1_serializeOpCreateResourcePolicyStatement struct {
}

func (*awsRestjson1_serializeOpCreateResourcePolicyStatement) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateResourcePolicyStatement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateResourcePolicyStatementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policy/{resourceArn}/statements")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateResourcePolicyStatementInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateResourcePolicyStatementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateResourcePolicyStatementInput(v *CreateResourcePolicyStatementInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedRevisionId != nil {
		encoder.SetQuery("expectedRevisionId").String(*v.ExpectedRevisionId)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateResourcePolicyStatementInput(v *CreateResourcePolicyStatementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Action != nil {
		ok := object.Key("action")
		if err := awsRestjson1_serializeDocumentOperationList(v.Action, ok); err != nil {
			return err
		}
	}

	if v.Condition != nil {
		ok := object.Key("condition")
		if err := awsRestjson1_serializeDocumentConditionMap(v.Condition, ok); err != nil {
			return err
		}
	}

	if len(v.Effect) > 0 {
		ok := object.Key("effect")
		ok.String(string(v.Effect))
	}

	if v.Principal != nil {
		ok := object.Key("principal")
		if err := awsRestjson1_serializeDocumentPrincipalList(v.Principal, ok); err != nil {
			return err
		}
	}

	if v.StatementId != nil {
		ok := object.Key("statementId")
		ok.String(*v.StatementId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateSlot struct {
}

func (*awsRestjson1_serializeOpCreateSlot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSlot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSlotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSlotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSlotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSlotInput(v *CreateSlotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.IntentId == nil || len(*v.IntentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member intentId must not be empty")}
	}
	if v.IntentId != nil {
		if err := encoder.SetURI("intentId").String(*v.IntentId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSlotInput(v *CreateSlotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.MultipleValuesSetting != nil {
		ok := object.Key("multipleValuesSetting")
		if err := awsRestjson1_serializeDocumentMultipleValuesSetting(v.MultipleValuesSetting, ok); err != nil {
			return err
		}
	}

	if v.ObfuscationSetting != nil {
		ok := object.Key("obfuscationSetting")
		if err := awsRestjson1_serializeDocumentObfuscationSetting(v.ObfuscationSetting, ok); err != nil {
			return err
		}
	}

	if v.SlotName != nil {
		ok := object.Key("slotName")
		ok.String(*v.SlotName)
	}

	if v.SlotTypeId != nil {
		ok := object.Key("slotTypeId")
		ok.String(*v.SlotTypeId)
	}

	if v.SubSlotSetting != nil {
		ok := object.Key("subSlotSetting")
		if err := awsRestjson1_serializeDocumentSubSlotSetting(v.SubSlotSetting, ok); err != nil {
			return err
		}
	}

	if v.ValueElicitationSetting != nil {
		ok := object.Key("valueElicitationSetting")
		if err := awsRestjson1_serializeDocumentSlotValueElicitationSetting(v.ValueElicitationSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateSlotType struct {
}

func (*awsRestjson1_serializeOpCreateSlotType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateSlotType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSlotTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSlotTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSlotTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSlotTypeInput(v *CreateSlotTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSlotTypeInput(v *CreateSlotTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CompositeSlotTypeSetting != nil {
		ok := object.Key("compositeSlotTypeSetting")
		if err := awsRestjson1_serializeDocumentCompositeSlotTypeSetting(v.CompositeSlotTypeSetting, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExternalSourceSetting != nil {
		ok := object.Key("externalSourceSetting")
		if err := awsRestjson1_serializeDocumentExternalSourceSetting(v.ExternalSourceSetting, ok); err != nil {
			return err
		}
	}

	if v.ParentSlotTypeSignature != nil {
		ok := object.Key("parentSlotTypeSignature")
		ok.String(*v.ParentSlotTypeSignature)
	}

	if v.SlotTypeName != nil {
		ok := object.Key("slotTypeName")
		ok.String(*v.SlotTypeName)
	}

	if v.SlotTypeValues != nil {
		ok := object.Key("slotTypeValues")
		if err := awsRestjson1_serializeDocumentSlotTypeValues(v.SlotTypeValues, ok); err != nil {
			return err
		}
	}

	if v.ValueSelectionSetting != nil {
		ok := object.Key("valueSelectionSetting")
		if err := awsRestjson1_serializeDocumentSlotValueSelectionSetting(v.ValueSelectionSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTestSetDiscrepancyReport struct {
}

func (*awsRestjson1_serializeOpCreateTestSetDiscrepancyReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTestSetDiscrepancyReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTestSetDiscrepancyReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsets/{testSetId}/testsetdiscrepancy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateTestSetDiscrepancyReportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateTestSetDiscrepancyReportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateTestSetDiscrepancyReportInput(v *CreateTestSetDiscrepancyReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestSetId == nil || len(*v.TestSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testSetId must not be empty")}
	}
	if v.TestSetId != nil {
		if err := encoder.SetURI("testSetId").String(*v.TestSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateTestSetDiscrepancyReportInput(v *CreateTestSetDiscrepancyReportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentTestSetDiscrepancyReportResourceTarget(v.Target, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateUploadUrl struct {
}

func (*awsRestjson1_serializeOpCreateUploadUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateUploadUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUploadUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/createuploadurl")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateUploadUrlInput(v *CreateUploadUrlInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBot struct {
}

func (*awsRestjson1_serializeOpDeleteBot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBotInput(v *DeleteBotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.SkipResourceInUseCheck {
		encoder.SetQuery("skipResourceInUseCheck").Boolean(v.SkipResourceInUseCheck)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBotAlias struct {
}

func (*awsRestjson1_serializeOpDeleteBotAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBotAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBotAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botaliases/{botAliasId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBotAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBotAliasInput(v *DeleteBotAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.SkipResourceInUseCheck {
		encoder.SetQuery("skipResourceInUseCheck").Boolean(v.SkipResourceInUseCheck)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBotLocale struct {
}

func (*awsRestjson1_serializeOpDeleteBotLocale) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBotLocale) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBotLocaleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBotLocaleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBotLocaleInput(v *DeleteBotLocaleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBotReplica struct {
}

func (*awsRestjson1_serializeOpDeleteBotReplica) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBotReplica) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBotReplicaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/replicas/{replicaRegion}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBotReplicaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBotReplicaInput(v *DeleteBotReplicaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.ReplicaRegion == nil || len(*v.ReplicaRegion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member replicaRegion must not be empty")}
	}
	if v.ReplicaRegion != nil {
		if err := encoder.SetURI("replicaRegion").String(*v.ReplicaRegion); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteBotVersion struct {
}

func (*awsRestjson1_serializeOpDeleteBotVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteBotVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBotVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteBotVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteBotVersionInput(v *DeleteBotVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.SkipResourceInUseCheck {
		encoder.SetQuery("skipResourceInUseCheck").Boolean(v.SkipResourceInUseCheck)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCustomVocabulary struct {
}

func (*awsRestjson1_serializeOpDeleteCustomVocabulary) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCustomVocabulary) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteCustomVocabularyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteCustomVocabularyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteCustomVocabularyInput(v *DeleteCustomVocabularyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteExport struct {
}

func (*awsRestjson1_serializeOpDeleteExport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteExport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteExportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/exports/{exportId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteExportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteExportInput(v *DeleteExportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExportId == nil || len(*v.ExportId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member exportId must not be empty")}
	}
	if v.ExportId != nil {
		if err := encoder.SetURI("exportId").String(*v.ExportId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteImport struct {
}

func (*awsRestjson1_serializeOpDeleteImport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteImport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteImportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/imports/{importId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteImportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteImportInput(v *DeleteImportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ImportId == nil || len(*v.ImportId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member importId must not be empty")}
	}
	if v.ImportId != nil {
		if err := encoder.SetURI("importId").String(*v.ImportId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIntent struct {
}

func (*awsRestjson1_serializeOpDeleteIntent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIntent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIntentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIntentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIntentInput(v *DeleteIntentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.IntentId == nil || len(*v.IntentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member intentId must not be empty")}
	}
	if v.IntentId != nil {
		if err := encoder.SetURI("intentId").String(*v.IntentId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteResourcePolicy struct {
}

func (*awsRestjson1_serializeOpDeleteResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policy/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteResourcePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteResourcePolicyInput(v *DeleteResourcePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedRevisionId != nil {
		encoder.SetQuery("expectedRevisionId").String(*v.ExpectedRevisionId)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteResourcePolicyStatement struct {
}

func (*awsRestjson1_serializeOpDeleteResourcePolicyStatement) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteResourcePolicyStatement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteResourcePolicyStatementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policy/{resourceArn}/statements/{statementId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteResourcePolicyStatementInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteResourcePolicyStatementInput(v *DeleteResourcePolicyStatementInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedRevisionId != nil {
		encoder.SetQuery("expectedRevisionId").String(*v.ExpectedRevisionId)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.StatementId == nil || len(*v.StatementId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member statementId must not be empty")}
	}
	if v.StatementId != nil {
		if err := encoder.SetURI("statementId").String(*v.StatementId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSlot struct {
}

func (*awsRestjson1_serializeOpDeleteSlot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSlot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSlotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSlotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSlotInput(v *DeleteSlotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.IntentId == nil || len(*v.IntentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member intentId must not be empty")}
	}
	if v.IntentId != nil {
		if err := encoder.SetURI("intentId").String(*v.IntentId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SlotId == nil || len(*v.SlotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member slotId must not be empty")}
	}
	if v.SlotId != nil {
		if err := encoder.SetURI("slotId").String(*v.SlotId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteSlotType struct {
}

func (*awsRestjson1_serializeOpDeleteSlotType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteSlotType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSlotTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSlotTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSlotTypeInput(v *DeleteSlotTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SkipResourceInUseCheck {
		encoder.SetQuery("skipResourceInUseCheck").Boolean(v.SkipResourceInUseCheck)
	}

	if v.SlotTypeId == nil || len(*v.SlotTypeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member slotTypeId must not be empty")}
	}
	if v.SlotTypeId != nil {
		if err := encoder.SetURI("slotTypeId").String(*v.SlotTypeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTestSet struct {
}

func (*awsRestjson1_serializeOpDeleteTestSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTestSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTestSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsets/{testSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteTestSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteTestSetInput(v *DeleteTestSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestSetId == nil || len(*v.TestSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testSetId must not be empty")}
	}
	if v.TestSetId != nil {
		if err := encoder.SetURI("testSetId").String(*v.TestSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUtterances struct {
}

func (*awsRestjson1_serializeOpDeleteUtterances) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUtterances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUtterancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/utterances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUtterancesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUtterancesInput(v *DeleteUtterancesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.LocaleId != nil {
		encoder.SetQuery("localeId").String(*v.LocaleId)
	}

	if v.SessionId != nil {
		encoder.SetQuery("sessionId").String(*v.SessionId)
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBot struct {
}

func (*awsRestjson1_serializeOpDescribeBot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBotInput(v *DescribeBotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBotAlias struct {
}

func (*awsRestjson1_serializeOpDescribeBotAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBotAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBotAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botaliases/{botAliasId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBotAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBotAliasInput(v *DescribeBotAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBotLocale struct {
}

func (*awsRestjson1_serializeOpDescribeBotLocale) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBotLocale) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBotLocaleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBotLocaleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBotLocaleInput(v *DescribeBotLocaleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBotRecommendation struct {
}

func (*awsRestjson1_serializeOpDescribeBotRecommendation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBotRecommendation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBotRecommendationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBotRecommendationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBotRecommendationInput(v *DescribeBotRecommendationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotRecommendationId == nil || len(*v.BotRecommendationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botRecommendationId must not be empty")}
	}
	if v.BotRecommendationId != nil {
		if err := encoder.SetURI("botRecommendationId").String(*v.BotRecommendationId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBotReplica struct {
}

func (*awsRestjson1_serializeOpDescribeBotReplica) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBotReplica) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBotReplicaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/replicas/{replicaRegion}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBotReplicaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBotReplicaInput(v *DescribeBotReplicaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.ReplicaRegion == nil || len(*v.ReplicaRegion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member replicaRegion must not be empty")}
	}
	if v.ReplicaRegion != nil {
		if err := encoder.SetURI("replicaRegion").String(*v.ReplicaRegion); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBotResourceGeneration struct {
}

func (*awsRestjson1_serializeOpDescribeBotResourceGeneration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBotResourceGeneration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBotResourceGenerationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/generations/{generationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBotResourceGenerationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBotResourceGenerationInput(v *DescribeBotResourceGenerationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.GenerationId == nil || len(*v.GenerationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member generationId must not be empty")}
	}
	if v.GenerationId != nil {
		if err := encoder.SetURI("generationId").String(*v.GenerationId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeBotVersion struct {
}

func (*awsRestjson1_serializeOpDescribeBotVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeBotVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeBotVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeBotVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeBotVersionInput(v *DescribeBotVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeCustomVocabularyMetadata struct {
}

func (*awsRestjson1_serializeOpDescribeCustomVocabularyMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeCustomVocabularyMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeCustomVocabularyMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/metadata")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeCustomVocabularyMetadataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeCustomVocabularyMetadataInput(v *DescribeCustomVocabularyMetadataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeExport struct {
}

func (*awsRestjson1_serializeOpDescribeExport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeExport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeExportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/exports/{exportId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeExportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeExportInput(v *DescribeExportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExportId == nil || len(*v.ExportId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member exportId must not be empty")}
	}
	if v.ExportId != nil {
		if err := encoder.SetURI("exportId").String(*v.ExportId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeImport struct {
}

func (*awsRestjson1_serializeOpDescribeImport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeImport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeImportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/imports/{importId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeImportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeImportInput(v *DescribeImportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ImportId == nil || len(*v.ImportId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member importId must not be empty")}
	}
	if v.ImportId != nil {
		if err := encoder.SetURI("importId").String(*v.ImportId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeIntent struct {
}

func (*awsRestjson1_serializeOpDescribeIntent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeIntent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeIntentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeIntentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeIntentInput(v *DescribeIntentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.IntentId == nil || len(*v.IntentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member intentId must not be empty")}
	}
	if v.IntentId != nil {
		if err := encoder.SetURI("intentId").String(*v.IntentId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeResourcePolicy struct {
}

func (*awsRestjson1_serializeOpDescribeResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policy/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeResourcePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeResourcePolicyInput(v *DescribeResourcePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeSlot struct {
}

func (*awsRestjson1_serializeOpDescribeSlot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeSlot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSlotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeSlotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeSlotInput(v *DescribeSlotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.IntentId == nil || len(*v.IntentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member intentId must not be empty")}
	}
	if v.IntentId != nil {
		if err := encoder.SetURI("intentId").String(*v.IntentId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SlotId == nil || len(*v.SlotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member slotId must not be empty")}
	}
	if v.SlotId != nil {
		if err := encoder.SetURI("slotId").String(*v.SlotId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeSlotType struct {
}

func (*awsRestjson1_serializeOpDescribeSlotType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeSlotType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeSlotTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeSlotTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeSlotTypeInput(v *DescribeSlotTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SlotTypeId == nil || len(*v.SlotTypeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member slotTypeId must not be empty")}
	}
	if v.SlotTypeId != nil {
		if err := encoder.SetURI("slotTypeId").String(*v.SlotTypeId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTestExecution struct {
}

func (*awsRestjson1_serializeOpDescribeTestExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTestExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTestExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testexecutions/{testExecutionId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTestExecutionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTestExecutionInput(v *DescribeTestExecutionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestExecutionId == nil || len(*v.TestExecutionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testExecutionId must not be empty")}
	}
	if v.TestExecutionId != nil {
		if err := encoder.SetURI("testExecutionId").String(*v.TestExecutionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTestSet struct {
}

func (*awsRestjson1_serializeOpDescribeTestSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTestSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTestSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsets/{testSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTestSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTestSetInput(v *DescribeTestSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestSetId == nil || len(*v.TestSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testSetId must not be empty")}
	}
	if v.TestSetId != nil {
		if err := encoder.SetURI("testSetId").String(*v.TestSetId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTestSetDiscrepancyReport struct {
}

func (*awsRestjson1_serializeOpDescribeTestSetDiscrepancyReport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTestSetDiscrepancyReport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTestSetDiscrepancyReportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsetdiscrepancy/{testSetDiscrepancyReportId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTestSetDiscrepancyReportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTestSetDiscrepancyReportInput(v *DescribeTestSetDiscrepancyReportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestSetDiscrepancyReportId == nil || len(*v.TestSetDiscrepancyReportId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testSetDiscrepancyReportId must not be empty")}
	}
	if v.TestSetDiscrepancyReportId != nil {
		if err := encoder.SetURI("testSetDiscrepancyReportId").String(*v.TestSetDiscrepancyReportId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeTestSetGeneration struct {
}

func (*awsRestjson1_serializeOpDescribeTestSetGeneration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeTestSetGeneration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTestSetGenerationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsetgenerations/{testSetGenerationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeTestSetGenerationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeTestSetGenerationInput(v *DescribeTestSetGenerationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestSetGenerationId == nil || len(*v.TestSetGenerationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testSetGenerationId must not be empty")}
	}
	if v.TestSetGenerationId != nil {
		if err := encoder.SetURI("testSetGenerationId").String(*v.TestSetGenerationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGenerateBotElement struct {
}

func (*awsRestjson1_serializeOpGenerateBotElement) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGenerateBotElement) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GenerateBotElementInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/generate")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGenerateBotElementInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGenerateBotElementInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGenerateBotElementInput(v *GenerateBotElementInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGenerateBotElementInput(v *GenerateBotElementInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntentId != nil {
		ok := object.Key("intentId")
		ok.String(*v.IntentId)
	}

	return nil
}

type awsRestjson1_serializeOpGetTestExecutionArtifactsUrl struct {
}

func (*awsRestjson1_serializeOpGetTestExecutionArtifactsUrl) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTestExecutionArtifactsUrl) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetTestExecutionArtifactsUrlInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testexecutions/{testExecutionId}/artifacturl")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetTestExecutionArtifactsUrlInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetTestExecutionArtifactsUrlInput(v *GetTestExecutionArtifactsUrlInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestExecutionId == nil || len(*v.TestExecutionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testExecutionId must not be empty")}
	}
	if v.TestExecutionId != nil {
		if err := encoder.SetURI("testExecutionId").String(*v.TestExecutionId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAggregatedUtterances struct {
}

func (*awsRestjson1_serializeOpListAggregatedUtterances) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAggregatedUtterances) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAggregatedUtterancesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/aggregatedutterances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAggregatedUtterancesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAggregatedUtterancesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAggregatedUtterancesInput(v *ListAggregatedUtterancesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAggregatedUtterancesInput(v *ListAggregatedUtterancesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AggregationDuration != nil {
		ok := object.Key("aggregationDuration")
		if err := awsRestjson1_serializeDocumentUtteranceAggregationDuration(v.AggregationDuration, ok); err != nil {
			return err
		}
	}

	if v.BotAliasId != nil {
		ok := object.Key("botAliasId")
		ok.String(*v.BotAliasId)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAggregatedUtterancesFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentAggregatedUtterancesSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBotAliases struct {
}

func (*awsRestjson1_serializeOpListBotAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBotAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botaliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotAliasesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBotAliasesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotAliasesInput(v *ListBotAliasesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBotAliasesInput(v *ListBotAliasesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBotAliasReplicas struct {
}

func (*awsRestjson1_serializeOpListBotAliasReplicas) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBotAliasReplicas) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotAliasReplicasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/replicas/{replicaRegion}/botaliases")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotAliasReplicasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBotAliasReplicasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotAliasReplicasInput(v *ListBotAliasReplicasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.ReplicaRegion == nil || len(*v.ReplicaRegion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member replicaRegion must not be empty")}
	}
	if v.ReplicaRegion != nil {
		if err := encoder.SetURI("replicaRegion").String(*v.ReplicaRegion); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBotAliasReplicasInput(v *ListBotAliasReplicasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBotLocales struct {
}

func (*awsRestjson1_serializeOpListBotLocales) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBotLocales) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotLocalesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotLocalesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBotLocalesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotLocalesInput(v *ListBotLocalesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBotLocalesInput(v *ListBotLocalesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentBotLocaleFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentBotLocaleSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBotRecommendations struct {
}

func (*awsRestjson1_serializeOpListBotRecommendations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBotRecommendations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotRecommendationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotRecommendationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBotRecommendationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotRecommendationsInput(v *ListBotRecommendationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBotRecommendationsInput(v *ListBotRecommendationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListBotReplicas struct {
}

func (*awsRestjson1_serializeOpListBotReplicas) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBotReplicas) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotReplicasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/replicas")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotReplicasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotReplicasInput(v *ListBotReplicasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBotResourceGenerations struct {
}

func (*awsRestjson1_serializeOpListBotResourceGenerations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBotResourceGenerations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotResourceGenerationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/generations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotResourceGenerationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBotResourceGenerationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotResourceGenerationsInput(v *ListBotResourceGenerationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBotResourceGenerationsInput(v *ListBotResourceGenerationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentGenerationSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBots struct {
}

func (*awsRestjson1_serializeOpListBots) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBotsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotsInput(v *ListBotsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBotsInput(v *ListBotsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentBotFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentBotSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBotVersionReplicas struct {
}

func (*awsRestjson1_serializeOpListBotVersionReplicas) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBotVersionReplicas) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotVersionReplicasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/replicas/{replicaRegion}/botversions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotVersionReplicasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBotVersionReplicasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotVersionReplicasInput(v *ListBotVersionReplicasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.ReplicaRegion == nil || len(*v.ReplicaRegion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member replicaRegion must not be empty")}
	}
	if v.ReplicaRegion != nil {
		if err := encoder.SetURI("replicaRegion").String(*v.ReplicaRegion); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBotVersionReplicasInput(v *ListBotVersionReplicasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentBotVersionReplicaSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBotVersions struct {
}

func (*awsRestjson1_serializeOpListBotVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBotVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBotVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBotVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBotVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBotVersionsInput(v *ListBotVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBotVersionsInput(v *ListBotVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentBotVersionSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBuiltInIntents struct {
}

func (*awsRestjson1_serializeOpListBuiltInIntents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBuiltInIntents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBuiltInIntentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/builtins/locales/{localeId}/intents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBuiltInIntentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBuiltInIntentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBuiltInIntentsInput(v *ListBuiltInIntentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBuiltInIntentsInput(v *ListBuiltInIntentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentBuiltInIntentSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListBuiltInSlotTypes struct {
}

func (*awsRestjson1_serializeOpListBuiltInSlotTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListBuiltInSlotTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListBuiltInSlotTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/builtins/locales/{localeId}/slottypes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListBuiltInSlotTypesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListBuiltInSlotTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListBuiltInSlotTypesInput(v *ListBuiltInSlotTypesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListBuiltInSlotTypesInput(v *ListBuiltInSlotTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentBuiltInSlotTypeSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListCustomVocabularyItems struct {
}

func (*awsRestjson1_serializeOpListCustomVocabularyItems) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListCustomVocabularyItems) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCustomVocabularyItemsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/customvocabulary/DEFAULT/list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListCustomVocabularyItemsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListCustomVocabularyItemsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListCustomVocabularyItemsInput(v *ListCustomVocabularyItemsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListCustomVocabularyItemsInput(v *ListCustomVocabularyItemsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListExports struct {
}

func (*awsRestjson1_serializeOpListExports) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListExports) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListExportsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/exports")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListExportsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListExportsInput(v *ListExportsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListExportsInput(v *ListExportsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentExportFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentExportSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListImports struct {
}

func (*awsRestjson1_serializeOpListImports) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListImports) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListImportsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/imports")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListImportsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListImportsInput(v *ListImportsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListImportsInput(v *ListImportsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentImportFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentImportSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListIntentMetrics struct {
}

func (*awsRestjson1_serializeOpListIntentMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIntentMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIntentMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/analytics/intentmetrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIntentMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListIntentMetricsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIntentMetricsInput(v *ListIntentMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListIntentMetricsInput(v *ListIntentMetricsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BinBy != nil {
		ok := object.Key("binBy")
		if err := awsRestjson1_serializeDocumentAnalyticsBinByList(v.BinBy, ok); err != nil {
			return err
		}
	}

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAnalyticsIntentFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.GroupBy != nil {
		ok := object.Key("groupBy")
		if err := awsRestjson1_serializeDocumentAnalyticsIntentGroupByList(v.GroupBy, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Metrics != nil {
		ok := object.Key("metrics")
		if err := awsRestjson1_serializeDocumentAnalyticsIntentMetrics(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

type awsRestjson1_serializeOpListIntentPaths struct {
}

func (*awsRestjson1_serializeOpListIntentPaths) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIntentPaths) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIntentPathsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/analytics/intentpaths")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIntentPathsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListIntentPathsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIntentPathsInput(v *ListIntentPathsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListIntentPathsInput(v *ListIntentPathsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAnalyticsPathFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.IntentPath != nil {
		ok := object.Key("intentPath")
		ok.String(*v.IntentPath)
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

type awsRestjson1_serializeOpListIntents struct {
}

func (*awsRestjson1_serializeOpListIntents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIntents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIntentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIntentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListIntentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIntentsInput(v *ListIntentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListIntentsInput(v *ListIntentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentIntentFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentIntentSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListIntentStageMetrics struct {
}

func (*awsRestjson1_serializeOpListIntentStageMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIntentStageMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIntentStageMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/analytics/intentstagemetrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIntentStageMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListIntentStageMetricsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIntentStageMetricsInput(v *ListIntentStageMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListIntentStageMetricsInput(v *ListIntentStageMetricsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BinBy != nil {
		ok := object.Key("binBy")
		if err := awsRestjson1_serializeDocumentAnalyticsBinByList(v.BinBy, ok); err != nil {
			return err
		}
	}

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAnalyticsIntentStageFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.GroupBy != nil {
		ok := object.Key("groupBy")
		if err := awsRestjson1_serializeDocumentAnalyticsIntentStageGroupByList(v.GroupBy, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Metrics != nil {
		ok := object.Key("metrics")
		if err := awsRestjson1_serializeDocumentAnalyticsIntentStageMetrics(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

type awsRestjson1_serializeOpListRecommendedIntents struct {
}

func (*awsRestjson1_serializeOpListRecommendedIntents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRecommendedIntents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRecommendedIntentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/intents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRecommendedIntentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListRecommendedIntentsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRecommendedIntentsInput(v *ListRecommendedIntentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotRecommendationId == nil || len(*v.BotRecommendationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botRecommendationId must not be empty")}
	}
	if v.BotRecommendationId != nil {
		if err := encoder.SetURI("botRecommendationId").String(*v.BotRecommendationId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListRecommendedIntentsInput(v *ListRecommendedIntentsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListSessionAnalyticsData struct {
}

func (*awsRestjson1_serializeOpListSessionAnalyticsData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSessionAnalyticsData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSessionAnalyticsDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/analytics/sessions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSessionAnalyticsDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListSessionAnalyticsDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSessionAnalyticsDataInput(v *ListSessionAnalyticsDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListSessionAnalyticsDataInput(v *ListSessionAnalyticsDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAnalyticsSessionFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentSessionDataSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

type awsRestjson1_serializeOpListSessionMetrics struct {
}

func (*awsRestjson1_serializeOpListSessionMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSessionMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSessionMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/analytics/sessionmetrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSessionMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListSessionMetricsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSessionMetricsInput(v *ListSessionMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListSessionMetricsInput(v *ListSessionMetricsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BinBy != nil {
		ok := object.Key("binBy")
		if err := awsRestjson1_serializeDocumentAnalyticsBinByList(v.BinBy, ok); err != nil {
			return err
		}
	}

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAnalyticsSessionFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.GroupBy != nil {
		ok := object.Key("groupBy")
		if err := awsRestjson1_serializeDocumentAnalyticsSessionGroupByList(v.GroupBy, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Metrics != nil {
		ok := object.Key("metrics")
		if err := awsRestjson1_serializeDocumentAnalyticsSessionMetrics(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

type awsRestjson1_serializeOpListSlots struct {
}

func (*awsRestjson1_serializeOpListSlots) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSlots) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSlotsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSlotsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListSlotsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSlotsInput(v *ListSlotsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.IntentId == nil || len(*v.IntentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member intentId must not be empty")}
	}
	if v.IntentId != nil {
		if err := encoder.SetURI("intentId").String(*v.IntentId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListSlotsInput(v *ListSlotsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentSlotFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentSlotSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListSlotTypes struct {
}

func (*awsRestjson1_serializeOpListSlotTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListSlotTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListSlotTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListSlotTypesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListSlotTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListSlotTypesInput(v *ListSlotTypesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListSlotTypesInput(v *ListSlotTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentSlotTypeFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentSlotTypeSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTestExecutionResultItems struct {
}

func (*awsRestjson1_serializeOpListTestExecutionResultItems) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTestExecutionResultItems) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTestExecutionResultItemsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testexecutions/{testExecutionId}/results")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTestExecutionResultItemsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTestExecutionResultItemsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTestExecutionResultItemsInput(v *ListTestExecutionResultItemsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestExecutionId == nil || len(*v.TestExecutionId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testExecutionId must not be empty")}
	}
	if v.TestExecutionId != nil {
		if err := encoder.SetURI("testExecutionId").String(*v.TestExecutionId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTestExecutionResultItemsInput(v *ListTestExecutionResultItemsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ResultFilterBy != nil {
		ok := object.Key("resultFilterBy")
		if err := awsRestjson1_serializeDocumentTestExecutionResultFilterBy(v.ResultFilterBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTestExecutions struct {
}

func (*awsRestjson1_serializeOpListTestExecutions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTestExecutions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTestExecutionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testexecutions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTestExecutionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTestExecutionsInput(v *ListTestExecutionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTestExecutionsInput(v *ListTestExecutionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentTestExecutionSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListTestSetRecords struct {
}

func (*awsRestjson1_serializeOpListTestSetRecords) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTestSetRecords) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTestSetRecordsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsets/{testSetId}/records")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTestSetRecordsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTestSetRecordsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTestSetRecordsInput(v *ListTestSetRecordsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestSetId == nil || len(*v.TestSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testSetId must not be empty")}
	}
	if v.TestSetId != nil {
		if err := encoder.SetURI("testSetId").String(*v.TestSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTestSetRecordsInput(v *ListTestSetRecordsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTestSets struct {
}

func (*awsRestjson1_serializeOpListTestSets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTestSets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTestSetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTestSetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTestSetsInput(v *ListTestSetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTestSetsInput(v *ListTestSetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentTestSetSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListUtteranceAnalyticsData struct {
}

func (*awsRestjson1_serializeOpListUtteranceAnalyticsData) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUtteranceAnalyticsData) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUtteranceAnalyticsDataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/analytics/utterances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUtteranceAnalyticsDataInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListUtteranceAnalyticsDataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUtteranceAnalyticsDataInput(v *ListUtteranceAnalyticsDataInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListUtteranceAnalyticsDataInput(v *ListUtteranceAnalyticsDataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.SortBy != nil {
		ok := object.Key("sortBy")
		if err := awsRestjson1_serializeDocumentUtteranceDataSortBy(v.SortBy, ok); err != nil {
			return err
		}
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

type awsRestjson1_serializeOpListUtteranceMetrics struct {
}

func (*awsRestjson1_serializeOpListUtteranceMetrics) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListUtteranceMetrics) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListUtteranceMetricsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/analytics/utterancemetrics")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListUtteranceMetricsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListUtteranceMetricsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListUtteranceMetricsInput(v *ListUtteranceMetricsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListUtteranceMetricsInput(v *ListUtteranceMetricsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.BinBy != nil {
		ok := object.Key("binBy")
		if err := awsRestjson1_serializeDocumentAnalyticsBinByList(v.BinBy, ok); err != nil {
			return err
		}
	}

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.GroupBy != nil {
		ok := object.Key("groupBy")
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceGroupByList(v.GroupBy, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.Metrics != nil {
		ok := object.Key("metrics")
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceMetrics(v.Metrics, ok); err != nil {
			return err
		}
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

type awsRestjson1_serializeOpSearchAssociatedTranscripts struct {
}

func (*awsRestjson1_serializeOpSearchAssociatedTranscripts) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchAssociatedTranscripts) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchAssociatedTranscriptsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/associatedtranscripts")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchAssociatedTranscriptsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchAssociatedTranscriptsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchAssociatedTranscriptsInput(v *SearchAssociatedTranscriptsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotRecommendationId == nil || len(*v.BotRecommendationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botRecommendationId must not be empty")}
	}
	if v.BotRecommendationId != nil {
		if err := encoder.SetURI("botRecommendationId").String(*v.BotRecommendationId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchAssociatedTranscriptsInput(v *SearchAssociatedTranscriptsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentAssociatedTranscriptFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextIndex != nil {
		ok := object.Key("nextIndex")
		ok.Integer(*v.NextIndex)
	}

	if len(v.SearchOrder) > 0 {
		ok := object.Key("searchOrder")
		ok.String(string(v.SearchOrder))
	}

	return nil
}

type awsRestjson1_serializeOpStartBotRecommendation struct {
}

func (*awsRestjson1_serializeOpStartBotRecommendation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartBotRecommendation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartBotRecommendationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartBotRecommendationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartBotRecommendationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartBotRecommendationInput(v *StartBotRecommendationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartBotRecommendationInput(v *StartBotRecommendationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionSetting != nil {
		ok := object.Key("encryptionSetting")
		if err := awsRestjson1_serializeDocumentEncryptionSetting(v.EncryptionSetting, ok); err != nil {
			return err
		}
	}

	if v.TranscriptSourceSetting != nil {
		ok := object.Key("transcriptSourceSetting")
		if err := awsRestjson1_serializeDocumentTranscriptSourceSetting(v.TranscriptSourceSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartBotResourceGeneration struct {
}

func (*awsRestjson1_serializeOpStartBotResourceGeneration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartBotResourceGeneration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartBotResourceGenerationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/startgeneration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartBotResourceGenerationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartBotResourceGenerationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartBotResourceGenerationInput(v *StartBotResourceGenerationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartBotResourceGenerationInput(v *StartBotResourceGenerationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GenerationInputPrompt != nil {
		ok := object.Key("generationInputPrompt")
		ok.String(*v.GenerationInputPrompt)
	}

	return nil
}

type awsRestjson1_serializeOpStartImport struct {
}

func (*awsRestjson1_serializeOpStartImport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartImport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartImportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/imports")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartImportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartImportInput(v *StartImportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartImportInput(v *StartImportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilePassword != nil {
		ok := object.Key("filePassword")
		ok.String(*v.FilePassword)
	}

	if v.ImportId != nil {
		ok := object.Key("importId")
		ok.String(*v.ImportId)
	}

	if len(v.MergeStrategy) > 0 {
		ok := object.Key("mergeStrategy")
		ok.String(string(v.MergeStrategy))
	}

	if v.ResourceSpecification != nil {
		ok := object.Key("resourceSpecification")
		if err := awsRestjson1_serializeDocumentImportResourceSpecification(v.ResourceSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStartTestExecution struct {
}

func (*awsRestjson1_serializeOpStartTestExecution) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartTestExecution) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTestExecutionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsets/{testSetId}/testexecutions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartTestExecutionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartTestExecutionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartTestExecutionInput(v *StartTestExecutionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestSetId == nil || len(*v.TestSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testSetId must not be empty")}
	}
	if v.TestSetId != nil {
		if err := encoder.SetURI("testSetId").String(*v.TestSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartTestExecutionInput(v *StartTestExecutionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ApiMode) > 0 {
		ok := object.Key("apiMode")
		ok.String(string(v.ApiMode))
	}

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentTestExecutionTarget(v.Target, ok); err != nil {
			return err
		}
	}

	if len(v.TestExecutionModality) > 0 {
		ok := object.Key("testExecutionModality")
		ok.String(string(v.TestExecutionModality))
	}

	return nil
}

type awsRestjson1_serializeOpStartTestSetGeneration struct {
}

func (*awsRestjson1_serializeOpStartTestSetGeneration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartTestSetGeneration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartTestSetGenerationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsetgenerations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentStartTestSetGenerationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartTestSetGenerationInput(v *StartTestSetGenerationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentStartTestSetGenerationInput(v *StartTestSetGenerationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.GenerationDataSource != nil {
		ok := object.Key("generationDataSource")
		if err := awsRestjson1_serializeDocumentTestSetGenerationDataSource(v.GenerationDataSource, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.StorageLocation != nil {
		ok := object.Key("storageLocation")
		if err := awsRestjson1_serializeDocumentTestSetStorageLocation(v.StorageLocation, ok); err != nil {
			return err
		}
	}

	if v.TestSetName != nil {
		ok := object.Key("testSetName")
		ok.String(*v.TestSetName)
	}

	if v.TestSetTags != nil {
		ok := object.Key("testSetTags")
		if err := awsRestjson1_serializeDocumentTagMap(v.TestSetTags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopBotRecommendation struct {
}

func (*awsRestjson1_serializeOpStopBotRecommendation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopBotRecommendation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopBotRecommendationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}/stopbotrecommendation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopBotRecommendationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopBotRecommendationInput(v *StopBotRecommendationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotRecommendationId == nil || len(*v.BotRecommendationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botRecommendationId must not be empty")}
	}
	if v.BotRecommendationId != nil {
		if err := encoder.SetURI("botRecommendationId").String(*v.BotRecommendationId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBot struct {
}

func (*awsRestjson1_serializeOpUpdateBot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBotInput(v *UpdateBotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBotInput(v *UpdateBotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotMembers != nil {
		ok := object.Key("botMembers")
		if err := awsRestjson1_serializeDocumentBotMembers(v.BotMembers, ok); err != nil {
			return err
		}
	}

	if v.BotName != nil {
		ok := object.Key("botName")
		ok.String(*v.BotName)
	}

	if len(v.BotType) > 0 {
		ok := object.Key("botType")
		ok.String(string(v.BotType))
	}

	if v.DataPrivacy != nil {
		ok := object.Key("dataPrivacy")
		if err := awsRestjson1_serializeDocumentDataPrivacy(v.DataPrivacy, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.IdleSessionTTLInSeconds != nil {
		ok := object.Key("idleSessionTTLInSeconds")
		ok.Integer(*v.IdleSessionTTLInSeconds)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBotAlias struct {
}

func (*awsRestjson1_serializeOpUpdateBotAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBotAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBotAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botaliases/{botAliasId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBotAliasInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBotAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBotAliasInput(v *UpdateBotAliasInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotAliasId == nil || len(*v.BotAliasId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botAliasId must not be empty")}
	}
	if v.BotAliasId != nil {
		if err := encoder.SetURI("botAliasId").String(*v.BotAliasId); err != nil {
			return err
		}
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBotAliasInput(v *UpdateBotAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotAliasLocaleSettings != nil {
		ok := object.Key("botAliasLocaleSettings")
		if err := awsRestjson1_serializeDocumentBotAliasLocaleSettingsMap(v.BotAliasLocaleSettings, ok); err != nil {
			return err
		}
	}

	if v.BotAliasName != nil {
		ok := object.Key("botAliasName")
		ok.String(*v.BotAliasName)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.ConversationLogSettings != nil {
		ok := object.Key("conversationLogSettings")
		if err := awsRestjson1_serializeDocumentConversationLogSettings(v.ConversationLogSettings, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.SentimentAnalysisSettings != nil {
		ok := object.Key("sentimentAnalysisSettings")
		if err := awsRestjson1_serializeDocumentSentimentAnalysisSettings(v.SentimentAnalysisSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBotLocale struct {
}

func (*awsRestjson1_serializeOpUpdateBotLocale) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBotLocale) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBotLocaleInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBotLocaleInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBotLocaleInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBotLocaleInput(v *UpdateBotLocaleInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBotLocaleInput(v *UpdateBotLocaleInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.GenerativeAISettings != nil {
		ok := object.Key("generativeAISettings")
		if err := awsRestjson1_serializeDocumentGenerativeAISettings(v.GenerativeAISettings, ok); err != nil {
			return err
		}
	}

	if v.NluIntentConfidenceThreshold != nil {
		ok := object.Key("nluIntentConfidenceThreshold")
		switch {
		case math.IsNaN(*v.NluIntentConfidenceThreshold):
			ok.String("NaN")

		case math.IsInf(*v.NluIntentConfidenceThreshold, 1):
			ok.String("Infinity")

		case math.IsInf(*v.NluIntentConfidenceThreshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.NluIntentConfidenceThreshold)

		}
	}

	if v.VoiceSettings != nil {
		ok := object.Key("voiceSettings")
		if err := awsRestjson1_serializeDocumentVoiceSettings(v.VoiceSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBotRecommendation struct {
}

func (*awsRestjson1_serializeOpUpdateBotRecommendation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBotRecommendation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBotRecommendationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/botrecommendations/{botRecommendationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBotRecommendationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBotRecommendationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBotRecommendationInput(v *UpdateBotRecommendationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotRecommendationId == nil || len(*v.BotRecommendationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botRecommendationId must not be empty")}
	}
	if v.BotRecommendationId != nil {
		if err := encoder.SetURI("botRecommendationId").String(*v.BotRecommendationId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBotRecommendationInput(v *UpdateBotRecommendationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionSetting != nil {
		ok := object.Key("encryptionSetting")
		if err := awsRestjson1_serializeDocumentEncryptionSetting(v.EncryptionSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateExport struct {
}

func (*awsRestjson1_serializeOpUpdateExport) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateExport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateExportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/exports/{exportId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateExportInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateExportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateExportInput(v *UpdateExportInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExportId == nil || len(*v.ExportId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member exportId must not be empty")}
	}
	if v.ExportId != nil {
		if err := encoder.SetURI("exportId").String(*v.ExportId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateExportInput(v *UpdateExportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FilePassword != nil {
		ok := object.Key("filePassword")
		ok.String(*v.FilePassword)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIntent struct {
}

func (*awsRestjson1_serializeOpUpdateIntent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIntent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIntentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIntentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIntentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIntentInput(v *UpdateIntentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.IntentId == nil || len(*v.IntentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member intentId must not be empty")}
	}
	if v.IntentId != nil {
		if err := encoder.SetURI("intentId").String(*v.IntentId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIntentInput(v *UpdateIntentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DialogCodeHook != nil {
		ok := object.Key("dialogCodeHook")
		if err := awsRestjson1_serializeDocumentDialogCodeHookSettings(v.DialogCodeHook, ok); err != nil {
			return err
		}
	}

	if v.FulfillmentCodeHook != nil {
		ok := object.Key("fulfillmentCodeHook")
		if err := awsRestjson1_serializeDocumentFulfillmentCodeHookSettings(v.FulfillmentCodeHook, ok); err != nil {
			return err
		}
	}

	if v.InitialResponseSetting != nil {
		ok := object.Key("initialResponseSetting")
		if err := awsRestjson1_serializeDocumentInitialResponseSetting(v.InitialResponseSetting, ok); err != nil {
			return err
		}
	}

	if v.InputContexts != nil {
		ok := object.Key("inputContexts")
		if err := awsRestjson1_serializeDocumentInputContextsList(v.InputContexts, ok); err != nil {
			return err
		}
	}

	if v.IntentClosingSetting != nil {
		ok := object.Key("intentClosingSetting")
		if err := awsRestjson1_serializeDocumentIntentClosingSetting(v.IntentClosingSetting, ok); err != nil {
			return err
		}
	}

	if v.IntentConfirmationSetting != nil {
		ok := object.Key("intentConfirmationSetting")
		if err := awsRestjson1_serializeDocumentIntentConfirmationSetting(v.IntentConfirmationSetting, ok); err != nil {
			return err
		}
	}

	if v.IntentName != nil {
		ok := object.Key("intentName")
		ok.String(*v.IntentName)
	}

	if v.KendraConfiguration != nil {
		ok := object.Key("kendraConfiguration")
		if err := awsRestjson1_serializeDocumentKendraConfiguration(v.KendraConfiguration, ok); err != nil {
			return err
		}
	}

	if v.OutputContexts != nil {
		ok := object.Key("outputContexts")
		if err := awsRestjson1_serializeDocumentOutputContextsList(v.OutputContexts, ok); err != nil {
			return err
		}
	}

	if v.ParentIntentSignature != nil {
		ok := object.Key("parentIntentSignature")
		ok.String(*v.ParentIntentSignature)
	}

	if v.SampleUtterances != nil {
		ok := object.Key("sampleUtterances")
		if err := awsRestjson1_serializeDocumentSampleUtterancesList(v.SampleUtterances, ok); err != nil {
			return err
		}
	}

	if v.SlotPriorities != nil {
		ok := object.Key("slotPriorities")
		if err := awsRestjson1_serializeDocumentSlotPrioritiesList(v.SlotPriorities, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateResourcePolicy struct {
}

func (*awsRestjson1_serializeOpUpdateResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/policy/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateResourcePolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateResourcePolicyInput(v *UpdateResourcePolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ExpectedRevisionId != nil {
		encoder.SetQuery("expectedRevisionId").String(*v.ExpectedRevisionId)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateResourcePolicyInput(v *UpdateResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("policy")
		ok.String(*v.Policy)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSlot struct {
}

func (*awsRestjson1_serializeOpUpdateSlot) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSlot) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSlotInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/intents/{intentId}/slots/{slotId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSlotInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSlotInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSlotInput(v *UpdateSlotInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.IntentId == nil || len(*v.IntentId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member intentId must not be empty")}
	}
	if v.IntentId != nil {
		if err := encoder.SetURI("intentId").String(*v.IntentId); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SlotId == nil || len(*v.SlotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member slotId must not be empty")}
	}
	if v.SlotId != nil {
		if err := encoder.SetURI("slotId").String(*v.SlotId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSlotInput(v *UpdateSlotInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.MultipleValuesSetting != nil {
		ok := object.Key("multipleValuesSetting")
		if err := awsRestjson1_serializeDocumentMultipleValuesSetting(v.MultipleValuesSetting, ok); err != nil {
			return err
		}
	}

	if v.ObfuscationSetting != nil {
		ok := object.Key("obfuscationSetting")
		if err := awsRestjson1_serializeDocumentObfuscationSetting(v.ObfuscationSetting, ok); err != nil {
			return err
		}
	}

	if v.SlotName != nil {
		ok := object.Key("slotName")
		ok.String(*v.SlotName)
	}

	if v.SlotTypeId != nil {
		ok := object.Key("slotTypeId")
		ok.String(*v.SlotTypeId)
	}

	if v.SubSlotSetting != nil {
		ok := object.Key("subSlotSetting")
		if err := awsRestjson1_serializeDocumentSubSlotSetting(v.SubSlotSetting, ok); err != nil {
			return err
		}
	}

	if v.ValueElicitationSetting != nil {
		ok := object.Key("valueElicitationSetting")
		if err := awsRestjson1_serializeDocumentSlotValueElicitationSetting(v.ValueElicitationSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSlotType struct {
}

func (*awsRestjson1_serializeOpUpdateSlotType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSlotType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSlotTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/bots/{botId}/botversions/{botVersion}/botlocales/{localeId}/slottypes/{slotTypeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSlotTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSlotTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSlotTypeInput(v *UpdateSlotTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.BotId == nil || len(*v.BotId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botId must not be empty")}
	}
	if v.BotId != nil {
		if err := encoder.SetURI("botId").String(*v.BotId); err != nil {
			return err
		}
	}

	if v.BotVersion == nil || len(*v.BotVersion) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member botVersion must not be empty")}
	}
	if v.BotVersion != nil {
		if err := encoder.SetURI("botVersion").String(*v.BotVersion); err != nil {
			return err
		}
	}

	if v.LocaleId == nil || len(*v.LocaleId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member localeId must not be empty")}
	}
	if v.LocaleId != nil {
		if err := encoder.SetURI("localeId").String(*v.LocaleId); err != nil {
			return err
		}
	}

	if v.SlotTypeId == nil || len(*v.SlotTypeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member slotTypeId must not be empty")}
	}
	if v.SlotTypeId != nil {
		if err := encoder.SetURI("slotTypeId").String(*v.SlotTypeId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSlotTypeInput(v *UpdateSlotTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CompositeSlotTypeSetting != nil {
		ok := object.Key("compositeSlotTypeSetting")
		if err := awsRestjson1_serializeDocumentCompositeSlotTypeSetting(v.CompositeSlotTypeSetting, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExternalSourceSetting != nil {
		ok := object.Key("externalSourceSetting")
		if err := awsRestjson1_serializeDocumentExternalSourceSetting(v.ExternalSourceSetting, ok); err != nil {
			return err
		}
	}

	if v.ParentSlotTypeSignature != nil {
		ok := object.Key("parentSlotTypeSignature")
		ok.String(*v.ParentSlotTypeSignature)
	}

	if v.SlotTypeName != nil {
		ok := object.Key("slotTypeName")
		ok.String(*v.SlotTypeName)
	}

	if v.SlotTypeValues != nil {
		ok := object.Key("slotTypeValues")
		if err := awsRestjson1_serializeDocumentSlotTypeValues(v.SlotTypeValues, ok); err != nil {
			return err
		}
	}

	if v.ValueSelectionSetting != nil {
		ok := object.Key("valueSelectionSetting")
		if err := awsRestjson1_serializeDocumentSlotValueSelectionSetting(v.ValueSelectionSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTestSet struct {
}

func (*awsRestjson1_serializeOpUpdateTestSet) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTestSet) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTestSetInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/testsets/{testSetId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateTestSetInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateTestSetInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateTestSetInput(v *UpdateTestSetInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TestSetId == nil || len(*v.TestSetId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member testSetId must not be empty")}
	}
	if v.TestSetId != nil {
		if err := encoder.SetURI("testSetId").String(*v.TestSetId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateTestSetInput(v *UpdateTestSetInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.TestSetName != nil {
		ok := object.Key("testSetName")
		ok.String(*v.TestSetName)
	}

	return nil
}

func awsRestjson1_serializeDocumentAdvancedRecognitionSetting(v *types.AdvancedRecognitionSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AudioRecognitionStrategy) > 0 {
		ok := object.Key("audioRecognitionStrategy")
		ok.String(string(v.AudioRecognitionStrategy))
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregatedUtterancesFilter(v *types.AggregatedUtterancesFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAggregatedUtterancesFilters(v []types.AggregatedUtterancesFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAggregatedUtterancesFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAggregatedUtterancesSortBy(v *types.AggregatedUtterancesSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentAllowedInputTypes(v *types.AllowedInputTypes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowAudioInput != nil {
		ok := object.Key("allowAudioInput")
		ok.Boolean(*v.AllowAudioInput)
	}

	if v.AllowDTMFInput != nil {
		ok := object.Key("allowDTMFInput")
		ok.Boolean(*v.AllowDTMFInput)
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsBinByList(v []types.AnalyticsBinBySpecification, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsBinBySpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsBinBySpecification(v *types.AnalyticsBinBySpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Interval) > 0 {
		ok := object.Key("interval")
		ok.String(string(v.Interval))
	}

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsFilterValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentFilter(v *types.AnalyticsIntentFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAnalyticsFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentFilters(v []types.AnalyticsIntentFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsIntentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentGroupByList(v []types.AnalyticsIntentGroupBySpecification, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsIntentGroupBySpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentGroupBySpecification(v *types.AnalyticsIntentGroupBySpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentMetric(v *types.AnalyticsIntentMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	if len(v.Statistic) > 0 {
		ok := object.Key("statistic")
		ok.String(string(v.Statistic))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentMetrics(v []types.AnalyticsIntentMetric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsIntentMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentStageFilter(v *types.AnalyticsIntentStageFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAnalyticsFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentStageFilters(v []types.AnalyticsIntentStageFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsIntentStageFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentStageGroupByList(v []types.AnalyticsIntentStageGroupBySpecification, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsIntentStageGroupBySpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentStageGroupBySpecification(v *types.AnalyticsIntentStageGroupBySpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentStageMetric(v *types.AnalyticsIntentStageMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	if len(v.Statistic) > 0 {
		ok := object.Key("statistic")
		ok.String(string(v.Statistic))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsIntentStageMetrics(v []types.AnalyticsIntentStageMetric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsIntentStageMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsPathFilter(v *types.AnalyticsPathFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAnalyticsFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsPathFilters(v []types.AnalyticsPathFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsPathFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsSessionFilter(v *types.AnalyticsSessionFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAnalyticsFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsSessionFilters(v []types.AnalyticsSessionFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsSessionFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsSessionGroupByList(v []types.AnalyticsSessionGroupBySpecification, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsSessionGroupBySpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsSessionGroupBySpecification(v *types.AnalyticsSessionGroupBySpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsSessionMetric(v *types.AnalyticsSessionMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	if len(v.Statistic) > 0 {
		ok := object.Key("statistic")
		ok.String(string(v.Statistic))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsSessionMetrics(v []types.AnalyticsSessionMetric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsSessionMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsUtteranceAttribute(v *types.AnalyticsUtteranceAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsUtteranceAttributes(v []types.AnalyticsUtteranceAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsUtteranceFilter(v *types.AnalyticsUtteranceFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentAnalyticsFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsUtteranceFilters(v []types.AnalyticsUtteranceFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsUtteranceGroupByList(v []types.AnalyticsUtteranceGroupBySpecification, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceGroupBySpecification(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAnalyticsUtteranceGroupBySpecification(v *types.AnalyticsUtteranceGroupBySpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsUtteranceMetric(v *types.AnalyticsUtteranceMetric, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	if len(v.Statistic) > 0 {
		ok := object.Key("statistic")
		ok.String(string(v.Statistic))
	}

	return nil
}

func awsRestjson1_serializeDocumentAnalyticsUtteranceMetrics(v []types.AnalyticsUtteranceMetric, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAnalyticsUtteranceMetric(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAssociatedTranscriptFilter(v *types.AssociatedTranscriptFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAssociatedTranscriptFilters(v []types.AssociatedTranscriptFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAssociatedTranscriptFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAudioAndDTMFInputSpecification(v *types.AudioAndDTMFInputSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioSpecification != nil {
		ok := object.Key("audioSpecification")
		if err := awsRestjson1_serializeDocumentAudioSpecification(v.AudioSpecification, ok); err != nil {
			return err
		}
	}

	if v.DtmfSpecification != nil {
		ok := object.Key("dtmfSpecification")
		if err := awsRestjson1_serializeDocumentDTMFSpecification(v.DtmfSpecification, ok); err != nil {
			return err
		}
	}

	if v.StartTimeoutMs != nil {
		ok := object.Key("startTimeoutMs")
		ok.Integer(*v.StartTimeoutMs)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioLogDestination(v *types.AudioLogDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Bucket != nil {
		ok := object.Key("s3Bucket")
		if err := awsRestjson1_serializeDocumentS3BucketLogDestination(v.S3Bucket, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioLogSetting(v *types.AudioLogSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentAudioLogDestination(v.Destination, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.SelectiveLoggingEnabled != nil {
		ok := object.Key("selectiveLoggingEnabled")
		ok.Boolean(*v.SelectiveLoggingEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentAudioLogSettingsList(v []types.AudioLogSetting, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAudioLogSetting(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAudioSpecification(v *types.AudioSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTimeoutMs != nil {
		ok := object.Key("endTimeoutMs")
		ok.Integer(*v.EndTimeoutMs)
	}

	if v.MaxLengthMs != nil {
		ok := object.Key("maxLengthMs")
		ok.Integer(*v.MaxLengthMs)
	}

	return nil
}

func awsRestjson1_serializeDocumentBedrockModelSpecification(v *types.BedrockModelSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ModelArn != nil {
		ok := object.Key("modelArn")
		ok.String(*v.ModelArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentBotAliasLocaleSettings(v *types.BotAliasLocaleSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CodeHookSpecification != nil {
		ok := object.Key("codeHookSpecification")
		if err := awsRestjson1_serializeDocumentCodeHookSpecification(v.CodeHookSpecification, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentBotAliasLocaleSettingsMap(v map[string]types.BotAliasLocaleSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentBotAliasLocaleSettings(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBotAliasTestExecutionTarget(v *types.BotAliasTestExecutionTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotAliasId != nil {
		ok := object.Key("botAliasId")
		ok.String(*v.BotAliasId)
	}

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	return nil
}

func awsRestjson1_serializeDocumentBotExportSpecification(v *types.BotExportSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentBotFilter(v *types.BotFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBotFilters(v []types.BotFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBotFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBotImportSpecification(v *types.BotImportSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotName != nil {
		ok := object.Key("botName")
		ok.String(*v.BotName)
	}

	if v.BotTags != nil {
		ok := object.Key("botTags")
		if err := awsRestjson1_serializeDocumentTagMap(v.BotTags, ok); err != nil {
			return err
		}
	}

	if v.DataPrivacy != nil {
		ok := object.Key("dataPrivacy")
		if err := awsRestjson1_serializeDocumentDataPrivacy(v.DataPrivacy, ok); err != nil {
			return err
		}
	}

	if v.IdleSessionTTLInSeconds != nil {
		ok := object.Key("idleSessionTTLInSeconds")
		ok.Integer(*v.IdleSessionTTLInSeconds)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.TestBotAliasTags != nil {
		ok := object.Key("testBotAliasTags")
		if err := awsRestjson1_serializeDocumentTagMap(v.TestBotAliasTags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBotLocaleExportSpecification(v *types.BotLocaleExportSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	return nil
}

func awsRestjson1_serializeDocumentBotLocaleFilter(v *types.BotLocaleFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBotLocaleFilters(v []types.BotLocaleFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBotLocaleFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBotLocaleImportSpecification(v *types.BotLocaleImportSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	if v.NluIntentConfidenceThreshold != nil {
		ok := object.Key("nluIntentConfidenceThreshold")
		switch {
		case math.IsNaN(*v.NluIntentConfidenceThreshold):
			ok.String("NaN")

		case math.IsInf(*v.NluIntentConfidenceThreshold, 1):
			ok.String("Infinity")

		case math.IsInf(*v.NluIntentConfidenceThreshold, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.NluIntentConfidenceThreshold)

		}
	}

	if v.VoiceSettings != nil {
		ok := object.Key("voiceSettings")
		if err := awsRestjson1_serializeDocumentVoiceSettings(v.VoiceSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBotLocaleSortBy(v *types.BotLocaleSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentBotMember(v *types.BotMember, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotMemberAliasId != nil {
		ok := object.Key("botMemberAliasId")
		ok.String(*v.BotMemberAliasId)
	}

	if v.BotMemberAliasName != nil {
		ok := object.Key("botMemberAliasName")
		ok.String(*v.BotMemberAliasName)
	}

	if v.BotMemberId != nil {
		ok := object.Key("botMemberId")
		ok.String(*v.BotMemberId)
	}

	if v.BotMemberName != nil {
		ok := object.Key("botMemberName")
		ok.String(*v.BotMemberName)
	}

	if v.BotMemberVersion != nil {
		ok := object.Key("botMemberVersion")
		ok.String(*v.BotMemberVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentBotMembers(v []types.BotMember, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBotMember(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBotSortBy(v *types.BotSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentBotVersionLocaleDetails(v *types.BotVersionLocaleDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceBotVersion != nil {
		ok := object.Key("sourceBotVersion")
		ok.String(*v.SourceBotVersion)
	}

	return nil
}

func awsRestjson1_serializeDocumentBotVersionLocaleSpecification(v map[string]types.BotVersionLocaleDetails, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentBotVersionLocaleDetails(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBotVersionReplicaSortBy(v *types.BotVersionReplicaSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentBotVersionSortBy(v *types.BotVersionSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentBuildtimeSettings(v *types.BuildtimeSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DescriptiveBotBuilder != nil {
		ok := object.Key("descriptiveBotBuilder")
		if err := awsRestjson1_serializeDocumentDescriptiveBotBuilderSpecification(v.DescriptiveBotBuilder, ok); err != nil {
			return err
		}
	}

	if v.SampleUtteranceGeneration != nil {
		ok := object.Key("sampleUtteranceGeneration")
		if err := awsRestjson1_serializeDocumentSampleUtteranceGenerationSpecification(v.SampleUtteranceGeneration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBuiltInIntentSortBy(v *types.BuiltInIntentSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentBuiltInSlotTypeSortBy(v *types.BuiltInSlotTypeSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentButton(v *types.Button, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Text != nil {
		ok := object.Key("text")
		ok.String(*v.Text)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentButtonsList(v []types.Button, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentButton(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCloudWatchLogGroupLogDestination(v *types.CloudWatchLogGroupLogDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogGroupArn != nil {
		ok := object.Key("cloudWatchLogGroupArn")
		ok.String(*v.CloudWatchLogGroupArn)
	}

	if v.LogPrefix != nil {
		ok := object.Key("logPrefix")
		ok.String(*v.LogPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentCodeHookSpecification(v *types.CodeHookSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LambdaCodeHook != nil {
		ok := object.Key("lambdaCodeHook")
		if err := awsRestjson1_serializeDocumentLambdaCodeHook(v.LambdaCodeHook, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCompositeSlotTypeSetting(v *types.CompositeSlotTypeSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SubSlots != nil {
		ok := object.Key("subSlots")
		if err := awsRestjson1_serializeDocumentSubSlotTypeList(v.SubSlots, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCondition(v *types.Condition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExpressionString != nil {
		ok := object.Key("expressionString")
		ok.String(*v.ExpressionString)
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalBranch(v *types.ConditionalBranch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Condition != nil {
		ok := object.Key("condition")
		if err := awsRestjson1_serializeDocumentCondition(v.Condition, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.NextStep != nil {
		ok := object.Key("nextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.NextStep, ok); err != nil {
			return err
		}
	}

	if v.Response != nil {
		ok := object.Key("response")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.Response, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionalBranches(v []types.ConditionalBranch, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentConditionalBranch(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConditionalSpecification(v *types.ConditionalSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Active != nil {
		ok := object.Key("active")
		ok.Boolean(*v.Active)
	}

	if v.ConditionalBranches != nil {
		ok := object.Key("conditionalBranches")
		if err := awsRestjson1_serializeDocumentConditionalBranches(v.ConditionalBranches, ok); err != nil {
			return err
		}
	}

	if v.DefaultBranch != nil {
		ok := object.Key("defaultBranch")
		if err := awsRestjson1_serializeDocumentDefaultConditionalBranch(v.DefaultBranch, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentConditionKeyValueMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentConditionMap(v map[string]map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentConditionKeyValueMap(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConversationLevelTestResultsFilterBy(v *types.ConversationLevelTestResultsFilterBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.EndToEndResult) > 0 {
		ok := object.Key("endToEndResult")
		ok.String(string(v.EndToEndResult))
	}

	return nil
}

func awsRestjson1_serializeDocumentConversationLogsDataSource(v *types.ConversationLogsDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotAliasId != nil {
		ok := object.Key("botAliasId")
		ok.String(*v.BotAliasId)
	}

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.Filter != nil {
		ok := object.Key("filter")
		if err := awsRestjson1_serializeDocumentConversationLogsDataSourceFilterBy(v.Filter, ok); err != nil {
			return err
		}
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	return nil
}

func awsRestjson1_serializeDocumentConversationLogsDataSourceFilterBy(v *types.ConversationLogsDataSourceFilterBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("endTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if len(v.InputMode) > 0 {
		ok := object.Key("inputMode")
		ok.String(string(v.InputMode))
	}

	if v.StartTime != nil {
		ok := object.Key("startTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentConversationLogSettings(v *types.ConversationLogSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AudioLogSettings != nil {
		ok := object.Key("audioLogSettings")
		if err := awsRestjson1_serializeDocumentAudioLogSettingsList(v.AudioLogSettings, ok); err != nil {
			return err
		}
	}

	if v.TextLogSettings != nil {
		ok := object.Key("textLogSettings")
		if err := awsRestjson1_serializeDocumentTextLogSettingsList(v.TextLogSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateCustomVocabularyItemsList(v []types.NewCustomVocabularyItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentNewCustomVocabularyItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentCustomPayload(v *types.CustomPayload, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomVocabularyEntryId(v *types.CustomVocabularyEntryId, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ItemId != nil {
		ok := object.Key("itemId")
		ok.String(*v.ItemId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomVocabularyExportSpecification(v *types.CustomVocabularyExportSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomVocabularyImportSpecification(v *types.CustomVocabularyImportSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.BotVersion != nil {
		ok := object.Key("botVersion")
		ok.String(*v.BotVersion)
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	return nil
}

func awsRestjson1_serializeDocumentCustomVocabularyItem(v *types.CustomVocabularyItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayAs != nil {
		ok := object.Key("displayAs")
		ok.String(*v.DisplayAs)
	}

	if v.ItemId != nil {
		ok := object.Key("itemId")
		ok.String(*v.ItemId)
	}

	if v.Phrase != nil {
		ok := object.Key("phrase")
		ok.String(*v.Phrase)
	}

	if v.Weight != nil {
		ok := object.Key("weight")
		ok.Integer(*v.Weight)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataPrivacy(v *types.DataPrivacy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("childDirected")
		ok.Boolean(v.ChildDirected)
	}

	return nil
}

func awsRestjson1_serializeDocumentDateRangeFilter(v *types.DateRangeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentDefaultConditionalBranch(v *types.DefaultConditionalBranch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.NextStep != nil {
		ok := object.Key("nextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.NextStep, ok); err != nil {
			return err
		}
	}

	if v.Response != nil {
		ok := object.Key("response")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.Response, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDeleteCustomVocabularyItemsList(v []types.CustomVocabularyEntryId, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCustomVocabularyEntryId(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDescriptiveBotBuilderSpecification(v *types.DescriptiveBotBuilderSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BedrockModelSpecification != nil {
		ok := object.Key("bedrockModelSpecification")
		if err := awsRestjson1_serializeDocumentBedrockModelSpecification(v.BedrockModelSpecification, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentDialogAction(v *types.DialogAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SlotToElicit != nil {
		ok := object.Key("slotToElicit")
		ok.String(*v.SlotToElicit)
	}

	if v.SuppressNextMessage != nil {
		ok := object.Key("suppressNextMessage")
		ok.Boolean(*v.SuppressNextMessage)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDialogCodeHookInvocationSetting(v *types.DialogCodeHookInvocationSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Active != nil {
		ok := object.Key("active")
		ok.Boolean(*v.Active)
	}

	if v.EnableCodeHookInvocation != nil {
		ok := object.Key("enableCodeHookInvocation")
		ok.Boolean(*v.EnableCodeHookInvocation)
	}

	if v.InvocationLabel != nil {
		ok := object.Key("invocationLabel")
		ok.String(*v.InvocationLabel)
	}

	if v.PostCodeHookSpecification != nil {
		ok := object.Key("postCodeHookSpecification")
		if err := awsRestjson1_serializeDocumentPostDialogCodeHookInvocationSpecification(v.PostCodeHookSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDialogCodeHookSettings(v *types.DialogCodeHookSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentDialogState(v *types.DialogState, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DialogAction != nil {
		ok := object.Key("dialogAction")
		if err := awsRestjson1_serializeDocumentDialogAction(v.DialogAction, ok); err != nil {
			return err
		}
	}

	if v.Intent != nil {
		ok := object.Key("intent")
		if err := awsRestjson1_serializeDocumentIntentOverride(v.Intent, ok); err != nil {
			return err
		}
	}

	if v.SessionAttributes != nil {
		ok := object.Key("sessionAttributes")
		if err := awsRestjson1_serializeDocumentStringMap(v.SessionAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDTMFSpecification(v *types.DTMFSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeletionCharacter != nil {
		ok := object.Key("deletionCharacter")
		ok.String(*v.DeletionCharacter)
	}

	if v.EndCharacter != nil {
		ok := object.Key("endCharacter")
		ok.String(*v.EndCharacter)
	}

	if v.EndTimeoutMs != nil {
		ok := object.Key("endTimeoutMs")
		ok.Integer(*v.EndTimeoutMs)
	}

	if v.MaxLength != nil {
		ok := object.Key("maxLength")
		ok.Integer(*v.MaxLength)
	}

	return nil
}

func awsRestjson1_serializeDocumentElicitationCodeHookInvocationSetting(v *types.ElicitationCodeHookInvocationSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableCodeHookInvocation != nil {
		ok := object.Key("enableCodeHookInvocation")
		ok.Boolean(*v.EnableCodeHookInvocation)
	}

	if v.InvocationLabel != nil {
		ok := object.Key("invocationLabel")
		ok.String(*v.InvocationLabel)
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryptionSetting(v *types.EncryptionSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AssociatedTranscriptsPassword != nil {
		ok := object.Key("associatedTranscriptsPassword")
		ok.String(*v.AssociatedTranscriptsPassword)
	}

	if v.BotLocaleExportPassword != nil {
		ok := object.Key("botLocaleExportPassword")
		ok.String(*v.BotLocaleExportPassword)
	}

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentExportFilter(v *types.ExportFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentExportFilters(v []types.ExportFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentExportFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentExportResourceSpecification(v *types.ExportResourceSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotExportSpecification != nil {
		ok := object.Key("botExportSpecification")
		if err := awsRestjson1_serializeDocumentBotExportSpecification(v.BotExportSpecification, ok); err != nil {
			return err
		}
	}

	if v.BotLocaleExportSpecification != nil {
		ok := object.Key("botLocaleExportSpecification")
		if err := awsRestjson1_serializeDocumentBotLocaleExportSpecification(v.BotLocaleExportSpecification, ok); err != nil {
			return err
		}
	}

	if v.CustomVocabularyExportSpecification != nil {
		ok := object.Key("customVocabularyExportSpecification")
		if err := awsRestjson1_serializeDocumentCustomVocabularyExportSpecification(v.CustomVocabularyExportSpecification, ok); err != nil {
			return err
		}
	}

	if v.TestSetExportSpecification != nil {
		ok := object.Key("testSetExportSpecification")
		if err := awsRestjson1_serializeDocumentTestSetExportSpecification(v.TestSetExportSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentExportSortBy(v *types.ExportSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentExternalSourceSetting(v *types.ExternalSourceSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GrammarSlotTypeSetting != nil {
		ok := object.Key("grammarSlotTypeSetting")
		if err := awsRestjson1_serializeDocumentGrammarSlotTypeSetting(v.GrammarSlotTypeSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFilterValues(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFulfillmentCodeHookSettings(v *types.FulfillmentCodeHookSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Active != nil {
		ok := object.Key("active")
		ok.Boolean(*v.Active)
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.FulfillmentUpdatesSpecification != nil {
		ok := object.Key("fulfillmentUpdatesSpecification")
		if err := awsRestjson1_serializeDocumentFulfillmentUpdatesSpecification(v.FulfillmentUpdatesSpecification, ok); err != nil {
			return err
		}
	}

	if v.PostFulfillmentStatusSpecification != nil {
		ok := object.Key("postFulfillmentStatusSpecification")
		if err := awsRestjson1_serializeDocumentPostFulfillmentStatusSpecification(v.PostFulfillmentStatusSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFulfillmentStartResponseSpecification(v *types.FulfillmentStartResponseSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowInterrupt != nil {
		ok := object.Key("allowInterrupt")
		ok.Boolean(*v.AllowInterrupt)
	}

	if v.DelayInSeconds != nil {
		ok := object.Key("delayInSeconds")
		ok.Integer(*v.DelayInSeconds)
	}

	if v.MessageGroups != nil {
		ok := object.Key("messageGroups")
		if err := awsRestjson1_serializeDocumentMessageGroupsList(v.MessageGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFulfillmentUpdateResponseSpecification(v *types.FulfillmentUpdateResponseSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowInterrupt != nil {
		ok := object.Key("allowInterrupt")
		ok.Boolean(*v.AllowInterrupt)
	}

	if v.FrequencyInSeconds != nil {
		ok := object.Key("frequencyInSeconds")
		ok.Integer(*v.FrequencyInSeconds)
	}

	if v.MessageGroups != nil {
		ok := object.Key("messageGroups")
		if err := awsRestjson1_serializeDocumentMessageGroupsList(v.MessageGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFulfillmentUpdatesSpecification(v *types.FulfillmentUpdatesSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Active != nil {
		ok := object.Key("active")
		ok.Boolean(*v.Active)
	}

	if v.StartResponse != nil {
		ok := object.Key("startResponse")
		if err := awsRestjson1_serializeDocumentFulfillmentStartResponseSpecification(v.StartResponse, ok); err != nil {
			return err
		}
	}

	if v.TimeoutInSeconds != nil {
		ok := object.Key("timeoutInSeconds")
		ok.Integer(*v.TimeoutInSeconds)
	}

	if v.UpdateResponse != nil {
		ok := object.Key("updateResponse")
		if err := awsRestjson1_serializeDocumentFulfillmentUpdateResponseSpecification(v.UpdateResponse, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGenerationSortBy(v *types.GenerationSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentGenerativeAISettings(v *types.GenerativeAISettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BuildtimeSettings != nil {
		ok := object.Key("buildtimeSettings")
		if err := awsRestjson1_serializeDocumentBuildtimeSettings(v.BuildtimeSettings, ok); err != nil {
			return err
		}
	}

	if v.RuntimeSettings != nil {
		ok := object.Key("runtimeSettings")
		if err := awsRestjson1_serializeDocumentRuntimeSettings(v.RuntimeSettings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGrammarSlotTypeSetting(v *types.GrammarSlotTypeSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Source != nil {
		ok := object.Key("source")
		if err := awsRestjson1_serializeDocumentGrammarSlotTypeSource(v.Source, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentGrammarSlotTypeSource(v *types.GrammarSlotTypeSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3ObjectKey != nil {
		ok := object.Key("s3ObjectKey")
		ok.String(*v.S3ObjectKey)
	}

	return nil
}

func awsRestjson1_serializeDocumentImageResponseCard(v *types.ImageResponseCard, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Buttons != nil {
		ok := object.Key("buttons")
		if err := awsRestjson1_serializeDocumentButtonsList(v.Buttons, ok); err != nil {
			return err
		}
	}

	if v.ImageUrl != nil {
		ok := object.Key("imageUrl")
		ok.String(*v.ImageUrl)
	}

	if v.Subtitle != nil {
		ok := object.Key("subtitle")
		ok.String(*v.Subtitle)
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentImportFilter(v *types.ImportFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImportFilters(v []types.ImportFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentImportFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentImportResourceSpecification(v *types.ImportResourceSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotImportSpecification != nil {
		ok := object.Key("botImportSpecification")
		if err := awsRestjson1_serializeDocumentBotImportSpecification(v.BotImportSpecification, ok); err != nil {
			return err
		}
	}

	if v.BotLocaleImportSpecification != nil {
		ok := object.Key("botLocaleImportSpecification")
		if err := awsRestjson1_serializeDocumentBotLocaleImportSpecification(v.BotLocaleImportSpecification, ok); err != nil {
			return err
		}
	}

	if v.CustomVocabularyImportSpecification != nil {
		ok := object.Key("customVocabularyImportSpecification")
		if err := awsRestjson1_serializeDocumentCustomVocabularyImportSpecification(v.CustomVocabularyImportSpecification, ok); err != nil {
			return err
		}
	}

	if v.TestSetImportResourceSpecification != nil {
		ok := object.Key("testSetImportResourceSpecification")
		if err := awsRestjson1_serializeDocumentTestSetImportResourceSpecification(v.TestSetImportResourceSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentImportSortBy(v *types.ImportSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentInitialResponseSetting(v *types.InitialResponseSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CodeHook != nil {
		ok := object.Key("codeHook")
		if err := awsRestjson1_serializeDocumentDialogCodeHookInvocationSetting(v.CodeHook, ok); err != nil {
			return err
		}
	}

	if v.Conditional != nil {
		ok := object.Key("conditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.Conditional, ok); err != nil {
			return err
		}
	}

	if v.InitialResponse != nil {
		ok := object.Key("initialResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.InitialResponse, ok); err != nil {
			return err
		}
	}

	if v.NextStep != nil {
		ok := object.Key("nextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.NextStep, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInputContext(v *types.InputContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentInputContextsList(v []types.InputContext, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInputContext(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIntentClosingSetting(v *types.IntentClosingSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Active != nil {
		ok := object.Key("active")
		ok.Boolean(*v.Active)
	}

	if v.ClosingResponse != nil {
		ok := object.Key("closingResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.ClosingResponse, ok); err != nil {
			return err
		}
	}

	if v.Conditional != nil {
		ok := object.Key("conditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.Conditional, ok); err != nil {
			return err
		}
	}

	if v.NextStep != nil {
		ok := object.Key("nextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.NextStep, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntentConfirmationSetting(v *types.IntentConfirmationSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Active != nil {
		ok := object.Key("active")
		ok.Boolean(*v.Active)
	}

	if v.CodeHook != nil {
		ok := object.Key("codeHook")
		if err := awsRestjson1_serializeDocumentDialogCodeHookInvocationSetting(v.CodeHook, ok); err != nil {
			return err
		}
	}

	if v.ConfirmationConditional != nil {
		ok := object.Key("confirmationConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.ConfirmationConditional, ok); err != nil {
			return err
		}
	}

	if v.ConfirmationNextStep != nil {
		ok := object.Key("confirmationNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.ConfirmationNextStep, ok); err != nil {
			return err
		}
	}

	if v.ConfirmationResponse != nil {
		ok := object.Key("confirmationResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.ConfirmationResponse, ok); err != nil {
			return err
		}
	}

	if v.DeclinationConditional != nil {
		ok := object.Key("declinationConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.DeclinationConditional, ok); err != nil {
			return err
		}
	}

	if v.DeclinationNextStep != nil {
		ok := object.Key("declinationNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.DeclinationNextStep, ok); err != nil {
			return err
		}
	}

	if v.DeclinationResponse != nil {
		ok := object.Key("declinationResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.DeclinationResponse, ok); err != nil {
			return err
		}
	}

	if v.ElicitationCodeHook != nil {
		ok := object.Key("elicitationCodeHook")
		if err := awsRestjson1_serializeDocumentElicitationCodeHookInvocationSetting(v.ElicitationCodeHook, ok); err != nil {
			return err
		}
	}

	if v.FailureConditional != nil {
		ok := object.Key("failureConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.FailureConditional, ok); err != nil {
			return err
		}
	}

	if v.FailureNextStep != nil {
		ok := object.Key("failureNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.FailureNextStep, ok); err != nil {
			return err
		}
	}

	if v.FailureResponse != nil {
		ok := object.Key("failureResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.FailureResponse, ok); err != nil {
			return err
		}
	}

	if v.PromptSpecification != nil {
		ok := object.Key("promptSpecification")
		if err := awsRestjson1_serializeDocumentPromptSpecification(v.PromptSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntentFilter(v *types.IntentFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntentFilters(v []types.IntentFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentIntentFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIntentOverride(v *types.IntentOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Slots != nil {
		ok := object.Key("slots")
		if err := awsRestjson1_serializeDocumentSlotValueOverrideMap(v.Slots, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIntentSortBy(v *types.IntentSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentKendraConfiguration(v *types.KendraConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KendraIndex != nil {
		ok := object.Key("kendraIndex")
		ok.String(*v.KendraIndex)
	}

	if v.QueryFilterString != nil {
		ok := object.Key("queryFilterString")
		ok.String(*v.QueryFilterString)
	}

	if v.QueryFilterStringEnabled {
		ok := object.Key("queryFilterStringEnabled")
		ok.Boolean(v.QueryFilterStringEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaCodeHook(v *types.LambdaCodeHook, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CodeHookInterfaceVersion != nil {
		ok := object.Key("codeHookInterfaceVersion")
		ok.String(*v.CodeHookInterfaceVersion)
	}

	if v.LambdaARN != nil {
		ok := object.Key("lambdaARN")
		ok.String(*v.LambdaARN)
	}

	return nil
}

func awsRestjson1_serializeDocumentLexTranscriptFilter(v *types.LexTranscriptFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DateRangeFilter != nil {
		ok := object.Key("dateRangeFilter")
		if err := awsRestjson1_serializeDocumentDateRangeFilter(v.DateRangeFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMessage(v *types.Message, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomPayload != nil {
		ok := object.Key("customPayload")
		if err := awsRestjson1_serializeDocumentCustomPayload(v.CustomPayload, ok); err != nil {
			return err
		}
	}

	if v.ImageResponseCard != nil {
		ok := object.Key("imageResponseCard")
		if err := awsRestjson1_serializeDocumentImageResponseCard(v.ImageResponseCard, ok); err != nil {
			return err
		}
	}

	if v.PlainTextMessage != nil {
		ok := object.Key("plainTextMessage")
		if err := awsRestjson1_serializeDocumentPlainTextMessage(v.PlainTextMessage, ok); err != nil {
			return err
		}
	}

	if v.SsmlMessage != nil {
		ok := object.Key("ssmlMessage")
		if err := awsRestjson1_serializeDocumentSSMLMessage(v.SsmlMessage, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMessageGroup(v *types.MessageGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Message != nil {
		ok := object.Key("message")
		if err := awsRestjson1_serializeDocumentMessage(v.Message, ok); err != nil {
			return err
		}
	}

	if v.Variations != nil {
		ok := object.Key("variations")
		if err := awsRestjson1_serializeDocumentMessageVariationsList(v.Variations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentMessageGroupsList(v []types.MessageGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMessageGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMessageVariationsList(v []types.Message, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMessage(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMultipleValuesSetting(v *types.MultipleValuesSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowMultipleValues {
		ok := object.Key("allowMultipleValues")
		ok.Boolean(v.AllowMultipleValues)
	}

	return nil
}

func awsRestjson1_serializeDocumentNewCustomVocabularyItem(v *types.NewCustomVocabularyItem, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DisplayAs != nil {
		ok := object.Key("displayAs")
		ok.String(*v.DisplayAs)
	}

	if v.Phrase != nil {
		ok := object.Key("phrase")
		ok.String(*v.Phrase)
	}

	if v.Weight != nil {
		ok := object.Key("weight")
		ok.Integer(*v.Weight)
	}

	return nil
}

func awsRestjson1_serializeDocumentObfuscationSetting(v *types.ObfuscationSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ObfuscationSettingType) > 0 {
		ok := object.Key("obfuscationSettingType")
		ok.String(string(v.ObfuscationSettingType))
	}

	return nil
}

func awsRestjson1_serializeDocumentObjectPrefixes(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentOperationList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentOutputContext(v *types.OutputContext, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.TimeToLiveInSeconds != nil {
		ok := object.Key("timeToLiveInSeconds")
		ok.Integer(*v.TimeToLiveInSeconds)
	}

	if v.TurnsToLive != nil {
		ok := object.Key("turnsToLive")
		ok.Integer(*v.TurnsToLive)
	}

	return nil
}

func awsRestjson1_serializeDocumentOutputContextsList(v []types.OutputContext, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentOutputContext(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPathFormat(v *types.PathFormat, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectPrefixes != nil {
		ok := object.Key("objectPrefixes")
		if err := awsRestjson1_serializeDocumentObjectPrefixes(v.ObjectPrefixes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPlainTextMessage(v *types.PlainTextMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentPostDialogCodeHookInvocationSpecification(v *types.PostDialogCodeHookInvocationSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailureConditional != nil {
		ok := object.Key("failureConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.FailureConditional, ok); err != nil {
			return err
		}
	}

	if v.FailureNextStep != nil {
		ok := object.Key("failureNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.FailureNextStep, ok); err != nil {
			return err
		}
	}

	if v.FailureResponse != nil {
		ok := object.Key("failureResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.FailureResponse, ok); err != nil {
			return err
		}
	}

	if v.SuccessConditional != nil {
		ok := object.Key("successConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.SuccessConditional, ok); err != nil {
			return err
		}
	}

	if v.SuccessNextStep != nil {
		ok := object.Key("successNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.SuccessNextStep, ok); err != nil {
			return err
		}
	}

	if v.SuccessResponse != nil {
		ok := object.Key("successResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.SuccessResponse, ok); err != nil {
			return err
		}
	}

	if v.TimeoutConditional != nil {
		ok := object.Key("timeoutConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.TimeoutConditional, ok); err != nil {
			return err
		}
	}

	if v.TimeoutNextStep != nil {
		ok := object.Key("timeoutNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.TimeoutNextStep, ok); err != nil {
			return err
		}
	}

	if v.TimeoutResponse != nil {
		ok := object.Key("timeoutResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.TimeoutResponse, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPostFulfillmentStatusSpecification(v *types.PostFulfillmentStatusSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FailureConditional != nil {
		ok := object.Key("failureConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.FailureConditional, ok); err != nil {
			return err
		}
	}

	if v.FailureNextStep != nil {
		ok := object.Key("failureNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.FailureNextStep, ok); err != nil {
			return err
		}
	}

	if v.FailureResponse != nil {
		ok := object.Key("failureResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.FailureResponse, ok); err != nil {
			return err
		}
	}

	if v.SuccessConditional != nil {
		ok := object.Key("successConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.SuccessConditional, ok); err != nil {
			return err
		}
	}

	if v.SuccessNextStep != nil {
		ok := object.Key("successNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.SuccessNextStep, ok); err != nil {
			return err
		}
	}

	if v.SuccessResponse != nil {
		ok := object.Key("successResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.SuccessResponse, ok); err != nil {
			return err
		}
	}

	if v.TimeoutConditional != nil {
		ok := object.Key("timeoutConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.TimeoutConditional, ok); err != nil {
			return err
		}
	}

	if v.TimeoutNextStep != nil {
		ok := object.Key("timeoutNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.TimeoutNextStep, ok); err != nil {
			return err
		}
	}

	if v.TimeoutResponse != nil {
		ok := object.Key("timeoutResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.TimeoutResponse, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPrincipal(v *types.Principal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("arn")
		ok.String(*v.Arn)
	}

	if v.Service != nil {
		ok := object.Key("service")
		ok.String(*v.Service)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrincipalList(v []types.Principal, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPrincipal(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPromptAttemptSpecification(v *types.PromptAttemptSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedInputTypes != nil {
		ok := object.Key("allowedInputTypes")
		if err := awsRestjson1_serializeDocumentAllowedInputTypes(v.AllowedInputTypes, ok); err != nil {
			return err
		}
	}

	if v.AllowInterrupt != nil {
		ok := object.Key("allowInterrupt")
		ok.Boolean(*v.AllowInterrupt)
	}

	if v.AudioAndDTMFInputSpecification != nil {
		ok := object.Key("audioAndDTMFInputSpecification")
		if err := awsRestjson1_serializeDocumentAudioAndDTMFInputSpecification(v.AudioAndDTMFInputSpecification, ok); err != nil {
			return err
		}
	}

	if v.TextInputSpecification != nil {
		ok := object.Key("textInputSpecification")
		if err := awsRestjson1_serializeDocumentTextInputSpecification(v.TextInputSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPromptAttemptsSpecificationMap(v map[string]types.PromptAttemptSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentPromptAttemptSpecification(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPromptSpecification(v *types.PromptSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowInterrupt != nil {
		ok := object.Key("allowInterrupt")
		ok.Boolean(*v.AllowInterrupt)
	}

	if v.MaxRetries != nil {
		ok := object.Key("maxRetries")
		ok.Integer(*v.MaxRetries)
	}

	if v.MessageGroups != nil {
		ok := object.Key("messageGroups")
		if err := awsRestjson1_serializeDocumentMessageGroupsList(v.MessageGroups, ok); err != nil {
			return err
		}
	}

	if len(v.MessageSelectionStrategy) > 0 {
		ok := object.Key("messageSelectionStrategy")
		ok.String(string(v.MessageSelectionStrategy))
	}

	if v.PromptAttemptsSpecification != nil {
		ok := object.Key("promptAttemptsSpecification")
		if err := awsRestjson1_serializeDocumentPromptAttemptsSpecificationMap(v.PromptAttemptsSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRelativeAggregationDuration(v *types.RelativeAggregationDuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.TimeDimension) > 0 {
		ok := object.Key("timeDimension")
		ok.String(string(v.TimeDimension))
	}

	if v.TimeValue != nil {
		ok := object.Key("timeValue")
		ok.Integer(*v.TimeValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentResponseSpecification(v *types.ResponseSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowInterrupt != nil {
		ok := object.Key("allowInterrupt")
		ok.Boolean(*v.AllowInterrupt)
	}

	if v.MessageGroups != nil {
		ok := object.Key("messageGroups")
		if err := awsRestjson1_serializeDocumentMessageGroupsList(v.MessageGroups, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentRuntimeSettings(v *types.RuntimeSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SlotResolutionImprovement != nil {
		ok := object.Key("slotResolutionImprovement")
		if err := awsRestjson1_serializeDocumentSlotResolutionImprovementSpecification(v.SlotResolutionImprovement, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentS3BucketLogDestination(v *types.S3BucketLogDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.LogPrefix != nil {
		ok := object.Key("logPrefix")
		ok.String(*v.LogPrefix)
	}

	if v.S3BucketArn != nil {
		ok := object.Key("s3BucketArn")
		ok.String(*v.S3BucketArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3BucketTranscriptSource(v *types.S3BucketTranscriptSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.PathFormat != nil {
		ok := object.Key("pathFormat")
		if err := awsRestjson1_serializeDocumentPathFormat(v.PathFormat, ok); err != nil {
			return err
		}
	}

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.TranscriptFilter != nil {
		ok := object.Key("transcriptFilter")
		if err := awsRestjson1_serializeDocumentTranscriptFilter(v.TranscriptFilter, ok); err != nil {
			return err
		}
	}

	if len(v.TranscriptFormat) > 0 {
		ok := object.Key("transcriptFormat")
		ok.String(string(v.TranscriptFormat))
	}

	return nil
}

func awsRestjson1_serializeDocumentSampleUtterance(v *types.SampleUtterance, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Utterance != nil {
		ok := object.Key("utterance")
		ok.String(*v.Utterance)
	}

	return nil
}

func awsRestjson1_serializeDocumentSampleUtteranceGenerationSpecification(v *types.SampleUtteranceGenerationSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BedrockModelSpecification != nil {
		ok := object.Key("bedrockModelSpecification")
		if err := awsRestjson1_serializeDocumentBedrockModelSpecification(v.BedrockModelSpecification, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentSampleUtterancesList(v []types.SampleUtterance, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSampleUtterance(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSampleValue(v *types.SampleValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentSentimentAnalysisSettings(v *types.SentimentAnalysisSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("detectSentiment")
		ok.Boolean(v.DetectSentiment)
	}

	return nil
}

func awsRestjson1_serializeDocumentSessionDataSortBy(v *types.SessionDataSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotCaptureSetting(v *types.SlotCaptureSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CaptureConditional != nil {
		ok := object.Key("captureConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.CaptureConditional, ok); err != nil {
			return err
		}
	}

	if v.CaptureNextStep != nil {
		ok := object.Key("captureNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.CaptureNextStep, ok); err != nil {
			return err
		}
	}

	if v.CaptureResponse != nil {
		ok := object.Key("captureResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.CaptureResponse, ok); err != nil {
			return err
		}
	}

	if v.CodeHook != nil {
		ok := object.Key("codeHook")
		if err := awsRestjson1_serializeDocumentDialogCodeHookInvocationSetting(v.CodeHook, ok); err != nil {
			return err
		}
	}

	if v.ElicitationCodeHook != nil {
		ok := object.Key("elicitationCodeHook")
		if err := awsRestjson1_serializeDocumentElicitationCodeHookInvocationSetting(v.ElicitationCodeHook, ok); err != nil {
			return err
		}
	}

	if v.FailureConditional != nil {
		ok := object.Key("failureConditional")
		if err := awsRestjson1_serializeDocumentConditionalSpecification(v.FailureConditional, ok); err != nil {
			return err
		}
	}

	if v.FailureNextStep != nil {
		ok := object.Key("failureNextStep")
		if err := awsRestjson1_serializeDocumentDialogState(v.FailureNextStep, ok); err != nil {
			return err
		}
	}

	if v.FailureResponse != nil {
		ok := object.Key("failureResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.FailureResponse, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotDefaultValue(v *types.SlotDefaultValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotDefaultValueList(v []types.SlotDefaultValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSlotDefaultValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlotDefaultValueSpecification(v *types.SlotDefaultValueSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValueList != nil {
		ok := object.Key("defaultValueList")
		if err := awsRestjson1_serializeDocumentSlotDefaultValueList(v.DefaultValueList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotFilter(v *types.SlotFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotFilters(v []types.SlotFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSlotFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlotPrioritiesList(v []types.SlotPriority, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSlotPriority(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlotPriority(v *types.SlotPriority, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Priority != nil {
		ok := object.Key("priority")
		ok.Integer(*v.Priority)
	}

	if v.SlotId != nil {
		ok := object.Key("slotId")
		ok.String(*v.SlotId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotResolutionImprovementSpecification(v *types.SlotResolutionImprovementSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BedrockModelSpecification != nil {
		ok := object.Key("bedrockModelSpecification")
		if err := awsRestjson1_serializeDocumentBedrockModelSpecification(v.BedrockModelSpecification, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotResolutionSetting(v *types.SlotResolutionSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.SlotResolutionStrategy) > 0 {
		ok := object.Key("slotResolutionStrategy")
		ok.String(string(v.SlotResolutionStrategy))
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotSortBy(v *types.SlotSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotTypeFilter(v *types.SlotTypeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentFilterValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotTypeFilters(v []types.SlotTypeFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSlotTypeFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlotTypeSortBy(v *types.SlotTypeSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotTypeValue(v *types.SlotTypeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SampleValue != nil {
		ok := object.Key("sampleValue")
		if err := awsRestjson1_serializeDocumentSampleValue(v.SampleValue, ok); err != nil {
			return err
		}
	}

	if v.Synonyms != nil {
		ok := object.Key("synonyms")
		if err := awsRestjson1_serializeDocumentSynonymList(v.Synonyms, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotTypeValues(v []types.SlotTypeValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSlotTypeValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlotValue(v *types.SlotValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InterpretedValue != nil {
		ok := object.Key("interpretedValue")
		ok.String(*v.InterpretedValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotValueElicitationSetting(v *types.SlotValueElicitationSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValueSpecification != nil {
		ok := object.Key("defaultValueSpecification")
		if err := awsRestjson1_serializeDocumentSlotDefaultValueSpecification(v.DefaultValueSpecification, ok); err != nil {
			return err
		}
	}

	if v.PromptSpecification != nil {
		ok := object.Key("promptSpecification")
		if err := awsRestjson1_serializeDocumentPromptSpecification(v.PromptSpecification, ok); err != nil {
			return err
		}
	}

	if v.SampleUtterances != nil {
		ok := object.Key("sampleUtterances")
		if err := awsRestjson1_serializeDocumentSampleUtterancesList(v.SampleUtterances, ok); err != nil {
			return err
		}
	}

	if v.SlotCaptureSetting != nil {
		ok := object.Key("slotCaptureSetting")
		if err := awsRestjson1_serializeDocumentSlotCaptureSetting(v.SlotCaptureSetting, ok); err != nil {
			return err
		}
	}

	if len(v.SlotConstraint) > 0 {
		ok := object.Key("slotConstraint")
		ok.String(string(v.SlotConstraint))
	}

	if v.SlotResolutionSetting != nil {
		ok := object.Key("slotResolutionSetting")
		if err := awsRestjson1_serializeDocumentSlotResolutionSetting(v.SlotResolutionSetting, ok); err != nil {
			return err
		}
	}

	if v.WaitAndContinueSpecification != nil {
		ok := object.Key("waitAndContinueSpecification")
		if err := awsRestjson1_serializeDocumentWaitAndContinueSpecification(v.WaitAndContinueSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotValueOverride(v *types.SlotValueOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Shape) > 0 {
		ok := object.Key("shape")
		ok.String(string(v.Shape))
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentSlotValue(v.Value, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentSlotValues(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotValueOverrideMap(v map[string]types.SlotValueOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentSlotValueOverride(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlotValueRegexFilter(v *types.SlotValueRegexFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Pattern != nil {
		ok := object.Key("pattern")
		ok.String(*v.Pattern)
	}

	return nil
}

func awsRestjson1_serializeDocumentSlotValues(v []types.SlotValueOverride, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSlotValueOverride(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSlotValueSelectionSetting(v *types.SlotValueSelectionSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdvancedRecognitionSetting != nil {
		ok := object.Key("advancedRecognitionSetting")
		if err := awsRestjson1_serializeDocumentAdvancedRecognitionSetting(v.AdvancedRecognitionSetting, ok); err != nil {
			return err
		}
	}

	if v.RegexFilter != nil {
		ok := object.Key("regexFilter")
		if err := awsRestjson1_serializeDocumentSlotValueRegexFilter(v.RegexFilter, ok); err != nil {
			return err
		}
	}

	if len(v.ResolutionStrategy) > 0 {
		ok := object.Key("resolutionStrategy")
		ok.String(string(v.ResolutionStrategy))
	}

	return nil
}

func awsRestjson1_serializeDocumentSpecifications(v *types.Specifications, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SlotTypeId != nil {
		ok := object.Key("slotTypeId")
		ok.String(*v.SlotTypeId)
	}

	if v.ValueElicitationSetting != nil {
		ok := object.Key("valueElicitationSetting")
		if err := awsRestjson1_serializeDocumentSubSlotValueElicitationSetting(v.ValueElicitationSetting, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSSMLMessage(v *types.SSMLMessage, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentStillWaitingResponseSpecification(v *types.StillWaitingResponseSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowInterrupt != nil {
		ok := object.Key("allowInterrupt")
		ok.Boolean(*v.AllowInterrupt)
	}

	if v.FrequencyInSeconds != nil {
		ok := object.Key("frequencyInSeconds")
		ok.Integer(*v.FrequencyInSeconds)
	}

	if v.MessageGroups != nil {
		ok := object.Key("messageGroups")
		if err := awsRestjson1_serializeDocumentMessageGroupsList(v.MessageGroups, ok); err != nil {
			return err
		}
	}

	if v.TimeoutInSeconds != nil {
		ok := object.Key("timeoutInSeconds")
		ok.Integer(*v.TimeoutInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentStringMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentSubSlotSetting(v *types.SubSlotSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Expression != nil {
		ok := object.Key("expression")
		ok.String(*v.Expression)
	}

	if v.SlotSpecifications != nil {
		ok := object.Key("slotSpecifications")
		if err := awsRestjson1_serializeDocumentSubSlotSpecificationMap(v.SlotSpecifications, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSubSlotSpecificationMap(v map[string]types.Specifications, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentSpecifications(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSubSlotTypeComposition(v *types.SubSlotTypeComposition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.SlotTypeId != nil {
		ok := object.Key("slotTypeId")
		ok.String(*v.SlotTypeId)
	}

	return nil
}

func awsRestjson1_serializeDocumentSubSlotTypeList(v []types.SubSlotTypeComposition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSubSlotTypeComposition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentSubSlotValueElicitationSetting(v *types.SubSlotValueElicitationSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DefaultValueSpecification != nil {
		ok := object.Key("defaultValueSpecification")
		if err := awsRestjson1_serializeDocumentSlotDefaultValueSpecification(v.DefaultValueSpecification, ok); err != nil {
			return err
		}
	}

	if v.PromptSpecification != nil {
		ok := object.Key("promptSpecification")
		if err := awsRestjson1_serializeDocumentPromptSpecification(v.PromptSpecification, ok); err != nil {
			return err
		}
	}

	if v.SampleUtterances != nil {
		ok := object.Key("sampleUtterances")
		if err := awsRestjson1_serializeDocumentSampleUtterancesList(v.SampleUtterances, ok); err != nil {
			return err
		}
	}

	if v.WaitAndContinueSpecification != nil {
		ok := object.Key("waitAndContinueSpecification")
		if err := awsRestjson1_serializeDocumentWaitAndContinueSpecification(v.WaitAndContinueSpecification, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSynonymList(v []types.SampleValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSampleValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTestExecutionResultFilterBy(v *types.TestExecutionResultFilterBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConversationLevelTestResultsFilterBy != nil {
		ok := object.Key("conversationLevelTestResultsFilterBy")
		if err := awsRestjson1_serializeDocumentConversationLevelTestResultsFilterBy(v.ConversationLevelTestResultsFilterBy, ok); err != nil {
			return err
		}
	}

	if len(v.ResultTypeFilter) > 0 {
		ok := object.Key("resultTypeFilter")
		ok.String(string(v.ResultTypeFilter))
	}

	return nil
}

func awsRestjson1_serializeDocumentTestExecutionSortBy(v *types.TestExecutionSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentTestExecutionTarget(v *types.TestExecutionTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotAliasTarget != nil {
		ok := object.Key("botAliasTarget")
		if err := awsRestjson1_serializeDocumentBotAliasTestExecutionTarget(v.BotAliasTarget, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTestSetDiscrepancyReportBotAliasTarget(v *types.TestSetDiscrepancyReportBotAliasTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotAliasId != nil {
		ok := object.Key("botAliasId")
		ok.String(*v.BotAliasId)
	}

	if v.BotId != nil {
		ok := object.Key("botId")
		ok.String(*v.BotId)
	}

	if v.LocaleId != nil {
		ok := object.Key("localeId")
		ok.String(*v.LocaleId)
	}

	return nil
}

func awsRestjson1_serializeDocumentTestSetDiscrepancyReportResourceTarget(v *types.TestSetDiscrepancyReportResourceTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BotAliasTarget != nil {
		ok := object.Key("botAliasTarget")
		if err := awsRestjson1_serializeDocumentTestSetDiscrepancyReportBotAliasTarget(v.BotAliasTarget, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTestSetExportSpecification(v *types.TestSetExportSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TestSetId != nil {
		ok := object.Key("testSetId")
		ok.String(*v.TestSetId)
	}

	return nil
}

func awsRestjson1_serializeDocumentTestSetGenerationDataSource(v *types.TestSetGenerationDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConversationLogsDataSource != nil {
		ok := object.Key("conversationLogsDataSource")
		if err := awsRestjson1_serializeDocumentConversationLogsDataSource(v.ConversationLogsDataSource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTestSetImportInputLocation(v *types.TestSetImportInputLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3Path != nil {
		ok := object.Key("s3Path")
		ok.String(*v.S3Path)
	}

	return nil
}

func awsRestjson1_serializeDocumentTestSetImportResourceSpecification(v *types.TestSetImportResourceSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ImportInputLocation != nil {
		ok := object.Key("importInputLocation")
		if err := awsRestjson1_serializeDocumentTestSetImportInputLocation(v.ImportInputLocation, ok); err != nil {
			return err
		}
	}

	if len(v.Modality) > 0 {
		ok := object.Key("modality")
		ok.String(string(v.Modality))
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.StorageLocation != nil {
		ok := object.Key("storageLocation")
		if err := awsRestjson1_serializeDocumentTestSetStorageLocation(v.StorageLocation, ok); err != nil {
			return err
		}
	}

	if v.TestSetName != nil {
		ok := object.Key("testSetName")
		ok.String(*v.TestSetName)
	}

	if v.TestSetTags != nil {
		ok := object.Key("testSetTags")
		if err := awsRestjson1_serializeDocumentTagMap(v.TestSetTags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTestSetSortBy(v *types.TestSetSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Attribute) > 0 {
		ok := object.Key("attribute")
		ok.String(string(v.Attribute))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentTestSetStorageLocation(v *types.TestSetStorageLocation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyArn != nil {
		ok := object.Key("kmsKeyArn")
		ok.String(*v.KmsKeyArn)
	}

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3Path != nil {
		ok := object.Key("s3Path")
		ok.String(*v.S3Path)
	}

	return nil
}

func awsRestjson1_serializeDocumentTextInputSpecification(v *types.TextInputSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StartTimeoutMs != nil {
		ok := object.Key("startTimeoutMs")
		ok.Integer(*v.StartTimeoutMs)
	}

	return nil
}

func awsRestjson1_serializeDocumentTextLogDestination(v *types.TextLogDestination, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatch != nil {
		ok := object.Key("cloudWatch")
		if err := awsRestjson1_serializeDocumentCloudWatchLogGroupLogDestination(v.CloudWatch, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTextLogSetting(v *types.TextLogSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("destination")
		if err := awsRestjson1_serializeDocumentTextLogDestination(v.Destination, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.SelectiveLoggingEnabled != nil {
		ok := object.Key("selectiveLoggingEnabled")
		ok.Boolean(*v.SelectiveLoggingEnabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentTextLogSettingsList(v []types.TextLogSetting, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTextLogSetting(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTranscriptFilter(v *types.TranscriptFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LexTranscriptFilter != nil {
		ok := object.Key("lexTranscriptFilter")
		if err := awsRestjson1_serializeDocumentLexTranscriptFilter(v.LexTranscriptFilter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTranscriptSourceSetting(v *types.TranscriptSourceSetting, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3BucketTranscriptSource != nil {
		ok := object.Key("s3BucketTranscriptSource")
		if err := awsRestjson1_serializeDocumentS3BucketTranscriptSource(v.S3BucketTranscriptSource, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateCustomVocabularyItemsList(v []types.CustomVocabularyItem, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentCustomVocabularyItem(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUtteranceAggregationDuration(v *types.UtteranceAggregationDuration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RelativeAggregationDuration != nil {
		ok := object.Key("relativeAggregationDuration")
		if err := awsRestjson1_serializeDocumentRelativeAggregationDuration(v.RelativeAggregationDuration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUtteranceDataSortBy(v *types.UtteranceDataSortBy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Name) > 0 {
		ok := object.Key("name")
		ok.String(string(v.Name))
	}

	if len(v.Order) > 0 {
		ok := object.Key("order")
		ok.String(string(v.Order))
	}

	return nil
}

func awsRestjson1_serializeDocumentVoiceSettings(v *types.VoiceSettings, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Engine) > 0 {
		ok := object.Key("engine")
		ok.String(string(v.Engine))
	}

	if v.VoiceId != nil {
		ok := object.Key("voiceId")
		ok.String(*v.VoiceId)
	}

	return nil
}

func awsRestjson1_serializeDocumentWaitAndContinueSpecification(v *types.WaitAndContinueSpecification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Active != nil {
		ok := object.Key("active")
		ok.Boolean(*v.Active)
	}

	if v.ContinueResponse != nil {
		ok := object.Key("continueResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.ContinueResponse, ok); err != nil {
			return err
		}
	}

	if v.StillWaitingResponse != nil {
		ok := object.Key("stillWaitingResponse")
		if err := awsRestjson1_serializeDocumentStillWaitingResponseSpecification(v.StillWaitingResponse, ok); err != nil {
			return err
		}
	}

	if v.WaitingResponse != nil {
		ok := object.Key("waitingResponse")
		if err := awsRestjson1_serializeDocumentResponseSpecification(v.WaitingResponse, ok); err != nil {
			return err
		}
	}

	return nil
}
