// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptographydata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Translates encrypted PIN block from and to ISO 9564 formats 0,1,3,4. For more
// information, see Translate PIN data (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/translate-pin-data.html)
// in the Amazon Web Services Payment Cryptography User Guide. PIN block
// translation involves changing the encrytion of PIN block from one encryption key
// to another encryption key and changing PIN block format from one to another
// without PIN block data leaving Amazon Web Services Payment Cryptography. The
// encryption key transformation can be from PEK (Pin Encryption Key) to BDK (Base
// Derivation Key) for DUKPT or from BDK for DUKPT to PEK. Amazon Web Services
// Payment Cryptography supports TDES and AES key derivation type for DUKPT
// tranlations. You can use this operation for P2PE (Point to Point Encryption) use
// cases where the encryption keys should change but the processing system either
// does not need to, or is not permitted to, decrypt the data. The allowed
// combinations of PIN block format translations are guided by PCI. It is important
// to note that not all encrypted PIN block formats (example, format 1) require PAN
// (Primary Account Number) as input. And as such, PIN block format that requires
// PAN (example, formats 0,3,4) cannot be translated to a format (format 1) that
// does not require a PAN for generation. For information about valid keys for this
// operation, see Understanding key attributes (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html)
// and Key types for specific data operations (https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html)
// in the Amazon Web Services Payment Cryptography User Guide. At this time, Amazon
// Web Services Payment Cryptography does not support translations to PIN format 4.
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts. Related operations:
//   - GeneratePinData
//   - VerifyPinData
func (c *Client) TranslatePinData(ctx context.Context, params *TranslatePinDataInput, optFns ...func(*Options)) (*TranslatePinDataOutput, error) {
	if params == nil {
		params = &TranslatePinDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TranslatePinData", params, optFns, c.addOperationTranslatePinDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TranslatePinDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TranslatePinDataInput struct {

	// The encrypted PIN block data that Amazon Web Services Payment Cryptography
	// translates.
	//
	// This member is required.
	EncryptedPinBlock *string

	// The keyARN of the encryption key under which incoming PIN block data is
	// encrypted. This key type can be PEK or BDK.
	//
	// This member is required.
	IncomingKeyIdentifier *string

	// The format of the incoming PIN block data for tranlation within Amazon Web
	// Services Payment Cryptography.
	//
	// This member is required.
	IncomingTranslationAttributes types.TranslationIsoFormats

	// The keyARN of the encryption key for encrypting outgoing PIN block data. This
	// key type can be PEK or BDK.
	//
	// This member is required.
	OutgoingKeyIdentifier *string

	// The format of the outgoing PIN block data after tranlation by Amazon Web
	// Services Payment Cryptography.
	//
	// This member is required.
	OutgoingTranslationAttributes types.TranslationIsoFormats

	// The attributes and values to use for incoming DUKPT encryption key for PIN
	// block tranlation.
	IncomingDukptAttributes *types.DukptDerivationAttributes

	// The attributes and values to use for outgoing DUKPT encryption key after PIN
	// block translation.
	OutgoingDukptAttributes *types.DukptDerivationAttributes

	noSmithyDocumentSerde
}

type TranslatePinDataOutput struct {

	// The keyARN of the encryption key that Amazon Web Services Payment Cryptography
	// uses to encrypt outgoing PIN block data after translation.
	//
	// This member is required.
	KeyArn *string

	// The key check value (KCV) of the encryption key. The KCV is used to check if
	// all parties holding a given key have the same key or to detect that a key has
	// changed. Amazon Web Services Payment Cryptography calculates the KCV by using
	// standard algorithms, typically by encrypting 8 or 16 bytes or "00" or "01" and
	// then truncating the result to the first 3 bytes, or 6 hex digits, of the
	// resulting cryptogram.
	//
	// This member is required.
	KeyCheckValue *string

	// The ougoing encrypted PIN block data after tranlation.
	//
	// This member is required.
	PinBlock *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTranslatePinDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpTranslatePinData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpTranslatePinData{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "TranslatePinData"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpTranslatePinDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTranslatePinData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opTranslatePinData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "TranslatePinData",
	}
}
