// Code generated by smithy-go-codegen DO NOT EDIT.

package personalize

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/personalize/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of dataset groups. The response provides the properties for each
// dataset group, including the Amazon Resource Name (ARN). For more information on
// dataset groups, see CreateDatasetGroup (https://docs.aws.amazon.com/personalize/latest/dg/API_CreateDatasetGroup.html)
// .
func (c *Client) ListDatasetGroups(ctx context.Context, params *ListDatasetGroupsInput, optFns ...func(*Options)) (*ListDatasetGroupsOutput, error) {
	if params == nil {
		params = &ListDatasetGroupsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDatasetGroups", params, optFns, c.addOperationListDatasetGroupsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDatasetGroupsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDatasetGroupsInput struct {

	// The maximum number of dataset groups to return.
	MaxResults *int32

	// A token returned from the previous call to ListDatasetGroups for getting the
	// next set of dataset groups (if they exist).
	NextToken *string

	noSmithyDocumentSerde
}

type ListDatasetGroupsOutput struct {

	// The list of your dataset groups.
	DatasetGroups []types.DatasetGroupSummary

	// A token for getting the next set of dataset groups (if they exist).
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDatasetGroupsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListDatasetGroups{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListDatasetGroups{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDatasetGroups"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDatasetGroups(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDatasetGroupsAPIClient is a client that implements the ListDatasetGroups
// operation.
type ListDatasetGroupsAPIClient interface {
	ListDatasetGroups(context.Context, *ListDatasetGroupsInput, ...func(*Options)) (*ListDatasetGroupsOutput, error)
}

var _ ListDatasetGroupsAPIClient = (*Client)(nil)

// ListDatasetGroupsPaginatorOptions is the paginator options for ListDatasetGroups
type ListDatasetGroupsPaginatorOptions struct {
	// The maximum number of dataset groups to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDatasetGroupsPaginator is a paginator for ListDatasetGroups
type ListDatasetGroupsPaginator struct {
	options   ListDatasetGroupsPaginatorOptions
	client    ListDatasetGroupsAPIClient
	params    *ListDatasetGroupsInput
	nextToken *string
	firstPage bool
}

// NewListDatasetGroupsPaginator returns a new ListDatasetGroupsPaginator
func NewListDatasetGroupsPaginator(client ListDatasetGroupsAPIClient, params *ListDatasetGroupsInput, optFns ...func(*ListDatasetGroupsPaginatorOptions)) *ListDatasetGroupsPaginator {
	if params == nil {
		params = &ListDatasetGroupsInput{}
	}

	options := ListDatasetGroupsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDatasetGroupsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDatasetGroupsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDatasetGroups page.
func (p *ListDatasetGroupsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDatasetGroupsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListDatasetGroups(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDatasetGroups(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDatasetGroups",
	}
}
