// Code generated by smithy-go-codegen DO NOT EDIT.

package savingsplans

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/savingsplans/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the specified Savings Plans offerings.
func (c *Client) DescribeSavingsPlansOfferings(ctx context.Context, params *DescribeSavingsPlansOfferingsInput, optFns ...func(*Options)) (*DescribeSavingsPlansOfferingsOutput, error) {
	if params == nil {
		params = &DescribeSavingsPlansOfferingsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeSavingsPlansOfferings", params, optFns, c.addOperationDescribeSavingsPlansOfferingsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeSavingsPlansOfferingsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeSavingsPlansOfferingsInput struct {

	// The currencies.
	Currencies []types.CurrencyCode

	// The descriptions.
	Descriptions []string

	// The durations, in seconds.
	Durations []int64

	// The filters.
	Filters []types.SavingsPlanOfferingFilterElement

	// The maximum number of results to return with a single call. To retrieve
	// additional results, make another call with the returned token value.
	MaxResults int32

	// The token for the next page of results.
	NextToken *string

	// The IDs of the offerings.
	OfferingIds []string

	// The specific AWS operation for the line item in the billing report.
	Operations []string

	// The payment options.
	PaymentOptions []types.SavingsPlanPaymentOption

	// The plan type.
	PlanTypes []types.SavingsPlanType

	// The product type.
	ProductType types.SavingsPlanProductType

	// The services.
	ServiceCodes []string

	// The usage details of the line item in the billing report.
	UsageTypes []string

	noSmithyDocumentSerde
}

type DescribeSavingsPlansOfferingsOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Information about the Savings Plans offerings.
	SearchResults []types.SavingsPlanOffering

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeSavingsPlansOfferingsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDescribeSavingsPlansOfferings{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDescribeSavingsPlansOfferings{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeSavingsPlansOfferings"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeSavingsPlansOfferings(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeSavingsPlansOfferings(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeSavingsPlansOfferings",
	}
}
