---
aliases:
  - /docs/grafana/latest/setup-grafana/configure-grafana/feature-toggles/
description: Learn about toggles for experimental and beta features, which you can enable or disable.
title: Configure feature toggles
weight: 150
---

<!-- DO NOT EDIT THIS PAGE, it is machine generated by running the test in -->
<!-- https://github.com/grafana/grafana/blob/main/pkg/services/featuremgmt/toggles_gen_test.go#L19 -->

# Configure feature toggles

You use feature toggles, also known as feature flags, to turn experimental or beta features on and off in Grafana. Although we do not recommend using these features in production, you can turn on feature toggles to try out new functionality in development or test environments.

This page contains a list of available feature toggles. To learn how to turn on feature toggles, refer to our [Configure Grafana documentation]({{< relref "../_index.md/#feature_toggles" >}}). Feature toggles are also available to Grafana Cloud Advanced customers. If you use Grafana Cloud Advanced, you can open a support ticket and specify the feature toggles and stack for which you want them enabled.

## Stable feature toggles

Some stable features are enabled by default. You can disable a stable feature by setting the feature flag to "false" in the configuration.

| Feature toggle name                 | Description                                                                                                                                                                  | Enabled by default |
| ----------------------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------ |
| `disableEnvelopeEncryption`         | Disable envelope encryption (emergency only)                                                                                                                                 |                    |
| `database_metrics`                  | Add Prometheus metrics for database tables                                                                                                                                   |                    |
| `featureHighlights`                 | Highlight Grafana Enterprise features                                                                                                                                        |                    |
| `cloudWatchDynamicLabels`           | Use dynamic labels instead of alias patterns in CloudWatch datasource                                                                                                        | Yes                |
| `dataConnectionsConsole`            | Enables a new top-level page called Connections. This page is an experiment that provides a better experience when you install and configure data sources and other plugins. | Yes                |
| `internationalization`              | Enables internationalization                                                                                                                                                 | Yes                |
| `topnav`                            | Enables new top navigation and page layouts                                                                                                                                  | Yes                |
| `cloudWatchCrossAccountQuerying`    | Enables cross-account querying in CloudWatch datasources                                                                                                                     | Yes                |
| `newPanelChromeUI`                  | Show updated look and feel of grafana-ui PanelChrome: panel header, icons, and menu                                                                                          | Yes                |
| `accessTokenExpirationCheck`        | Enable OAuth access_token expiration check and token refresh using the refresh_token                                                                                         |                    |
| `emptyDashboardPage`                | Enable the redesigned user interface of a dashboard page that includes no panels                                                                                             | Yes                |
| `disablePrometheusExemplarSampling` | Disable Prometheus exemplar sampling                                                                                                                                         |                    |
| `logsSampleInExplore`               | Enables access to the logs sample feature in Explore                                                                                                                         | Yes                |

## Beta feature toggles

| Feature toggle name                       | Description                                                                                                                                                                                  |
| ----------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `trimDefaults`                            | Use cue schema to remove values that will be applied automatically                                                                                                                           |
| `panelTitleSearch`                        | Search for dashboards using panel title                                                                                                                                                      |
| `prometheusAzureOverrideAudience`         | Experimental. Allow override default AAD audience for Azure Prometheus endpoint                                                                                                              |
| `migrationLocking`                        | Lock database during migrations                                                                                                                                                              |
| `newDBLibrary`                            | Use jmoiron/sqlx rather than xorm for a few backend services                                                                                                                                 |
| `validateDashboardsOnSave`                | Validate dashboard JSON POSTed to api/dashboards/db                                                                                                                                          |
| `autoMigrateOldPanels`                    | Migrate old angular panels to supported versions (graph, table-old, worldmap, etc)                                                                                                           |
| `disableAngular`                          | Dynamic flag to disable angular at runtime. The preferred method is to set `angular_support_enabled` to `false` in the [security] settings, which allows you to change the state at runtime. |
| `accessControlOnCall`                     | Access control primitives for OnCall                                                                                                                                                         |
| `alertingNoNormalState`                   | Stop maintaining state of alerts that are not firing                                                                                                                                         |
| `disableElasticsearchBackendExploreQuery` | Disable executing of Elasticsearch Explore queries through backend                                                                                                                           |
| `renderAuthJWT`                           | Uses JWT-based auth for rendering instead of relying on remote cache                                                                                                                         |

## Alpha feature toggles

These features are early in their development lifecycle and so are not yet supported in Grafana Cloud.
Alpha features might be changed or removed without prior notice.

| Feature toggle name                | Description                                                                                                                                                                                         |
| ---------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `dashboardPreviews`                | Create and show thumbnails for dashboard search results                                                                                                                                             |
| `live-service-web-worker`          | This will use a webworker thread to processes events rather than the main thread                                                                                                                    |
| `queryOverLive`                    | Use Grafana Live WebSocket to execute backend queries                                                                                                                                               |
| `publicDashboards`                 | Enables public access to dashboards                                                                                                                                                                 |
| `publicDashboardsEmailSharing`     | Enables public dashboard sharing to be restricted to only allowed emails                                                                                                                            |
| `lokiLive`                         | Support WebSocket streaming for loki (early prototype)                                                                                                                                              |
| `lokiDataframeApi`                 | Use experimental loki api for WebSocket streaming (early prototype)                                                                                                                                 |
| `storage`                          | Configurable storage for dashboards, datasources, and resources                                                                                                                                     |
| `exploreMixedDatasource`           | Enable mixed datasource in Explore                                                                                                                                                                  |
| `newTraceView`                     | Shows the new trace view design                                                                                                                                                                     |
| `correlations`                     | Correlations page                                                                                                                                                                                   |
| `datasourceQueryMultiStatus`       | Introduce HTTP 207 Multi Status for api/ds/query                                                                                                                                                    |
| `traceToMetrics`                   | Enable trace to metrics links                                                                                                                                                                       |
| `prometheusWideSeries`             | Enable wide series responses in the Prometheus datasource                                                                                                                                           |
| `canvasPanelNesting`               | Allow elements nesting                                                                                                                                                                              |
| `scenes`                           | Experimental framework to build interactive dashboards                                                                                                                                              |
| `disableSecretsCompatibility`      | Disable duplicated secret storage in legacy tables                                                                                                                                                  |
| `logRequestsInstrumentedAsUnknown` | Logs the path for requests that are instrumented as unknown                                                                                                                                         |
| `redshiftAsyncQueryDataSupport`    | Enable async query data support for Redshift                                                                                                                                                        |
| `athenaAsyncQueryDataSupport`      | Enable async query data support for Athena                                                                                                                                                          |
| `showDashboardValidationWarnings`  | Show warnings when dashboards do not validate against the schema                                                                                                                                    |
| `mysqlAnsiQuotes`                  | Use double quotes to escape keyword in a MySQL query                                                                                                                                                |
| `elasticsearchBackendMigration`    | Use Elasticsearch as backend data source                                                                                                                                                            |
| `secureSocksDatasourceProxy`       | Enable secure socks tunneling for supported core datasources                                                                                                                                        |
| `authnService`                     | Use new auth service to perform authentication                                                                                                                                                      |
| `alertingBacktesting`              | Rule backtesting API for alerting                                                                                                                                                                   |
| `editPanelCSVDragAndDrop`          | Enables drag and drop for CSV and Excel files                                                                                                                                                       |
| `logsContextDatasourceUi`          | Allow datasource to provide custom UI for context view                                                                                                                                              |
| `lokiQuerySplitting`               | Split large interval queries into subqueries with smaller time intervals                                                                                                                            |
| `lokiQuerySplittingConfig`         | Give users the option to configure split durations for Loki queries                                                                                                                                 |
| `individualCookiePreferences`      | Support overriding cookie preferences per user                                                                                                                                                      |
| `onlyExternalOrgRoleSync`          | Prohibits a user from changing organization roles synced with external auth providers                                                                                                               |
| `drawerDataSourcePicker`           | Changes the user experience for data source selection to a drawer.                                                                                                                                  |
| `traceqlSearch`                    | Enables the 'TraceQL Search' tab for the Tempo datasource which provides a UI to generate TraceQL queries                                                                                           |
| `prometheusMetricEncyclopedia`     | Replaces the Prometheus query builder metric select option with a paginated and filterable component                                                                                                |
| `timeSeriesTable`                  | Enable time series table transformer & sparkline cell type                                                                                                                                          |
| `prometheusResourceBrowserCache`   | Displays browser caching options in Prometheus data source configuration                                                                                                                            |
| `influxdbBackendMigration`         | Query InfluxDB InfluxQL without the proxy                                                                                                                                                           |
| `clientTokenRotation`              | Replaces the current in-request token rotation so that the client initiates the rotation                                                                                                            |
| `prometheusDataplane`              | Changes responses to from Prometheus to be compliant with the dataplane specification. In particular it sets the numeric Field.Name from 'Value' to the value of the `__name__` label when present. |
| `alertStateHistoryLokiSecondary`   | Enable Grafana to write alert state history to an external Loki instance in addition to Grafana annotations.                                                                                        |
| `alertStateHistoryLokiPrimary`     | Enable a remote Loki instance as the primary source for state history reads.                                                                                                                        |
| `alertStateHistoryLokiOnly`        | Disable Grafana alerts from emitting annotations when a remote Loki instance is available.                                                                                                          |
| `unifiedRequestLog`                | Writes error logs to the request logger                                                                                                                                                             |

## Development feature toggles

The following toggles require explicitly setting Grafana's [app mode]({{< relref "../_index.md/#app_mode" >}}) to 'development' before you can enable this feature toggle. These features tend to be experimental.

| Feature toggle name | Description                                         |
| ------------------- | --------------------------------------------------- |
| `k8s`               | Explore native k8s integrations                     |
| `grpcServer`        | Run GRPC server                                     |
| `entityStore`       | SQL-based entity store (requires storage flag also) |
| `nestedFolders`     | Enable folder nesting                               |
