/*Package api contains base API implementation of unified alerting
 *
 *Generated by: Swagger Codegen (https://github.com/swagger-api/swagger-codegen.git)
 *
 *Do not manually edit these files, please find ngalert/api/swagger-codegen/ for commands on how to generate them.
 */
package api

import (
	"net/http"

	"github.com/grafana/grafana/pkg/api/response"
	"github.com/grafana/grafana/pkg/api/routing"
	"github.com/grafana/grafana/pkg/middleware"
	contextmodel "github.com/grafana/grafana/pkg/services/contexthandler/model"
	"github.com/grafana/grafana/pkg/services/ngalert/metrics"
	"github.com/grafana/grafana/pkg/web"
)

type PrometheusApi interface {
	RouteGetAlertStatuses(*contextmodel.ReqContext) response.Response
	RouteGetGrafanaAlertStatuses(*contextmodel.ReqContext) response.Response
	RouteGetGrafanaRuleStatuses(*contextmodel.ReqContext) response.Response
	RouteGetRuleStatuses(*contextmodel.ReqContext) response.Response
}

func (f *PrometheusApiHandler) RouteGetAlertStatuses(ctx *contextmodel.ReqContext) response.Response {
	// Parse Path Parameters
	datasourceUIDParam := web.Params(ctx.Req)[":DatasourceUID"]
	return f.handleRouteGetAlertStatuses(ctx, datasourceUIDParam)
}
func (f *PrometheusApiHandler) RouteGetGrafanaAlertStatuses(ctx *contextmodel.ReqContext) response.Response {
	return f.handleRouteGetGrafanaAlertStatuses(ctx)
}
func (f *PrometheusApiHandler) RouteGetGrafanaRuleStatuses(ctx *contextmodel.ReqContext) response.Response {
	return f.handleRouteGetGrafanaRuleStatuses(ctx)
}
func (f *PrometheusApiHandler) RouteGetRuleStatuses(ctx *contextmodel.ReqContext) response.Response {
	// Parse Path Parameters
	datasourceUIDParam := web.Params(ctx.Req)[":DatasourceUID"]
	return f.handleRouteGetRuleStatuses(ctx, datasourceUIDParam)
}

func (api *API) RegisterPrometheusApiEndpoints(srv PrometheusApi, m *metrics.API) {
	api.RouteRegister.Group("", func(group routing.RouteRegister) {
		group.Get(
			toMacaronPath("/api/prometheus/{DatasourceUID}/api/v1/alerts"),
			api.authorize(http.MethodGet, "/api/prometheus/{DatasourceUID}/api/v1/alerts"),
			metrics.Instrument(
				http.MethodGet,
				"/api/prometheus/{DatasourceUID}/api/v1/alerts",
				api.Hooks.Wrap(srv.RouteGetAlertStatuses),
				m,
			),
		)
		group.Get(
			toMacaronPath("/api/prometheus/grafana/api/v1/alerts"),
			api.authorize(http.MethodGet, "/api/prometheus/grafana/api/v1/alerts"),
			metrics.Instrument(
				http.MethodGet,
				"/api/prometheus/grafana/api/v1/alerts",
				api.Hooks.Wrap(srv.RouteGetGrafanaAlertStatuses),
				m,
			),
		)
		group.Get(
			toMacaronPath("/api/prometheus/grafana/api/v1/rules"),
			api.authorize(http.MethodGet, "/api/prometheus/grafana/api/v1/rules"),
			metrics.Instrument(
				http.MethodGet,
				"/api/prometheus/grafana/api/v1/rules",
				api.Hooks.Wrap(srv.RouteGetGrafanaRuleStatuses),
				m,
			),
		)
		group.Get(
			toMacaronPath("/api/prometheus/{DatasourceUID}/api/v1/rules"),
			api.authorize(http.MethodGet, "/api/prometheus/{DatasourceUID}/api/v1/rules"),
			metrics.Instrument(
				http.MethodGet,
				"/api/prometheus/{DatasourceUID}/api/v1/rules",
				api.Hooks.Wrap(srv.RouteGetRuleStatuses),
				m,
			),
		)
	}, middleware.ReqSignedIn)
}
