#!/bin/bash

# NOTE: This debian-package is based on the kernel version.
#       Since the files being diverted are kernel specific it's most likely that
#       an upgrade is a QA function and not triggered by a customer.
#       Even though the divert command is idempotent we must still distinguish
#       between install and upgrade.

# Create the diversions
for mod in !!MODLIST!! ; do
  # Not all modules in this list need diverts, so see if the file exists first
  if [[ -e "$mod" ]]; then
    if [[ $1 == "upgrade" ]]; then
      if [[ -n $(dpkg-divert --listpackage $mod) ]]; then
        # If already diverted, skip it
        continue
      fi
      package=$(dpkg-query -S $mod| awk -F '[ :]' '{print $1}')
      if [[ $package != "!!PACKAGE!!" ]]; then
        # Not already our package
        echo "Diverting kernel module $(basename $mod)"
        dpkg-divert --add --package !!PACKAGE!! --rename --divert "$mod.orig" "$mod"
      fi
    else  # Assume install
      echo "Diverting kernel module $(basename $mod)"
      dpkg-divert --add --package !!PACKAGE!! --rename --divert "$mod.orig" "$mod"
      rc=$?
      if [ $rc -ne 0 ] ; then
        echo "Error $rc while diverting $mod"
        exit $rc
      fi
    fi
  fi
done

# TODO: Remove in PGE 3.8
# M-0043095: Hit issue with double-upgrade
# This version of the file is not packaged in PGE 3.7
# Just get rid of the diversion since there's no conflict
old_qed_bin='/lib/firmware/qed/qed_init_values_zipped-8.50.16.0.bin'
package=$(dpkg-divert --listpackage $old_qed_bin)
if [[ -n $package ]]; then
  # The "remove" command fails if the $old_qed_bin file exists
  # And if the orig file exists it would be from some upgrade issue
  # So remove the file and orig
  rm -f "$old_qed_bin" "$old_qed_bin.orig"
  dpkg-divert --remove --package $package --rename $old_qed_bin
fi
