## Change Log

### 2.0.3 (2020/03/02 06:12 +00:00)
- [7774e4e](https://github.com/thelastpickle/cassandra-reaper/commit/7774e4eeaaac5af0598887ee62713882b65d3906) Fix large partitions in the metrics v2 table for the sidecar (@adejanovski)
- [05e5f32](https://github.com/thelastpickle/cassandra-reaper/commit/05e5f3256fffed8005fe96647b1d482a815982eb) Avoid aborting repair segments too early. (@smarsching)

### 2.0.2 (2020/01/13 06:37 +00:00)
- [16b0db9](https://github.com/thelastpickle/cassandra-reaper/commit/16b0db9ebae0c75ef86c5213f2629a00b0812eb8) Remove the keyspace from the initial Cassandra migration script (@adejanovski)
- [256682f](https://github.com/thelastpickle/cassandra-reaper/commit/256682fbf7829e5a5a38080a1756aa6a146a3e40) Add cluster deletion support to spreaper (@adejanovski)
- [c6937a5](https://github.com/thelastpickle/cassandra-reaper/commit/c6937a5a66e5e38553e37acbc9af9660af3a39e5) Add the repair_unit_id in the repair schedule status (@adejanovski)
- [c1ca09f](https://github.com/thelastpickle/cassandra-reaper/commit/c1ca09f8f9e29f1aeb74665b23cf84e5fbd19585) Fix spreaper list_runs() command not using the right query params (@adejanovski)

### 2.0.1 (2019/12/18 12:48 +00:00)
- [72b7fd5](https://github.com/thelastpickle/cassandra-reaper/commit/72b7fd5cc7c06cf7f7152b1fb63503af68414198) Fix the dockerfile issues along with Shiro when postgres is used as storage backend (@adejanovski)
- [797fd78](https://github.com/thelastpickle/cassandra-reaper/commit/797fd7827248a8c21931068ce72d0329360c531f) fix regression caused by PR 783 (@jsanda)

### 2.0 (2019/12/06 06:25 +00:00)
- [848e48b](https://github.com/thelastpickle/cassandra-reaper/commit/848e48bec6b2afe42cd9857abe1533e7d9f776d7) Add "force" flag to cluster delete REST endpoint, allowing registered clusters with schedules and repairs runs to be forcibly deleted. (@michaelsembwever)
- [e13b34d](https://github.com/thelastpickle/cassandra-reaper/commit/e13b34d77f6ec5789e311bd287edb602dca8198f) Remove leader election in Reaper for schema migrations and instead rely on the cassandra-migration lib built in consensus. (@adejanovski)
- [da5a058](https://github.com/thelastpickle/cassandra-reaper/commit/da5a05817f7ac467a862b3679dc8e3f99ec59325) Display available repair metrics in the UI (@adejanovski)
- [2243c73](https://github.com/thelastpickle/cassandra-reaper/commit/2243c733140a04f65c560c7e9f531c1c56d350e2) Make docker image run as non-root (@mimarpe)
- [edfd5a9](https://github.com/thelastpickle/cassandra-reaper/commit/edfd5a9ce9c38162cae864f17e83f64368ab2d96) Added option REAPER_AUTH_ENABLED. (@andrejvanderzee)
- [9bb2878](https://github.com/thelastpickle/cassandra-reaper/commit/9bb2878a3626c62ea58705ff3d6e32072ed1ad85) Add switchable UI themes (@adejanovski)
aa833d8cd69e27655155e40bfe971e13a3cc4e47) support use of Postgresql as storage backend for multiple reapers (@Saleil-Bhat)
- [0591b38](https://github.com/thelastpickle/cassandra-reaper/commit/0591b38d3166a392643d854942d308ec5fd021f5) Make stream tracking work with 4.0 (@rzvoncek)
- [b293160](https://github.com/thelastpickle/cassandra-reaper/commit/b2931600ae09606d11227a8f61dbacf2d41515bf) Add Cassandra storage support for Diagnostic Events (@michaelsembwever)
- [e65a47e](https://github.com/thelastpickle/cassandra-reaper/commit/e65a47e42ec88f9c55f560a3123048d8a02b8b72) Add JMX and REST support for diagnostic events (@spodkowinski)
- [a04e7cf](https://github.com/thelastpickle/cassandra-reaper/commit/a04e7cf4823d6d87977bcbbaa751268d4cf2dbb7) Fix NPE upon upgrade when last contact is null on existing clusters (@adejanovski)
- [22c7cfe](https://github.com/thelastpickle/cassandra-reaper/commit/22c7cfef2fbcce12bbb7468ab6752096dae10cbe) Self register clusters in sidecar mode since the nodes are collocated with Reaper. (@adejanovski)
- [a5fdac2](https://github.com/thelastpickle/cassandra-reaper/commit/a5fdac292e955da425b00d62853d667c2f7b6586) Simplify how RepairManager aborts/postpones segments, fixing how leader election happens and when and how it is correctly released. (@michaelsembwever)
- [f01e914](https://github.com/thelastpickle/cassandra-reaper/commit/f01e914ff1fc8295da1e6dcce348effc1cdd4ee6) Implement the sidecar mode (@adejanovski)
- [f798244](https://github.com/thelastpickle/cassandra-reaper/commit/f7982449b2dfdf4110041dc8c58bb89e5ffcee5f) Handle new messaging service verbs for dropped reads in Cassandra 4.0 (@michaelsembwever)
- [fed72fe](https://github.com/thelastpickle/cassandra-reaper/commit/fed72fee191496c0e883c23dc603dd6d6e3c388c) Request remote nodes metrics only if there are several reapers running (@adejanovski)
- [644553a](https://github.com/thelastpickle/cassandra-reaper/commit/644553a762e6abb4eb32e7e8fdcf58da324ae5c2) Improves the preventation of multiple scheduled repair runs starting at the same time. (@michaelsembwever)
- [65909e3](https://github.com/thelastpickle/cassandra-reaper/commit/65909e32287b3b6f6f37bb10adacd06e2db79685) The purge and abort segment REST endpoints are actions, not idempotent reads, so should be POST instead of GET method requests. (@michaelsembwever)
- [e686c2f](https://github.com/thelastpickle/cassandra-reaper/commit/e686c2f22866efb4ee9ea0d7a4001bcc0ecd0190) Don't start a segment repair if it is already started, running, or done. (@michaelsembwever)
- [d7d045f](https://github.com/thelastpickle/cassandra-reaper/commit/d7d045f7eaa4e214584c4ec8082265ba45c36d9b) Add automated retries when connecting to the storage backend (@adejanovski)
- [f6c451b](https://github.com/thelastpickle/cassandra-reaper/commit/f6c451baa7da321319987ea3e46bee7a5858bb76) Encapsulate jmx interactions in a proxy class (@adejanovski)

### 1.4.8 (2019/11/15 09:05 +00:00)
- [3bffd87](https://github.com/thelastpickle/cassandra-reaper/commit/3bffd8717b6731c7264ad2f9be65764467544cff) Fix bug in UI where only three datacenters would ever be displayed even if there were more (@ossarga)
- [e83c2be](https://github.com/thelastpickle/cassandra-reaper/commit/e83c2be560044d6cfc500cb6724f3324d8bf487d) ninja-fix: correct output when searching for cassandra-reaper installation (@michaelsembwever)
- [f4d2d9f](https://github.com/thelastpickle/cassandra-reaper/commit/f4d2d9fbc618ae8067f2238512127d80c609457b) Avoid length `find` commands when starting reaper from a higher/top- level directory by limiting find's depth to 4 levels. (@michaelsembwever)

### 1.4.7 (2019/10/16 13:18 +00:00)
- [bb39388](https://github.com/thelastpickle/cassandra-reaper/commit/bb393887c561ae9a17e24bed9053ff46146412a3) Fix metric naming to allow long term tracking of repairs. (@adejanovski)
- [68f92a4](https://github.com/thelastpickle/cassandra-reaper/commit/68f92a4ae3348330a82e2d7d3bc4eb8ab2cfef83) Cluster view UI reorg (@adejanovski)

### 1.4.6 (2019/09/02 16:12 +00:00)
- [bf18681](https://github.com/thelastpickle/cassandra-reaper/commit/bf18681cd1bf2625a3ab772294d3acb87b6240d2) Fix deploy phase (@adejanovski)

### 1.4.5 (2019/08/23 15:36 +00:00)
- [8bcf6d3](https://github.com/thelastpickle/cassandra-reaper/commit/8bcf6d3df9ca3d05feabc2167d622976d5b833b8) Backport multiple DC UI fix to 1.4 (@michaelsembwever)
- [3dcb5d5](https://github.com/thelastpickle/cassandra-reaper/commit/3dcb5d5021a5f3f153555edfed131e1f89cac4dd) Fix the find command to correctly identify the reaper jar on all systems while excluding source/javadoc jars (@adejanovski)
- [1cb9075](https://github.com/thelastpickle/cassandra-reaper/commit/1cb9075bda3b7560b435690e980e360419e772fe) Add authorization to rest endpoints based on their verbs (http method), add "operator" (read+write) and "user" (read-only) roles, let the existing admin user be an operator and add a new user "user" with the "user" role. (@michaelsembwever)
- [134c7a0](https://github.com/thelastpickle/cassandra-reaper/commit/134c7a0e7f861c909aeb2deefcb15ee66d9ad798) Don't include *-sources.jar into the classpath, and be a bit smarter in finding the jar file in a current project directory (regardless of the current folder in the project directory) (@michaelsembwever)
- [534f5aa](https://github.com/thelastpickle/cassandra-reaper/commit/534f5aae0dde877910e8394653c8b81307441428) Fix initialisation ordering of AppContext (@treuherz)
- [a934aea](https://github.com/thelastpickle/cassandra-reaper/commit/a934aea7a1db3ea978e8c6e96854a122f6d847d1) Improve performance of JsonParseUtils (@michaelsembwever)

### 1.4.4 (2019/05/28 09:21 +00:00)

- [47322c1](https://github.com/thelastpickle/cassandra-reaper/commit/47322c1436f868318a1823df65574c7d4acf1d4d) Fix for NPE when a segment is aborted (@adejanovski)

### 1.4.3 (2019/05/21 00:43 +00:00)

- [91f6f51](https://github.com/thelastpickle/cassandra-reaper/commit/91f6f5167675e25268ba862bdc13c6625fe1dca7) Automatically run every Cassandra Migration class when upgrading (@michaelsembwever)
- [2b82937](https://github.com/thelastpickle/cassandra-reaper/commit/2b829379081f0d97af57aadb54e6f4dd61edde86) Change UI run_repair API call to be more performant (@ossarga)
- [544de58](https://github.com/thelastpickle/cassandra-reaper/commit/544de58872ebc2a45151299a14415f4f47157164) In SegmentRunner immediately release the segment lead once the segment repair is done. The intensity pause can happen afterwards. (@michaelsembwever)
- [c6e1098](https://github.com/thelastpickle/cassandra-reaper/commit/c6e1098b22a89bd75975b192af0d9959274e1fd6) Fix (set to null) endTime in any repairRuns that are in PAUSED state (@michaelsembwever)

### 1.4.2 (2019/05/07 06:31 +00:00)
- [5cdd573](https://github.com/thelastpickle/cassandra-reaper/commit/5cdd57330db562e061d325abf54b0f59c120c7b2) Fix RepairRun timestamps, honouring different run states. (@michaelsembwever)
- [c0b4600](https://github.com/thelastpickle/cassandra-reaper/commit/c0b460002dd2f5173323d68979f7368e3cbe3c4c) Auto scheduler encounters null pointer exception #298 (@michaelsembwever)
- [cf34fbb](https://github.com/thelastpickle/cassandra-reaper/commit/cf34fbb1ac7d3043119ee6920ab0a148fccbc402) Fix LongCollectionSqlType.getValue() (@mmonemali)
- [7bf92be](https://github.com/thelastpickle/cassandra-reaper/commit/7bf92be033a01dedebb175f4059531d5e45958a5) ninja-fix to RepairUnitServiceTest (@michaelsembwever)
- [b075113](https://github.com/thelastpickle/cassandra-reaper/commit/b0751133728ab39d1b03a3abe02f6aa0d3ab486a) ColumnFamilyStoreMBean.getCompactionParameters() is only available since Cassandra 2.1 (@rborer)
- [f39b55a](https://github.com/thelastpickle/cassandra-reaper/commit/f39b55a72593aa5c83f5e4a8c51d07876e7fa612) fix version. only the tag, and one sha, should ever share a version number. (@michaelsembwever)

### 1.4.1 (2019/02/15 13:49 +00:00)
- [7f46e20](https://github.com/thelastpickle/cassandra-reaper/commit/7f46e2054005cf7da16bda214d404db179df42cc) Add newline at the end of shiro.ini to fix REAPER_AUTH_USER (@viossat)
- [b7d6593](https://github.com/thelastpickle/cassandra-reaper/commit/b7d65934862b6a17de9af3bccc1e34ab66780f3d) In NodesStatus when parsing gossipinfo status, also exclude those nodes that have been "removed", as well as those that are "left". (@michaelsembwever)
- [0a2c11f](https://github.com/thelastpickle/cassandra-reaper/commit/0a2c11fceff0ee515000d2e502220d276d6573e1) Fix for #613 when driver class is missing from config (@adejanovski)

### 1.4.0 (2019/02/11 11:10 +00:00)
- [3504dd5](https://github.com/thelastpickle/cassandra-reaper/commit/3504dd53d3fac4ccf2a4e8313d2bdda16ab27323) ninja-fix to f5431fb: docker variable shiro file is by default blank (for internal classpath shiro file provided) (@michaelsembwever)
- [f5431fb](https://github.com/thelastpickle/cassandra-reaper/commit/f5431fb45bace8e065033754ce9de86f44091434) Update Docker variables to work with the latest (and embedded) shiro configuration. (@michaelsembwever)
- [4749ca1](https://github.com/thelastpickle/cassandra-reaper/commit/4749ca1c628904f9725ac88a7a9e00c93d123cad) Add docker variable `REAPER_BLACKLIST_TWCS` to define blacklistTwcsTables in yaml (@michaelsembwever)
- [4bd5c54](https://github.com/thelastpickle/cassandra-reaper/commit/4bd5c542e9c3bc23dfed5d1c49d252d3a50f74c6) Improve error logging in ShiroJwtVerifyingFilter.java (include remote addr, remove stacktrace) (@michaelsembwever)
- [25e5cde](https://github.com/thelastpickle/cassandra-reaper/commit/25e5cde76e58a73ed4c72570c52e8c96767160c9) Save the JWT locally to avoid passing it for each call (@adejanovski)
- [b1099d9](https://github.com/thelastpickle/cassandra-reaper/commit/b1099d924776a638b13fbf07eaa6d1a86403a0fa) Enforce use of JWT instead of sending credentials for each call (@adejanovski)
- [519093b](https://github.com/thelastpickle/cassandra-reaper/commit/519093b875611570554980ca95ab7ec9f5bed732) Add support for authentication in spreaper (@adejanovski)
- [842eb02](https://github.com/thelastpickle/cassandra-reaper/commit/842eb0286536407e97d03e70c795ea9caec7fc24) Add unit tests for verifying JWTs. (@michaelsembwever)
- [689e474](https://github.com/thelastpickle/cassandra-reaper/commit/689e4745026ec48d747c1784462e82e7c4baa7af) Add valid checks for the JWT validity (@adejanovski)
- [f8bb73b](https://github.com/thelastpickle/cassandra-reaper/commit/f8bb73b0092743fe53dc3d09fed98d2d2f70aee4) Tests, documentation, and a configuration template, for Shiro->LDAP support (@michaelsembwever)
- [3fcb7b6](https://github.com/thelastpickle/cassandra-reaper/commit/3fcb7b699922a5bceef6d67f84ce108753eb242c) japanese samurai fix: remove scenario in cucumber feature file. (@michaelsembwever)
- [88d4d5c](https://github.com/thelastpickle/cassandra-reaper/commit/88d4d5c168ed6be23777c51046f96679293b927e) ninja-fix: fix TWCS Blacklisting integration tests (@michaelsembwever)
- [f9dca5f](https://github.com/thelastpickle/cassandra-reaper/commit/f9dca5f34bcdbc984265787f681c7762639aef91) Update cluster list to include model with JMX credential information from server (@ossarga)
- [0bf93c6](https://github.com/thelastpickle/cassandra-reaper/commit/0bf93c683f021810f4fb7d606decefb4ba7e5cff) Add flag to cluster information to say if JMX password is set (@ossarga)
- [8a0857c](https://github.com/thelastpickle/cassandra-reaper/commit/8a0857c9c990659c4675f4140425fb5d3157976b) Add JMX username to cluster information (@ossarga)
- [00ca613](https://github.com/thelastpickle/cassandra-reaper/commit/00ca613f370f850715f4768d3ae555e071252af0) Update Docker Maving plugin version (@ossarga)
- [c8a88f6](https://github.com/thelastpickle/cassandra-reaper/commit/c8a88f6e7c4c1d59eac88d1851a7b6943820af2a) ninja-fix: default shiro.ini is now inside the shaded jar (@michaelsembwever)
- [59e58c7](https://github.com/thelastpickle/cassandra-reaper/commit/59e58c73b875814b8cc2c27df5ee737089288d1d) Full Shiro protection. (@michaelsembwever)
- [dfa792f](https://github.com/thelastpickle/cassandra-reaper/commit/dfa792f5a9f65d0a21173701d0c87579f1a1a42f) Allow for automatically blacklisting any TWCS or DTCS tables within a keyspace (@denniskline)
- [8d6fa96](https://github.com/thelastpickle/cassandra-reaper/commit/8d6fa96e4473e5b52cfe0614240b77ffc0bb4cd7) Use a concurrency lock around the  `repairRunners` map to ensure synchronized access and modifications. (@michaelsembwever)
- [f3a7c94](https://github.com/thelastpickle/cassandra-reaper/commit/f3a7c9472c86dc4ea36203374a4ad6b16fa20280) Upgrade to Dropwizard 1.1.8 (Jetty upgrade) (@adejanovski)
- [d29fe5f](https://github.com/thelastpickle/cassandra-reaper/commit/d29fe5fbdfe3c77b026ee079e6080685c7344541) Fix for duplicate repair runs being started for a given schedule and unit by different SchedulingManager instances in different JVMs. (@michaelsembwever)
- [40f0638](https://github.com/thelastpickle/cassandra-reaper/commit/40f063823e5b31e7d6b9f00e0b40798787bf24ba) Mmake SchedulingManager a singleton that can be closed/cancelled, rather than static. (@michaelsembwever)
- [cbfc8f1](https://github.com/thelastpickle/cassandra-reaper/commit/cbfc8f19939f3c4857235cf419d33afe061f65a0) Introduce system variable to adjust the scheduling manager's check frequency. (@michaelsembwever)
- [7cdb6c6](https://github.com/thelastpickle/cassandra-reaper/commit/7cdb6c6f68e09d2405d154b560335bed530997ac) Separate default test job from deploy test job, and move them into different stages (@michaelsembwever)
- [e3a96ba](https://github.com/thelastpickle/cassandra-reaper/commit/e3a96ba68a3ca6b8d71e29de4d724d37ce29235f) Add Support for Integration tests to run against any past released version of Reaper (@michaelsembwever)
- [7f3ff17](https://github.com/thelastpickle/cassandra-reaper/commit/7f3ff170e2e6e4e04b6453022c1c92dd5e7fdbbc) Allow to configure a custom JMX port per cluster (@adejanovski)
- [7e2441a](https://github.com/thelastpickle/cassandra-reaper/commit/7e2441a65522b2c3058eabc53bb87ae25e2214b5) Properly report the list and count of tokens for a node (@adejanovski)
- [a8ddc8e](https://github.com/thelastpickle/cassandra-reaper/commit/a8ddc8e8685d3f81ea5257ef03982f06458c4421) Remove nodes that left the cluster from the cluster view (@adejanovski)
- [c53ab83](https://github.com/thelastpickle/cassandra-reaper/commit/c53ab83d1f6121aa03341c02783a94f393583324) Add configuration support for enabling an addressTranslator in cassandra persistence options (@paddybyers)
- [49789e3](https://github.com/thelastpickle/cassandra-reaper/commit/49789e398a70ae6eed07c98aae4fa7f42bff2524) Rename Reaper metrics to make them compatible with Prometheus (@rzvoncek)
- [a15bdac](https://github.com/thelastpickle/cassandra-reaper/commit/a15bdacba7d61f13130f9b84ae553ebb640f9fd0) Workaround SUREFIRE-1588 bug that crashes the build with using jdk8_u181 (@michaelsembwever)
- [0a7217c](https://github.com/thelastpickle/cassandra-reaper/commit/0a7217c5dd4ff1e5ead484dd2b22073914b95185) StreamManagerMBean is only available from Cassandra 2.0 onwards (@rborer)

### 1.3.0 (2018/10/03 14:09 +00:00)
- [58b295c](https://github.com/thelastpickle/cassandra-reaper/commit/58b295c24584842e634474d4c8f955e8e57f8f7f) Ninja fix tarball push to bintray (@adejanovski)
- [9197ec0](https://github.com/thelastpickle/cassandra-reaper/commit/9197ec088ff8d44acf538dc40cf03a3310e8e302) Refactor *Manager classes to *Service, to be consistent with rest of package. (@michaelsembwever)
- [4cceff1](https://github.com/thelastpickle/cassandra-reaper/commit/4cceff16fe7bc9c1f35e31f6f78bdc8e0b226b93) Remove the release profile and fix the version number evaluation with mvn (@adejanovski)
- [6bce8c6](https://github.com/thelastpickle/cassandra-reaper/commit/6bce8c63e3fa6bcbee589282103cd45451158448) Remove unused (and test) methods from StreamSessionFactory (@michaelsembwever)
- [52af1fe](https://github.com/thelastpickle/cassandra-reaper/commit/52af1fe2d1f3fdab4835166ea3fc7a4d7a3a6159) Ninja fix bintray upload issues (@adejanovski)
- [4441f2b](https://github.com/thelastpickle/cassandra-reaper/commit/4441f2b02922b2ffeb1a99745ece16aad5152c42) Remove mention of `copyright grant` or any implied notion of a CLA (@michaelsembwever)
- [e68f795](https://github.com/thelastpickle/cassandra-reaper/commit/e68f7954431e1fd57e8ad4a4aec4b2ef40a0a372) ninja-fix: uncomment and rename to maven-reaper-beta (@michaelsembwever)
- [ae27e45](https://github.com/thelastpickle/cassandra-reaper/commit/ae27e45fce0c002871aa14473208a677908acc99) ninja-fix: comment out reaper-maven-snapshots bintray uploads until the bintray problems are sorted out (@michaelsembwever)
- [d47930a](https://github.com/thelastpickle/cassandra-reaper/commit/d47930a9fe99e19adbe84b78cea7465822d8d471) Always carry the operator when wrapping lines. (@michaelsembwever)
- [22f6fca](https://github.com/thelastpickle/cassandra-reaper/commit/22f6fca6ec0c7be96f0c2f8ee47acdbfd4daa574) Refactor MetricsGrapper to MetricsService (to match existing terminology and verbs in the package) (@michaelsembwever)
- [68332c7](https://github.com/thelastpickle/cassandra-reaper/commit/68332c7b50291156ef3fe15b487d19fbb273058a) Refactor MetricsProxy out of JmxProxyImpl (@michaelsembwever)
- [895efba](https://github.com/thelastpickle/cassandra-reaper/commit/895efba1f4e8bc5a56a967edea9058ad38100aee) In Travis and CircleCI run maven in batch mode (@michaelsembwever)
- [33941f6](https://github.com/thelastpickle/cassandra-reaper/commit/33941f68e78897cf72562d20bbce71cf89eb71b4) Apply Apache licenses and appropriate copyright statements to all source files. (@michaelsembwever)
- [cdef39e](https://github.com/thelastpickle/cassandra-reaper/commit/cdef39e300c3ec8505d65ada765a5e4f93937da8) Downgrade the enforced Maven version to 3.3.8 to allow the Docker build to work again. (@adejanovski)
- [6ed2363](https://github.com/thelastpickle/cassandra-reaper/commit/6ed2363dc07606ec25699a1a30fd01ef1729aa7a) ninja-fix: on clean don't delete the `src/packages` directory, just its contents (@michaelsembwever)
- [633ae06](https://github.com/thelastpickle/cassandra-reaper/commit/633ae061271985e15b0e595320950518fb4d9812) clean UI and packaging components as well (@michaelsembwever)
- [a7a7913](https://github.com/thelastpickle/cassandra-reaper/commit/a7a7913d38d7dcbae7bcacf9589c43705f0012f3) ISSUE-475: Remove deprecated 'database' keyword (@ossarga)
- [79685e1](https://github.com/thelastpickle/cassandra-reaper/commit/79685e158f429b6cde63b8e715e239398ab18d05) ISSUE-481  Re-add 'useAddressTranslator' to docs (@ossarga)
- [4eda10a](https://github.com/thelastpickle/cassandra-reaper/commit/4eda10a1882d76322f242a68f7e5fca53652753f) Use new bintray package names (@michaelsembwever)
- [8dfc08c](https://github.com/thelastpickle/cassandra-reaper/commit/8dfc08c7043c6aed49489e1d6fe5c5acbd3b8bc0) Refactor EndpointSnitchInfoProxy from JmxProxy (@michaelsembwever)
- [4e0bf87](https://github.com/thelastpickle/cassandra-reaper/commit/4e0bf870df2626698b685de1a69ecac1e21eee79) Refactor FailureDetectorProxy out of JmxProxy (@michaelsembwever)
- [40b79c7](https://github.com/thelastpickle/cassandra-reaper/commit/40b79c7634f48e9cd7d48069680d8df9cf2e8301) Add password generation mechanism (@nsteinmetz)
- [ffcb691](https://github.com/thelastpickle/cassandra-reaper/commit/ffcb6919b574955eb8a9bba8e31b5601adc3ae81) Add auth with encrypted password sample (@nsteinmetz)
- [#533](https://github.com/thelastpickle/cassandra-reaper/pull/533) Update cassqndra-reaper.To be able to read config from /usr/local/etc (#533) (@KotaroYamazaki)
- [c975ab2](https://github.com/thelastpickle/cassandra-reaper/commit/c975ab2705f9190992b1b852f7de6359c02ab493) Move jmx ObjectNames in JmxProxyImpl into a static initialisation-on-demand-holder inner class. (@michaelsembwever)
- [b4defff](https://github.com/thelastpickle/cassandra-reaper/commit/b4defff4f83188d9e72c9c44f54d533004674b5c) Refactor StreamsProxy out of JmxProxyImpl (@michaelsembwever)
- [b6e84dd](https://github.com/thelastpickle/cassandra-reaper/commit/b6e84ddbf226ff8cd2afc7a5538ba9638ff923b1) Refactor SnapshotProxy out of JmxProxyImpl (@michaelsembwever)
- [c91a035](https://github.com/thelastpickle/cassandra-reaper/commit/c91a0351ea745d44b6f9e83d0820627470369470) Upgrade Travis and CircleCI to latest C* versions (@michaelsembwever)
- [#461](https://github.com/thelastpickle/cassandra-reaper/pull/461) Fixes #311.  Allow webui to be aware of a server defined applicationContextPath setting (#461) (@denniskline)
- [49f3722](https://github.com/thelastpickle/cassandra-reaper/commit/49f37223d4f1900ca81524aa82489462c997af61) Refactor usage of com.google.common.base.Optional to java.util.Optional (@michaelsembwever)
- [a22a319](https://github.com/thelastpickle/cassandra-reaper/commit/a22a319b5d1e2c73d6aa39eb198397f28252c565) Cast mbean attribute ValidationExecutor ActiveTasks and PendingTasks to Number object instead of Integer or Long. (@michaelsembwever)
- [8b28071](https://github.com/thelastpickle/cassandra-reaper/commit/8b28071488c91cd909d23ecee788b168829dc226) [node-stats] Add missing React keys to prevent exceptions (@rzvoncek)
- [00cc0cc](https://github.com/thelastpickle/cassandra-reaper/commit/00cc0ccb42926d6284e17d86ce34b578c0f49185) [streams] Add a 'no ongoing streams' mention when there are no streams (@rzvoncek)
- [35fec8c](https://github.com/thelastpickle/cassandra-reaper/commit/35fec8c9d95926d4766a724e1cdc682667481716) Add support for collecting metrics on a node (@adejanovski)
- [909895d](https://github.com/thelastpickle/cassandra-reaper/commit/909895d371f5116e8bd95b08a1bc7f363debae0c) Add support for listing running compactions (@adejanovski)
- [4892197](https://github.com/thelastpickle/cassandra-reaper/commit/4892197ea0e3b2d164b6d557d6e3308c0b49d5d9) [streams] Show tables using tags, so they are nicely separated (@rzvoncek)
- [87540ba](https://github.com/thelastpickle/cassandra-reaper/commit/87540bac3393bb1b9f2a5e7a79241c3e4b15157b) If a cluster is deleted too quickly after a schedule/repair has been created, rather than the ClusterResource catch it, it will get caught as an assertion failure in CassandraStorage. (@michaelsembwever)
- [467c793](https://github.com/thelastpickle/cassandra-reaper/commit/467c79347ba608930f73ab49954ff468a719f83e) Reaper #369 Frontend for showing node streams (@rzvoncek)
- [b11518a](https://github.com/thelastpickle/cassandra-reaper/commit/b11518a31766bd90b7a709db8e54086dbe75b506) Reaper #369 Pull-only backend for tracking streams (@rzvoncek)
- [737fa57](https://github.com/thelastpickle/cassandra-reaper/commit/737fa57ec0ec2ae78d528886db060f8c747ab1a2) ninja-fix to 2d89ea0: correct path to upload toplevel pom (@michaelsembwever)
- [bcf5a36](https://github.com/thelastpickle/cassandra-reaper/commit/bcf5a3615efc19ac65c1b36ca8544e7e04a3f9c2) merge in "update changelog in preparation for 1.2.2" (@michaelsembwever)
- [324f0c6](https://github.com/thelastpickle/cassandra-reaper/commit/324f0c640bef5655e9142502d01896f25dd1444b) Add informations to upgrade from 1.2.0/1.2.1 to 1.2.2 (@adejanovski)
- [f4f7a0c](https://github.com/thelastpickle/cassandra-reaper/commit/f4f7a0c7573bd0ca74183d55b04b73b61695202f) Rebuild modified doc pages (@adejanovski)
- [2d89ea0](https://github.com/thelastpickle/cassandra-reaper/commit/2d89ea02617be8108e556afa3edb5afd6b70bb6e) cassandra-reaper-pom files must also be uploaded (@michaelsembwever)
- [9360c61](https://github.com/thelastpickle/cassandra-reaper/commit/9360c6171b94f3e3fe088613a323181746064a93) Log when database migrations are going to happen, and ensure other reaper instances are stopped. (@michaelsembwever)
- [56ab26e](https://github.com/thelastpickle/cassandra-reaper/commit/56ab26ef80047f338e335626b021ee5e278cf8df) ninja-fix :: use correct commit for PR :: Use cucumber options from command line (@michaelsembwever)
- [e5b7250](https://github.com/thelastpickle/cassandra-reaper/commit/e5b72501fb7c222ad491a5d606faa639f9b7b173) Use cucumber options from command line (@michaelsembwever)
- [e10354f](https://github.com/thelastpickle/cassandra-reaper/commit/e10354fd3bc3c1567687655b30efa1224ae864ab) (ninja-fix) Fix enforcer plugin. Was failing when building from `src/server/` (@michaelsembwever)
- [d4406b5](https://github.com/thelastpickle/cassandra-reaper/commit/d4406b5cd59398b3a0269c880bdae604a62cb54b) Clean up on 'display node metrics' (@michaelsembwever)
- [124f9e2](https://github.com/thelastpickle/cassandra-reaper/commit/124f9e227424775e915fdb74be14654eeded8070) Migrate the forgotten unused AddClusterIT and basic_reaper_functionality.feature into BasicSteps and integration_reaper_functionality.feature (@michaelsembwever)
- [efc32b4](https://github.com/thelastpickle/cassandra-reaper/commit/efc32b4ddd9cfe9f4fbe0a45378072780508567d) whitespace format fix to package.json (@michaelsembwever)
- [d8d69de](https://github.com/thelastpickle/cassandra-reaper/commit/d8d69deaed994c1a9a03425ea87f3dde14a602a0) make max pending compactions configurable
- [72ce3a9](https://github.com/thelastpickle/cassandra-reaper/commit/72ce3a9a8748e82d7251faec17f5ca2cfe9c412f) Display metrics in the node's detail page (@adejanovski)
- [09c39f3](https://github.com/thelastpickle/cassandra-reaper/commit/09c39f3a7aa79885506674782cd1265c6d134ead) Remove the maven gpg plugin (@adejanovski)
- [438ed51](https://github.com/thelastpickle/cassandra-reaper/commit/438ed514685016072d4f42423c6fecfa7649978f) Add support for collecting metrics on a node (@adejanovski)
- [c16a728](https://github.com/thelastpickle/cassandra-reaper/commit/c16a728271ff1a8f8d1f2f53491b4709870d55ab) Add maven-enforcer-plugin to ensure known and correct java and maven versions are used to build. (@michaelsembwever)
- [6a757ff](https://github.com/thelastpickle/cassandra-reaper/commit/6a757ff0636e9c5c87a58c461572b34122ef9af1) Unit tests that the db migration scripts are ok. (@michaelsembwever)
- [f22fe3f](https://github.com/thelastpickle/cassandra-reaper/commit/f22fe3f91a4e389f6c8742722b214c68ef2d8b0b) [maven-release-plugin] prepare for next development iteration (@michaelsembwever)

### 1.2.2 (2018/07/25 10:50 +00:00)
- [ae42bab](https://github.com/thelastpickle/cassandra-reaper/commit/ae42babd76956a298ab86cf5ca67fc56aeaf58cb) Fix `IStorage.getRepairUnit(builder)` implementations to include matching on incremental boolean parameter, and deleting (all related) units only when deleting the cluster. (@michaelsembwever)
- [b4c3248](https://github.com/thelastpickle/cassandra-reaper/commit/b4c32482e600699c41e90ba8c9f517b81a870bf6) Use executorServices from DropWizard's lifecycle, where possible in various top-level singletons. (@michaelsembwever)
- [2726931](https://github.com/thelastpickle/cassandra-reaper/commit/27269317e8b6c958b3a606c4ad7859505bbb9656) Set isDev flag correctly for server.js (@spodkowinski)
- [9a48abf](https://github.com/thelastpickle/cassandra-reaper/commit/9a48abfc5919dd8a0f63dca7ad36847b725a623d) Ignore late "start" notifications in SegmentRunner (@michaelsembwever)
- [bfda40d](https://github.com/thelastpickle/cassandra-reaper/commit/bfda40d4d30dee0164cd8f0c8361f9f1880ade0f) fix typo in sample for cassandra backend
- [c0cf003](https://github.com/thelastpickle/cassandra-reaper/commit/c0cf00310ac5947a378381ae9babb2e4ec17624c) Add systemd service file, add post-install task for log directories creation
- [9b2c66d](https://github.com/thelastpickle/cassandra-reaper/commit/9b2c66d88921397b07d3dc4dad7a650faed7c20a) Listing snapshots can fail easily (if snapshot files/directories are deleted by someone else). (@michaelsembwever)
- [d32b54e](https://github.com/thelastpickle/cassandra-reaper/commit/d32b54e076fd4c797e9abb9fe74ed4ddedefcd95) In RepairManager synchronise the private method startRepair to multiple repair runners on the same runId (@michaelsembwever)
- [998250c](https://github.com/thelastpickle/cassandra-reaper/commit/998250cb3a85caa7d146cc4a193e1cde18345dce) Replace RepairRun, RepairUnit and RepairSchedule's inner Builder classes' verbose public constructor with a static `builder()` methods and builder methods. (@michaelsembwever)

### 1.2.1 (2018/07/12 16:55 +00:00)
- [9b128fc](https://github.com/thelastpickle/cassandra-reaper/commit/9b128fccc67864e0170934585e95403bec863731) Fix incremental repair sending several SUCCESS notifications in 2.1 (@adejanovski)
- [9c26058](https://github.com/thelastpickle/cassandra-reaper/commit/9c260588d2c9cb193e5e42b63580fc2359fa38e1) Fix for the schema disagreement issue created by Migration014 (@adejanovski)
- [c42a808](https://github.com/thelastpickle/cassandra-reaper/commit/c42a808c3e3534eae0b9c5e5df63e9bd903a6fb5) Fix cluster screen display with Postgres and H2 (@adejanovski)
- [16c4d49](https://github.com/thelastpickle/cassandra-reaper/commit/16c4d495adcebe255be4061e94cb35191db7ca51) Ensure notifications for a given repairNo are processed in order. (@michaelsembwever)
- [f35648e](https://github.com/thelastpickle/cassandra-reaper/commit/f35648e9902fe94d3565afffcbedb5d5d7bf0a4d) In JmxProxyImpl refactor commandId to repairNo, for consistent terminology. (@michaelsembwever)
- [36fe520](https://github.com/thelastpickle/cassandra-reaper/commit/36fe5203f4c33531bafef1552a4047412f2fa785) fix login (@nsteinmetz)

### 1.2.0 (2018/07/06 15:07 +00:00)
- [6a44f3c](https://github.com/thelastpickle/cassandra-reaper/commit/6a44f3cd2069cdf00788a07a862d6c46133e68cf) Add automated purge functions (@adejanovski)
- [c29acc7](https://github.com/thelastpickle/cassandra-reaper/commit/c29acc74c9edcc9e8383948019a85e1b78779dcf) Handle out of order repair notifications (@adejanovski)
- [707305d](https://github.com/thelastpickle/cassandra-reaper/commit/707305d80b89ddb5dcf9972344876256765dd077) Fix base url issues with the UI (@adejanovski)
- [ef61566](https://github.com/thelastpickle/cassandra-reaper/commit/ef61566a2b4c933462471a6542107659007348d6) Clean code: remove unused JmxProxyImpl.cmProxy (@michaelsembwever)
- [60095ff](https://github.com/thelastpickle/cassandra-reaper/commit/60095ff8dba4187b279d20df995708ef3f6800ab) Clean code: remove RepairStatusHandler parameter  from JmxConnectionFactory's connect methods. It was but test pollution. (@michaelsembwever)
- [ca18d00](https://github.com/thelastpickle/cassandra-reaper/commit/ca18d003c9879a0dac7460a90c29736769065a66) Fix the broken "add node" button in the UI (@adejanovski)
- [53d9246](https://github.com/thelastpickle/cassandra-reaper/commit/53d9246c1a37df50f0e1660989a7d737be3884a6) Improve start time selection for schedules (@adejanovski)
- [b81fb13](https://github.com/thelastpickle/cassandra-reaper/commit/b81fb1393433d62c7d2a50abf6032da83c440fbe) Ninja fix refresh issue on the new time picker for schedules (@adejanovski)
- [#452](https://github.com/thelastpickle/cassandra-reaper/pull/452) UI improvements (#452) (@pndewit)
- [c4feb99](https://github.com/thelastpickle/cassandra-reaper/commit/c4feb99a34c1621282717494d18aac868aa92194) Use a new datetime picker for the schedule page (@adejanovski)
- [32c779f](https://github.com/thelastpickle/cassandra-reaper/commit/32c779ff2e7a923ed3570c1b206eb0e81ff38c96) Support Cassandra-4.0 for backend storage (@michaelsembwever)
- [3d62a2c](https://github.com/thelastpickle/cassandra-reaper/commit/3d62a2c89e122255e4c9d5975fe210d959348159) Implement limit in `CassandraStorage.getRepairRunsForCluster(cluster, limit)` (@michaelsembwever)
- [633c1d4](https://github.com/thelastpickle/cassandra-reaper/commit/633c1d4e7c1dc233c0024b907308c06a30aa80f7) As RepairUnits are immutable, and limited in number, introduce in CasandraStorage a LoadingCache. (@michaelsembwever)
- [1253f03](https://github.com/thelastpickle/cassandra-reaper/commit/1253f0319f2b9980951f4b1ee09338ad8df46e46) Refactor the `IStorage.getRepairUnit(UUID)` method to return the RepairUnit instead of an Optional. (@michaelsembwever)
- [a4626dd](https://github.com/thelastpickle/cassandra-reaper/commit/a4626ddfd6a84d1dc47140ef47109c36a5e1b79b) Cleanup the RepairManager.abortSegmentsWithNoLeader() method. (@michaelsembwever)
- [b27a55f](https://github.com/thelastpickle/cassandra-reaper/commit/b27a55f602a1f45130224507354cc129b750a190) break down the RepairManager.resumeRunningRepairRuns() method for better readability (@michaelsembwever)
- [17bbf11](https://github.com/thelastpickle/cassandra-reaper/commit/17bbf11b2d18d490242f44d5db4c1f08b81da6e1) Upgrade dependencies. (@michaelsembwever)
- [ce5196a](https://github.com/thelastpickle/cassandra-reaper/commit/ce5196af324ce40ed24d36080113581c2b9d25a4) Ninja fix for job threads set to 0 (@adejanovski)
- [21edbeb](https://github.com/thelastpickle/cassandra-reaper/commit/21edbeb102dc9384c58f6840a6c75fae77acfb6f) Fix incremental repair segments from being identified as stuck (@adejanovski)
- [72fc8c3](https://github.com/thelastpickle/cassandra-reaper/commit/72fc8c3b625507f8449ae6a3839f3b734d16fd96) ninja fix travis deployments (@adejanovski)
- [e0e2cf1](https://github.com/thelastpickle/cassandra-reaper/commit/e0e2cf17b628c2e9d422afb7ba0e5a8e82a8d7cc) Add support for repair threads to spreaper (@adejanovski)
- [12d8ef5](https://github.com/thelastpickle/cassandra-reaper/commit/12d8ef5c9d4e2cef4981ad1b2e1eda2169ed3d36) Documentation updates for the repair threads setting (@adejanovski)
- [ce04d57](https://github.com/thelastpickle/cassandra-reaper/commit/ce04d571823be1485c2c92bc26bac18abac20583) UI changes for repair thread count support (@adejanovski)
- [c5d3b1b](https://github.com/thelastpickle/cassandra-reaper/commit/c5d3b1b68540f33e471888ae7b1de8694ea727cd) Avoid the NPE in Heart.beat when shutting down (@michaelsembwever)
- [5360688](https://github.com/thelastpickle/cassandra-reaper/commit/53606883d122dbea0c2fe04ef88d76fd8476738d) Fix spelling of "parallelism" (@a1exsh)
- [8882458](https://github.com/thelastpickle/cassandra-reaper/commit/8882458a108729ce55d7a4bba8a8f0c30ec77b9a) Fix spreaper add schedule function (@adejanovski)
- [4903226](https://github.com/thelastpickle/cassandra-reaper/commit/4903226672f7696044e5bc57fdbc04d7dc58775b) CircleCI – paramterise the build, using yaml references (@michaelsembwever)
- [a9b6386](https://github.com/thelastpickle/cassandra-reaper/commit/a9b638612d483bcaf8a5d07c280a9a1fe2340a73) Make Travis also test against Cassandra-4.0 backend (@michaelsembwever)
- [bc86d40](https://github.com/thelastpickle/cassandra-reaper/commit/bc86d40e9f68fcb20ca2f409736522983b6421b9) Update REST API and Docker vars docs (@adejanovski)
- [32867cb](https://github.com/thelastpickle/cassandra-reaper/commit/32867cb73bfa9c117316478bff6154130c8154a9) Update Bootstrap and Fontawesome to use latest CDN  over HTTPS. (@terrcin)
- [4d7cc72](https://github.com/thelastpickle/cassandra-reaper/commit/4d7cc72f4c0bcfc3bda5def4b7b86da7e36fcd9b) For the Cassandra storage optimise the select statements around fetching segments from the repair_run table. (@michaelsembwever)
- [d18183a](https://github.com/thelastpickle/cassandra-reaper/commit/d18183a1c695f3b3302f73f32e987abfb566fb04) small fix to link to travis branches page (otherwise it lands on latest build of any branch) (@michaelsembwever)
- [69238f9](https://github.com/thelastpickle/cassandra-reaper/commit/69238f941f72ea5b6c39dd869b9d1f621c271c1e) Publish new website with "Always build the npm and bower UI components" changes. (@michaelsembwever)
- [3f655c4](https://github.com/thelastpickle/cassandra-reaper/commit/3f655c406461c8fe33e125a02fbc5acccd53b98f) Remove unused `src/docs/public` directory (@michaelsembwever)
- [d943370](https://github.com/thelastpickle/cassandra-reaper/commit/d943370fad3a93c856e7e3251599aec117a6addf) Always build the npm and bower UI components. (@michaelsembwever)
- [2f48c54](https://github.com/thelastpickle/cassandra-reaper/commit/2f48c54f637df15fff7a9ff5cbfc19840a266abe) clean code on SnapshotResource and SnapshotManager (@michaelsembwever)
- [0159fc5](https://github.com/thelastpickle/cassandra-reaper/commit/0159fc5bd12ca5df02ec6c495aa561e3e521baca) Improve REST API to RepairRunResource and SnapshotResource (@michaelsembwever)
- [29cfa53](https://github.com/thelastpickle/cassandra-reaper/commit/29cfa535981808296517193a004beb731e912506) Avoid blocking the jmx broadcasting thread, offload work to a separate thread immediately. (@michaelsembwever)
- [1e08061](https://github.com/thelastpickle/cassandra-reaper/commit/1e080614280dac893a333e24f9e7c18c10b0a901) Remove segmentCount from the default configurations and update the doc with segmentCountPerNode. (@adejanovski)
- [c44b196](https://github.com/thelastpickle/cassandra-reaper/commit/c44b196f594293319dcf32cc575ab4027428251a) Updates to documentation as per code review (@ossarga)
- [9fda426](https://github.com/thelastpickle/cassandra-reaper/commit/9fda426f87264c39613b461fdc69f682327c4e46) Implement segment coalescing to reduce the overhead of vnodes (@adejanovski)
- [9bdb4b4](https://github.com/thelastpickle/cassandra-reaper/commit/9bdb4b47b4d6f5856614a6735849d4ebe2c8bf35) Remove pre-conditions that break node metrics requests (@adejanovski)
- [4602d65](https://github.com/thelastpickle/cassandra-reaper/commit/4602d6507b23fc8a18c0b5e2b0234419a413b353) Improve REST API to RepairScheduleResource mutations: (@michaelsembwever)
- [791d214](https://github.com/thelastpickle/cassandra-reaper/commit/791d2147989d951b37a9265c6c7a8512244b6489) clean code (@michaelsembwever)
- [28e5898](https://github.com/thelastpickle/cassandra-reaper/commit/28e58984a44d8bb79f6a62072621aeeda8f9a500) Improve REST API to ClusterResource mutations: (@michaelsembwever)
- [b854892](https://github.com/thelastpickle/cassandra-reaper/commit/b85489208956e4e8cff7782862b79cec8c3a4f16) Removed file logger settings from docker image (@ossarga)
- [3c0a1fa](https://github.com/thelastpickle/cassandra-reaper/commit/3c0a1fae7bf21f40be319464bcd16ebf50397417) Fix duration issues in the UI (@adejanovski)
- [6a59fed](https://github.com/thelastpickle/cassandra-reaper/commit/6a59feda5c2fd4ea6f05a41a8437c3749e29fd21) Try to show IPv6 endpoints in UI correctly (@dormidon)
- [bc8ffad](https://github.com/thelastpickle/cassandra-reaper/commit/bc8ffadec6e7ed9421eb1331dbdcbc9669da3f53) Support IPv6 Cassandra nodes (@dormidon)
- [c75825c](https://github.com/thelastpickle/cassandra-reaper/commit/c75825cf9f787ebafc69a762d423e036d44c68cc) ninja fix docker build path issue (@adejanovski)
- [e0d6c27](https://github.com/thelastpickle/cassandra-reaper/commit/e0d6c277356e15f95dde67a00eefc326e89b1db7) Deploy Docker images from Travis (@adejanovski)
- [647f560](https://github.com/thelastpickle/cassandra-reaper/commit/647f5603f0f0f23491be00a034dc33ab1c36bd07) Gracefully degrade on 2.0 and prior for snapshot listing. (@adejanovski)
- [65984ae](https://github.com/thelastpickle/cassandra-reaper/commit/65984ae6ca091507947a8f6bec27b8bda2429ba2) Update the list of nodes for a cluster at the start of each repair run. (@adejanovski)
- [051be2a](https://github.com/thelastpickle/cassandra-reaper/commit/051be2a560c799e04cf0247238d47afa52076e13) Fix CircleCI tests since we have 2 DCs there. (@adejanovski)
- [d7689fa](https://github.com/thelastpickle/cassandra-reaper/commit/d7689fa7860f65064a13283a14a948991e6cb1b6) Dawde duckling to: Sanitise cluster and host names going into metric names. (@michaelsembwever)
- [8bb930d](https://github.com/thelastpickle/cassandra-reaper/commit/8bb930d868f8e1295ad29bbca67929ccc5095cfb) Sanitise cluster and host names going into metric names. (@michaelsembwever)
- [170c9ae](https://github.com/thelastpickle/cassandra-reaper/commit/170c9ae437f243f33075b39cdf5f60faf3a89cac) Fail fast when Cassandra storage is an older version not supported (@michaelsembwever)
- [3da6336](https://github.com/thelastpickle/cassandra-reaper/commit/3da6336d2f76d0f0342632c1fc07d6dd88d7d0d8) Fix CircleCI tests with jmx auth and jdk incompatibility with C* 3.11.0 (@adejanovski)
- [198b33e](https://github.com/thelastpickle/cassandra-reaper/commit/198b33eab7a8e615ac029eeb9ef58fdf1098e98d) made getNodeMetrics to get remote metrics via storage when DatacenterAvailability is not ALL
- [b98c6c3](https://github.com/thelastpickle/cassandra-reaper/commit/b98c6c31f9c828278f38a077161e235079c6861e) Updated docker image to include new logging settings. (@ossarga)
- [56f3f19](https://github.com/thelastpickle/cassandra-reaper/commit/56f3f192da302f7195b67cc4f4268d5f502eb361) Instead of logging to the console, log to files that are rolled over daily. (@michaelsembwever)
- [469475a](https://github.com/thelastpickle/cassandra-reaper/commit/469475a697b36e106225093ea465020bbacc8d45) Add web ui auth capability to the Docker image (@adejanovski)
- [98e7f56](https://github.com/thelastpickle/cassandra-reaper/commit/98e7f569ee53abe6f3cb7f98a74a0cd37518c610) Documentation updates (@ossarga)
- [eb84ef3](https://github.com/thelastpickle/cassandra-reaper/commit/eb84ef301a67ac43bcab26fd1ef9295aacf47849) Ninja fix: Fixed navbar headings (@ossarga)
- [1204fba](https://github.com/thelastpickle/cassandra-reaper/commit/1204fbacd9799fb270576b946b682986911ba83d) ninja fix: Makefiles' addiction to tabs over spaces. (@michaelsembwever)
- [750a850](https://github.com/thelastpickle/cassandra-reaper/commit/750a850d493ac3d9d42842f85ad12bf505c95eee) Bash completion for spreaper (@michaelsembwever)
- [8c9de3c](https://github.com/thelastpickle/cassandra-reaper/commit/8c9de3c83acbc6666e5cb12fccd2deee5b3b3d92) Fix travis deploy tool downgrade (@adejanovski)
- [a21edd0](https://github.com/thelastpickle/cassandra-reaper/commit/a21edd0060b3a27f7e18ffd294cff5d979ccd0fb) Downgrade Travis deploy tool to earlier version to fix bintray auth issues (@adejanovski)
- [2a89b16](https://github.com/thelastpickle/cassandra-reaper/commit/2a89b165dfd9b86b0324e88ea77afefb5ba86bb9) Implement authentication for the web UI (@adejanovski)
- [ae9f491](https://github.com/thelastpickle/cassandra-reaper/commit/ae9f491c7cfd0b686b97d95eac6f037facbd792f) Add support for snapshots (@adejanovski)
- [5cefe53](https://github.com/thelastpickle/cassandra-reaper/commit/5cefe53c187245b60c2e94a7034316722aaa9752) Add support for handling clusters with different JMX credentials (@adejanovski)
- [4b639bf](https://github.com/thelastpickle/cassandra-reaper/commit/4b639bf071150cd4120e203d742fba7e77dbb5f9) Add command line (spreaper) functionality to modify a repair run's intensity. (@michaelsembwever)
- [4a53719](https://github.com/thelastpickle/cassandra-reaper/commit/4a53719dbd2517d3512941950edf785429dafbb7) Make it possible to list repair runs that belong to a specific cluster, or specific cluster and keyspace. (@michaelsembwever)
- [0148b14](https://github.com/thelastpickle/cassandra-reaper/commit/0148b14f117f645a51bae2ae561a4cb5704431ac) Fix `spreaper resume-run`, `spreaper pause-run`, `spreaper abort-run`. (@michaelsembwever)
- [f320071](https://github.com/thelastpickle/cassandra-reaper/commit/f3200713a5d3f8418f4480a6b01f1d5764f24f8a) Implement unix mode, via use of quiet flag. (@michaelsembwever)

### 1.1.0 (2018/02/28 19:30 +00:00)
- [e5519a7](https://github.com/thelastpickle/cassandra-reaper/commit/e5519a7c1daf59264082cf649205dde43d54c841) updating metrics for repairProgress,segmentsDone,segmentsTotal and added keyspace to metric (@kingm5)
- [3cf121d](https://github.com/thelastpickle/cassandra-reaper/commit/3cf121ddd4c64bc211925cd3cb5290c6f2e32918) Prevent stuck segment runner issues on uncatched exceptions (@adejanovski)
- [f7a148d](https://github.com/thelastpickle/cassandra-reaper/commit/f7a148dca742291f8baa08c1ee41d4d35bf2a145) Remove unnecessary postpones when a segment isn't allowed to start (@adejanovski)
- [bd17578](https://github.com/thelastpickle/cassandra-reaper/commit/bd175784a20e72ee523d292899ff1ffa2ca1badd) Ninja fix for error trace overload (@adejanovski)
- [07a897c](https://github.com/thelastpickle/cassandra-reaper/commit/07a897c2d49927cf3ca040dae2fb2bb9b590d90b) Ninja fix for segment abort (due to a bad rebase) (@adejanovski)
- [6f3f3fa](https://github.com/thelastpickle/cassandra-reaper/commit/6f3f3fa4d6294fb60b9ee20aeebcf45c239fb6c0) Initialize JMX connections on startup only when necessary. (@adejanovski)
- [00c2cc7](https://github.com/thelastpickle/cassandra-reaper/commit/00c2cc755bc7b558997ef72b9b54eeec16bff31c) Fix issue with poorly registered metrics upon node restarts (@adejanovski)
- [b9d8681](https://github.com/thelastpickle/cassandra-reaper/commit/b9d8681b938ff1fe499886d4055428f2ed2dab71) Switch to re-usable JMX connections instead of re-creating one each time it's needed. (@adejanovski)
- [0465aa1](https://github.com/thelastpickle/cassandra-reaper/commit/0465aa1213e419579a548e49aef83baead592144) Update documentation to install the GPG keys for apt-get (@adejanovski)
- [ca2341a](https://github.com/thelastpickle/cassandra-reaper/commit/ca2341ad5270b933130fed27c6f42a3686886fad) UI update for ordering fixes (@adejanovski)
- [ea1a0a0](https://github.com/thelastpickle/cassandra-reaper/commit/ea1a0a037a1a83ee8c3cca4b4daabae22c213337) Fix orderings of cluster names, repair runs and schedules (@adejanovski)
- [961fd69](https://github.com/thelastpickle/cassandra-reaper/commit/961fd6996c767805729b439995dd96116ebd2abb) Update docs for apt-get installation (@adejanovski)
- [283f7e2](https://github.com/thelastpickle/cassandra-reaper/commit/283f7e27fc5d9e1a95c849f9a65c4b80e2b53074) Add Maven uploads to Bintray (@adejanovski)
- [39e8cab](https://github.com/thelastpickle/cassandra-reaper/commit/39e8cabf263f6df527ebe17eefd6428d2060b3df) turn on gpg signing of uploaded packages (@adejanovski)
- [6e2afd3](https://github.com/thelastpickle/cassandra-reaper/commit/6e2afd3a1352eb924574969c2b681cb4a2fe6793) Ninja fix for hardcoded urls (@adejanovski)
- [a07d2e6](https://github.com/thelastpickle/cassandra-reaper/commit/a07d2e6cb41acc1d9bedd2e83a00bb131a576dc3) UI update for segment display/abort (@adejanovski)
- [263f4ec](https://github.com/thelastpickle/cassandra-reaper/commit/263f4ec3f062b5c9ee95e8a618123e69d2f5adb3) Add ability to list and abort segments (@adejanovski)
- [42784f8](https://github.com/thelastpickle/cassandra-reaper/commit/42784f87a95af183ddae5462023157f8ceed7546) Update doc install and download sections to point to Binary (@adejanovski)
- [d30d79f](https://github.com/thelastpickle/cassandra-reaper/commit/d30d79f275b4bd20311d43cf51721a9421ae8808) fix build by using fpm directly instead of docker-compose (@adejanovski)
- [0ba0272](https://github.com/thelastpickle/cassandra-reaper/commit/0ba027216055ecbd519216e73846db78c26f09d5) Add traces to analyze issues with docker build on master (@adejanovski)
- [689f3c7](https://github.com/thelastpickle/cassandra-reaper/commit/689f3c71f68b537adba164b85e80a17ae6cfb922) Fix Travis build being killed (@adejanovski)
- [35694c3](https://github.com/thelastpickle/cassandra-reaper/commit/35694c3dae4211a116a757d9d216098beea93923) Handle cases where a segment reaches timeout without being in either RUNNING or DONE state. (@adejanovski)
- [0091a4b](https://github.com/thelastpickle/cassandra-reaper/commit/0091a4bbfcad0bd8189b3d6f0853e0f707f7fc99) Push all packages to Bintray on the master branch (beta) and tags (releases). (@adejanovski)
- [65fd58f](https://github.com/thelastpickle/cassandra-reaper/commit/65fd58f34fdeed081c11225f3800d38cb73eea6e) Prevent crashing the scheduler for RepairManager.resumePendingRepairRuns() in case of unexpected exception. (@adejanovski)
- [07eadc3](https://github.com/thelastpickle/cassandra-reaper/commit/07eadc38131925058f454ec778a346ea2772c547) added 1st set of metrics suggested (@debswade)
- [21ba0fb](https://github.com/thelastpickle/cassandra-reaper/commit/21ba0fbc0199d6f8a5d05768a62f66d9cc339453) | Another fix for `IllegalStateException: startTime must be set if segment is RUNNING or DONE` (@michaelsembwever)
- [67d6721](https://github.com/thelastpickle/cassandra-reaper/commit/67d67210b23e36c95733cceafbe55c8fe1d62a3c) Another fix for `IllegalStateException: startTime must be set if segment is RUNNING or DONE` (@michaelsembwever)
- [ff0214f](https://github.com/thelastpickle/cassandra-reaper/commit/ff0214f9a7d87a720acef0be7d1dcd9bcbf263ac) Ninja fix for issue #288 (@adejanovski)
- [13524bc](https://github.com/thelastpickle/cassandra-reaper/commit/13524bc319912dcf7f132df8a560877745bf73ca) Fix computing too many segments on high clusters with high number of vnodes. (@adejanovski)
- [5a4bfe9](https://github.com/thelastpickle/cassandra-reaper/commit/5a4bfe9c44f613910ea2bf3e423b77cb30d4d591) NodeStatus: Handle hostnames in endpointsStatus output (@tedoc2000)
- [5b563db](https://github.com/thelastpickle/cassandra-reaper/commit/5b563db59b490545981fc8426a60315ade676df1) Supported change intensity in web app (@kipwoker)
- [6f71b67](https://github.com/thelastpickle/cassandra-reaper/commit/6f71b67a614d18b27627f5191d25f57f026f01f1) Implemented PUT method for change intensity (@kipwoker)
- [d3fb850](https://github.com/thelastpickle/cassandra-reaper/commit/d3fb8504e82645dfa74345cc295db3efe5de0631) Revert master back to 51b971f35fb02111f6e807ccbdf048a475611014 (@michaelsembwever)
- [4e84fc8](https://github.com/thelastpickle/cassandra-reaper/commit/4e84fc8afbc028efdf9aaf2e4ccf09980f0b8fd9) allow the docker job to fail, temporary fix (@michaelsembwever)
- [6d06781](https://github.com/thelastpickle/cassandra-reaper/commit/6d06781b62d9d0faa2538718fc6e14a6a57683b1) Only disable RepairSegment precondition checks when JVM is running with system property "-Dreaper.disableSegmentChecks=true" (@michaelsembwever)
- [1cb89b0](https://github.com/thelastpickle/cassandra-reaper/commit/1cb89b0ceb85362b36b63eba67caa0112a2c426d) Version update in the UI (@adejanovski)

### 1.0.2 (2017/12/07 18:06 +00:00)
- [5c9ca98](https://github.com/thelastpickle/cassandra-reaper/commit/5c9ca985de9f5df59661d4cb476558f1acdb67b5) Ugly shameful fix for the endTime/startTime infamous bug (@adejanovski)

### 1.0.1 (2017/11/26 11:15 +00:00)
- [e3b2cd7](https://github.com/thelastpickle/cassandra-reaper/commit/e3b2cd74108c3a9093606ab1019a4475c352fc95) Fix for Elassandra's gossip info output parsing (@adejanovski)
- [5a14d92](https://github.com/thelastpickle/cassandra-reaper/commit/5a14d92c3ae840383505f91f5187dcdb71c65e3f) Duplicate the Migration009 script so it can run again to fix missing RepairSegment startTimes (@michaelsembwever)
- [b56ce12](https://github.com/thelastpickle/cassandra-reaper/commit/b56ce1274479a7ee91ab403a9497ead945a895f0) breakup the `SegmentRunner.runRepair(..)` method, the bulk of the body going into `SegmentRunner.processTriggeredSegment(..)` (@michaelsembwever)
- [f9ea67e](https://github.com/thelastpickle/cassandra-reaper/commit/f9ea67e27f683fe919b4f7f863a2da09176ebf7f) if endTime is set, so must startTime be set #281 (@michaelsembwever)
- [2d386b7](https://github.com/thelastpickle/cassandra-reaper/commit/2d386b7eb3e3c3a65ef4bca762caee25e5a2e5ca) Revert "Remove precondition checks that break Reaper when endTime/startTime are inconsistently set" (@michaelsembwever)
- [ed418ce](https://github.com/thelastpickle/cassandra-reaper/commit/ed418ce2c80aa9194ce87603fed241fecb94233e) Remove precondition checks that break Reaper when endTime/startTime are inconsistently set (@adejanovski)

### 1.0.0 (2017/11/14 20:58 +00:00)
- [ba9ca5f](https://github.com/thelastpickle/cassandra-reaper/commit/ba9ca5f7f6b9a44a56c1c665f35142be1384baa2) Release 1.0.0 final (@adejanovski)

### 1.0.0-RC3 (2017/11/13 10:01 +00:00)
- [91b2737](https://github.com/thelastpickle/cassandra-reaper/commit/91b273720ae04fbb10a9a73ec71f8a0294979189) Ninja fix to have Reaper work with 2.0 again (@adejanovski)

### 1.0.0-RC2 (2017/11/09 16:50 +00:00)
- [02e53d0](https://github.com/thelastpickle/cassandra-reaper/commit/02e53d0f421d27f62d9da5355ef4d250ce0b6f46) Should resolve current Docker image issues (@joaquincasares)
- [d75ba7b](https://github.com/thelastpickle/cassandra-reaper/commit/d75ba7b2123af27b3971181893a46a839894200d) Don't log every jmx connection failure within JmxProxyImpl. The thrown exception is logged appropriately when caught. (@michaelsembwever)
- [5d3d469](https://github.com/thelastpickle/cassandra-reaper/commit/5d3d46932ba03d2a0d00040b1c2560bc7bf5bbb6) enable assertions by default when running Reaper. (@michaelsembwever)
- [257bab2](https://github.com/thelastpickle/cassandra-reaper/commit/257bab2aa468e7631c469ad4076f6f364790d39b) Fix typo: endabled -> enabled (@SaaldjorMike)

### 1.0.0-RC1 (2017/11/03 11:44 +00:00)
- [dc9c00d](https://github.com/thelastpickle/cassandra-reaper/commit/dc9c00dfc890091015272358af902fc23c552e45) Pulled back the "database" setting for storage type to ensure backwards compatibility (@adejanovski)
- [92a120c](https://github.com/thelastpickle/cassandra-reaper/commit/92a120c7e16344bc0b6275421a27066f8883507f) Split 'database' configuration setting (@ossarga)
- [1c64c1a](https://github.com/thelastpickle/cassandra-reaper/commit/1c64c1a502a38b5916a149bb12c4b2b133680d9c) Minimal fix for test failure as in described in https://github.com/thelastpickle/cassandra-reaper/issues/266 (@michaelsembwever)
- [42c4c14](https://github.com/thelastpickle/cassandra-reaper/commit/42c4c14914edfb8ad4e0db8cb964f5ae942b7ef7) Add a doc page about multi DC clusters (@adejanovski)
- [13d9246](https://github.com/thelastpickle/cassandra-reaper/commit/13d9246256b4150334a1f59989aa5055190c3164) Merge branch 'master' of https://github.com/thelastpickle/cassandra-reaper (@adejanovski)
- [10d3b02](https://github.com/thelastpickle/cassandra-reaper/commit/10d3b02c239d7af034f64178b74e16677a4c39b8) Fix maven ui build with absolute path in pom instead of relative (@adejanovski)
- [8241eab](https://github.com/thelastpickle/cassandra-reaper/commit/8241eab9cf6d6adfd7004419b31e52ddfab39380) fixed ignore for packages (@rustyrazorblade)
- [c0a4b7a](https://github.com/thelastpickle/cassandra-reaper/commit/c0a4b7ad5b051c8516ac0f6025fc54c58bf727b0) Add version number in the UI (@adejanovski)
- [c85e43c](https://github.com/thelastpickle/cassandra-reaper/commit/c85e43cd1d1a188aa1bd9c4bf24eae4821c4101b) Automating release process using rultor (@velo)
- [619b28a](https://github.com/thelastpickle/cassandra-reaper/commit/619b28a79c2681e3fef9aba41f0167a723c7e15e) Correct cassandra storage table properties. Always enable the key cache, and disable all read_repairs. (@michaelsembwever)
- [e5dbedf](https://github.com/thelastpickle/cassandra-reaper/commit/e5dbedff51f29073c73fb852994400e702e6635d) Remove localMode configuration and logic, as it's not actually implemented yet. (@michaelsembwever)
- [91e5464](https://github.com/thelastpickle/cassandra-reaper/commit/91e5464487cef86e4a080cff2fee394b334d99d5) Fix repair_segment table start_time/end_time/state consistency (@adejanovski)
- [d6e5a10](https://github.com/thelastpickle/cassandra-reaper/commit/d6e5a10af05382b25a9621b5f0dcd6d0c5f2ef56) Remove NULLs in RepairSegments stored in Cassandra. (@michaelsembwever)
- [20f5558](https://github.com/thelastpickle/cassandra-reaper/commit/20f55587cbc7956deb86d4538d2143964bcde36c) Fix issue with upgrades on postgres and h2 when coming from pre-0.8 versions (@adejanovski)
- [#256](https://github.com/thelastpickle/cassandra-reaper/pull/256) Add metrics for repair progress + time since last repair. Fixes #207. (@thelastpickle)
- [2decdde](https://github.com/thelastpickle/cassandra-reaper/commit/2decddebe95b20591c2b4140fdde394f66ad94fa) dawdle duckling to 41ecc2b : node_metrics_v1.minute is a bigint (long) (@michaelsembwever)
- [ee37c5a](https://github.com/thelastpickle/cassandra-reaper/commit/ee37c5a625656cd475d025973c50f1e2b8ef8b58) Add metrics for repair progress + time since last repair. Fixes #207. (@rzvoncek)
- [41ecc2b](https://github.com/thelastpickle/cassandra-reaper/commit/41ecc2bcd2f5e01bca16ed30f27a813903647cb7) Add request mechanism for metrics to allow datacenterAvailability = EACH to work properly on large clusters (@adejanovski)
- [ad41d64](https://github.com/thelastpickle/cassandra-reaper/commit/ad41d6410420a4adc34dddfb9128163e2a0c03a7) Refactor test packages to match the runtime packages. Reduce class and methods visibilities where possible. (@michaelsembwever)
- [d6a8eb4](https://github.com/thelastpickle/cassandra-reaper/commit/d6a8eb40a2ed9606e98a428c9b5a02dcc1f669a8) Cleanup naming: use "node" consistently, in place of "host". (@michaelsembwever)
- [ff19c38](https://github.com/thelastpickle/cassandra-reaper/commit/ff19c38f34f7a7d8b8ffe9dae17cf7fe25d28b1c) Make RepairManager and Heart hold the AppContext as a field, rather than a parameter to all methods. (@michaelsembwever)
- [83d5528](https://github.com/thelastpickle/cassandra-reaper/commit/83d5528ff58642860584005e39eef63ae846beca) Break apart CommonTools. Its methods put it correct peer classes, or into new service classes. (@michaelsembwever)
- [c572e57](https://github.com/thelastpickle/cassandra-reaper/commit/c572e57137d5b5229cf3917c3deef4365089a471) Give datacenterAvailability = EACH better chances to work, through requesting for and updating node metrics for running repairs, as part of heartbeat. (@michaelsembwever)
- [2b806d3](https://github.com/thelastpickle/cassandra-reaper/commit/2b806d3fe1bcb5c7e6181748c8f62235e2550a20) Unit tests for Heart (@michaelsembwever)
- [27b8038](https://github.com/thelastpickle/cassandra-reaper/commit/27b803861c4cb95c9b65cd8d5368e24811e96e45) set heap sizes for travis builds to the same as circleci (which displays better stability) (@michaelsembwever)

- [f188f92](https://github.com/thelastpickle/cassandra-reaper/commit/f188f92074ea897ffaa711ee9f7283bc865a2095) Rebuilt docs (@ossarga)
- [6f10a47](https://github.com/thelastpickle/cassandra-reaper/commit/6f10a47b41a00644de4b71138fe7e9bf2aecd3d9) Updated configuration docs and Docker envs (@ossarga)
- [40e852d](https://github.com/thelastpickle/cassandra-reaper/commit/40e852d4f52412c8ec48accbd04c77a6b8b9d5d9) Fix minor UI issues with autocomplete fields (@adejanovski)
- [8bf9aae](https://github.com/thelastpickle/cassandra-reaper/commit/8bf9aae3a90e8f2fedff4a03be54997a3e3e10b1) UI changes for the new segment count per node (@adejanovski)
- [f3de7a3](https://github.com/thelastpickle/cassandra-reaper/commit/f3de7a39badaa2550b97354fd76b16df6d99b198) Switch from a global segment count to a segment count per node (@adejanovski)
- [a8aae66](https://github.com/thelastpickle/cassandra-reaper/commit/a8aae6699849e1d9d852ea10d6cff1f15b7492ca) Fix browser cache issues when the UI evolves. (@adejanovski)
- [e717ad8](https://github.com/thelastpickle/cassandra-reaper/commit/e717ad8491ea97b116d310e54e9e571c01959fde) For Cassandra storage minimise the number of tombstones (NULL entries) in the repair_run table. (@michaelsembwever)
- [22afbdb](https://github.com/thelastpickle/cassandra-reaper/commit/22afbdb8500c4e08c66584454ea8854c1e85dcfa) Fix JmxConnectionFactory.connectAny(..) to loop a second time trying all hosts regardless of past successes/failures. (@michaelsembwever)
- [e899534](https://github.com/thelastpickle/cassandra-reaper/commit/e899534d23ad2fe6254746f2091c10934ad7e402) Doc fix for correct docker build commands (@michaelsembwever)
- [#228](https://github.com/thelastpickle/cassandra-reaper/pull/228) Create CODE_OF_CONDUCT.md (#228) (@michaelsembwever)
- [9227f61](https://github.com/thelastpickle/cassandra-reaper/commit/9227f6189f9703559d8a465c6d61e34b263ea600) Fix NPE in CassandraStorage, when a read times out and the statement is null. (@michaelsembwever)
- [7b56121](https://github.com/thelastpickle/cassandra-reaper/commit/7b561214420c176a19cf9d82bf87fa2132a9918b) Fix assertions around schedules, as the jersey response need not be successful, and then a correct response has to be waited for. (@michaelsembwever)
- [ea655b3](https://github.com/thelastpickle/cassandra-reaper/commit/ea655b3413be0c197e5ac39ee45033b0cd6e13e5) the integration-test profile is not used anywhere anymore. remove it. (@michaelsembwever)
- [6073a01](https://github.com/thelastpickle/cassandra-reaper/commit/6073a010bd4e373e9234d649114ab2ed739e6fce) Cleanup classes and tests in the io.cassandrareaper.jmx pacakge (@michaelsembwever)
- [e2cf31c](https://github.com/thelastpickle/cassandra-reaper/commit/e2cf31c220cc1040aaffd85a3db0ff02a29853d9) Update Dockerfile (@elsmorian)
- [630257d](https://github.com/thelastpickle/cassandra-reaper/commit/630257df0738185089c00780b234a44f7fcdb8c0) Update cassandra-reaper.yml (@elsmorian)
- [cfe3040](https://github.com/thelastpickle/cassandra-reaper/commit/cfe304094b76fc129ba6afd99dc2f977f83cdbb6) Add logic for handling table blacklists (@adejanovski)
- [6b6b785](https://github.com/thelastpickle/cassandra-reaper/commit/6b6b78572b14dcfe7a9c31b943ec687f6a62a2a3) Add REST endpoint for listing tables from a cluster (@adejanovski)
- [7078584](https://github.com/thelastpickle/cassandra-reaper/commit/7078584f05b6f57efdd0fa105484eb46f4275add) UI changes for blacklisted tables and other minor improvements (@adejanovski)
- [4c3ece2](https://github.com/thelastpickle/cassandra-reaper/commit/4c3ece231d66d62eed55dccfb83bed87f1989ca2) Schema changes for blacklisted tables (@adejanovski)
- [f342866](https://github.com/thelastpickle/cassandra-reaper/commit/f342866ac5e89f5435e2a896a12cdd9e4514464d) Add to checkstyle the ConstantName rule. All static final fields are to be UPPER_CASE. (@michaelsembwever)
- [7dc2316](https://github.com/thelastpickle/cassandra-reaper/commit/7dc231659dbed2c38741693f89e4a111f89be095) In cassandra storage override pooling options to allow bigger queue and longer timeout. (@michaelsembwever)
- [e42ca22](https://github.com/thelastpickle/cassandra-reaper/commit/e42ca22b5507784264524d117dd5ca855d8e844f) Add useAddressTranslator and localDC Docker envar support (@joaquincasares)
- [ce8e4e2](https://github.com/thelastpickle/cassandra-reaper/commit/ce8e4e2b4026bfc95c439110c4d8a8adfe4f1222) Fix yaml reference text (@joaquincasares)
- [b30652c](https://github.com/thelastpickle/cassandra-reaper/commit/b30652cd39c73c631e0f4d1dd653b315fda6e31c) Add  for Docker, which defaults to 20s, based on the code default (@joaquincasares)
- [bdb0bd1](https://github.com/thelastpickle/cassandra-reaper/commit/bdb0bd1eba1c5c06c512461fb17829daaa1872bd) Fix for properly handling reboots of Reaper instances with distributed storage (@adejanovski)
- [b975c39](https://github.com/thelastpickle/cassandra-reaper/commit/b975c39455a5bb95f412cbd6f638e492324df3a1) rebuilt docs (@rustyrazorblade)
- [#218](https://github.com/thelastpickle/cassandra-reaper/pull/218) Docs usage section (#218) (@rustyrazorblade)
- [aff6d33](https://github.com/thelastpickle/cassandra-reaper/commit/aff6d33c00123f257ae4b31e3b01b6f779ef9145) Add useAddressTranslator info in the docs (@adejanovski)
- [26bc722](https://github.com/thelastpickle/cassandra-reaper/commit/26bc722709882e4c8394877930209ae14824ac87) Add JMX connection test for the whole cluster on init to speed up subsequent connections (@adejanovski)
- [3f4f09e](https://github.com/thelastpickle/cassandra-reaper/commit/3f4f09e57f5d1d7df4c83168c1ddecdf18cb5dfb) Fix bugs detected by error prone (@adejanovski)
- [354fe59](https://github.com/thelastpickle/cassandra-reaper/commit/354fe597bb13d5f4e61db0fd5b93be83387d91dc) Ignore any AssertionError trying to releaseLead() when handling a jmx ABORT|ERROR|SESSION_FAILED notification. (@michaelsembwever)
- [2aff661](https://github.com/thelastpickle/cassandra-reaper/commit/2aff66175b4e6423d0ee400178f69f193493657f) Increase timeouts for SegmentRunner in SegmentRunnerTest. (@michaelsembwever)
- [61a8ac4](https://github.com/thelastpickle/cassandra-reaper/commit/61a8ac4f595cf5ff9e9b2debb49441dcf0656f03) Rename package from com.spotify.reaper to io.cassandrareaper (@adejanovski)
- [8d2846e](https://github.com/thelastpickle/cassandra-reaper/commit/8d2846e87d6fe0f229d9dc9b1b0b5a5137cbda9e) regen site (@rustyrazorblade)
- [d1a5aa6](https://github.com/thelastpickle/cassandra-reaper/commit/d1a5aa6c7d6b70cc58618ba5e7d7d0ec288ea6f6) fixed download links and docker link (@rustyrazorblade)
- [fb171d9](https://github.com/thelastpickle/cassandra-reaper/commit/fb171d956264bcd28e41431f8917e1882367ad3f) Changes requested by Alex (@rustyrazorblade)
- [ff6b3ab](https://github.com/thelastpickle/cassandra-reaper/commit/ff6b3ab796327a389dba67c935fa4e22cac61a60) Format java files to suit checkstyle rules. (@michaelsembwever)
- [9f2b7bb](https://github.com/thelastpickle/cassandra-reaper/commit/9f2b7bb57581b37d3100366a8b4c194cd5c85403) add maven-checkstyle-plugin and a ruleset based off google's codestyle (which seems to be what Spotify was using). (@michaelsembwever)
- [f40e87d](https://github.com/thelastpickle/cassandra-reaper/commit/f40e87d2a55c46f0d82e6344522e3964a1c26cd4) fixed packages gitignore and page (@rustyrazorblade)
- [92ab864](https://github.com/thelastpickle/cassandra-reaper/commit/92ab86451330f3acbe0a33e4136fa843c2528793) rebuild website (@rustyrazorblade)
- [#203](https://github.com/thelastpickle/cassandra-reaper/pull/203) Improving docs (#203) (@rustyrazorblade)
- [6eb7f9a](https://github.com/thelastpickle/cassandra-reaper/commit/6eb7f9a06e8117d4c50f1dfa03217802f11debdc) Fix retry policy NPE errors and disable assertions in packaged installs (@adejanovski)
- [eebc3d2](https://github.com/thelastpickle/cassandra-reaper/commit/eebc3d2028ea43ac62db20d746b1781bb0c8a8f9) Fix hanging calls when resuming pending repair runs (@adejanovski)
- [2971e07](https://github.com/thelastpickle/cassandra-reaper/commit/2971e075d207cd055abd701363f5a5812634a3af) Add debug logs for potential coordinator selection (@adejanovski)
- [e1e436d](https://github.com/thelastpickle/cassandra-reaper/commit/e1e436d2502d6e28e68eb9454daf09cb83ed80ee) Add support to run repair on specific nodes or specific datacenter (@adejanovski)
- [c483b8d](https://github.com/thelastpickle/cassandra-reaper/commit/c483b8d39b87653d2b035f94e795d2b204049de2) Add tag list inputs for nodes and datacenters in both repair and schedule forms (@adejanovski)
- [ae8bce7](https://github.com/thelastpickle/cassandra-reaper/commit/ae8bce70fe48a80e4a504f212dcc27c204784190) Bump version number to 0.8.0 (@adejanovski)

### 0.7.1 (2017/10/27 11:53 +00:00)
- [a78d677](https://github.com/thelastpickle/cassandra-reaper/commit/a78d67782d21593f68c29d9940c4341f85f86fc7) Fix issue with pre-2.1.10 versions of Cassandra that don't have the SS.getHostIdToEndpoint() op (@adejanovski)


### 0.7.0 (2017/09/22 14:35 +00:00)
- [54f8230](https://github.com/thelastpickle/cassandra-reaper/commit/54f8230fe76a5f996c8246c6f04a8887aa1d345c) fix typo on release generation when creating tags (@adejanovski)
- [01eae06](https://github.com/thelastpickle/cassandra-reaper/commit/01eae06812d4a1e8c1cab40b5a038a03e9620a31) 0.7.0 release (@adejanovski)
- [c4cb627](https://github.com/thelastpickle/cassandra-reaper/commit/c4cb6271ddf3ce8dc02bc3777c1338cd823a1c37) Fix flaky test due to shared mock object between tests (@adejanovski)
- [89cd6bc](https://github.com/thelastpickle/cassandra-reaper/commit/89cd6bc83d4538285d6763dbe1ebd1abcf463fa2) Change default configurations for more safety. (@adejanovski)
- [1416ef9](https://github.com/thelastpickle/cassandra-reaper/commit/1416ef93d37872fe5df6e3087326b3295f5508ed) Fixes assertion error, when timed out segment repairs are still getting jmx notifications. (@michaelsembwever)
- [1d2cf15](https://github.com/thelastpickle/cassandra-reaper/commit/1d2cf1515c88ca4e499eb7b4d0d1fbf298d1a58d) Regenerated website content (@ossarga)
- [683cb8c](https://github.com/thelastpickle/cassandra-reaper/commit/683cb8c73c38b1f27f6479ef304ee9063c7d24e9) Doc fix to be specific about from where we run the docker-compose command since that is not immediately apparent (@zznate)
- [bf24736](https://github.com/thelastpickle/cassandra-reaper/commit/bf24736f6bdc36227c10b544de4e0f289e9af0d4) Refactored Travis to allow parallel Docker builds (@ossarga)
- [3699509](https://github.com/thelastpickle/cassandra-reaper/commit/3699509d2f3e92aab24173bb872b71192291cb46) Make asserts on schedules existing (having been created) eventual, as this is done by design eventually. (@michaelsembwever)
- [d85d438](https://github.com/thelastpickle/cassandra-reaper/commit/d85d438e2108d80ae9c4f67e4119b1d3e55ac55f) Added Docker SSL encryption example (@ossarga)
- [080c30c](https://github.com/thelastpickle/cassandra-reaper/commit/080c30c60d69e4fbd9bbf772ebfa89de414df16b) Add support for AllEndpointStates output in pre-2.2 versions (@adejanovski)
- [be745f6](https://github.com/thelastpickle/cassandra-reaper/commit/be745f6a07d414bda62990da30f979ce422f7fac) Updates to Docker packaging to fix structure and flexibility (@ossarga)
- [536ddc6](https://github.com/thelastpickle/cassandra-reaper/commit/536ddc615263b1a1b7ecbc70d4a466637bf9808d) Document in requirement to CREATE the reaper_db keyspace (@rustyrazorblade)
- [d313813](https://github.com/thelastpickle/cassandra-reaper/commit/d3138139655f4e58b38f63e3c805c86f3df5d755) showing google we own it (@rustyrazorblade)
- [bafb9c4](https://github.com/thelastpickle/cassandra-reaper/commit/bafb9c41c162269ac7f4727a0926a59d6391df08) added robots.txt to allow full indexing (@rustyrazorblade)
- [bd7c24b](https://github.com/thelastpickle/cassandra-reaper/commit/bd7c24b5a439c66e493257f7f37fa77dfc59e31a) Docker Cassandra configuration update (@ossarga)
- [f677b33](https://github.com/thelastpickle/cassandra-reaper/commit/f677b33392506635944d7d4d6b0d45588f9113fc) Fixed broken link (@rustyrazorblade)
- [9e6665d](https://github.com/thelastpickle/cassandra-reaper/commit/9e6665d12fdf9a307b174cf40305a1b8621db7f5) Removed dead link to backends (@rustyrazorblade)
- [e8351ad](https://github.com/thelastpickle/cassandra-reaper/commit/e8351ad872112a5eb55307cbe5790b8fad6742b0) Merge branch 'master' of github.com:thelastpickle/cassandra-reaper (@rustyrazorblade)
- [7d46c51](https://github.com/thelastpickle/cassandra-reaper/commit/7d46c514fa6504dc8e0dc467b989030128df7bdb) Needed to serve the site correctly (@rustyrazorblade)
- [c3a950b](https://github.com/thelastpickle/cassandra-reaper/commit/c3a950b0c6dc6344c530a659bb5024e2977ffb52) Create CNAME (@rustyrazorblade)
- [#176](https://github.com/thelastpickle/cassandra-reaper/pull/176) Merge docs from the site into the main repo. (@thelastpickle)
- [903e15d](https://github.com/thelastpickle/cassandra-reaper/commit/903e15dca11121d512a5a0aba1f449a36ab04630) fixed data dir (@rustyrazorblade)
- [273b913](https://github.com/thelastpickle/cassandra-reaper/commit/273b913fa2c274e21dc02cc449a5c2e3f28b572c) Add the Datadog metrics reporter (@adejanovski)
- [8afa041](https://github.com/thelastpickle/cassandra-reaper/commit/8afa0419d51470237434f9d110e34478c163de4f) updated readme with info about the in tree docs (@rustyrazorblade)
- [510f598](https://github.com/thelastpickle/cassandra-reaper/commit/510f5984fcbba99dddaf53ae23bf661fae5e9cd3) Generated Site HTML (@rustyrazorblade)
- [7a6ffdd](https://github.com/thelastpickle/cassandra-reaper/commit/7a6ffdd50527ee09b331702a4628badd92a09a3c) Brought in docs from the reaper site repo. (@rustyrazorblade)
- [55324b7](https://github.com/thelastpickle/cassandra-reaper/commit/55324b744668b6b2d9c25a9c1b225c7a9bca225b) Add the Graphite reporter to the list of dependencies (@adejanovski)
- [f2712b1](https://github.com/thelastpickle/cassandra-reaper/commit/f2712b1ce65e0d4751bed1861a29634763c5c0a5) move LongCollectionSQLType to inner class in RepairSchedule. (@michaelsembwever)
- [45dec62](https://github.com/thelastpickle/cassandra-reaper/commit/45dec620892161251f1dfda72ae9903e4587cbb9) move ReaperApplication.checkRepairParrellismString() to RepairRunResource. (@michaelsembwever)
- [c7776fb](https://github.com/thelastpickle/cassandra-reaper/commit/c7776fbf994732410a07f4378e9bc2e61953c2a8) Move contextual fields from ReaperApplication to AppContext. (@michaelsembwever)
- [880d378](https://github.com/thelastpickle/cassandra-reaper/commit/880d37828c4a051bcb0997d81dea66385268f3b8) Move DatacenterAvailability to be an inner class of ReaperApplicationConfiguration, as it's a config object, not a domain object. (@michaelsembwever)
- [3168507](https://github.com/thelastpickle/cassandra-reaper/commit/3168507b96e7016e0ed71bdd3f916d5b8234a09d) remove orphaned class KeyspaceStatus (@michaelsembwever)
- [c9b8876](https://github.com/thelastpickle/cassandra-reaper/commit/c9b8876de1e28f1921c49a31cf64071e8a53c6a5) Move SimpleCondition to service package, as it is a private peer class to SegmentRunner. (@michaelsembwever)
- [ecd75c3](https://github.com/thelastpickle/cassandra-reaper/commit/ecd75c32b50f0b092292d1e42066c72666b6fb66) Merge branch 'mck/project-toplevel-restructure' (@michaelsembwever)
- [6374f44](https://github.com/thelastpickle/cassandra-reaper/commit/6374f44b05012a052fb5dd178666f3527b112a72) Rearrange project to separate concerns (source code versus packaging artifacts, etc) (@michaelsembwever)

### 0.7.0-beta-25082017 (2017/08/23 21:40 +00:00)
- [649c876](https://github.com/thelastpickle/cassandra-reaper/commit/649c87665278d6f8a025d1eca4c5abec415b145b) removed redundant readme (@rustyrazorblade)
- [9ed5f49](https://github.com/thelastpickle/cassandra-reaper/commit/9ed5f49a24f42b1b5e0724f8ce5431be330083bf) Make JMX connections smarter by picking primarily to nodes for which connection didn't fail in the past. (@adejanovski)
- [e3dcb7d](https://github.com/thelastpickle/cassandra-reaper/commit/e3dcb7d69656c32efe78e9c2409bd0e5ace4d8b4) Add 3 different profiles of metrics collection : ALL, LOCAL and EACH. (@adejanovski)
- [6a835f7](https://github.com/thelastpickle/cassandra-reaper/commit/6a835f7b2b1831d0e60130c52b75ec8d6e875a59) Calls to `SegmentRunner.abort()` or `SegmentRunner.postpone()` must still happen within the leader-election framework. (@michaelsembwever)
- [49bfc6f](https://github.com/thelastpickle/cassandra-reaper/commit/49bfc6f31a881da30e20c0a8abcdacbed5c43c11) fix the heap setting, and save 10% cpu-time by preferring IPv4 connections (@michaelsembwever)
- [cdf5147](https://github.com/thelastpickle/cassandra-reaper/commit/cdf51474c1f5d16db0878966ff12e7fc8131e3d3) Add methods to JmxProxy so know which datacenters each host is in. (@michaelsembwever)
- [08bc563](https://github.com/thelastpickle/cassandra-reaper/commit/08bc563a4ff470eb67d7c349fdefa92d3194fc4f) Make the tests create keyspaces that match the cluster topology being tested. (@michaelsembwever)
- [3e5fa3d](https://github.com/thelastpickle/cassandra-reaper/commit/3e5fa3d6c208dcf2a3441ceafac4bf878599b48f) Add metrics to JmxConnectionFactory and SegmentRunner. Also add the promethues servlet to the admin interface. (@michaelsembwever)
- [2a2ad66](https://github.com/thelastpickle/cassandra-reaper/commit/2a2ad66282ce47fe16d667e6220d7926190ee037) In ReaperApplicationConfiguration apply the documented defaults to the code. (@michaelsembwever)
- [b2db7c2](https://github.com/thelastpickle/cassandra-reaper/commit/b2db7c2cf36ccd418c307a8423f38571a94e909c) circleci setup, postgres excluded (@michaelsembwever)
- [6336456](https://github.com/thelastpickle/cassandra-reaper/commit/6336456494c5d634259723f11a88246d45976431) Implement Fault Tolerant Reaper (@adejanovski)
- [ca25596](https://github.com/thelastpickle/cassandra-reaper/commit/ca255964c868bdbd3433c2ca4252997cf4f4ded2) Configure the Cassandra driver with a custom retry policy that (basically) always retries. (@michaelsembwever)
- [c0b1774](https://github.com/thelastpickle/cassandra-reaper/commit/c0b1774e431eac14c64a462bf9324c2a94905bf2) In the CassandraStorage make constant the remaining select cql statements (@michaelsembwever)
- [138f6b3](https://github.com/thelastpickle/cassandra-reaper/commit/138f6b35865880b0e849f49a2a22c6a501dfd8a9) In the Cassandra storage make all write statements async. (@michaelsembwever)
- [a7104ba](https://github.com/thelastpickle/cassandra-reaper/commit/a7104ba23eeaec14a004ceab9a3ab6270a22ff75) Remove the LOGGED batch statements. Only offering atomicity on successful requests they have little impact of design and usuability. (@michaelsembwever)
- [0f3b900](https://github.com/thelastpickle/cassandra-reaper/commit/0f3b900676b788c1048d4fcfa65f390998114940) Improve test stability and pass rate for distributed tests. (@michaelsembwever)
- [aee1979](https://github.com/thelastpickle/cassandra-reaper/commit/aee1979629753e955a10c3be69e4452ac47eaf05) Add asserts ensuring that repair segments are only ever written to from an elected leader. (@michaelsembwever)
- [514e01e](https://github.com/thelastpickle/cassandra-reaper/commit/514e01e95154ca50edcf74ac6f05885d663c83da) Remove `IStorage.getNextFreeSegment(..)` as `getNextFreeSegmentInRange(..)` is always used now. (@michaelsembwever)
- [956b2ae](https://github.com/thelastpickle/cassandra-reaper/commit/956b2ae61f7cb8bb556cc4a9fb25a90d850cb267) Implement "local mode" as a "Distributed Storage" capability. (@michaelsembwever)
- [ccbb31f](https://github.com/thelastpickle/cassandra-reaper/commit/ccbb31f9e20fc2aff51f4e7ece8a019976bcbf4c) Make integration tests capable of testing multiple running reaper instances. (@michaelsembwever)
- [1cc8520](https://github.com/thelastpickle/cassandra-reaper/commit/1cc8520181d28718de72717566dc8de6c192799d) Make the SchedulingManager more BASE design friendly (@michaelsembwever)
- [c791f64](https://github.com/thelastpickle/cassandra-reaper/commit/c791f64d51d30c47a01e35cfd2711e0588e29da5) Fix nodes status in the health view when shutdown is not clean (@adejanovski)
- [f4e5be3](https://github.com/thelastpickle/cassandra-reaper/commit/f4e5be307f276d1e9e71c0ef742e3d9f9d336499) Add loader in the UI to show progress on getting nodes statuses (@adejanovski)
- [647ae73](https://github.com/thelastpickle/cassandra-reaper/commit/647ae73882bfe3696a6673278e8b030b8a33a74d) bump to next development version (@michaelsembwever)
- [6823b8e](https://github.com/thelastpickle/cassandra-reaper/commit/6823b8e58902af020c066b74a946c776823f55d0) Updated README to point to new documentation home on cassandra-reaper.io (@rustyrazorblade)

### 0.6.2 (2017/08/22 13:37 +00:00)
- [4640eaf](https://github.com/thelastpickle/cassandra-reaper/commit/4640eaf2807604144d3bd46c3a69a79598b24510) 0.6.2 release (@adejanovski)
- [#157](https://github.com/thelastpickle/cassandra-reaper/pull/157) Add a Gitter chat badge to README.md (@gitter-badger)
- [8a5f31f](https://github.com/thelastpickle/cassandra-reaper/commit/8a5f31f896c0a9ed18cf0f3de538e685d6d16bfa) Add Gitter badge (@gitter-badger)
- [74776b1](https://github.com/thelastpickle/cassandra-reaper/commit/74776b122837ce152c4d33074377c3cb3004f3b8) Fix coordinator node being nulled out by abort() for incremental repairs. (@adejanovski)
- [f022542](https://github.com/thelastpickle/cassandra-reaper/commit/f02254206dc3936b27510e417d358e30ff930f8c) Added delete-schedule to the CLI (@favoretti)
- [9c230e1](https://github.com/thelastpickle/cassandra-reaper/commit/9c230e15710cfc1652beffbdcf88868f78ea7111) Add ability to have both a schedule for full and incremental repairs at the same time for the same keyspace (@adejanovski)
- [#151](https://github.com/thelastpickle/cassandra-reaper/pull/151) Fix ClassCastException when using H2 database (#151). (@smarsching)
- [e89720c](https://github.com/thelastpickle/cassandra-reaper/commit/e89720cbba5f935477f3ae0146096295dda70dc9) Fix issue #132 (@adejanovski)
- [08f3275](https://github.com/thelastpickle/cassandra-reaper/commit/08f3275e09f8b300de687421b34d26b9179c0237) Fix SSL encrypted and client authenticating connections to Cassandra's jmx. (@michaelsembwever)
- [3deb77b](https://github.com/thelastpickle/cassandra-reaper/commit/3deb77b8aad9773761a030700b6cf1cedfb3aed1) Update README.md (@adejanovski)
- [#141](https://github.com/thelastpickle/cassandra-reaper/pull/141) Add instructions to install and run reaper as a service (@thelastpickle)
- [a70bd36](https://github.com/thelastpickle/cassandra-reaper/commit/a70bd362056b0616e8c02f188eb7ae37b482dfa7) Add instructions to install and run reaper as a service (@adejanovski)
- [4e9fd40](https://github.com/thelastpickle/cassandra-reaper/commit/4e9fd40b75ba7ae8f38e2a7ab8cff5e16769a0aa) Add note on how to find the IP address for the Docker Compose example (@joaquincasares)
- [43cdb4b](https://github.com/thelastpickle/cassandra-reaper/commit/43cdb4b81ec10d42186f952618b9a1a0914c876b) Allow for a configurable replication factor for reaper_db (@joaquincasares)
- [a3a2708](https://github.com/thelastpickle/cassandra-reaper/commit/a3a2708c727dad5544c22e55d25c44aab0e11f58) Include Docker-specific documentation. (@joaquincasares)
- [6449e9c](https://github.com/thelastpickle/cassandra-reaper/commit/6449e9c9ec800bb89f23e546f2d97d2b26b09ab8) Add docker-compose environment (@joaquincasares)
- [#135](https://github.com/thelastpickle/cassandra-reaper/pull/135) Add jmxAuth keys to default configs. (@thelastpickle)
- [#134](https://github.com/thelastpickle/cassandra-reaper/pull/134) Add docker-build process. (@thelastpickle)
- [eae87d0](https://github.com/thelastpickle/cassandra-reaper/commit/eae87d0da407800a69f76b8dbe51820eec989714) Requested changes for #134's review. (@joaquincasares)
- [79d76f5](https://github.com/thelastpickle/cassandra-reaper/commit/79d76f5c8e98825ab73ccec7b345260e05488666) Fix issue #137 with dashes not being kept in cluster/datacenter/rack names (@adejanovski)
- [a8d645e](https://github.com/thelastpickle/cassandra-reaper/commit/a8d645e7932beba4a63d673fb3bbcaf0749b418b) Add jmxAuth keys to default configs. (@joaquincasares)
- [413a4f3](https://github.com/thelastpickle/cassandra-reaper/commit/413a4f382cc87513cd45c39fbd135e2101c693e2) Add docker-build process. (@joaquincasares)
- [629abb5](https://github.com/thelastpickle/cassandra-reaper/commit/629abb58409ecdf3001fff8156b29dcbdb7ad360) Make UUIDs returned from PostgresStorage deterministic to reduce confusion (@Bj0rnen)
- [#127](https://github.com/thelastpickle/cassandra-reaper/pull/127) Fix repair parallelism in cluster overview output, for schedules/runs… (@Bj0rnen)
- [36c9b3d](https://github.com/thelastpickle/cassandra-reaper/commit/36c9b3d55b4ffbfd3fe57daae297549ff189c27e) Fix repair parallelism in cluster overview output, for schedules/runs created in old versions (@Bj0rnen)
- [#120](https://github.com/thelastpickle/cassandra-reaper/pull/120) Changed the git protocol form SSH to http of startbootstrap-sb-admin (@Japio007)
- [#121](https://github.com/thelastpickle/cassandra-reaper/pull/121) Allow the auto scheduler to honour the incrementalRepair option. (@Japio007)
- [#123](https://github.com/thelastpickle/cassandra-reaper/pull/123) Fix issue with C* <= 2.1.9 not having the StorageServiceMBean.getEndp… (@thelastpickle)
- [6f91035](https://github.com/thelastpickle/cassandra-reaper/commit/6f910352dc4fe1772248dae0d2a0f8e5e2fb1921) Fix issue with C* <= 2.1.9 not having the StorageServiceMBean.getEndpointToHostId() method (@adejanovski)
- [#117](https://github.com/thelastpickle/cassandra-reaper/pull/117) Web UI improvements (@thelastpickle)
- [b5fcfce](https://github.com/thelastpickle/cassandra-reaper/commit/b5fcfce48b9ee22008ec41c8b8e5a4b853b80353) Optimize listing repairs by not counting segments for runs with state DONE (@adejanovski)
- [6e2055d](https://github.com/thelastpickle/cassandra-reaper/commit/6e2055d23abaf54faf37686b638d7dc8e48d8242) Web ui improvements with filters, cluster health view and collapseable blocks (@adejanovski)
- [ca07648](https://github.com/thelastpickle/cassandra-reaper/commit/ca07648d3289d06658d6b3ffabfb8744036ee70a) Fix issues with changes in RepairParallelism enum between 2.1 and 2.2. Helps with schedules created in old versions. (@adejanovski)
- [39e4c97](https://github.com/thelastpickle/cassandra-reaper/commit/39e4c97ade1da0c6e43f8c03fc7456330a51d699) Allow the auto scheduler to honour the incrementalRepair option.
- [4e88d00](https://github.com/thelastpickle/cassandra-reaper/commit/4e88d00a5d27d5103b3d83326923cbfe9f49f2fc) Changed the git protocol form SSH to http of startbootstrap-sb-admin
- [#116](https://github.com/thelastpickle/cassandra-reaper/pull/116) Adds integration test to ensure scheduled repairs can initiate repair runs, and maintain history (@thelastpickle)
- [15f4755](https://github.com/thelastpickle/cassandra-reaper/commit/15f4755d58f730b6f6ee52c86bad9faa1ee66abf) Adds integration test to ensure scheduled repairs can initiate repair runs, and maintain history. (@michaelsembwever)
- [b13d0ef](https://github.com/thelastpickle/cassandra-reaper/commit/b13d0efd9c20304b455e6d7fc083c70ef8225e5f) Bump up version number (@adejanovski)

### 0.6.1 (2017/06/08 15:39 +00:00)
- [64dea25](https://github.com/thelastpickle/cassandra-reaper/commit/64dea25891629c9793e55696f46a5d0a9b6fb822) 0.6.1 release (@adejanovski)
- [#114](https://github.com/thelastpickle/cassandra-reaper/pull/114) LongCollectionSQLType should hold Longs, not UUIDs (@vrischmann)
- [3d16533](https://github.com/thelastpickle/cassandra-reaper/commit/3d16533fe5be00cd1ce500225349068b33b974bf) LongCollectionSQLType should hold Longs, not UUIDs (@vrischmann)
- [#110](https://github.com/thelastpickle/cassandra-reaper/pull/110) move into the next development cycle (@thelastpickle)
- [ad3d7e7](https://github.com/thelastpickle/cassandra-reaper/commit/ad3d7e704d8e64d93abb19cb59bd1d707e4cf689) move into the next development cycle (@michaelsembwever)

### 0.6.0 (2017/06/01 14:41 +00:00)
- [0031da9](https://github.com/thelastpickle/cassandra-reaper/commit/0031da9c5f3cc572fcb69b00b0e5222c8a7c0c06) Release 0.6.0 (@adejanovski)
- [#109](https://github.com/thelastpickle/cassandra-reaper/pull/109) Cassandra backend improvements (#109) (@adejanovski)
- [#106](https://github.com/thelastpickle/cassandra-reaper/pull/106) Symlink 'src/main/resource/assets' to 'reaper_ui/build' just like in original 'reaper_ui' so we can actually use webpack dev server and hot reload when working on UI. (#106) (@anguenot)
- [#107](https://github.com/thelastpickle/cassandra-reaper/pull/107) Fix CFs list broken display in repairs and schedule views. (#107) (@anguenot)
- [f7682f2](https://github.com/thelastpickle/cassandra-reaper/commit/f7682f237c3d8a5becbae8abe92f3665fcc4e584) Disable the query logger by default (@adejanovski)
- [#96](https://github.com/thelastpickle/cassandra-reaper/pull/96) Add LCS and row cache (#96) (@michaelsembwever)
- [#93](https://github.com/thelastpickle/cassandra-reaper/pull/93) Add a query logger to the Cassandra storage, for debugging and profiling. (#93) (@michaelsembwever)
- [#95](https://github.com/thelastpickle/cassandra-reaper/pull/95) Cassandra performance: use prepared statements against repair_id, and cache a floor for the sequence number to reduce lookups. (#95) (@michaelsembwever)
- [#97](https://github.com/thelastpickle/cassandra-reaper/pull/97) Don't handle success callbacks after timeout (C* <= 2.1) (#97) (@Bj0rnen)
- [#98](https://github.com/thelastpickle/cassandra-reaper/pull/98) Bump aborted runs down in cluster run summary (#98) (@Bj0rnen)
- [#91](https://github.com/thelastpickle/cassandra-reaper/pull/91) Ec2MultiRegionAddressTranslator. (#91) (@MALPI)
- [#76](https://github.com/thelastpickle/cassandra-reaper/pull/76) Adding support to build cassandra-reaper docker images (@chrislbs)
- [8639ea2](https://github.com/thelastpickle/cassandra-reaper/commit/8639ea2657651df48825ee840d1e6d21f7b9676c) Correcting ENV DB prefix; Inlining chwon/chmod commands
- [6195670](https://github.com/thelastpickle/cassandra-reaper/commit/6195670b6fcbda317169821f1e5ee2803bd32dac) Using su-exec and removing env var prefix
- [#73](https://github.com/thelastpickle/cassandra-reaper/pull/73) additional example and doc around cassandra storage for reaper (#73) (@skhatri)
- [#81](https://github.com/thelastpickle/cassandra-reaper/pull/81) Minor fixes (#81) (@MALPI)
- [36019b9](https://github.com/thelastpickle/cassandra-reaper/commit/36019b9344e53a513a720b587c2dcebc25e5fa5e) # Conflicts: #	pom.xml (@adejanovski)
- [984a265](https://github.com/thelastpickle/cassandra-reaper/commit/984a265057caf75e2b6f19c3ab717e1e53f380e3) Fix issue with incremental repair using new repair methods (issue #71) (@adejanovski)
- [2588b9d](https://github.com/thelastpickle/cassandra-reaper/commit/2588b9d85c734b0c9ad3dcd65d3791fbae997f43) Adding support to build cassandra-reaper docker images
- [#66](https://github.com/thelastpickle/cassandra-reaper/pull/66) Use dropwizard 1.0 (#66) (@adejanovski)
- [#67](https://github.com/thelastpickle/cassandra-reaper/pull/67) Use new repair API and adapt notification handler (#67) (@adejanovski)
- [7f16e02](https://github.com/thelastpickle/cassandra-reaper/commit/7f16e0261ef8f26e8152e66a05e4f44f9249562e) Bump up version number (@adejanovski)

### 0.5.0 (2017/03/17 08:57 +00:00)
- [c1253b0](https://github.com/thelastpickle/cassandra-reaper/commit/c1253b089674457613ec4ba3f6d666c47b18841f) 0.5.0 release (@adejanovski)
- [#63](https://github.com/thelastpickle/cassandra-reaper/pull/63) Add dynamic discovery of seeds for clusters (#63) (@adejanovski)
- [#64](https://github.com/thelastpickle/cassandra-reaper/pull/64) Fix bad segment count display on scheduled repairs (#64) (@adejanovski)
- [#55](https://github.com/thelastpickle/cassandra-reaper/pull/55) Autoschedule (#55) (@adejanovski)
- [8d7500c](https://github.com/thelastpickle/cassandra-reaper/commit/8d7500c2db4b909a881841bbf94201969e9fbaf0) Bump version number (@adejanovski)

### 0.4.1 (2017/03/03 14:49 +00:00)
- [3334115](https://github.com/thelastpickle/cassandra-reaper/commit/33341156047738786c5577d3a86097213caadb82) Release 0.4.1 (@adejanovski)
- [#53](https://github.com/thelastpickle/cassandra-reaper/pull/53) Fix getting metrics for pending compactions and active/pending repair… (#53) (@adejanovski)

### v0.4.0 (2017/02/23 11:02 +00:00)
- [9fb2b6e](https://github.com/thelastpickle/cassandra-reaper/commit/9fb2b6e9cae1875eb5ee17eacdb5f7c399028475) Fix deploy phase (@adejanovski)
- [2151cd1](https://github.com/thelastpickle/cassandra-reaper/commit/2151cd1d05b4c2f3f3e6d1c24fdfb9453e8f6fde) Add automatic release in Travis (@adejanovski)
- [ecd6054](https://github.com/thelastpickle/cassandra-reaper/commit/ecd605416dc299a805d5de6a23a3a76cdb06c896) Remove file due to premature inclusion (@adejanovski)
- [#48](https://github.com/thelastpickle/cassandra-reaper/pull/48) Code improvements based on SonarQube analysis (#48) (@adejanovski)
- [61f14f0](https://github.com/thelastpickle/cassandra-reaper/commit/61f14f01d86e4be175b86dd78b2c7f01ffae6eed) Update documentation after adding FlyWay (@adejanovski)
- [#45](https://github.com/thelastpickle/cassandra-reaper/pull/45) Add auto initialization of the Reaper Cassandra DB (#45) (@adejanovski)
- [e6d0cae](https://github.com/thelastpickle/cassandra-reaper/commit/e6d0cae0117c2aa436c9ac419a000fdd23a42979) Add documentation for storage backend configuration (@adejanovski)
- [#37](https://github.com/thelastpickle/cassandra-reaper/pull/37) added support for H2 database storage (#37) (@adejanovski)
- [#44](https://github.com/thelastpickle/cassandra-reaper/pull/44) Allow Reaper to work with Cassandra 1.2 (#44) (@adejanovski)
- [#38](https://github.com/thelastpickle/cassandra-reaper/pull/38) postgresql: the stored repair parallelism can be lowercase (#38) (@vrischmann)
- [#40](https://github.com/thelastpickle/cassandra-reaper/pull/40) Add possibility to run repair on clusters with unreachable DCs (#40) (@adejanovski)
- [#42](https://github.com/thelastpickle/cassandra-reaper/pull/42) Fix performance issues with Cassandra backend (#42) (@adejanovski)

### 0.3.1 (2017/01/17 10:38 +00:00)
- [033ac3d](https://github.com/thelastpickle/cassandra-reaper/commit/033ac3d5bd5350c2bb8cbaf08aa54dafd01a7542) fixed reaper class path (@rustyrazorblade)

### 0.3.0 (2017/01/05 13:11 +00:00)
- [#36](https://github.com/thelastpickle/cassandra-reaper/pull/36) Fix a NullPointerException when postponing (#36) (@vrischmann)
- [#35](https://github.com/thelastpickle/cassandra-reaper/pull/35) Create a full integration test suite (@thelastpickle)
- [8df29f8](https://github.com/thelastpickle/cassandra-reaper/commit/8df29f87261bd5198903a28976ae0631660b862a) Fix the stuff SonarQube was complaining about (never use Thread.sleep in tests :) (@adejanovski)
- [0496cc4](https://github.com/thelastpickle/cassandra-reaper/commit/0496cc4e6df4511e51148dcc083d465a20964772) Create a separate integration test phase for running against a real ccm cluster (@adejanovski)
- [d65a34e](https://github.com/thelastpickle/cassandra-reaper/commit/d65a34e286467c2642635df00577c11683de418a) Update README.md (@rustyrazorblade)
- [#34](https://github.com/thelastpickle/cassandra-reaper/pull/34) Travis ci (#34) (@adejanovski)
- [#33](https://github.com/thelastpickle/cassandra-reaper/pull/33) Fix issue #32 with parallelism parsing issues with postgres storage (#33) (@adejanovski)
- [#25](https://github.com/thelastpickle/cassandra-reaper/pull/25) Include UI sources and maven profile to rebuild it (#25) (@adejanovski)
- [#23](https://github.com/thelastpickle/cassandra-reaper/pull/23) Add support for incremental repair to sprearer (#23) (@adejanovski)
- [#20](https://github.com/thelastpickle/cassandra-reaper/pull/20) Fix wierdness on 14.04 (#20) (@neogenix)
- [#18](https://github.com/thelastpickle/cassandra-reaper/pull/18) Makefile change (#18) (@neogenix)
- [4c4d96c](https://github.com/thelastpickle/cassandra-reaper/commit/4c4d96cc66def12a1f67f3fd986d26afc7535504) Fix issue #21 with Cassandra storage (@adejanovski)
- [#14](https://github.com/thelastpickle/cassandra-reaper/pull/14) Fix for Cassandra 2.2 full repair bug (@thelastpickle)
- [f337e65](https://github.com/thelastpickle/cassandra-reaper/commit/f337e651b89c590978268b707340abcda2420495) Fix for Cassandra 2.2 full repair bug (@adejanovski)
- [#16](https://github.com/thelastpickle/cassandra-reaper/pull/16) typo on db name (@eslocombe)
- [15c5690](https://github.com/thelastpickle/cassandra-reaper/commit/15c56907f7c968f7881a38d61a037b33376acb16) typo on db name
- [f68b8eb](https://github.com/thelastpickle/cassandra-reaper/commit/f68b8eb6d81a1728d72be0179bf1e9ff9aa3f2d1) Add Cassandra storage option (@adejanovski)
- [#9](https://github.com/thelastpickle/cassandra-reaper/pull/9) Fix for issue #8 (problem starting incremental repair when full repair was executed earlier or vice-versa) (@thelastpickle)
- [41ef23d](https://github.com/thelastpickle/cassandra-reaper/commit/41ef23db591e8663a6cb2c412d6b57840fa887f6) Fix for issue #8 to allow different repair units on the same cluster/keyspace with different inc repair settings (@adejanovski)

### v0.3.0 (2016/10/13 23:22 +00:00)
- [16d7759](https://github.com/thelastpickle/cassandra-reaper/commit/16d7759ec0b02121acec3ce6d45d1e025dc5bf29) updated readme (@rustyrazorblade)
- [1aa0be5](https://github.com/thelastpickle/cassandra-reaper/commit/1aa0be52e06c3c7acbcf5d39a403a2bdf2dccfa2) tweaked makefile (@rustyrazorblade)
- [294efb3](https://github.com/thelastpickle/cassandra-reaper/commit/294efb393d2d8ac908e85a8ed67d7a3b80f60c71) Merge branch 'master' into inc-repair-support-with-ui (@rustyrazorblade)
- [67b5c5b](https://github.com/thelastpickle/cassandra-reaper/commit/67b5c5b429f19351d73e9c9ef2f47a88f59c6f47) made running reaper a little easier in reaper directory (@rustyrazorblade)
- [712cecf](https://github.com/thelastpickle/cassandra-reaper/commit/712cecf7cdeb09fbc2f1b72c365ce57db66b58b5) # Conflicts: #	src/main/java/com/spotify/reaper/cassandra/JmxProxy.java (@adejanovski)
- [788d5d1](https://github.com/thelastpickle/cassandra-reaper/commit/788d5d16965a4680ac9b072b97c0394d4e117da8) fix for Cassandra 2.0 (@adejanovski)
- [a20d2f3](https://github.com/thelastpickle/cassandra-reaper/commit/a20d2f36877b0239cee6663d36e47bd3429bf0e4) make all (@rustyrazorblade)
- [51f8a0a](https://github.com/thelastpickle/cassandra-reaper/commit/51f8a0a1fa99a768990bf7f2150f164dd9ab180e) Merge branch 'master' of github.com:thelastpickle/cassandra-reaper (@rustyrazorblade)
- [7d547e5](https://github.com/thelastpickle/cassandra-reaper/commit/7d547e5532d1b54e1cf02163ac4a59c2cb46a05a) removed the incremental repair support for now.  will readd soon (@rustyrazorblade)
- [8205b2b](https://github.com/thelastpickle/cassandra-reaper/commit/8205b2b826f852cef4b89a3d5f8fbd4e6eaf38f6) add better logging (@rustyrazorblade)
- [9f6cc90](https://github.com/thelastpickle/cassandra-reaper/commit/9f6cc90421abf058d16e88c705320a067d7b143d) Changed first heading for trademark compliance (@zznate)
- [9c569ad](https://github.com/thelastpickle/cassandra-reaper/commit/9c569ad836891cfd57a19671e2ca70b23dc3f3a8) Brought in line with ASF copyright compliance (@zznate)
- [7ded9d3](https://github.com/thelastpickle/cassandra-reaper/commit/7ded9d310523b965fdb7f184066e813e70c45563) Init script (@rustyrazorblade)
- [24c8b63](https://github.com/thelastpickle/cassandra-reaper/commit/24c8b63d60d92c767b90dd02d83207ab93bfe494) trying to get init scripts (@rustyrazorblade)
- [abd85fa](https://github.com/thelastpickle/cassandra-reaper/commit/abd85fae16f520e8d69126a6b5960eb509408460) working on init script (@rustyrazorblade)
- [9898418](https://github.com/thelastpickle/cassandra-reaper/commit/9898418a36ee2e562a03eeca56815cce56dbed66) Merge branch 'master' of github.com:thelastpickle/cassandra-reaper (@rustyrazorblade)
- [e2ad760](https://github.com/thelastpickle/cassandra-reaper/commit/e2ad760524b02347dd4b330b9c83935bc76aa657) fixed version, fixed build script (@rustyrazorblade)
- [d62e26e](https://github.com/thelastpickle/cassandra-reaper/commit/d62e26e0bea0b2a905a8ca4de7a96b4b8cf41394) Fixed typo (@adejanovski)
- [6272a9d](https://github.com/thelastpickle/cassandra-reaper/commit/6272a9d29e3b08ef24f4ecdac0482235f03b1256) build file (@rustyrazorblade)
- [80f874c](https://github.com/thelastpickle/cassandra-reaper/commit/80f874c57c07fd843250dca704f4b4833d4feb4d) added artifacts to gitignore (@rustyrazorblade)
- [fee2385](https://github.com/thelastpickle/cassandra-reaper/commit/fee2385c53c9878b8f9b4ac4663e48deb7e43cf4) This patch merges adejanovski's branch Incremental repair support with ui #1 (@rustyrazorblade)
- [608a612](https://github.com/thelastpickle/cassandra-reaper/commit/608a612601fd30564de5c47b77882fa152394533) tweaked class path so its not always hard coded to a /usr/share location (@rustyrazorblade)
- [bee5036](https://github.com/thelastpickle/cassandra-reaper/commit/bee5036216a97eebe0968c538371ad75c1fb3da8) Merge remote-tracking branch 'origin/inc-repair-support-with-ui' into inc_repair (@rustyrazorblade)
- [54a551c](https://github.com/thelastpickle/cassandra-reaper/commit/54a551cd78f83eb0d7fa2ed0ae42308071d50bf0) fixed permissions (@rustyrazorblade)
- [0455334](https://github.com/thelastpickle/cassandra-reaper/commit/0455334ac78ffeb79b7a7cdadeb2f58a08fa52a9) fix for html file being ignored by git, which broke the ui (@adejanovski)
- [a4507ee](https://github.com/thelastpickle/cassandra-reaper/commit/a4507ee744b710418aaac422a7e2280cc4628f8b) update from branch inc-repair-that-works and add ui back again (@adejanovski)
- [bb42a81](https://github.com/thelastpickle/cassandra-reaper/commit/bb42a81942d41e418b344d15c89aeb2edf4f12e7) # Conflicts: #	resource/cassandra-reaper.yaml #	src/main/resources/assets/65bcbc899f379216109acd0b6c494618.svg #	src/main/resources/assets/deps.js #	src/main/resources/assets/index.js #	src/main/resources/assets/repair.js #	src/main/resources/assets/schedules.js (@adejanovski)
- [2508688](https://github.com/thelastpickle/cassandra-reaper/commit/250868813b0ef53db9fe121dbe4399f066ded7ba) remove ui (@adejanovski)
- [970f934](https://github.com/thelastpickle/cassandra-reaper/commit/970f934341c2151a8b01707157d8f0f9d1e82817) fix for getPendingTasks() that disappeared in C* 3.0 (using JMX directly to get pending compactions) (@adejanovski)
- [1a72c1c](https://github.com/thelastpickle/cassandra-reaper/commit/1a72c1c51863293f903ac6919b5a8a53c37f2b41) Add more loopback addresses for ccm clusters with up to 7 nodes (@adejanovski)
- [0e54137](https://github.com/thelastpickle/cassandra-reaper/commit/0e54137f6964e7dab023594e694fa7f4362066a0) fix missing files for reaper ui (@adejanovski)
- [6eab076](https://github.com/thelastpickle/cassandra-reaper/commit/6eab076f05633a14d1aebb5168af26e037bb9c25) Merge branch 'inc-repair-that-works' into inc-repair-support-with-ui (@adejanovski)
- [42f5f0d](https://github.com/thelastpickle/cassandra-reaper/commit/42f5f0d28cf2add127d034237c8bdc7115a0f38b) prevent incremental subrange repair to allow proper support for inc repairs (@adejanovski)
- [29387ec](https://github.com/thelastpickle/cassandra-reaper/commit/29387ecf66bf23a9de29f7c43233b7b5f7c8aeeb) Merge branch 'sly/incremental-repair-support' into inc-repair-support-with-ui (@adejanovski)
- [05b912d](https://github.com/thelastpickle/cassandra-reaper/commit/05b912ddabc8ea89cf109bc45054b1d135d1d412) ignore binaries and eclipse files (@adejanovski)
- [2083c0a](https://github.com/thelastpickle/cassandra-reaper/commit/2083c0ade04592bfb8fe9789ddf95c467bfc4cd9) Conflicts: 	resource/cassandra-reaper.yaml 	src/main/java/com/spotify/reaper/ReaperApplicationConfiguration.java 	src/main/java/com/spotify/reaper/resources/RepairScheduleResource.java 	src/main/java/com/spotify/reaper/service/SegmentRunner.java 	src/main/java/com/spotify/reaper/storage/postgresql/IStoragePostgreSQL.java 	src/test/resources/cassandra-reaper.yaml (@adejanovski)
- [842ad6b](https://github.com/thelastpickle/cassandra-reaper/commit/842ad6b2df4452917aa86dc9bdd67e650b6d2c6b) added ui from https://github.com/spodkowinski/cassandra-reaper-ui with improved support for incremental repair found in https://github.com/Nuance-Mobility/cassandra-reaper/tree/sly/incremental-repair-support (@adejanovski)
- [3e9cbd2](https://github.com/thelastpickle/cassandra-reaper/commit/3e9cbd247250c8a11da9880c86327b865db92493) upgrade to C* 2.1.13 libs (@adejanovski)
- [#135](https://github.com/thelastpickle/cassandra-reaper/pull/135) Add modifiability of seed host to cluster endpoint (@spotify)
- [92207e4](https://github.com/thelastpickle/cassandra-reaper/commit/92207e466b533850781202be25daca8eba611694) Add modifiability of seed host to cluster endpoint (@Bj0rnen)
- [c16709d](https://github.com/thelastpickle/cassandra-reaper/commit/c16709d12dde4675a25d51b08a172eb5f20b26db) ND-1369: fix repair_unit statement, also fixed db script to crate table in the right DB (@djsly)
- [dcb33fb](https://github.com/thelastpickle/cassandra-reaper/commit/dcb33fbc7e4c4af297bfe8540b055cc89e7a81e0) start development on 0.2.4 (@Bj0rnen)

### v0.2.3 (2015/11/16 15:51 +00:00)
- [e6d0997](https://github.com/thelastpickle/cassandra-reaper/commit/e6d0997c4961068adefdc436a678707c0267803d) release version 0.2.3 (@Bj0rnen)
- [#128](https://github.com/thelastpickle/cassandra-reaper/pull/128) Bj0rnen/kill lingering repairs (@spotify)
- [9564f09](https://github.com/thelastpickle/cassandra-reaper/commit/9564f090cda2d279fd7591fdc518c2e7048f8839) Improve readability (@Bj0rnen)
- [5dc0607](https://github.com/thelastpickle/cassandra-reaper/commit/5dc06070dd18dc4956e4a9709ef8c7577830e30a) Explain usage of LazyInitializer (@Bj0rnen)
- [bd35bce](https://github.com/thelastpickle/cassandra-reaper/commit/bd35bcecd1bcb4d39abb5906b4bfd12bc8baa095) Fix mistake: use respective keyspace (@Bj0rnen)
- [512e2b8](https://github.com/thelastpickle/cassandra-reaper/commit/512e2b8f88850d8614d5cb6411da9e5ead5abe10) Lazily compute list of nodes with ongoing repairs (@Bj0rnen)
- [af24e8a](https://github.com/thelastpickle/cassandra-reaper/commit/af24e8ae22616840836f36721b026f7d6fbddb87) Log when aborting repairs of unknown origin (@Bj0rnen)
- [acfc913](https://github.com/thelastpickle/cassandra-reaper/commit/acfc9133116e43a44d4914c3e2a71b460433fdd8) If stalled, kill repairs that Reaper doesn't know about (@Bj0rnen)
- [8d89ba8](https://github.com/thelastpickle/cassandra-reaper/commit/8d89ba8dc610a6835403066fefc4fca4134cb2b7) Add storage query for all repair commands currently running in cluster (@Bj0rnen)
- [1c7d421](https://github.com/thelastpickle/cassandra-reaper/commit/1c7d42118bc8847aa57e11e7e5f97ad317994703) Add type to hold parameters of issued repair commands (@Bj0rnen)
- [42526c0](https://github.com/thelastpickle/cassandra-reaper/commit/42526c03a3532528878d1666bc8c5598929af140) incremental_repair: adding missing column to query to make the sql work for cluster query with existing repair_run (@djsly)
- [e24da1c](https://github.com/thelastpickle/cassandra-reaper/commit/e24da1ca3e18e98d6b80152a321d7e45b5b5bcc0) incremental_repair: adding missing column to query to make the sql work: (@djsly)
- [#122](https://github.com/thelastpickle/cassandra-reaper/pull/122) change scheduler to wake up once every ten minutes (@spotify)
- [eff3c4f](https://github.com/thelastpickle/cassandra-reaper/commit/eff3c4f98ade3214e4f394a8bcb091ed46f22839) change scheduler to wake up once every ten minutes (@varjoranta)
- [d115a74](https://github.com/thelastpickle/cassandra-reaper/commit/d115a7431e6a7401264afc624a1870f9abcd1335) merge PR from Nuance-Mobility (@varjoranta)
- [ca185d8](https://github.com/thelastpickle/cassandra-reaper/commit/ca185d8a1a7af1c480c3d6c7a7bbda121d6edcf3) Adding missing SQL Query (@djsly)
- [e6f419d](https://github.com/thelastpickle/cassandra-reaper/commit/e6f419d9d4b2bd33c20efa166565306bbbfb7a64) Adding new rest API: get Repair Schedule by Keyspace and by Keyspace and Cluster as well as get Clusters associated with a seed host. (@djsly)
- [0e9dece](https://github.com/thelastpickle/cassandra-reaper/commit/0e9decec916d58d676533a11817671682f181488) merge PR from Nuance-Mobility (@varjoranta)
- [792f9d9](https://github.com/thelastpickle/cassandra-reaper/commit/792f9d9f7684d4c47e26acc890ecccdfd1cbbb1b) fixing compilation error made with the last cherry pick (@djsly)
- [8fde8c4](https://github.com/thelastpickle/cassandra-reaper/commit/8fde8c497cb25cbfabe2bdc347f9e922f7e12c1a) fixing compilation error made with the last cherry pick (@djsly)
- [c90164e](https://github.com/thelastpickle/cassandra-reaper/commit/c90164e89aae3f22a746b23b573979f5281a5cf7) removing left over imports that doesn't exist anymore. (@djsly)
- [1bd802a](https://github.com/thelastpickle/cassandra-reaper/commit/1bd802a14789ffa7bd1129c5486a5af400958bc5) +Preventing repair run to be created when the repair_unit as the same cluster/keyspace/table setting but a different incremental repair (@djsly)
- [dbbf1ee](https://github.com/thelastpickle/cassandra-reaper/commit/dbbf1ee19b3d1e2c0e4b26ee5e4d3394cf8dd685) Fix expected string from client side. (@djsly)
- [c749118](https://github.com/thelastpickle/cassandra-reaper/commit/c7491186813d60bf6939cbe2d59f729ee56f3b81) Updating doc for the new incrementalRepair parameter (@djsly)
- [1145834](https://github.com/thelastpickle/cassandra-reaper/commit/114583425215489326db6cc837cb7faaace6aa8c) Adding logic to prevent incremental repair at the same time as sequential repair. (@djsly)
- [58ded9d](https://github.com/thelastpickle/cassandra-reaper/commit/58ded9da8c6b67e7bc9530188fc57acb0befc598) Adding nee cassandra 2.1 incremental repair feature. (@djsly)
- [48f3c4b](https://github.com/thelastpickle/cassandra-reaper/commit/48f3c4b94a8001639ac63536a9699bd632904ae5) RE-adding the 2.0 SimpleCondition from cassandra 2.0.  Looks like the (@djsly)
- [4253061](https://github.com/thelastpickle/cassandra-reaper/commit/4253061c476071f0a2293e3790cf1bb1a10f573e) ND-1410 updating the reaper code to use cassadnra 2.1.8 library (@djsly)
- [2894824](https://github.com/thelastpickle/cassandra-reaper/commit/2894824b195ee0b6aaf0cc389121e299c47908f1) adding required settings for the scheduleDaysBetween optional feature (@djsly)
- [2ff195f](https://github.com/thelastpickle/cassandra-reaper/commit/2ff195f6910640b6c9c1bd0d4036a5fce92bffc1) Making ScheduleDaysBetween an optional parameter for the rest API for the Schedule. Added a default of 7 days in the config. (@djsly)
- [7bacba9](https://github.com/thelastpickle/cassandra-reaper/commit/7bacba95bf392863515b0c84bd0b4992bc56f3d5) add note about release changes into readme (@varjoranta)
- [d0ebf59](https://github.com/thelastpickle/cassandra-reaper/commit/d0ebf599a76d535ea6ad091e7d1de697ff22875a) start development on 0.2.3 (@varjoranta)

### v0.2.2 (2015/08/28 11:50 +00:00)
- [fee9bcb](https://github.com/thelastpickle/cassandra-reaper/commit/fee9bcb74da2564a3ec3368c87c82e7e0988528c) release version 0.2.2 (@varjoranta)
- [92715dc](https://github.com/thelastpickle/cassandra-reaper/commit/92715dcec395fe26d6627b775ca1178dbd7aa573) stabilize a test by increasing sleep time (@varjoranta)
- [#116](https://github.com/thelastpickle/cassandra-reaper/pull/116) fix not closing jmx connector sometimes (@spotify)
- [4cd8861](https://github.com/thelastpickle/cassandra-reaper/commit/4cd886136607082d7a9efbd6081d12821dd947a1) fix not closing jmx connector sometimes (@varjoranta)
- [#114](https://github.com/thelastpickle/cassandra-reaper/pull/114) add debug for hanging segments (@spotify)
- [d2ce932](https://github.com/thelastpickle/cassandra-reaper/commit/d2ce9323f94633d8590fbafe1d3df66cbafeb674) add debug for hanging segments (@varjoranta)
- [84ed30a](https://github.com/thelastpickle/cassandra-reaper/commit/84ed30a9172c8c1e085074412514596c4b4dde4e) remove unneeded old debug log message (@varjoranta)
- [#113](https://github.com/thelastpickle/cassandra-reaper/pull/113) fixing too many open files problem (@spotify)
- [79ac8de](https://github.com/thelastpickle/cassandra-reaper/commit/79ac8dee7a12216016e821576c3d3c5bee4e56c9) decrease log severity to info for common repair failures (@varjoranta)
- [6c413fa](https://github.com/thelastpickle/cassandra-reaper/commit/6c413fab92a3b1c1a93358deb7e045516b91f1bf) add explicit cleanup call for jmx connection on repair runner (@varjoranta)
- [5900663](https://github.com/thelastpickle/cassandra-reaper/commit/5900663abe89bd8ca58139b833162080176214c2) add debug for too many open files issue (@varjoranta)
- [#112](https://github.com/thelastpickle/cassandra-reaper/pull/112) Log date on every log line (@spotify)
- [52a7c9e](https://github.com/thelastpickle/cassandra-reaper/commit/52a7c9e3adf065794a009f4ce5fb5363c7b27a24) Log date on every log line
- [0ad34ff](https://github.com/thelastpickle/cassandra-reaper/commit/0ad34ff5fcf31d88646fbe4c706a501fbc9b9ef1) change the maintainer on project (@varjoranta)
- [6f47ae3](https://github.com/thelastpickle/cassandra-reaper/commit/6f47ae3dd4b920b2e759fa4c797de877a0ae31d2) change the runner rescheduling logic a bit (@varjoranta)
- [572c25f](https://github.com/thelastpickle/cassandra-reaper/commit/572c25f3fdef81eb8f89d03d264c844323910212) remove fan out in repair runner scheduling (@varjoranta)
- [af6faf1](https://github.com/thelastpickle/cassandra-reaper/commit/af6faf15ff74a9cb05895671957c0cc8ac871bb3) fix NPE on debug code (@varjoranta)
- [#111](https://github.com/thelastpickle/cassandra-reaper/pull/111) fix an issue on reapir run dying out (@spotify)
- [82fd279](https://github.com/thelastpickle/cassandra-reaper/commit/82fd2794137015cd52adaeedd50e6beec5434a52) fix an issue on reapir run dying out (@varjoranta)
- [ac75473](https://github.com/thelastpickle/cassandra-reaper/commit/ac75473668bf080b46985a3aadb99dd2a9ef5e72) add debug for hunting possible deadlock (@varjoranta)
- [#108](https://github.com/thelastpickle/cassandra-reaper/pull/108) Add a check that reaperId is never null or empty (@spotify)
- [55c3b77](https://github.com/thelastpickle/cassandra-reaper/commit/55c3b7761de674946c0090d5efdb076978842bf0) Add a check that reaperId is never null or empty (@mmatalka)
- [#107](https://github.com/thelastpickle/cassandra-reaper/pull/107) Zvo/resume errors (@spotify)
- [ec4ee70](https://github.com/thelastpickle/cassandra-reaper/commit/ec4ee70c90f51fd62c9f1a49e92d0b1c8e903c94) Implementing bj0rn's comments
- [d870f7b](https://github.com/thelastpickle/cassandra-reaper/commit/d870f7b6456fd4195d74437ebd3673a728426b2e) Extra check for errors in getRangeToEndpointMap()
- [4600378](https://github.com/thelastpickle/cassandra-reaper/commit/46003782e4cec6fafabfe30485b24c0c4e0d7f1c) Resume repair after error
- [a68d825](https://github.com/thelastpickle/cassandra-reaper/commit/a68d8259836486716b8d3a8ed0f930bfae61e8cd) Remove redundant throws/catches of ReaperException
- [1b94e82](https://github.com/thelastpickle/cassandra-reaper/commit/1b94e82c58f1cbef1ba9217c11f2ba83bd378c26) Free repair slot before handling the result
- [#105](https://github.com/thelastpickle/cassandra-reaper/pull/105) Removed internal Spotify manifest (@Yarin78)
- [6702e0f](https://github.com/thelastpickle/cassandra-reaper/commit/6702e0fa765a8047342b1936719c521887861ddc) Removed internal Spotify manifest (@Yarin78)
- [#103](https://github.com/thelastpickle/cassandra-reaper/pull/103) Clear snapshots on session failure (@spotify)
- [52cc32d](https://github.com/thelastpickle/cassandra-reaper/commit/52cc32d0ed97e673aa209c8f7911876a9f047f28) Clear snapshots on session failure
- [#102](https://github.com/thelastpickle/cassandra-reaper/pull/102) add release process definition to readme (@spotify)
- [#101](https://github.com/thelastpickle/cassandra-reaper/pull/101) Remove endTime on retried runs (@spotify)
- [15cb239](https://github.com/thelastpickle/cassandra-reaper/commit/15cb239b94205808c5a42e57a4cd861b0c85497f) add release process definition to readme (@varjoranta)
- [30f6a31](https://github.com/thelastpickle/cassandra-reaper/commit/30f6a310bb0ebe95d3970a3356aa74f791c729da) Remove endTime on retried runs (@Bj0rnen)
- [228381a](https://github.com/thelastpickle/cassandra-reaper/commit/228381a1486f2e587f3198c9627f711b315c8ed9) Update doc about possibility to resume ERROR runs (@Bj0rnen)
- [4682701](https://github.com/thelastpickle/cassandra-reaper/commit/46827018e4e47ff7f38b960f3f227ad3168ba981) start development on 0.2.2 (@Bj0rnen)

### v0.2.1 (2015/05/06 13:14 +00:00)
- [ef1e615](https://github.com/thelastpickle/cassandra-reaper/commit/ef1e6150a3b5cc6670a708fdcf1e12f2ae6ba096) release version 0.2.1 (@Bj0rnen)
- [#100](https://github.com/thelastpickle/cassandra-reaper/pull/100) Postpone schedule if failing to start a repair (@spotify)
- [7c4a2c5](https://github.com/thelastpickle/cassandra-reaper/commit/7c4a2c53b3edb676a02e0e4bbbf7367e8db72107) Postpone schedule if failing to start a repair (@Bj0rnen)
- [#97](https://github.com/thelastpickle/cassandra-reaper/pull/97) Add ability to reattempt repair run that went into ERROR (@spotify)
- [e276f23](https://github.com/thelastpickle/cassandra-reaper/commit/e276f23318abf776d40e1b05af6ce6a988d99264) Add ability to reattempt repair run that went into ERROR (@Bj0rnen)
- [#95](https://github.com/thelastpickle/cassandra-reaper/pull/95) Syncronize all get&update operations of RepairRun objects (@spotify)
- [bb13ed3](https://github.com/thelastpickle/cassandra-reaper/commit/bb13ed32652eb3c7c5efa976d16f81b2b9d3cfc8) Leave lastEvent unchanged on terminated repair runs (@Bj0rnen)
- [3b30858](https://github.com/thelastpickle/cassandra-reaper/commit/3b308587c83e5bf1788357b27f7198b931c98f05) Unregister repair runner whenever run terminates (@Bj0rnen)
- [5fb028b](https://github.com/thelastpickle/cassandra-reaper/commit/5fb028b889080853433b17d706befbfecfeb0d80) Syncronize all get&update operations of RepairRun objects (@Bj0rnen)
- [#94](https://github.com/thelastpickle/cassandra-reaper/pull/94) Always set end time on runs in error (@spotify)
- [72bb83b](https://github.com/thelastpickle/cassandra-reaper/commit/72bb83b40a4a52b9876609e02f2933f57d1d6857) Always set end time on runs in error (@Bj0rnen)
- [#93](https://github.com/thelastpickle/cassandra-reaper/pull/93) Fix check for empty tokenToEndpoint map (@spotify)
- [89e3621](https://github.com/thelastpickle/cassandra-reaper/commit/89e362129b7efa6e12eb086b131094ff59bc4be7) Fix check for empty tokenToEndpoint map
- [#91](https://github.com/thelastpickle/cassandra-reaper/pull/91) Fix bug that caused repair run to fail if nodes are going up or down (@ahenry)
- [#92](https://github.com/thelastpickle/cassandra-reaper/pull/92) Catch AssertionError if a keyspace doesn't exist (@spotify)
- [4efcae2](https://github.com/thelastpickle/cassandra-reaper/commit/4efcae212bbcbf65027f6fb271cd5f2dd8874c04) Catch AssertionError if a keyspace doesn't exist
- [a9ad7a1](https://github.com/thelastpickle/cassandra-reaper/commit/a9ad7a19f68044add53a97dab1a40264c9fba9c3) add a status message on failure due to exception in tokenRangeToEndpoint (@ahenry)
- [e7d3847](https://github.com/thelastpickle/cassandra-reaper/commit/e7d3847c8063472d9ca6462b08859b4e7b308615) Fix bug that caused repair run to fail if nodes are going up or down while (@ahenry)
- [ed3b043](https://github.com/thelastpickle/cassandra-reaper/commit/ed3b0439b4d27e9741ed5acde6aa78d09e208cc2) start development on 0.2.1 (@varjoranta)

### v0.2.0 (2015/04/10 14:06 +00:00)
- [8a423db](https://github.com/thelastpickle/cassandra-reaper/commit/8a423dbaf83ff6d3e50b300a3a7bb1f21f83ed1d) release version 0.2.0 (@varjoranta)
- [#87](https://github.com/thelastpickle/cassandra-reaper/pull/87) Enable GUI headers also through reaper configuration (@spotify)
- [d94e70c](https://github.com/thelastpickle/cassandra-reaper/commit/d94e70c95f4a5c7d798f15c3665eb0d838b2bf88) Enable GUI headers also through reaper configuration
- [#88](https://github.com/thelastpickle/cassandra-reaper/pull/88) Zvo/parallel segments (@spotify)
- [#90](https://github.com/thelastpickle/cassandra-reaper/pull/90) Update run's last_event when run goes into ERROR (@spotify)
- [fc73c06](https://github.com/thelastpickle/cassandra-reaper/commit/fc73c06a27311d88e62950c2ff60f388f947076b) Update run's last_event when run goes into ERROR
- [ebeaca4](https://github.com/thelastpickle/cassandra-reaper/commit/ebeaca4e9899189593004976614d043e53763e83) Append run id and segment id to thread name, where applicable (@Bj0rnen)
- [301c25b](https://github.com/thelastpickle/cassandra-reaper/commit/301c25b2d3c1036441ee68642e93f53e964888f9) Further fixes to getNextFreeSegmentInRange in Postgres (@Bj0rnen)
- [bd19b24](https://github.com/thelastpickle/cassandra-reaper/commit/bd19b24befdf4355b6421d858478d252d3a28ba1) updated readme (@varjoranta)
- [d4342a8](https://github.com/thelastpickle/cassandra-reaper/commit/d4342a8bf8006717afea58021bea9ad29f759512) Cleaning up redundant continue statements (@Bj0rnen)
- [c11af6e](https://github.com/thelastpickle/cassandra-reaper/commit/c11af6e46ba7358f6fc9f04e67d026181f4c9db6) Parallel Repairs
- [63b5cfb](https://github.com/thelastpickle/cassandra-reaper/commit/63b5cfb00c89fe168d6d42a0de3445ac4f8c3cd8) Fix condition for completed repair run (@Bj0rnen)
- [5fac9ed](https://github.com/thelastpickle/cassandra-reaper/commit/5fac9ed1e1d82e5728bcca79b026dd0b6a13b95d) Fix getNextFreeSegmentInRange implementation in PostgresStorage (@Bj0rnen)
- [216157b](https://github.com/thelastpickle/cassandra-reaper/commit/216157be9a2367169c35a0eca12804ad4b01461a) Set thread name to cluster name in SegmentRunner (@Bj0rnen)
- [8569c4d](https://github.com/thelastpickle/cassandra-reaper/commit/8569c4d8ba5129c64468c6de77d901ce3e89833d) add user error message for JMX auth failures (@varjoranta)
- [0d29753](https://github.com/thelastpickle/cassandra-reaper/commit/0d29753e298346d0a99c265ba1f638585621f1bf) introduced new jmx auth settings applied to jmx factory (@spodkowinski)
- [e696db4](https://github.com/thelastpickle/cassandra-reaper/commit/e696db46b674bdf71d2b1c96200422edf05e0232) added jxm authentication example (@spodkowinski)
- [0a37f0e](https://github.com/thelastpickle/cassandra-reaper/commit/0a37f0e00be531557daf0d6ee9c8371ca1353896) jmx proxy can now be created with optional username and password (@spodkowinski)
- [#80](https://github.com/thelastpickle/cassandra-reaper/pull/80) Web UI (@spodkowinski)
- [#86](https://github.com/thelastpickle/cassandra-reaper/pull/86) start development on 0.1.5 (@Yarin78)
- [2db3222](https://github.com/thelastpickle/cassandra-reaper/commit/2db3222b90412c0397980c2ff78faeccddc99118) start development on 0.1.5 (@Yarin78)
- [#85](https://github.com/thelastpickle/cassandra-reaper/pull/85) release version 0.1.4 (@Yarin78)

### v0.1.4 (2015/04/08 16:08 +00:00)
- [059bdd4](https://github.com/thelastpickle/cassandra-reaper/commit/059bdd4c7f9a6eca07a87eb6c9143b9f84224152) release version 0.1.4 (@Yarin78)
- [#84](https://github.com/thelastpickle/cassandra-reaper/pull/84) Bj0rnen/cluster schedules (@spotify)
- [#82](https://github.com/thelastpickle/cassandra-reaper/pull/82) Fix bug causing entire repair run to fail if a node is down (@Yarin78)
- [e9967e2](https://github.com/thelastpickle/cassandra-reaper/commit/e9967e22304e482fad34fcb99e45052da6e347e4) Allow scheduler to start a new run if a previous run had an error. (@Yarin78)
- [#81](https://github.com/thelastpickle/cassandra-reaper/pull/81) Abort repair runs (@spotify)
- [ed21152](https://github.com/thelastpickle/cassandra-reaper/commit/ed21152e20e3c8a2bd7923b8b7ebaeb9c73755cd) Fix bug causing entire repair run to fail if a node is down when terminating repair sessions (@Yarin78)
- [7ae5cca](https://github.com/thelastpickle/cassandra-reaper/commit/7ae5ccacc2039bd2fe7cb6758d2bea344cb68b0f) Add all-fields operator to RepairScheduleStatus (@Bj0rnen)
- [f792f71](https://github.com/thelastpickle/cassandra-reaper/commit/f792f71f09663abac3670e0e833193580760e43d) Add schedule status(es) to cluster status (@Bj0rnen)
- [cb302a4](https://github.com/thelastpickle/cassandra-reaper/commit/cb302a4a895fa62a31537ded5aa37c8a2372fbc5) Minimal stylistic change (@Bj0rnen)
- [749478b](https://github.com/thelastpickle/cassandra-reaper/commit/749478baf9a352bb1e8b6776169f88c73837a8c3) Abort repair runs
- [#79](https://github.com/thelastpickle/cassandra-reaper/pull/79) When creating a repair, start it by default (@spotify)
- [95956b7](https://github.com/thelastpickle/cassandra-reaper/commit/95956b752e4eb37fe3d6d054614c6aa851f37f8f) added support for serving web assets and CORS (@spodkowinski)
- [d84d4a3](https://github.com/thelastpickle/cassandra-reaper/commit/d84d4a39568addf8c776eee57bcf5d5a63c0ede2) Update service-info.yaml (@rouzwawi)
- [1ab5b12](https://github.com/thelastpickle/cassandra-reaper/commit/1ab5b12ec88d593bb34cf48e9f5f3c7ec2cbab6b) When creating a repair, start it by default
- [#77](https://github.com/thelastpickle/cassandra-reaper/pull/77) Include cluster name in each log line (@spotify)
- [d70c1b2](https://github.com/thelastpickle/cassandra-reaper/commit/d70c1b26b59bea676dbf098af75fc3cc46e7ac60) Remove clusterName field from RepairStatusHandler (@Bj0rnen)
- [abb60ac](https://github.com/thelastpickle/cassandra-reaper/commit/abb60ac4f9e0b8585354cefa4f3b5b30284e2f04) Include cluster name in each log line
- [e68f70e](https://github.com/thelastpickle/cassandra-reaper/commit/e68f70e2fbfd04799aac55436714199544478841) start development on 0.1.4 (@Bj0rnen)

### v0.1.3 (2015/03/24 17:02 +00:00)
- [5a4eb25](https://github.com/thelastpickle/cassandra-reaper/commit/5a4eb25017a017d88a865082410f158a68baa9a5) release version 0.1.3 (@Bj0rnen)
- [#76](https://github.com/thelastpickle/cassandra-reaper/pull/76) Fix errors in cluster resource (@spotify)
- [a62efbd](https://github.com/thelastpickle/cassandra-reaper/commit/a62efbd4a4e4968a1536cf647378ab23a8528760) Implement ordering and limiting of repair runs in MemoryStorage (@Bj0rnen)
- [5420853](https://github.com/thelastpickle/cassandra-reaper/commit/5420853326d75aa18ea767eb697a800a9db5d4c7) Order repairs for a cluster by end_time and then start_time, descending. (@Bj0rnen)
- [1cf3cb0](https://github.com/thelastpickle/cassandra-reaper/commit/1cf3cb0702f386e044ddeacab0c4a1c0fb71595f) Correct number of total segments per run returned by Postgres (@Bj0rnen)
- [19d342f](https://github.com/thelastpickle/cassandra-reaper/commit/19d342fb0955f2469d2ad9f2b33eee749a40d1ed) Fix null vs empty list discrepancy between storage implementations (@Bj0rnen)
- [1645c45](https://github.com/thelastpickle/cassandra-reaper/commit/1645c453a383b26c5d5e9a6ac2b0d6bd2cb6236c) Add seed_hosts field to ClusterStatus (@Bj0rnen)
- [32c38bb](https://github.com/thelastpickle/cassandra-reaper/commit/32c38bb4b71a059c27e8be5c7d780bb4c2fdde08) ClusterStatus takes a Cluster rather than only a name (@Bj0rnen)
- [ddb1f36](https://github.com/thelastpickle/cassandra-reaper/commit/ddb1f36787d83539ca677e4547e2cd71b4f38333) ClusterResource GET correctly returns 404 on non-existing cluster (@Bj0rnen)
- [e92cff4](https://github.com/thelastpickle/cassandra-reaper/commit/e92cff423b3ba8a8e35b66639b57b3f5a46b6f98) Default limit on number of repair runs to show for a cluster is changed from 10 to MAX_INT (@Bj0rnen)
- [0e673cf](https://github.com/thelastpickle/cassandra-reaper/commit/0e673cf4689cd9fc2e024ff532842c06d4cfe0e4) Fix typo in a JSON property (@Bj0rnen)
- [151e6b3](https://github.com/thelastpickle/cassandra-reaper/commit/151e6b30debaf680caafc625d8e0b316c9aa6fc0) start development on 0.1.3 (@Bj0rnen)

### v0.1.2 (2015/03/17 17:22 +00:00)
- [f9a01bb](https://github.com/thelastpickle/cassandra-reaper/commit/f9a01bbf51ecc7dddeaa33ccbabf4240335e8fe2) release version 0.1.2 (@Bj0rnen)
- [9cc1a7b](https://github.com/thelastpickle/cassandra-reaper/commit/9cc1a7bf0ccb9dac03ba1e8c65f773f167df44d9) Update readme with cluster endpoint changes (@Bj0rnen)
- [7e852ea](https://github.com/thelastpickle/cassandra-reaper/commit/7e852ead979fbb113773c2dfc8bc143d61d9c81b) Add name property to ClusterStatus (@Bj0rnen)
- [#75](https://github.com/thelastpickle/cassandra-reaper/pull/75) Bj0rn/informative api (@spotify)
- [8b6ff4a](https://github.com/thelastpickle/cassandra-reaper/commit/8b6ff4affaeb0f4c6f6f6739a8744930b4f313aa) Wrap CluserResource's responses in a simple ClusterStatus class (@Bj0rnen)
- [768d783](https://github.com/thelastpickle/cassandra-reaper/commit/768d783f29703d9c570995a285cce49427504cef) Remove hierarchy package - no longer used (@Bj0rnen)
- [2c7aa7b](https://github.com/thelastpickle/cassandra-reaper/commit/2c7aa7b18f3a747c695066ae80942900dbe156c2) Cleanup (@Bj0rnen)
- [2842722](https://github.com/thelastpickle/cassandra-reaper/commit/2842722953fff1ed3a21f153024ed755b9c7ffcd) Merge branch 'bj0rn/InformativeAPI' of https://github.com/spotify/cassandra-reaper into bj0rn/InformativeAPI (@Bj0rnen)
- [fffd90e](https://github.com/thelastpickle/cassandra-reaper/commit/fffd90e62f1ab4432e1459f32899ab7ab8746a35) Replace ClusterRun with RepairRunStatus (@Bj0rnen)
- [a7649b8](https://github.com/thelastpickle/cassandra-reaper/commit/a7649b8b71203a73821d0a60e90f4890ea131a08) Replace ClusterRun with RepairRunStatus (@Bj0rnen)
- [9a6bb2c](https://github.com/thelastpickle/cassandra-reaper/commit/9a6bb2c9caa22666839ac1c27299e8db14a43142) Add all-fields constructor to RepairRunStatus (@Bj0rnen)
- [02a2c1f](https://github.com/thelastpickle/cassandra-reaper/commit/02a2c1f3d823f3cc0de012c7fee2125edc836afe) Add duration and ETA to RepairRunStatus (@Bj0rnen)
- [e23de9f](https://github.com/thelastpickle/cassandra-reaper/commit/e23de9f2fe20f77f97904912ffc25bd5b7ad21c3) Added note (@Bj0rnen)
- [0d6bf98](https://github.com/thelastpickle/cassandra-reaper/commit/0d6bf98af468ede841e7b98cdbacf2d386934bec) Replaced cluster/x endpoint with summary of runs (@Bj0rnen)
- [2f9e90e](https://github.com/thelastpickle/cassandra-reaper/commit/2f9e90e06263f43b754d94c02f784221a3406459) Add /cluster/x/runs endpoint. Candidate for replacing /cluster/x (@Bj0rnen)
- [84a4f7c](https://github.com/thelastpickle/cassandra-reaper/commit/84a4f7cc976325636d78ca1bd9c56146b75b39b3) Reduce DateTime clutter (@Bj0rnen)
- [b6f3715](https://github.com/thelastpickle/cassandra-reaper/commit/b6f3715f860a12888a4e02bcb6253b777193ce33) Fix bug where paused schedules would get resumed when starting up reaper (@Bj0rnen)
- [c3b5c14](https://github.com/thelastpickle/cassandra-reaper/commit/c3b5c14733893d0dac6a91100558c84363c1973a) Replace call to removed function in spreaper (@Bj0rnen)
- [34a5f05](https://github.com/thelastpickle/cassandra-reaper/commit/34a5f0541db7c744e211856fc63f1b885077bb6f) Fix bug where paused schedules would get resumed when starting up reaper (@Bj0rnen)
- [87f82ed](https://github.com/thelastpickle/cassandra-reaper/commit/87f82eda11c3faaf24f075bc14607cf2de6a7419) Temporary way to get hierarchy to display fields with underscores (@Bj0rnen)
- [7531b30](https://github.com/thelastpickle/cassandra-reaper/commit/7531b30af0979c2e7d5416ac4f7e478b8dcd5d0e) Add all fields from core classes to hierarchy classes (@Bj0rnen)
- [21a229d](https://github.com/thelastpickle/cassandra-reaper/commit/21a229d093f5f3373f3c391915bf3882a977c59d) Remove unused imports (@Bj0rnen)
- [04b4263](https://github.com/thelastpickle/cassandra-reaper/commit/04b4263830d102d62b26fffff0668390ddbf23e4) Remove ClusterOverview (@Bj0rnen)
- [802c7e3](https://github.com/thelastpickle/cassandra-reaper/commit/802c7e3465ad6339feea752226a0f7bebbeb81ff) Provide a hierarchical view of Reaper's storage (@Bj0rnen)
- [7ca2628](https://github.com/thelastpickle/cassandra-reaper/commit/7ca26283f8510f26014615ea5a6cb01f7e599292) WIP (@Bj0rnen)
- [9f83ccc](https://github.com/thelastpickle/cassandra-reaper/commit/9f83ccc9213abbcbb6a229ee05c54c1242b38778) Force segmentsRepaired to be set in RepairRunStatus (@Bj0rnen)
- [507f239](https://github.com/thelastpickle/cassandra-reaper/commit/507f239e7f84f7434e71c008af3d165f4e143f94) Replace call to removed function in spreaper (@Bj0rnen)
- [a7d0a44](https://github.com/thelastpickle/cassandra-reaper/commit/a7d0a444118905f68cc5be82e96d3802c928db4a) start new development on 0.1.2 (@Bj0rnen)

### v0.1.1 (2015/02/27 10:38 +00:00)
- [b4944fb](https://github.com/thelastpickle/cassandra-reaper/commit/b4944fb3fe8ba1ea0c65d62509938a6787fb1fd3) release version 0.1.1 (@Bj0rnen)
- [#72](https://github.com/thelastpickle/cassandra-reaper/pull/72) add repair run, schedule, and cluster deletion endpoints (@spotify)
- [#71](https://github.com/thelastpickle/cassandra-reaper/pull/71) Add service-info.yaml file (@rouzwawi)
- [2a1a165](https://github.com/thelastpickle/cassandra-reaper/commit/2a1a165c34741f02ada403a0b5741b8feea1fc16) Make tests reflect recent changes (@Bj0rnen)
- [9f5b796](https://github.com/thelastpickle/cassandra-reaper/commit/9f5b7960e9a57f46570c6ae5e29dd3467eb7d68e) add comment (@rouzwawi)
- [#70](https://github.com/thelastpickle/cassandra-reaper/pull/70) Bj0rnen/updated responses (@spotify)
- [#69](https://github.com/thelastpickle/cassandra-reaper/pull/69) Update last message in repair run with info about failing to connect to ... (@spotify)
- [fec5dc6](https://github.com/thelastpickle/cassandra-reaper/commit/fec5dc6c9c94f2de5e13b39ddbd038a13e1b6a2c) Correctly handle segments that didn't need to repair (@Bj0rnen)
- [d88d5f0](https://github.com/thelastpickle/cassandra-reaper/commit/d88d5f012e1b0723b0cd93c5db17e330e6099b1c) triggerRepair returns 0 on "nothing to repair", not failure (@Bj0rnen)
- [e8cfdb8](https://github.com/thelastpickle/cassandra-reaper/commit/e8cfdb89df01c46f25b3f09a2958be6781319b1d) Handle failed triggerRepair (@Bj0rnen)
- [9290c60](https://github.com/thelastpickle/cassandra-reaper/commit/9290c60b97f8d4a8ce5f9cf6e89cde6fa30676ff) Fix bug with SESSION_FALED (@Bj0rnen)
- [466faad](https://github.com/thelastpickle/cassandra-reaper/commit/466faad25c12be16636a6ced79b28ac6f30b147a) fix postgres related deletion feature bugs (@varjoranta)
- [ac28426](https://github.com/thelastpickle/cassandra-reaper/commit/ac28426fb9cab77f1ba6b01fa2b0f4660cd8bdce) add service-info.yaml file (@rouzwawi)
- [b7886b4](https://github.com/thelastpickle/cassandra-reaper/commit/b7886b4fa836819efb94a9fc80c46e80185b7855) remove obsolete sql clauses (@varjoranta)
- [a080811](https://github.com/thelastpickle/cassandra-reaper/commit/a080811154c6dbc6167603cc741cf99cd0931d67) add schedule stop and start to spreaper cli (@varjoranta)
- [0c612c3](https://github.com/thelastpickle/cassandra-reaper/commit/0c612c3064f89c0e2a4ea347ae5a1e55d92afe8f) add repair run, schedule, and cluster deletion endpoints (@varjoranta)
- [8e23690](https://github.com/thelastpickle/cassandra-reaper/commit/8e236906987c61ba54bc4bc0923b78ba26eb0fba) Comment clarification (@Bj0rnen)
- [3fd866c](https://github.com/thelastpickle/cassandra-reaper/commit/3fd866c688fae8c78f1628903cb6808a8a9e530a) Make PUT endpoints output updated (not original) JSON (@Bj0rnen)
- [#67](https://github.com/thelastpickle/cassandra-reaper/pull/67) use validation annotations instead of assertions, minor refactoring (@spotify)
- [419621f](https://github.com/thelastpickle/cassandra-reaper/commit/419621f9c3926235116d6cb2571f6dec51217500) config.repairIntensity cannot be 0, add test (@mattnworb)
- [edba6f5](https://github.com/thelastpickle/cassandra-reaper/commit/edba6f52d21c36dc761e5b262b51ee72e370f324) Update last message in repair run with info about failing to connect to a host (@Bj0rnen)
- [#68](https://github.com/thelastpickle/cassandra-reaper/pull/68) Log hostname/port of a host JMXProxy failed to connect to (@spotify)
- [ece34af](https://github.com/thelastpickle/cassandra-reaper/commit/ece34aff059efbda950b4e099519712e2dc76f2d) Log hostname/port of a host JMXProxy failed to connect to
- [fc19a30](https://github.com/thelastpickle/cassandra-reaper/commit/fc19a30c5e666e417f2e072d9a1212c9fde0e918) use joda-time's DateTimeFormatter for date conversion (@mattnworb)
- [#66](https://github.com/thelastpickle/cassandra-reaper/pull/66) Some refactorings (@spotify)
- [8e93566](https://github.com/thelastpickle/cassandra-reaper/commit/8e93566725f128239ff6cb1f348236e6c0ed7cb5) use validation annotations for config validation (@mattnworb)
- [4f301a0](https://github.com/thelastpickle/cassandra-reaper/commit/4f301a08cd99ff4919fd67850c89b5052763c2da) AppContext doesn't need to be static (@mattnworb)
- [0555999](https://github.com/thelastpickle/cassandra-reaper/commit/0555999ee765f7dbaeea992ee0f2cab85c3b6c45) refactor: Extract static methods from RepairRunner into RepairManager (@Yarin78)
- [d8d272f](https://github.com/thelastpickle/cassandra-reaper/commit/d8d272f11cf85783828689678a8588168320ebe3) Made CLI file executable (@Yarin78)
- [da4c212](https://github.com/thelastpickle/cassandra-reaper/commit/da4c21249ce23e65d9ef44c095d18cf41e6d3653) Add names to threadpools (@Yarin78)
- [c86df78](https://github.com/thelastpickle/cassandra-reaper/commit/c86df78a881503755e6a1f8ac8ebdc5b896616ef) minor documentation and spreaper docstring cleanup (@varjoranta)
- [c788d23](https://github.com/thelastpickle/cassandra-reaper/commit/c788d23ba218853578ddf69c5b6fc6f5e3194ace) Merge remote-tracking branch 'origin/zvo/list-all' (@varjoranta)
- [#62](https://github.com/thelastpickle/cassandra-reaper/pull/62) separate the CLI tool into separate package (@varjoranta)
- [d2b9cf4](https://github.com/thelastpickle/cassandra-reaper/commit/d2b9cf403d140b8a3ed4fa026dad26c2f443f8a3) minor code cleanup regarding the custom JMX feature (@varjoranta)
- [c245fa2](https://github.com/thelastpickle/cassandra-reaper/commit/c245fa26ee9a7cea139c1fe22bc69fa20ccc50a8) added jmxPorts config option description and example (@spodkowinski)
- [438e329](https://github.com/thelastpickle/cassandra-reaper/commit/438e329e3ba65591238c946d755ecbbd34cfc3d4) added jmxPorts to configuration, added jmx port lookup in con.factory (@spodkowinski)
- [7d66fbd](https://github.com/thelastpickle/cassandra-reaper/commit/7d66fbdf0c7f1c5d8b4a3aa9e51b3235244fe262) Endpoints for listing repair runs and schedules
- [#59](https://github.com/thelastpickle/cassandra-reaper/pull/59) remove owner and cause arguments from wrong places (@varjoranta)
- [3960a4f](https://github.com/thelastpickle/cassandra-reaper/commit/3960a4f609d37a0c01d0632fb3da8aea11829a89) separate the CLI tool into separate package (@varjoranta)
- [938c2f6](https://github.com/thelastpickle/cassandra-reaper/commit/938c2f60dd54594fa7208dafeb22d091c41f78d9) remove owner and cause arguments from wrong places (@varjoranta)
- [0fa0317](https://github.com/thelastpickle/cassandra-reaper/commit/0fa031730f40816f0d92cd7ec93cfacebad98f7a) add explanation about current development phase in README (@varjoranta)
- [#50](https://github.com/thelastpickle/cassandra-reaper/pull/50) add python-requests as dependency of debian package for spreaper (@blablacar)
- [866df11](https://github.com/thelastpickle/cassandra-reaper/commit/866df11cd8fddd0984abbce72e418b6669685394) add python-requests as dependency of debian package for spreaper (@n0rad)
- [#49](https://github.com/thelastpickle/cassandra-reaper/pull/49) fix debian package depends from default to explicit java7 (@varjoranta)
- [0369d98](https://github.com/thelastpickle/cassandra-reaper/commit/0369d989c74d1d818f1934798e4495644d9d2cfc) fix debian package depends from default to explicit java7 (@varjoranta)
- [0894581](https://github.com/thelastpickle/cassandra-reaper/commit/08945815463f272a0566368f9b45b336b10bed8f) start development on 1.0.1 (@varjoranta)
- [#47](https://github.com/thelastpickle/cassandra-reaper/pull/47) release 0.1.0 (@varjoranta)

### v0.1.0 (2015/02/13 11:44 +00:00)
- [8f3c175](https://github.com/thelastpickle/cassandra-reaper/commit/8f3c17500cac8d43afe8afe2ad574f928ff50496) release 0.1.0 (@varjoranta)
- [11e9c8a](https://github.com/thelastpickle/cassandra-reaper/commit/11e9c8a8f1784c1c83d34f828255713495d3ec31) update run history for updated repair schedules (@varjoranta)
- [#46](https://github.com/thelastpickle/cassandra-reaper/pull/46) clean up the verbose scheduler logging (@varjoranta)
- [f5f3755](https://github.com/thelastpickle/cassandra-reaper/commit/f5f3755a06116737ec7eab16a7bd6d117631c5d1) clean up the verbose scheduler logging (@varjoranta)
- [#45](https://github.com/thelastpickle/cassandra-reaper/pull/45) repair scheduling (@spotify)
- [ee33d35](https://github.com/thelastpickle/cassandra-reaper/commit/ee33d35a5e5712d679a5290fd8251917de921689) fix bugs in scedule inserting and array mapping (@varjoranta)
- [ae5cbe5](https://github.com/thelastpickle/cassandra-reaper/commit/ae5cbe52456e5047ed87e08b15eecc1a902f537c) fix issue in mapping int SQL array to long array (@varjoranta)
- [cb50e66](https://github.com/thelastpickle/cassandra-reaper/commit/cb50e66d21185c0f6166580da8f9b306c8d41be0) fix issue with mapping generic collections to different sql type arrays (@varjoranta)
- [5ae9e09](https://github.com/thelastpickle/cassandra-reaper/commit/5ae9e09d7cc25e8ff6816e472d2c302fbc4ecea2) fix a bug in selecting schedules for a cluster (@varjoranta)
- [de3416c](https://github.com/thelastpickle/cassandra-reaper/commit/de3416c2ca79e5d21f321d6979fb427b254cfb5b) fix bug in repair_schedule table name in SQL (@varjoranta)
- [1fe9160](https://github.com/thelastpickle/cassandra-reaper/commit/1fe9160aedd69cc53135558a6d9cb41ac729418b) add start for scheduling manager (@varjoranta)
- [7a86ff2](https://github.com/thelastpickle/cassandra-reaper/commit/7a86ff205bbad147211cd04b72de4fd6ecc0f86e) Allow pausing/resuming repair schedules (@Bj0rnen)
- [5ade480](https://github.com/thelastpickle/cassandra-reaper/commit/5ade480b2c6492c19bd0bee0f538f3ebe955e6f9) add acceptance test for repair scheduling (@varjoranta)
- [a1262b7](https://github.com/thelastpickle/cassandra-reaper/commit/a1262b74f35eb91b12c7a0b0b0e1c8dc1d869bd1) add documentation and spreaper schedule status command (@varjoranta)
- [8b236dd](https://github.com/thelastpickle/cassandra-reaper/commit/8b236dd2e009bfb81dd25824819c9a077377b882) wip: added initial schedule resource, with some refactoring (@varjoranta)
- [90e4467](https://github.com/thelastpickle/cassandra-reaper/commit/90e446721206253d18b4442f4215b56aa1d06286) Fix time comparison error (@Bj0rnen)
- [6198337](https://github.com/thelastpickle/cassandra-reaper/commit/61983379e7dd87db4778f0215a4e87961899608f) Use ImmutableList for runHistory (@Bj0rnen)
- [55067c2](https://github.com/thelastpickle/cassandra-reaper/commit/55067c2e099af2a01618ba930548d2d11fc564dc) Fix duplicate intensity from merge (@Bj0rnen)
- [9b456be](https://github.com/thelastpickle/cassandra-reaper/commit/9b456be9463204e2f8d0497ef83ec81f4e87eec7) RepairSchedule implemented in storage (@Bj0rnen)
- [afdd1c3](https://github.com/thelastpickle/cassandra-reaper/commit/afdd1c382b6b08e09282a6d15fc7dfe55a7de3be) wip: refactor repair run management to separate class, use for scheduling (@varjoranta)
- [4081ecb](https://github.com/thelastpickle/cassandra-reaper/commit/4081ecb2b686794f6240d9e3dbbd384e1519633c) wip: Add runHistory to RepairSchedule and fix missing fields in Builder's "copy constructor" (@Bj0rnen)
- [4f30af2](https://github.com/thelastpickle/cassandra-reaper/commit/4f30af28c5f382513e97718508c078a8d9771a74) wip: continuing with scheduling manager using repair units (@varjoranta)
- [0ed38f7](https://github.com/thelastpickle/cassandra-reaper/commit/0ed38f717b3af45004c38529d160dfc147afc7b8) First draft of RepairSchedule duplicating fields from RepairRun (@Bj0rnen)
- [#43](https://github.com/thelastpickle/cassandra-reaper/pull/43) Bj0rnen/mock jmx (@spotify)
- [c2bda76](https://github.com/thelastpickle/cassandra-reaper/commit/c2bda769d8f0745766cc4b0f7f886cdc34db9ef5) Conflicts: 	src/main/db/reaper_db.sql 	src/main/java/com/spotify/reaper/core/RepairRun.java 	src/main/java/com/spotify/reaper/resources/ReaperHealthCheck.java 	src/main/java/com/spotify/reaper/resources/RepairRunResource.java 	src/main/java/com/spotify/reaper/resources/view/RepairRunStatus.java 	src/main/java/com/spotify/reaper/storage/postgresql/IStoragePostgreSQL.java 	src/test/java/com/spotify/reaper/unit/resources/RepairRunResourceTest.java 	src/test/java/com/spotify/reaper/unit/service/RepairRunnerTest.java 	src/test/java/com/spotify/reaper/unit/service/SegmentRunnerTest.java (@Bj0rnen)
- [d0ba8f8](https://github.com/thelastpickle/cassandra-reaper/commit/d0ba8f8fb34e3531de69ee47c17b079a501a90cd) Include cucumber test in junit tests (@Bj0rnen)
- [03ac3e9](https://github.com/thelastpickle/cassandra-reaper/commit/03ac3e9ba23915936c416f17c6ac63b91fa5962d) Mock a JmxProxy that can report cluster name in acceptance test (@Bj0rnen)
- [dd5d9d8](https://github.com/thelastpickle/cassandra-reaper/commit/dd5d9d88782be61d10c6846c51fbcb9add6f33d0) Unset currentlyRunningSegmentId when not running a segment (@Bj0rnen)
- [9473095](https://github.com/thelastpickle/cassandra-reaper/commit/947309506ed3c8b24bf3dcc1086b95497a48e15a) Fix printout with negative duration (@Bj0rnen)
- [#42](https://github.com/thelastpickle/cassandra-reaper/pull/42) move segments count and repair parallelism to repair_run (@varjoranta)
- [ccecc2b](https://github.com/thelastpickle/cassandra-reaper/commit/ccecc2b04ac16bf38a21deef4db817566de5a585) add intensity parameter for the spreaper on repair (@varjoranta)
- [0f24d15](https://github.com/thelastpickle/cassandra-reaper/commit/0f24d15dca2b8a01a9778a06211d2102fd4e97cb) Include cucumber test in junit tests (@Bj0rnen)
- [fc01b2d](https://github.com/thelastpickle/cassandra-reaper/commit/fc01b2dcca3567824422c60fafbf19cf057a5571) move segments count and repair parallelism to repair_run (@varjoranta)
- [d5e7204](https://github.com/thelastpickle/cassandra-reaper/commit/d5e7204d09454e61a4aadc2328d55fd1de71fb9f) Mock a JmxProxy that can report cluster name in acceptance test (@Bj0rnen)
- [991682a](https://github.com/thelastpickle/cassandra-reaper/commit/991682ac60035a02ee73a6e24406d53c2f07e1d1) add last_event to database model from repair run (@varjoranta)
- [81f1262](https://github.com/thelastpickle/cassandra-reaper/commit/81f12625ceb539e09254f80394da1536eb77d92e) some refactoring on acceptance tests (@varjoranta)
- [25295c4](https://github.com/thelastpickle/cassandra-reaper/commit/25295c47c94e1070a2b593e69fa3157ddb4577de) add acceptance tests, refactor Reaper to use context (@varjoranta)
- [20f4d43](https://github.com/thelastpickle/cassandra-reaper/commit/20f4d43592547475c01620f4cb22946c6dc02024) Include last event info in a RepairRun(Status)
- [#41](https://github.com/thelastpickle/cassandra-reaper/pull/41) add acceptance test and rados changes (@varjoranta)
- [ee5acdc](https://github.com/thelastpickle/cassandra-reaper/commit/ee5acdc94adfe9f0d873a0d38f047683d4e301d9) some refactoring on acceptance tests (@varjoranta)
- [7ca9c14](https://github.com/thelastpickle/cassandra-reaper/commit/7ca9c14bc1f3ce3899a9ca845877dba7cf477bbb) add acceptance tests, refactor Reaper to use context (@varjoranta)
- [9d34227](https://github.com/thelastpickle/cassandra-reaper/commit/9d34227554fdd94f2333b920130e7e21ddc144a0) add last_event to database model from repair run (@varjoranta)
- [0308a54](https://github.com/thelastpickle/cassandra-reaper/commit/0308a54828188c7ded8ac2f41042e20fbee87e52) Include last event info in a RepairRun(Status)
- [6badbd0](https://github.com/thelastpickle/cassandra-reaper/commit/6badbd0fe0464298ee4e73636a428eccacf17277) Fix rounding bug by using float literals
- [d4532f0](https://github.com/thelastpickle/cassandra-reaper/commit/d4532f02fd8e40bcf66c72b3ab188bb16ec72257) fix version compare to support revision strings in version (@varjoranta)
- [53c75f7](https://github.com/thelastpickle/cassandra-reaper/commit/53c75f7cf39a23a6b143dde65752aa9910df203a) Unset currentlyRunningSegmentId when not running a segment (@Bj0rnen)
- [#39](https://github.com/thelastpickle/cassandra-reaper/pull/39) Fix rounding bug by using float literals (@spotify)
- [d1093ab](https://github.com/thelastpickle/cassandra-reaper/commit/d1093abf322bf7997b6aa66f3c9b67d9c687c56b) Fix rounding bug by using float literals
- [#38](https://github.com/thelastpickle/cassandra-reaper/pull/38) fix version compare to support revision strings in version (@varjoranta)
- [5bafa32](https://github.com/thelastpickle/cassandra-reaper/commit/5bafa3282dde24a0d7806cbc511e77e13f3973ba) fix version compare to support revision strings in version (@varjoranta)
- [8847701](https://github.com/thelastpickle/cassandra-reaper/commit/88477016922d4e11506f706faead3b3c27863c40) Fix printout with negative duration (@Bj0rnen)
- [#37](https://github.com/thelastpickle/cassandra-reaper/pull/37) Log unchecked exceptions thrown on RepairRunner threads (@spotify)
- [b211e2f](https://github.com/thelastpickle/cassandra-reaper/commit/b211e2fd99f8b5ed3021e73ba9152306c8627e60) Log unchecked exceptions thrown on RepairRunner threads (@Bj0rnen)
- [#36](https://github.com/thelastpickle/cassandra-reaper/pull/36) improve user documentation regarding starting repairs (@varjoranta)
- [a59d094](https://github.com/thelastpickle/cassandra-reaper/commit/a59d09411d4e5c83fab3d4dfb709f987874d7237) fix test setup for SegmentRunnerTest (@varjoranta)
- [f323a09](https://github.com/thelastpickle/cassandra-reaper/commit/f323a094011a5beda9c6a4a900ed9233ba64df1c) improve some debug messages (@varjoranta)
- [9b9b8c5](https://github.com/thelastpickle/cassandra-reaper/commit/9b9b8c5e7f1df86e236c05c84174169af38b7925) Log actual cause of failed repair run (@Bj0rnen)
- [d92bc99](https://github.com/thelastpickle/cassandra-reaper/commit/d92bc992a542cd419cd49ebab4acca644d81af56) Clarify log message (@Bj0rnen)
- [23fe075](https://github.com/thelastpickle/cassandra-reaper/commit/23fe0754b4df3f7dcf52920e37b7cc4b93d81e46) fix failing tests after cluster name format change (@varjoranta)
- [7449274](https://github.com/thelastpickle/cassandra-reaper/commit/74492746fe8a728454b10e9c135ce34b31bb65b8) improve user documentation regarding starting repairs (@varjoranta)
- [da47813](https://github.com/thelastpickle/cassandra-reaper/commit/da47813a37324022dcaa7cf8f07919af5f8dedf2) Unset pause time when resuming run from pause (@Bj0rnen)
- [#35](https://github.com/thelastpickle/cassandra-reaper/pull/35) add repair parallelism as parameter to CLI and REST API (@varjoranta)
- [f752bba](https://github.com/thelastpickle/cassandra-reaper/commit/f752bba67f9e4f3be3ab9169edb7b9ba8649bb52) fixed one failing test case (@varjoranta)
- [7bd43c5](https://github.com/thelastpickle/cassandra-reaper/commit/7bd43c5b8466096af87722328ca0b27b16f7bddf) add repair parallelism as parameter to CLI and REST API (@varjoranta)
- [d710753](https://github.com/thelastpickle/cassandra-reaper/commit/d710753d1271e2f390a38d9b5433486d77d7e52d) fix tests that relied on wrongly changed segment state (@varjoranta)
- [d5f2df2](https://github.com/thelastpickle/cassandra-reaper/commit/d5f2df2623313ee96fc7dec7a51ff8f46c50e714) change into using Cassandra inbuilt RepairParallelism enum (@varjoranta)
- [610ffd6](https://github.com/thelastpickle/cassandra-reaper/commit/610ffd62b05f8247ea5e2d7128d72ff20556f67f) update segments count after actual segments are created (@varjoranta)
- [ef1044b](https://github.com/thelastpickle/cassandra-reaper/commit/ef1044b73c0418ec08ab155cd7cef3fa917629e8) fix an issue with utilising repair parallelism in DB (@varjoranta)
- [#34](https://github.com/thelastpickle/cassandra-reaper/pull/34) fixing spreaper for latest schema, fix few bugs also (@varjoranta)
- [b2e388a](https://github.com/thelastpickle/cassandra-reaper/commit/b2e388af225a49323bbbfdacf050b66056261a01) change snapshot repair into repair parallelism (@varjoranta)
- [832dd67](https://github.com/thelastpickle/cassandra-reaper/commit/832dd67627dd1c35ccd53d8954124ada680b6964) fixed issues in repair triggering after latest changes (@varjoranta)
- [83a7cde](https://github.com/thelastpickle/cassandra-reaper/commit/83a7cde8056a0b77796e7d527acaafa5bcc525fb) fixing spreaper for latest schema, fix few bugs also (@varjoranta)
- [#33](https://github.com/thelastpickle/cassandra-reaper/pull/33) Bj0rnen/can repair (@spotify)
- [34bc971](https://github.com/thelastpickle/cassandra-reaper/commit/34bc97112130cfe1f87f19c57f8aaffcc326d5fe) Conflicts: 	src/main/java/com/spotify/reaper/cassandra/JmxProxy.java (@Bj0rnen)
- [eff7f28](https://github.com/thelastpickle/cassandra-reaper/commit/eff7f283c03bd9242359fbaeb457ff7f06a978a9) Check for already running anti-entropy sessions (@Bj0rnen)
- [2f7bbac](https://github.com/thelastpickle/cassandra-reaper/commit/2f7bbac926fe1abb7e69725b4ece8f7ab1d33981) Check for already running anti-entropy sessions (@Bj0rnen)
- [0da9b92](https://github.com/thelastpickle/cassandra-reaper/commit/0da9b9261cd05770723004cf72c9626d77272c44) Conflicts: 	src/main/java/com/spotify/reaper/cassandra/JmxConnectionFactory.java 	src/main/java/com/spotify/reaper/service/SegmentRunner.java (@Bj0rnen)
- [eee0bfd](https://github.com/thelastpickle/cassandra-reaper/commit/eee0bfddc48b2cdd1fdecdfd61edbcc08f1fe79c) Consult all affected nodes about ongoing compactions (@Bj0rnen)
- [#32](https://github.com/thelastpickle/cassandra-reaper/pull/32) Bigger change to replace column family concept with repair unit (@spotify)
- [f9db262](https://github.com/thelastpickle/cassandra-reaper/commit/f9db262be0387dfb3fcd1687a49e1068f966387c) fix auto resuming repair runs (@varjoranta)
- [13839ec](https://github.com/thelastpickle/cassandra-reaper/commit/13839ecdfa7d805a4c758b6bba862501a2dded6c) Conflicts: 	src/main/java/com/spotify/reaper/resources/RepairRunResource.java 	src/main/java/com/spotify/reaper/service/RepairRunner.java 	src/test/java/com/spotify/reaper/service/RepairRunnerTest.java (@varjoranta)
- [5bac856](https://github.com/thelastpickle/cassandra-reaper/commit/5bac856139e455d1f653b2629843dd85db1cdb56) fix MemoryStorage to return Optionals instead of nulls (@varjoranta)
- [2ed0643](https://github.com/thelastpickle/cassandra-reaper/commit/2ed0643c839fa523f6a198cc27fd7e43bc6a7bc6) Properly resume paused runs (@Bj0rnen)
- [#31](https://github.com/thelastpickle/cassandra-reaper/pull/31) Properly resume paused runs (@spotify)
- [3d6c1e8](https://github.com/thelastpickle/cassandra-reaper/commit/3d6c1e8879d46ae663c0544c37d4ec7adf769be5) WIP fixing tests, still missing resume tests (@varjoranta)
- [757cff2](https://github.com/thelastpickle/cassandra-reaper/commit/757cff2c6439a167b37bae81153a66523c1aa974) Consult all affected nodes about ongoing compactions (@Bj0rnen)
- [953d167](https://github.com/thelastpickle/cassandra-reaper/commit/953d167c3bff3f5f51b773f331836b2849f400a6) Properly resume paused runs (@Bj0rnen)
- [666c5b5](https://github.com/thelastpickle/cassandra-reaper/commit/666c5b55849b1a172e3f0eeb384fef98fdca2197) WIP making the code compile, but errors in tests still (@varjoranta)
- [60a59fa](https://github.com/thelastpickle/cassandra-reaper/commit/60a59faa2ba0146a8f7ed15a0672b9f65a3dcbae) WIP fixing postgresql layer (@varjoranta)
- [b61a986](https://github.com/thelastpickle/cassandra-reaper/commit/b61a9867a0090aa5308658c59fa8967fec1c524d) WIP done fixing MemoryStorage (@Bj0rnen)
- [4bc7880](https://github.com/thelastpickle/cassandra-reaper/commit/4bc7880262fc78b56853d9b8e835025acf936649) Track time when a repair run is paused (@Bj0rnen)
- [6b2515a](https://github.com/thelastpickle/cassandra-reaper/commit/6b2515a366de511d2fa790e43c646d75ca21e798) WIP fixing the RepairRunner (@varjoranta)
- [5e35e6e](https://github.com/thelastpickle/cassandra-reaper/commit/5e35e6e1ec3c0b7a4ea9ca097f31ea184ebee41e) Conflicts: 	src/main/java/com/spotify/reaper/core/RepairSegment.java 	src/main/java/com/spotify/reaper/resources/RepairRunResource.java 	src/main/java/com/spotify/reaper/service/RepairRunner.java (@varjoranta)
- [27406da](https://github.com/thelastpickle/cassandra-reaper/commit/27406dad0b6fd7a195ccd53a16c03647b39d7f41) WIP continues 1 (@varjoranta)
- [90608df](https://github.com/thelastpickle/cassandra-reaper/commit/90608df0d959dcb08d580bde00884b0d38af188e) WIP removing column family concept (@varjoranta)
- [c01bef2](https://github.com/thelastpickle/cassandra-reaper/commit/c01bef21554c912aab50ad936e21eafd6e40120b) WIP still ongoing (@varjoranta)
- [#30](https://github.com/thelastpickle/cassandra-reaper/pull/30) Bj0rnen/segment coordinator (@spotify)
- [cca2305](https://github.com/thelastpickle/cassandra-reaper/commit/cca2305d54a92846bb20390f82b280b3642b647e) WIP still ongoing (@varjoranta)
- [163879e](https://github.com/thelastpickle/cassandra-reaper/commit/163879e3493f067b70c08ed193e42b929a01f894) Don't make JmxProxy serializable (@Bj0rnen)
- [eca1eaa](https://github.com/thelastpickle/cassandra-reaper/commit/eca1eaa509a602773ec3cb687d70c8b8bc8bf715) WIP removing column family concept (@varjoranta)
- [9d96dab](https://github.com/thelastpickle/cassandra-reaper/commit/9d96dab2eacc477f90173b15e90e3492ea9f1821) Abort repairs of segments marked as RUNNING when resuming repair runs (@Bj0rnen)
- [ff43121](https://github.com/thelastpickle/cassandra-reaper/commit/ff4312110ab44653227e70b40f9bc9dcc3913515) Track coordinator for running repair segments (@Bj0rnen)
- [#29](https://github.com/thelastpickle/cassandra-reaper/pull/29) Remove the unused ERROR state from RepairSegment (@spotify)
- [3be109d](https://github.com/thelastpickle/cassandra-reaper/commit/3be109d4e72ba9f94b69e7d18b4d92224f5c5d56) Remove the unused ERROR state from RepairSegment (@Bj0rnen)
- [#28](https://github.com/thelastpickle/cassandra-reaper/pull/28) cleanup spreaper and other minor user feedback changes (@varjoranta)
- [9c6c0b5](https://github.com/thelastpickle/cassandra-reaper/commit/9c6c0b5d2a6eea2a925e59a264e30cc1447d606b) cleanup spreaper and other minor user feedback changes (@varjoranta)
- [1a1289a](https://github.com/thelastpickle/cassandra-reaper/commit/1a1289a4b70e88ffee35537422ff2701695d6c87) Minor code tweaks (@Bj0rnen)
- [#27](https://github.com/thelastpickle/cassandra-reaper/pull/27) Add endpoints for starting, pausing and resuming a repair run. (@spotify)
- [02bbf29](https://github.com/thelastpickle/cassandra-reaper/commit/02bbf297bdf6b0dfe14b4132c2ccaa54c425a00f) Add endpoints for starting, pausing and resuming a repair run.
- [#26](https://github.com/thelastpickle/cassandra-reaper/pull/26) Bj0rnen/can repair (@spotify)
- [b7825db](https://github.com/thelastpickle/cassandra-reaper/commit/b7825db1c373be8af76a7c7dd3da5ae731e3cd9b) Update README.md (@rzvoncek)
- [e4ee887](https://github.com/thelastpickle/cassandra-reaper/commit/e4ee88729df5b96d161a5cbdff3879ab8d113872) Add check for whether a repair should be run on a segment (@Bj0rnen)
- [75d6924](https://github.com/thelastpickle/cassandra-reaper/commit/75d6924a04f91f844bf3dfd2fb8f9e0f4e5c14de) Refactor SegmentRunner, moving logic out of constructor (@Bj0rnen)
- [#25](https://github.com/thelastpickle/cassandra-reaper/pull/25) add fail count for repair segment (@varjoranta)
- [88bb14b](https://github.com/thelastpickle/cassandra-reaper/commit/88bb14b113e990fb61256006b75daa44b55580ea) add fail count for repair segment (@varjoranta)
- [#24](https://github.com/thelastpickle/cassandra-reaper/pull/24) Zvo/add run endpoint (@spotify)
- [c8a0ed9](https://github.com/thelastpickle/cassandra-reaper/commit/c8a0ed9fc13b280aa52e97c89d70d283cfafe9b5) Reworked the CLI to match previous changes in Resources
- [0d530bc](https://github.com/thelastpickle/cassandra-reaper/commit/0d530bc61bc48f4635dc73b836a9f78bb21ec420) improve the README (@varjoranta)
- [367ad98](https://github.com/thelastpickle/cassandra-reaper/commit/367ad985b3b13f766027b28dd4f5f275ebbb4b38) Move add/trigger repair run to RepairRunResource
- [4d70e23](https://github.com/thelastpickle/cassandra-reaper/commit/4d70e23a18d19c08676d4b2ec165cedb707bde33) Use futures to make test failures propagate to main thread (@Bj0rnen)
- [9be7f3f](https://github.com/thelastpickle/cassandra-reaper/commit/9be7f3f11444e7527d7cfaf5fef4b4a33de12e5c) Fix test compile error (@Bj0rnen)
- [#23](https://github.com/thelastpickle/cassandra-reaper/pull/23) Bj0rnen/segment runner (@spotify)
- [8720806](https://github.com/thelastpickle/cassandra-reaper/commit/8720806f61adecc71a347b360591113f182ab084) Implementation and tests for a SegmentRunner (@Bj0rnen)
- [555ffdc](https://github.com/thelastpickle/cassandra-reaper/commit/555ffdc49cf7ff038a8b9f7cca017044ddf3d132) Reimplement RepairRunner using SegmentRunner (@Bj0rnen)
- [e0c2bc5](https://github.com/thelastpickle/cassandra-reaper/commit/e0c2bc537d23344bd6f4eb329430da822804ab1a) Complete test coverage of SegmentRunner (@Bj0rnen)
- [8a256b1](https://github.com/thelastpickle/cassandra-reaper/commit/8a256b15fc282065bd75eceb51ddfc69aa32102e) Reimplement RepairRunner using SegmentRunner (@Bj0rnen)
- [#22](https://github.com/thelastpickle/cassandra-reaper/pull/22) Cleanup of PG storage related classes (@spotify)
- [#21](https://github.com/thelastpickle/cassandra-reaper/pull/21) Unit tests for RingRange and ClusterResource (@spotify)
- [30cb52a](https://github.com/thelastpickle/cassandra-reaper/commit/30cb52aede797b7c51172e639101139944e11064) Cleanup of PG storage related classes
- [f24a828](https://github.com/thelastpickle/cassandra-reaper/commit/f24a828c42c9ff4d61e2f92e9290600f91878435) Conflicts: 	src/main/java/com/spotify/reaper/resources/TableResource.java 	src/test/java/com/spotify/reaper/service/SegmentRunnerTest.java (@Bj0rnen)
- [47f2b4e](https://github.com/thelastpickle/cassandra-reaper/commit/47f2b4e28f0cc9557563e13dd2f0d3ab24676d56) Unit tests for RingRange and ClusterResource
- [a5735c2](https://github.com/thelastpickle/cassandra-reaper/commit/a5735c2b796122ad0d72839df6363aa4024f967d) Complete test coverage of SegmentRunner (@Bj0rnen)
- [2c54161](https://github.com/thelastpickle/cassandra-reaper/commit/2c541617aed2b3191b3c228439e7c419ce7ad145) Implementation and tests for a SegmentRunner (@Bj0rnen)
- [#20](https://github.com/thelastpickle/cassandra-reaper/pull/20) Zvo/jmx features (@spotify)
- [22cf5f6](https://github.com/thelastpickle/cassandra-reaper/commit/22cf5f6d116acc61ea6fa0de24afb42d3776f97a) Implementation and tests for a SegmentRunner (@Bj0rnen)
- [1ed554c](https://github.com/thelastpickle/cassandra-reaper/commit/1ed554c392c7d287f41ac5beea5f8b2f85fe0502) Check for table existance
- [5825959](https://github.com/thelastpickle/cassandra-reaper/commit/582595911be2b4d175f6968de12f85dca750c3ab) Expose cancelling all repairs to JmxProxy
- [b45ff49](https://github.com/thelastpickle/cassandra-reaper/commit/b45ff4917657d0131d4e9eb6baca039c605aabd3) Fetch pending compactions via JMX
- [b2c2e9f](https://github.com/thelastpickle/cassandra-reaper/commit/b2c2e9f8ade366d83b29142bb477af435d3a1f61) Make JmxProxy.connect static once again (@Bj0rnen)
- [#19](https://github.com/thelastpickle/cassandra-reaper/pull/19) Refactored TableResource (includes unit tests) (@spotify)
- [4c59bde](https://github.com/thelastpickle/cassandra-reaper/commit/4c59bdea42fa98c76bca8b6911776d73ad51d0a5) Refactored TableResource (includes unit tests)
- [4a4ee2e](https://github.com/thelastpickle/cassandra-reaper/commit/4a4ee2e22778177640f8a85ddee79c1c3743be06) Make repairCommandID in RepairSegment nullable (@Bj0rnen)
- [84c67c1](https://github.com/thelastpickle/cassandra-reaper/commit/84c67c16c4d14fc7180c44473ecb2af6b56befc9) Factor out RepairRunner.handleRunningRepairSegments (@Bj0rnen)
- [3e97386](https://github.com/thelastpickle/cassandra-reaper/commit/3e9738626c478c2c9bc889247b0272bb3d078f85) Syntactical cleanup (@Bj0rnen)
- [#18](https://github.com/thelastpickle/cassandra-reaper/pull/18) Bj0rnen/pre post design (@spotify)
- [314af93](https://github.com/thelastpickle/cassandra-reaper/commit/314af93db30f3aa84f80c7ed88ccfec2a864a495) Conflicts: 	src/test/java/com/spotify/reaper/service/RepairRunnerTest.java (@Bj0rnen)
- [95f1d5a](https://github.com/thelastpickle/cassandra-reaper/commit/95f1d5a56e2307177931a1e1338acacb5531bbe3) Fix compile errors (@Bj0rnen)
- [ec2635a](https://github.com/thelastpickle/cassandra-reaper/commit/ec2635a5f52b1f6b51aee2d19a83ae0827e7b625) Change code flow in RepairRunner to centralize handling of all repair outcomes (@Bj0rnen)
- [49e778c](https://github.com/thelastpickle/cassandra-reaper/commit/49e778c2436c5a0476d00eba9d09efebf8c11878) Add JmxConnectionFactory (@Bj0rnen)
- [7afbb81](https://github.com/thelastpickle/cassandra-reaper/commit/7afbb81d9677a390f1e562b0b0f54c5573d5086d) Optimize imports (@Bj0rnen)
- [a6577e2](https://github.com/thelastpickle/cassandra-reaper/commit/a6577e2828d09ffdcf266ffcc2116e646b46ad26) Complete hanging repair test case (@Bj0rnen)
- [f3e3a00](https://github.com/thelastpickle/cassandra-reaper/commit/f3e3a0043758bc9a5d8c120bc11dc5d8116c1431) [WIP] add test for hanging repairs (@Bj0rnen)
- [2da8630](https://github.com/thelastpickle/cassandra-reaper/commit/2da8630ebb5d643baffcfe9b907a54fcd4e85760) Keep an open JMX connection in RepairRunner at all times (@Bj0rnen)
- [#17](https://github.com/thelastpickle/cassandra-reaper/pull/17) Cleanup CLI (@spotify)
- [ab4423c](https://github.com/thelastpickle/cassandra-reaper/commit/ab4423cf3228165432296aa886b2d730ee06f909) Add JmxConnectionFactory (@Bj0rnen)
- [a98c2f9](https://github.com/thelastpickle/cassandra-reaper/commit/a98c2f9967e467592a1f568118d656f46ad2c8ff) Optimize imports (@Bj0rnen)
- [58d8a38](https://github.com/thelastpickle/cassandra-reaper/commit/58d8a3890e376867379879fb6b2567f74a1652d9) Make config use minutes for timeouts, while code uses seconds (@Bj0rnen)
- [87d9f3a](https://github.com/thelastpickle/cassandra-reaper/commit/87d9f3a48b56daf042431bb363a2421f50d644dc) Complete hanging repair test case (@Bj0rnen)
- [c42f702](https://github.com/thelastpickle/cassandra-reaper/commit/c42f70285e2ad56e4ee281d34fc54a66075cc66e) Keep an open JMX connection in RepairRunner at all times (@Bj0rnen)
- [5fbc3e8](https://github.com/thelastpickle/cassandra-reaper/commit/5fbc3e887a807590df9d62cf0fb36f439fc693d4) [WIP] add test for hanging repairs (@Bj0rnen)
- [acc8aca](https://github.com/thelastpickle/cassandra-reaper/commit/acc8aca985d3fe1968a8a5ee4f4beacd9d9c0aab) Change code flow in RepairRunner to centralize handling of all repair outcomes (@Bj0rnen)
- [eb2eb01](https://github.com/thelastpickle/cassandra-reaper/commit/eb2eb01a2d1c51b01a431226d4fecb30475bf649) Cleanup CLI
- [7a4e30e](https://github.com/thelastpickle/cassandra-reaper/commit/7a4e30ef5277ad17f9117889709e575e9cd95927) Conflicts: 	src/main/java/com/spotify/reaper/resources/TableResource.java 	src/main/java/com/spotify/reaper/service/RepairRunner.java 	src/test/java/com/spotify/reaper/service/RepairRunnerTest.java (@Bj0rnen)
- [f82cc0e](https://github.com/thelastpickle/cassandra-reaper/commit/f82cc0e907feb808dad86bc378156999b92cc7e8) Add JmxConnectionFactory (@Bj0rnen)
- [31ded88](https://github.com/thelastpickle/cassandra-reaper/commit/31ded88006157b7a10540be11089187f8204845d) Remove redundancy in a test (@Bj0rnen)
- [d632a50](https://github.com/thelastpickle/cassandra-reaper/commit/d632a50b23d1e602145e796651fe21309f0ae830) Pass runId to addRepairSegments (@Bj0rnen)
- [#15](https://github.com/thelastpickle/cassandra-reaper/pull/15) Code style cleanup (@spotify)
- [a0bac85](https://github.com/thelastpickle/cassandra-reaper/commit/a0bac85be11bf7cd87bfbb3446bc617cb6038672) Optimize imports (@Bj0rnen)
- [2e772e3](https://github.com/thelastpickle/cassandra-reaper/commit/2e772e398c67e98a5b3559f893883158d9fb1b52) Make config use minutes for timeouts, while code uses seconds (@Bj0rnen)
- [9cd3461](https://github.com/thelastpickle/cassandra-reaper/commit/9cd3461a121af199921b6eb8a0afa314b361dc16) Complete hanging repair test case (@Bj0rnen)
- [a19ddfb](https://github.com/thelastpickle/cassandra-reaper/commit/a19ddfbdb7673f26dd8ba1928defeb9f8266fe76) Code style cleanup
- [4c8ccb7](https://github.com/thelastpickle/cassandra-reaper/commit/4c8ccb76401a256e464bd8ba8ac1a3ec88c65846) [WIP] add test for hanging repairs (@Bj0rnen)
- [7e04424](https://github.com/thelastpickle/cassandra-reaper/commit/7e04424315282e3bdfd84bf040ce738420111f9c) Merge branch 'master' into Bj0rnen/sustainJMX (@Bj0rnen)
- [c66544c](https://github.com/thelastpickle/cassandra-reaper/commit/c66544cf9eb5593f212d2d0be7498dd1a88e4828) Keep an open JMX connection in RepairRunner at all times (@Bj0rnen)
- [0009be5](https://github.com/thelastpickle/cassandra-reaper/commit/0009be5d6f72537aa12d098cd3101a317789cf76) Remove "Simple" in SimpleRepairRunnerTest too (@Bj0rnen)
- [3675ca3](https://github.com/thelastpickle/cassandra-reaper/commit/3675ca3c9a9912bddf83caa3d08f971a4d55fa93) Rename SimpleRepairRunner to RepairRunner (@Bj0rnen)
- [fca4951](https://github.com/thelastpickle/cassandra-reaper/commit/fca495180c0ae6027dddb8b88b5e6352b1f58e6f) fixing repair resume after restart (@varjoranta)
- [31aab0c](https://github.com/thelastpickle/cassandra-reaper/commit/31aab0c3721c82ebbcadbef10bb181b43038d05f) add HUP signal handler skeleton (@varjoranta)
- [79324c8](https://github.com/thelastpickle/cassandra-reaper/commit/79324c87eba018aa779583116af62e6450ddd2dc) Merge branch 'zvo/setStartEndTime' (@varjoranta)
- [cace66c](https://github.com/thelastpickle/cassandra-reaper/commit/cace66c44a7208027aa814791e955febd94883ef) Set repair run start and end time
- [2a08e08](https://github.com/thelastpickle/cassandra-reaper/commit/2a08e08cdf8e518a24ebf7ff0d19a990363bf88e) make repair timeout configurable (@varjoranta)
- [5987787](https://github.com/thelastpickle/cassandra-reaper/commit/598778703949aad0662637c01020138fd5dc70a4) add upstart support and bump debian version (@varjoranta)
- [8357b65](https://github.com/thelastpickle/cassandra-reaper/commit/8357b652e6d920b6a530528274efdb689624c3be) Use correct instert statement when inserting repair segments
- [2ab352e](https://github.com/thelastpickle/cassandra-reaper/commit/2ab352e4ffa02b6ba011e5b859e762f4342fc60f) add SQL for dropping existing database for cleanup purposes (@varjoranta)
- [170bbf6](https://github.com/thelastpickle/cassandra-reaper/commit/170bbf636d705785a2ac0cf43b6bdff38d704671) Fix wrong default JMX port (@Bj0rnen)
- [fe3e1fc](https://github.com/thelastpickle/cassandra-reaper/commit/fe3e1fc4b4336e1e948bdfa41660d28680717537) Fix two bugs in SimpleRepairRunner and remove old RepairRunner (@Bj0rnen)
- [e360ac9](https://github.com/thelastpickle/cassandra-reaper/commit/e360ac91bc291b8475469dc4ba44dc890bbffbd8) Stop using RepairRunner (@Bj0rnen)
- [#13](https://github.com/thelastpickle/cassandra-reaper/pull/13) Bj0rnen/simple repair runner (@spotify)
- [b65514b](https://github.com/thelastpickle/cassandra-reaper/commit/b65514bf1231674e60f5506aaacc397338d9b2db) Update repairCommandId in storage (@Bj0rnen)
- [abb47d5](https://github.com/thelastpickle/cassandra-reaper/commit/abb47d51e10751d082a7edf97b93aa7056f11115) The SimpleRepairRunner with the ability to handle service restart and repair timeouts (@Bj0rnen)
- [f22f681](https://github.com/thelastpickle/cassandra-reaper/commit/f22f681dd37e27b26fcf6e4c83d335c8cbaef732) Core classes now have a more neat way of getting copies with new values (@Bj0rnen)
- [#12](https://github.com/thelastpickle/cassandra-reaper/pull/12) add methods for getting running repair runs (@varjoranta)
- [b197b7e](https://github.com/thelastpickle/cassandra-reaper/commit/b197b7e6854b5c3a9b41e95b04a943247997f968) add methods for getting running repair runs (@varjoranta)
- [#11](https://github.com/thelastpickle/cassandra-reaper/pull/11) separate view objects for REST API from core objects (@varjoranta)
- [f01e4ed](https://github.com/thelastpickle/cassandra-reaper/commit/f01e4edf97a9f261cb9b41eb140b6678c104890d) separate view objects for REST API from core objects (@varjoranta)
- [#10](https://github.com/thelastpickle/cassandra-reaper/pull/10) fix database interface issue on batch insert return type (@varjoranta)
- [6e7f361](https://github.com/thelastpickle/cassandra-reaper/commit/6e7f361b835f5d1c3adefc6e351b1fe6c9713caa) add more status and listing commands to CLI (@varjoranta)
- [1b8db3a](https://github.com/thelastpickle/cassandra-reaper/commit/1b8db3a5b6a9ee2982b3f5872dd0d9fcb99c8477) fix database interface issue on batch insert return type (@varjoranta)
- [#9](https://github.com/thelastpickle/cassandra-reaper/pull/9) fix storage layer issues, readme, and improve cli (@varjoranta)
- [8c6ea31](https://github.com/thelastpickle/cassandra-reaper/commit/8c6ea319a66f22ed8cc044e77a11d2cbf65c9671) fix database storage layer related issues (@varjoranta)
- [66ea9d6](https://github.com/thelastpickle/cassandra-reaper/commit/66ea9d606b59a8cbe95c76d43d7b73e7a4ba261a) improving the spreaper CLI (@varjoranta)
- [d904d1c](https://github.com/thelastpickle/cassandra-reaper/commit/d904d1c84c285eb1c9e0339b7b908ce2f56b0216) fix some readme formatting issues (@varjoranta)
- [#8](https://github.com/thelastpickle/cassandra-reaper/pull/8) Connect to valid coordinator when triggering repair (@spotify)
- [cb3cb09](https://github.com/thelastpickle/cassandra-reaper/commit/cb3cb09c0b889769cb55053dd85bf84b3394bcfd) Connect to valid coordinator when triggering repair (@Bj0rnen)
- [#7](https://github.com/thelastpickle/cassandra-reaper/pull/7) update README (@varjoranta)
- [2b85fe4](https://github.com/thelastpickle/cassandra-reaper/commit/2b85fe409ce082b2f59f5b895eef2d8e9f831a34) update README (@varjoranta)
- [#6](https://github.com/thelastpickle/cassandra-reaper/pull/6) fixed Postgres related storage issues (@varjoranta)
- [8de0139](https://github.com/thelastpickle/cassandra-reaper/commit/8de013998566f526c076adfd27e5afeccabe6fe6) fixed Postgres related storage issues (@varjoranta)
- [#5](https://github.com/thelastpickle/cassandra-reaper/pull/5) Update README.md (@echoajohnson)
- [eb8f38d](https://github.com/thelastpickle/cassandra-reaper/commit/eb8f38d235064e05f9c1ed79d0c6c34fc5939a61) Update README.md (@echoajohnson)
- [143e457](https://github.com/thelastpickle/cassandra-reaper/commit/143e45777be00eda16e6f946da87f59eabbad59c) A new type RingRange represents token ranges (@Bj0rnen)
- [1f5b7c2](https://github.com/thelastpickle/cassandra-reaper/commit/1f5b7c2be78db29428d41e1327f16f0735e2b17c) add list all clusters endpoint (@varjoranta)
- [470fef1](https://github.com/thelastpickle/cassandra-reaper/commit/470fef19b34c0bc034873161cd8a55645f8ed2ac) add initial reaper CLI Python executable (@varjoranta)
- [dced10f](https://github.com/thelastpickle/cassandra-reaper/commit/dced10fc3ce477d18bb063a6df88a95042442caf) rename host parameter to seedHost on cluster resource (@varjoranta)
- [891c9e5](https://github.com/thelastpickle/cassandra-reaper/commit/891c9e52f4b2a7369267a6807e5614c88e018cbb) ISO 8601 formatted JSON for RepairRun (@Bj0rnen)
- [4eb44a6](https://github.com/thelastpickle/cassandra-reaper/commit/4eb44a665a523462201fa311fe3aaf28dcfce55e) Increment RepairRun.completedSegments on finished segment (@Bj0rnen)
- [be31956](https://github.com/thelastpickle/cassandra-reaper/commit/be319560f16b39880b426b53148d6b5808d12bda) Add and initialize (total/completed)SegmentCount in RepairRun (@Bj0rnen)
- [67b39cc](https://github.com/thelastpickle/cassandra-reaper/commit/67b39cc28e6fead610c373fb80a42d8d4fdabc81) Remove reparirRunLock from RepairRun (@Bj0rnen)
- [8128d96](https://github.com/thelastpickle/cassandra-reaper/commit/8128d96b22e9be9f2c5f8b14710aca0fe6c8edb4) Synchronize RepairRunner methods that may conflict (@Bj0rnen)
- [800a24a](https://github.com/thelastpickle/cassandra-reaper/commit/800a24a32e0709eb2f301ef2bb5d091651d8ce6c) [healthcheck] added basic healthcheck for storage connectivity (@varjoranta)
- [d5b61b4](https://github.com/thelastpickle/cassandra-reaper/commit/d5b61b4d94b49e2386d6d6ef379b2ba6cd310b95) Add RepairRun GET resource (@Bj0rnen)
- [d5a6d09](https://github.com/thelastpickle/cassandra-reaper/commit/d5a6d09dcaa30727491d31bcc3cd4346b2654eea) finished initial postgresql storage implementation (@varjoranta)
- [e0ac9f0](https://github.com/thelastpickle/cassandra-reaper/commit/e0ac9f0bcc06200fe9a735a50bee8b662d67500f) RepairRunner respects intensity (@Bj0rnen)
- [5f54c7a](https://github.com/thelastpickle/cassandra-reaper/commit/5f54c7a9bad0c72ff85ee8d59d72cb140dd49799) [storage] add more of postgres storage implementation (@varjoranta)
- [e246274](https://github.com/thelastpickle/cassandra-reaper/commit/e2462740e4afbe8dd9c3d42c95dea0e0ba7ed418) Update a faulty copyright year (@Bj0rnen)
- [13dd50a](https://github.com/thelastpickle/cassandra-reaper/commit/13dd50a3859113c6765da76905750ec889d5d219) Add license (@Bj0rnen)
- [9f8aa80](https://github.com/thelastpickle/cassandra-reaper/commit/9f8aa8047b865dfb57377da19d9e094bf361e7df) Found code that's never reached (@Bj0rnen)
- [83bea6c](https://github.com/thelastpickle/cassandra-reaper/commit/83bea6cde12b97936aa7cdfabb05041d8d34fff7) Fix numerous bugs (@Bj0rnen)
- [9c149e4](https://github.com/thelastpickle/cassandra-reaper/commit/9c149e4c30d0f73eaf73b857c9725c4df72937f3) First working repair run (@Bj0rnen)
- [a4a6c25](https://github.com/thelastpickle/cassandra-reaper/commit/a4a6c2522b90235f543a6f9075770b7adfd06c1e) Fix bug where addTable crashes when called a second time with the same table (@Bj0rnen)
- [ce19e16](https://github.com/thelastpickle/cassandra-reaper/commit/ce19e16738ec48fb9cdb57cce6d7bc8e5f59ee41) small fixes of conditions (@Bj0rnen)
- [021b69e](https://github.com/thelastpickle/cassandra-reaper/commit/021b69e1b9b1dc613f8fab4d2afc15f86c875df2) finished initial repair runner implementation (@varjoranta)
- [6ecc29c](https://github.com/thelastpickle/cassandra-reaper/commit/6ecc29c3dd70ae236a14e48635bd6aec07bdcdc7) almost finished the runner implementation, still wip (@varjoranta)
- [1281a1a](https://github.com/thelastpickle/cassandra-reaper/commit/1281a1a7fe76c433552e7a49451c7b7e26f5cc8c) Implement all IStorage methods in MemoryStorage (@Bj0rnen)
- [98369db](https://github.com/thelastpickle/cassandra-reaper/commit/98369db683e7b109b3d5e440d3e185c80d7a409d) add more RepairRunner implementation, still wip (@varjoranta)
- [ad5fafc](https://github.com/thelastpickle/cassandra-reaper/commit/ad5fafc482da076ba6548eb67f49abc585eaf671) adding initial RepairRunner implementation, wip (@varjoranta)
- [6318037](https://github.com/thelastpickle/cassandra-reaper/commit/63180376bdcf47de8bc31d63c0c8ad9fe87f1531) addRepairSegments takes builders (@Bj0rnen)
- [eb3c1c8](https://github.com/thelastpickle/cassandra-reaper/commit/eb3c1c83bdde26a327cbe6394a78096176c087f1) Major overhaul of core types. (@Bj0rnen)
- [e6ff918](https://github.com/thelastpickle/cassandra-reaper/commit/e6ff91847bd2251a71bf42215e199ad5c1268528) add initial skeleton of repair runner (@varjoranta)
- [aa86dca](https://github.com/thelastpickle/cassandra-reaper/commit/aa86dca3d90d5e52962552461494a23bbb4007b2) cleaning up the storage API to be consistent (@varjoranta)
- [0928b5f](https://github.com/thelastpickle/cassandra-reaper/commit/0928b5f8ec7fa4c41c1af55c92eca4ac448b8b25) Create repairRun and generate repairSegments on call for manual repairRun (@Bj0rnen)
- [52ed592](https://github.com/thelastpickle/cassandra-reaper/commit/52ed592882d47a70985d69043670d0ebdfba34bc) Remove list of repairSegments from repairRun (@Bj0rnen)
- [5d29a6d](https://github.com/thelastpickle/cassandra-reaper/commit/5d29a6d5d975b7c968cff6bbc1c95b3489f6b24d) Report on attempt to add same cluster again (@Bj0rnen)
- [b97086b](https://github.com/thelastpickle/cassandra-reaper/commit/b97086b5713c668a9eeb4613638ae6f784ab8a13) Convert tokens to BigInteger (@Bj0rnen)
- [dfb602d](https://github.com/thelastpickle/cassandra-reaper/commit/dfb602deaa02cc39c047e0b12bd5e67cb35b6bb5) Repair ranges are exclusive-inclusive rather than inclusive-exclusive (@Bj0rnen)
- [a84ee3f](https://github.com/thelastpickle/cassandra-reaper/commit/a84ee3fbc049bfcce169158ff1ca35329ff4f609) add first implementation of table resource, removed strategy (@varjoranta)
- [443b5b7](https://github.com/thelastpickle/cassandra-reaper/commit/443b5b7596c89c8297afd132631ce390ddec07ec) fix existing resource skeleton and database schema for cluster (@varjoranta)
- [d778b18](https://github.com/thelastpickle/cassandra-reaper/commit/d778b182aaed9d564a788ccf6aced2652805b863) added back wrongly deleted class JmxProxy (@varjoranta)
- [1e1229a](https://github.com/thelastpickle/cassandra-reaper/commit/1e1229a189d809fa899500b5d5042fa7376cca2f) Conflicts: 	src/main/java/com/spotify/reaper/cassandra/ClusterInfo.java 	src/main/java/com/spotify/reaper/cassandra/IClusterInfo.java 	src/main/java/com/spotify/reaper/cassandra/JMXProxy.java (@varjoranta)
- [c205c35](https://github.com/thelastpickle/cassandra-reaper/commit/c205c350dd9955471ba201905ad79622ba3aa39b) Add method for converting cluster name to symbolic name valid for URLs (@Bj0rnen)
- [3296e8e](https://github.com/thelastpickle/cassandra-reaper/commit/3296e8ed77753da1ceb4abc8b0a98a550eba3115) JmxProxy class responsible for communication between Reaper and Cassandra
- [3f69dbe](https://github.com/thelastpickle/cassandra-reaper/commit/3f69dbe78cbd97a489cd5363e587a0baf9cca1f6) Renamed *Builder classes (@Bj0rnen)
- [7ce4381](https://github.com/thelastpickle/cassandra-reaper/commit/7ce4381a3ddcc98fa96cfa277af0bc38ea1502bd) add server parameters and postgres dependency (@varjoranta)
- [e7c863b](https://github.com/thelastpickle/cassandra-reaper/commit/e7c863b752b4e2ec2ce5231a8a7f4e15a9b13230) Simple in-memory storage (@Bj0rnen)
- [b01ffb3](https://github.com/thelastpickle/cassandra-reaper/commit/b01ffb3cd9af17dfe4e1fa76e09578fac16740fe) Don't require name in POST for /cluster (@Bj0rnen)
- [cb02702](https://github.com/thelastpickle/cassandra-reaper/commit/cb027024e92b8775499baaf818627967f17fe977) wip, continue implementation of cluster resource (@varjoranta)
- [#3](https://github.com/thelastpickle/cassandra-reaper/pull/3) Bj0rnen/total segment count (@spotify)
- [cd0c28a](https://github.com/thelastpickle/cassandra-reaper/commit/cd0c28a9f2ce4a8d0914d01b6a81cb109ded4374) New tests and safety checks for the new generateSegments (@Bj0rnen)
- [b433a86](https://github.com/thelastpickle/cassandra-reaper/commit/b433a8669af5f140a1624039b29c800da83afa29) Let generateSegments take total number of segments instead of segments per subrange (@Bj0rnen)
- [c19968b](https://github.com/thelastpickle/cassandra-reaper/commit/c19968b8934efb42e711281a150a3a844897987f) add initial storage implementation skeleton (@varjoranta)
- [0c50b4e](https://github.com/thelastpickle/cassandra-reaper/commit/0c50b4ecb8efb65d87ef5cb00e9c943ad880b4d6) Merge branch 'zvo/get-tokens' (@Bj0rnen)
- [1b88d4f](https://github.com/thelastpickle/cassandra-reaper/commit/1b88d4f1a919abafe097179a703b05fe23c4a8ec) Conflicts: 	src/main/java/com/spotify/reaper/core/RepairSegment.java (@Bj0rnen)
- [5dc93ab](https://github.com/thelastpickle/cassandra-reaper/commit/5dc93abb17cd58968fe1b2d97611082baa8e8e5f) Getters and builders for all core classes (@Bj0rnen)
- [2649855](https://github.com/thelastpickle/cassandra-reaper/commit/2649855dab0f35e0f249fadd49157b15ec8a8fc5) Generating repair segments
- [#1](https://github.com/thelastpickle/cassandra-reaper/pull/1) Add fields to core classes (@Bj0rnen)
- [cf7edd4](https://github.com/thelastpickle/cassandra-reaper/commit/cf7edd40a42c34ed28f2bf9c84a4ffc664d5e212) Add fields to core classes (@Bj0rnen)
- [297ab0d](https://github.com/thelastpickle/cassandra-reaper/commit/297ab0deba6897fabc2e26e42ce807d9d65deb04) Added JMX client who can fetch tokens from the ring
- [3b1eed2](https://github.com/thelastpickle/cassandra-reaper/commit/3b1eed265661768a69d9d98716d2317c9bab2eb7) add skeleton implementation for storage and repair strategies (@varjoranta)
- [7090fda](https://github.com/thelastpickle/cassandra-reaper/commit/7090fda6d7f355dda75baca97ff8c3113ae7d24b) add basic Travis configuration (@varjoranta)
- [5dfe868](https://github.com/thelastpickle/cassandra-reaper/commit/5dfe8680c1d432c91749fd5c73dee5f41f2f8a18) Increase logging level (@Bj0rnen)
- [bcf1966](https://github.com/thelastpickle/cassandra-reaper/commit/bcf19666f81289c14321f203e9ddd2c48ca4e9a3) add maintainer and uploaders for debian package (@varjoranta)
- [4b19ae8](https://github.com/thelastpickle/cassandra-reaper/commit/4b19ae87b74cd1b602ca1ccf16fe20490f401196) Add configuration plus logging (@Bj0rnen)
- [dada348](https://github.com/thelastpickle/cassandra-reaper/commit/dada3482fef5748a79cd99a2df795e97feea160f) Add resource skeletons (@Bj0rnen)
- [1517782](https://github.com/thelastpickle/cassandra-reaper/commit/1517782a02c69f55f1949ee5eda63e0ab41f6446) Add 'server' argument when starting the App.
- [7da611c](https://github.com/thelastpickle/cassandra-reaper/commit/7da611ce0e4bcff61bfe6c41ab0ceb37bf941927) remove unneeded supervision build line from debian rules (@varjoranta)
- [b663b94](https://github.com/thelastpickle/cassandra-reaper/commit/b663b946f80d20eb04c8562edbb60f5046296ec1) Remove spotify-settings.xml dependency from mvn (@varjoranta)
- [e9dc5d3](https://github.com/thelastpickle/cassandra-reaper/commit/e9dc5d30219c6d4d90e901788c812acd4dc4aff4) fix maven dependency (@varjoranta)
- [d2c04a7](https://github.com/thelastpickle/cassandra-reaper/commit/d2c04a79bbac42787f6499c96291198287a330a0) Fix broken maven dependency (@Bj0rnen)
- [3dfcd52](https://github.com/thelastpickle/cassandra-reaper/commit/3dfcd52cccaae8f97447ad2ac7d359a230d85dc1) Added binary (@Bj0rnen)
- [04e9c32](https://github.com/thelastpickle/cassandra-reaper/commit/04e9c323613f164bd6440c73b625cb103ed506d5) Initial build (@Bj0rnen)
- [a9facf3](https://github.com/thelastpickle/cassandra-reaper/commit/a9facf30dfd073fc5853722bfda3133a522ff40d) [dropwizard] initial dropwizard application skeleton (@varjoranta)
