#!/bin/bash
set -e

# remove the old blacklist file as it blacklists mpt3sas driver needed by deb9
if [ -f /etc/modprobe.d/sga-blacklist.conf ]; then
  rm /etc/modprobe.d/sga-blacklist.conf
fi


# Update module dependency lists for qed.  Version stuff is because depmod
# apparently gets information from uname -a or similar, so depmod -a breaks
# if run within a chroot on a build server running a newer kernel.  Note:
# avoid calling on /lib/modules/netapp-sga in PGE root as that will fail.
# For now we just require that the module directory starts with a number,
# such as 3.16.0-0.bpo.4-amd64 3.16.0-4-amd64 3.2.0-4-amd64 4.9.0-6-amd64
versions=$(ls -t /lib/modules | grep '^[0-9]\+.*')
if [[ -n $versions ]]; then
    for version in "$versions"; do
        depmod -a $version
    done
else
    echo "WARNING: no kernel versions under /lib/modules; running depmod -a"
    depmod -a
fi

# Rebuild initramfs so it includes the SGA-specific driver kmods
update-initramfs -k all -u
