/*
* Copyright 2015 NetApp, Inc.
*
* You may modify and redistribute the device driver code under the
* GNU General Public License (a copy of which is attached hereto as
* Exhibit A) published by the Free Software Foundation (version 2).
*
 *
 * EXHIBIT A
*
 *                                GNU GENERAL PUBLIC LICENSE
*                                   Version 2, June 1991
*
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
*  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*  Everyone is permitted to copy and distribute verbatim copies
*  of this license document, but changing it is not allowed.
*
 *                                                Preamble
*
 *   The licenses for most software are designed to take away your
* freedom to share and change it.  By contrast, the GNU General Public
* License is intended to guarantee your freedom to share and change free
* software--to make sure the software is free for all its users.  This
* General Public License applies to most of the Free Software
* Foundation's software and to any other program whose authors commit to
* using it.  (Some other Free Software Foundation software is covered by
* the GNU Lesser General Public License instead.)  You can apply it to
* your programs, too.
*
 *   When we speak of free software, we are referring to freedom, not
* price.  Our General Public Licenses are designed to make sure that you
* have the freedom to distribute copies of free software (and charge for
* this service if you wish), that you receive source code or can get it
* if you want it, that you can change the software or use pieces of it
* in new free programs; and that you know you can do these things.
*
 *   To protect your rights, we need to make restrictions that forbid
* anyone to deny you these rights or to ask you to surrender the rights.
* These restrictions translate to certain responsibilities for you if you
* distribute copies of the software, or if you modify it.
*
 *   For example, if you distribute copies of such a program, whether
* gratis or for a fee, you must give the recipients all the rights that
* you have.  You must make sure that they, too, receive or can get the
* source code.  And you must show them these terms so they know their
* rights.
*
 *   We protect your rights with two steps: (1) copyright the software, and
* (2) offer you this license which gives you legal permission to copy,
* distribute and/or modify the software.
*
 *   Also, for each author's protection and ours, we want to make certain
* that everyone understands that there is no warranty for this free
* software.  If the software is modified by someone else and passed on, we
* want its recipients to know that what they have is not the original, so
* that any problems introduced by others will not reflect on the original
* authors' reputations.
*
 *   Finally, any free program is threatened constantly by software
* patents.  We wish to avoid the danger that redistributors of a free
* program will individually obtain patent licenses, in effect making the
* program proprietary.  To prevent this, we have made it clear that any
* patent must be licensed for everyone's free use or not licensed at all.
*
 *   The precise terms and conditions for copying, distribution and
* modification follow.
*
 *                                GNU GENERAL PUBLIC LICENSE
*    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
*
 *   0. This License applies to any program or other work which contains
* a notice placed by the copyright holder saying it may be distributed
* under the terms of this General Public License.  The "Program", below,
* refers to any such program or work, and a "work based on the Program"
* means either the Program or any derivative work under copyright law:
* that is to say, a work containing the Program or a portion of it,
* either verbatim or with modifications and/or translated into another
* language.  (Hereinafter, translation is included without limitation in
* the term "modification".)  Each licensee is addressed as "you".
*
 * Activities other than copying, distribution and modification are not
* covered by this License; they are outside its scope.  The act of
* running the Program is not restricted, and the output from the Program
* is covered only if its contents constitute a work based on the
* Program (independent of having been made by running the Program).
* Whether that is true depends on what the Program does.
*
 *   1. You may copy and distribute verbatim copies of the Program's
* source code as you receive it, in any medium, provided that you
* conspicuously and appropriately publish on each copy an appropriate
* copyright notice and disclaimer of warranty; keep intact all the
* notices that refer to this License and to the absence of any warranty;
* and give any other recipients of the Program a copy of this License
* along with the Program.
*
 * You may charge a fee for the physical act of transferring a copy, and
* you may at your option offer warranty protection in exchange for a fee.
*
 *   2. You may modify your copy or copies of the Program or any portion
* of it, thus forming a work based on the Program, and copy and
* distribute such modifications or work under the terms of Section 1
* above, provided that you also meet all of these conditions:
*
 *     a) You must cause the modified files to carry prominent notices
*     stating that you changed the files and the date of any change.
*
 *     b) You must cause any work that you distribute or publish, that in
*     whole or in part contains or is derived from the Program or any
*     part thereof, to be licensed as a whole at no charge to all third
*     parties under the terms of this License.
*
 *     c) If the modified program normally reads commands interactively
*     when run, you must cause it, when started running for such
*     interactive use in the most ordinary way, to print or display an
*     announcement including an appropriate copyright notice and a
*     notice that there is no warranty (or else, saying that you provide
*     a warranty) and that users may redistribute the program under
*     these conditions, and telling the user how to view a copy of this
*     License.  (Exception: if the Program itself is interactive but
*     does not normally print such an announcement, your work based on
*     the Program is not required to print an announcement.)
*
 * These requirements apply to the modified work as a whole.  If
* identifiable sections of that work are not derived from the Program,
* and can be reasonably considered independent and separate works in
* themselves, then this License, and its terms, do not apply to those
* sections when you distribute them as separate works.  But when you
* distribute the same sections as part of a whole which is a work based
* on the Program, the distribution of the whole must be on the terms of
* this License, whose permissions for other licensees extend to the
* entire whole, and thus to each and every part regardless of who wrote it.
*
 * Thus, it is not the intent of this section to claim rights or contest
* your rights to work written entirely by you; rather, the intent is to
* exercise the right to control the distribution of derivative or
* collective works based on the Program.
*
 * In addition, mere aggregation of another work not based on the Program
* with the Program (or with a work based on the Program) on a volume of
* a storage or distribution medium does not bring the other work under
* the scope of this License.
*
 *   3. You may copy and distribute the Program (or a work based on it,
* under Section 2) in object code or executable form under the terms of
* Sections 1 and 2 above provided that you also do one of the following:
*
 *     a) Accompany it with the complete corresponding machine-readable
*     source code, which must be distributed under the terms of Sections
*     1 and 2 above on a medium customarily used for software interchange; or,
*
 *     b) Accompany it with a written offer, valid for at least three
*     years, to give any third party, for a charge no more than your
*     cost of physically performing source distribution, a complete
*     machine-readable copy of the corresponding source code, to be
*     distributed under the terms of Sections 1 and 2 above on a medium
*     customarily used for software interchange; or,
*
 *     c) Accompany it with the information you received as to the offer
*     to distribute corresponding source code.  (This alternative is
*     allowed only for noncommercial distribution and only if you
*     received the program in object code or executable form with such
*     an offer, in accord with Subsection b above.)
*
 * The source code for a work means the preferred form of the work for
* making modifications to it.  For an executable work, complete source
* code means all the source code for all modules it contains, plus any
* associated interface definition files, plus the scripts used to
* control compilation and installation of the executable.  However, as a
* special exception, the source code distributed need not include
* anything that is normally distributed (in either source or binary
* form) with the major components (compiler, kernel, and so on) of the
* operating system on which the executable runs, unless that component
* itself accompanies the executable.
*
 * If distribution of executable or object code is made by offering
* access to copy from a designated place, then offering equivalent
* access to copy the source code from the same place counts as
* distribution of the source code, even though third parties are not
* compelled to copy the source along with the object code.
*
 *   4. You may not copy, modify, sublicense, or distribute the Program
* except as expressly provided under this License.  Any attempt
* otherwise to copy, modify, sublicense or distribute the Program is
* void, and will automatically terminate your rights under this License.
* However, parties who have received copies, or rights, from you under
* this License will not have their licenses terminated so long as such
* parties remain in full compliance.
*
 *   5. You are not required to accept this License, since you have not
* signed it.  However, nothing else grants you permission to modify or
* distribute the Program or its derivative works.  These actions are
* prohibited by law if you do not accept this License.  Therefore, by
* modifying or distributing the Program (or any work based on the
* Program), you indicate your acceptance of this License to do so, and
* all its terms and conditions for copying, distributing or modifying
* the Program or works based on it.
*
 *   6. Each time you redistribute the Program (or any work based on the
* Program), the recipient automatically receives a license from the
* original licensor to copy, distribute or modify the Program subject to
* these terms and conditions.  You may not impose any further
* restrictions on the recipients' exercise of the rights granted herein.
* You are not responsible for enforcing compliance by third parties to
* this License.
*
 *   7. If, as a consequence of a court judgment or allegation of patent
* infringement or for any other reason (not limited to patent issues),
* conditions are imposed on you (whether by court order, agreement or
* otherwise) that contradict the conditions of this License, they do not
* excuse you from the conditions of this License.  If you cannot
* distribute so as to satisfy simultaneously your obligations under this
* License and any other pertinent obligations, then as a consequence you
* may not distribute the Program at all.  For example, if a patent
* license would not permit royalty-free redistribution of the Program by
* all those who receive copies directly or indirectly through you, then
* the only way you could satisfy both it and this License would be to
* refrain entirely from distribution of the Program.
*
 * If any portion of this section is held invalid or unenforceable under
* any particular circumstance, the balance of the section is intended to
* apply and the section as a whole is intended to apply in other
* circumstances.
*
 * It is not the purpose of this section to induce you to infringe any
* patents or other property right claims or to contest validity of any
* such claims; this section has the sole purpose of protecting the
* integrity of the free software distribution system, which is
* implemented by public license practices.  Many people have made
* generous contributions to the wide range of software distributed
* through that system in reliance on consistent application of that
* system; it is up to the author/donor to decide if he or she is willing
* to distribute software through any other system and a licensee cannot
* impose that choice.
*
 * This section is intended to make thoroughly clear what is believed to
* be a consequence of the rest of this License.
*
 *   8. If the distribution and/or use of the Program is restricted in
* certain countries either by patents or by copyrighted interfaces, the
* original copyright holder who places the Program under this License
* may add an explicit geographical distribution limitation excluding
* those countries, so that distribution is permitted only in or among
* countries not thus excluded.  In such case, this License incorporates
* the limitation as if written in the body of this License.
*
 *   9. The Free Software Foundation may publish revised and/or new versions
* of the General Public License from time to time.  Such new versions will
* be similar in spirit to the present version, but may differ in detail to
* address new problems or concerns.
*
 * Each version is given a distinguishing version number.  If the Program
* specifies a version number of this License which applies to it and "any
* later version", you have the option of following the terms and conditions
* either of that version or of any later version published by the Free
* Software Foundation.  If the Program does not specify a version number of
* this License, you may choose any version ever published by the Free Software
* Foundation.
*
 *   10. If you wish to incorporate parts of the Program into other free
* programs whose distribution conditions are different, write to the author
* to ask for permission.  For software which is copyrighted by the Free
* Software Foundation, write to the Free Software Foundation; we sometimes
* make exceptions for this.  Our decision will be guided by the two goals
* of preserving the free status of all derivatives of our free software and
* of promoting the sharing and reuse of software generally.
*
 *                                                NO WARRANTY
*
 *   11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
* FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
* OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
* PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
* OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
* TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
* PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
* REPAIR OR CORRECTION.
*
 *   12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
* WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
* REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
* INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
* OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
* TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
* YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
* PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGES.
*/
 

/*
 * Copyright (c) 2012 HON HAI PRECISION IND.CO.,LTD. (FOXCONN)
 */
#ifndef __EP8324_DEF_H__
#define __EP8324_DEF_H__

#include <linux/types.h>
#include <linux/pci.h>
#include <linux/list.h>
#include <linux/firmware.h>
#include <linux/ioctl.h>


#ifdef DEBUG
#define dprintk(fmt...) printk(KERN_INFO fmt)
#else
#define dprintk(fmt...) do { } while(0)
#endif

#define EP8324_DRIVER_NAME "ep8324_diag"
#define EP8324_DEV "ep8324"

#define PCI_DEVICE_ID_QLOGIC_ISP2031    0x2031
#define PCI_DEVICE_ID_QLOGIC_ISP8031    0x8031
#define PCI_DEVICE_ID_QLOGIC_ISP8032    0x8032
#define PCI_DEVICE_ID_QLOGIC_ISP8030    0x8030
#define PCI_DEVICE_ID_QLOGIC_EP2831     0x2831
#define PCI_DEVICE_ID_QLOGIC_EP8831     0x8831
#define PCI_DEVICE_ID_QLOGIC_EP8832     0x8832
#define PCI_DEVICE_ID_QLOGIC_EP8830     0x8830

/*
 * Data bit definitions
 */
#define BIT_0	0x1
#define BIT_1	0x2
#define BIT_2	0x4
#define BIT_3	0x8
#define BIT_4	0x10
#define BIT_5	0x20
#define BIT_6	0x40
#define BIT_7	0x80
#define BIT_8	0x100
#define BIT_9	0x200
#define BIT_10	0x400
#define BIT_11	0x800
#define BIT_12	0x1000
#define BIT_13	0x2000
#define BIT_14	0x4000
#define BIT_15	0x8000
#define BIT_16	0x10000
#define BIT_17	0x20000
#define BIT_18	0x40000
#define BIT_19	0x80000
#define BIT_20	0x100000
#define BIT_21	0x200000
#define BIT_22	0x400000
#define BIT_23	0x800000
#define BIT_24	0x1000000
#define BIT_25	0x2000000
#define BIT_26	0x4000000
#define BIT_27	0x8000000
#define BIT_28	0x10000000
#define BIT_29	0x20000000
#define BIT_30	0x40000000
#define BIT_31	0x80000000

#define LSB(x)	((uint8_t)(x))
#define MSB(x)	((uint8_t)((uint16_t)(x) >> 8))

#define LSW(x)	((uint16_t)(x))
#define MSW(x)	((uint16_t)((uint32_t)(x) >> 16))

#define LSD(x)	((uint32_t)((uint64_t)(x)))
#define MSD(x)	((uint32_t)((((uint64_t)(x)) >> 16) >> 16))

/*
 * I/O register
*/
#define RD_REG_BYTE(addr)		readb(addr)
#ifndef CONFIG_LSISAS3108_ROOT_COMPLEX
#define RD_REG_WORD(addr)		readw(addr)
#define RD_REG_DWORD(addr)		readl(addr)
#else
/* FIXME: LSI rootcomplex */
#define RD_REG_WORD(addr)		__raw_readw(addr)
#define RD_REG_DWORD(addr)		__raw_readl(addr)
#endif
#define RD_REG_BYTE_RELAXED(addr)	readb_relaxed(addr)
#define RD_REG_WORD_RELAXED(addr)	readw_relaxed(addr)
#define RD_REG_DWORD_RELAXED(addr)	readl_relaxed(addr)
#define WRT_REG_BYTE(addr, data)	writeb(data,addr)
#ifndef CONFIG_LSISAS3108_ROOT_COMPLEX
#define WRT_REG_WORD(addr, data)	writew(data,addr)
#define WRT_REG_DWORD(addr, data)	writel(data,addr)
#else
/* FIXME: LSI rootcomplex */
#define WRT_REG_WORD(addr, data)	__raw_writew(data,addr)
#define WRT_REG_DWORD(addr, data)	__raw_writel(data,addr)
#endif

/* Firmware Status Codes */
#define FSC_ROM_READY      0
#define FSC_ROM_BUSY       4
#define FSC_BOARD_ERROR    0xf
#define FSC_FW_RUNNING     0x8400
#define FSC_FW_ERROR       0x8401

#define MAILBOX_REGISTER_COUNT		32
/*
 * mailbox command complete status codes
 */
#define MBS_COMMAND_COMPLETE		0x4000
#define MBS_INVALID_COMMAND		0x4001
#define MBS_HOST_INTERFACE_ERROR	0x4002
#define MBS_TEST_FAILED			0x4003
#define MBS_COMMAND_ERROR		0x4005
#define MBS_COMMAND_PARAMETER_ERROR	0x4006
#define MBS_PORT_ID_USED		0x4007
#define MBS_LOOP_ID_USED		0x4008
#define MBS_ALL_IDS_IN_USE		0x4009
#define MBS_NOT_LOGGED_IN		0x400A
#define MBS_LINK_DOWN_ERROR		0x400B
#define MBS_DIAG_ECHO_TEST_ERROR	0x400C

/*
 * mailbox commands
 */
#define MBC_LOAD_RAM			1	/* Load RAM. */
#define MBC_EXECUTE_FIRMWARE		2	/* Execute firmware. */
#define MBC_WRITE_RAM_WORD		4	/* Write RAM word. */
#define MBC_READ_RAM_WORD		5	/* Read RAM word. */
#define MBC_MAILBOX_REGISTER_TEST	6	/* Wrap incoming mailboxes */
#define MBC_VERIFY_CHECKSUM		7	/* Verify checksum. */
#define MBC_GET_FIRMWARE_VERSION	8	/* Get firmware revision. */
#define MBC_LOAD_RISC_RAM		9	/* Load RAM command. */
#define MBC_DUMP_RISC_RAM		0xa	/* Dump RAM command. */
#define MBC_LOAD_RISC_RAM_EXTENDED	0xb	/* Load RAM extended. */
#define MBC_DUMP_RISC_RAM_EXTENDED	0xc	/* Dump RAM extended. */
#define MBC_WRITE_RAM_WORD_EXTENDED	0xd	/* Write RAM word extended */
#define MBC_READ_RAM_EXTENDED		0xf	/* Read RAM extended. */
#define MBC_IOCB_COMMAND		0x12	/* Execute IOCB command. */
#define MBC_STOP_FIRMWARE		0x14	/* Stop firmware. */
#define MBC_ABORT_COMMAND		0x15	/* Abort IOCB command. */
#define MBC_ABORT_DEVICE		0x16	/* Abort device (ID/LUN). */
#define MBC_ABORT_TARGET		0x17	/* Abort target (ID). */
#define MBC_RESET			0x18	/* Reset. */
#define MBC_GET_ADAPTER_LOOP_ID		0x20	/* Get loop id of ISP2200. */
#define MBC_GET_RETRY_COUNT		0x22	/* Get f/w retry cnt/delay. */
#define MBC_DISABLE_VI			0x24	/* Disable VI operation. */
#define MBC_ENABLE_VI			0x25	/* Enable VI operation. */
#define MBC_GET_FIRMWARE_OPTION		0x28	/* Get Firmware Options. */
#define MBC_SET_FIRMWARE_OPTION		0x38	/* Set Firmware Options. */
#define MBC_LOOP_PORT_BYPASS		0x40	/* Loop Port Bypass. */
#define MBC_LOOP_PORT_ENABLE		0x41	/* Loop Port Enable. */
#define MBC_GET_RESOURCE_COUNTS		0x42	/* Get Resource Counts. */
#define MBC_NON_PARTICIPATE		0x43	/* Non-Participating Mode. */
#define MBC_DIAGNOSTIC_ECHO		0x44	/* Diagnostic echo. */
#define MBC_DIAGNOSTIC_LOOP_BACK	0x45	/* Diagnostic loop back. */
#define MBC_ONLINE_SELF_TEST		0x46	/* Online self-test. */
#define MBC_ENHANCED_GET_PORT_DATABASE	0x47	/* Get port database + login */
#define MBC_CONFIGURE_VF		0x4b	/* Configure VFs */
#define MBC_RESET_LINK_STATUS		0x52	/* Reset Link Error Status */
#define MBC_IOCB_COMMAND_A64		0x54	/* Execute IOCB command (64) */
#define MBC_SEND_RNID_ELS		0x57	/* Send RNID ELS request */
#define MBC_SET_RNID_PARAMS		0x59	/* Set RNID parameters */
#define MBC_GET_RNID_PARAMS		0x5a	/* Data Rate */
#define MBC_DATA_RATE			0x5d	/* Get RNID parameters */
#define MBC_INITIALIZE_FIRMWARE		0x60	/* Initialize firmware */
#define MBC_INITIATE_LIP		0x62	/* Initiate Loop */
						/* Initialization Procedure */
#define MBC_GET_FC_AL_POSITION_MAP	0x63	/* Get FC_AL Position Map. */
#define MBC_GET_PORT_DATABASE		0x64	/* Get Port Database. */
#define MBC_CLEAR_ACA			0x65	/* Clear ACA. */
#define MBC_TARGET_RESET		0x66	/* Target Reset. */
#define MBC_CLEAR_TASK_SET		0x67	/* Clear Task Set. */
#define MBC_ABORT_TASK_SET		0x68	/* Abort Task Set. */
#define MBC_GET_FIRMWARE_STATE		0x69	/* Get firmware state. */
#define MBC_GET_PORT_NAME		0x6a	/* Get port name. */
#define MBC_GET_LINK_STATUS		0x6b	/* Get port link status. */
#define MBC_LIP_RESET			0x6c	/* LIP reset. */
#define MBC_SEND_SNS_COMMAND		0x6e	/* Send Simple Name Server */
						/* commandd. */
#define MBC_LOGIN_FABRIC_PORT		0x6f	/* Login fabric port. */
#define MBC_SEND_CHANGE_REQUEST		0x70	/* Send Change Request. */
#define MBC_LOGOUT_FABRIC_PORT		0x71	/* Logout fabric port. */
#define MBC_LIP_FULL_LOGIN		0x72	/* Full login LIP. */
#define MBC_LOGIN_LOOP_PORT		0x74	/* Login Loop Port. */
#define MBC_PORT_NODE_NAME_LIST		0x75	/* Get port/node name list. */
#define MBC_INITIALIZE_RECEIVE_QUEUE	0x77	/* Initialize receive queue */
#define MBC_UNLOAD_IP			0x79	/* Shutdown IP */
#define MBC_GET_ID_LIST			0x7C	/* Get Port ID list. */
#define MBC_SEND_LFA_COMMAND		0x7D	/* Send Loop Fabric Address */
#define MBC_LUN_RESET			0x7E	/* Send LUN reset */

#define MBC_SERDES_PARAMS		0x10	/* Serdes Tx Parameters. */
#define MBC_GET_IOCB_STATUS		0x12	/* Get IOCB status command. */
#define MBC_PORT_PARAMS			0x1A	/* Port iDMA Parameters. */
#define MBC_GET_TIMEOUT_PARAMS		0x22	/* Get FW timeouts. */
#define MBC_TRACE_CONTROL		0x27	/* Trace control command. */
#define MBC_GEN_SYSTEM_ERROR		0x2a	/* Generate System Error. */
#define MBC_WRITE_SFP			0x30	/* Write SFP Data. */
#define MBC_READ_SFP			0x31	/* Read SFP Data. */
#define MBC_SET_TIMEOUT_PARAMS		0x32	/* Set FW timeouts. */
#define MBC_MID_INITIALIZE_FIRMWARE	0x48	/* MID Initialize firmware. */
#define MBC_MID_GET_VP_DATABASE		0x49	/* MID Get VP Database. */
#define MBC_MID_GET_VP_ENTRY		0x4a	/* MID Get VP Entry. */
#define MBC_HOST_MEMORY_COPY		0x53	/* Host Memory Copy. */
#define MBC_SEND_RNFT_ELS		0x5e	/* Send RNFT ELS request */
#define MBC_GET_LINK_PRIV_STATS		0x6d	/* Get link & private data. */
#define MBC_SET_VENDOR_ID		0x76	/* Set Vendor ID. */
#define MBC_SET_PORT_CONFIG		0x122	/* Set port configuration */
#define MBC_GET_PORT_CONFIG		0x123	/* Get port configuration */


/* Mailbox bit definitions for out_mb and in_mb */
#define	MBX_31		BIT_31
#define	MBX_30		BIT_30
#define	MBX_29		BIT_29
#define	MBX_28		BIT_28
#define	MBX_27		BIT_27
#define	MBX_26		BIT_26
#define	MBX_25		BIT_25
#define	MBX_24		BIT_24
#define	MBX_23		BIT_23
#define	MBX_22		BIT_22
#define	MBX_21		BIT_21
#define	MBX_20		BIT_20
#define	MBX_19		BIT_19
#define	MBX_18		BIT_18
#define	MBX_17		BIT_17
#define	MBX_16		BIT_16
#define	MBX_15		BIT_15
#define	MBX_14		BIT_14
#define	MBX_13		BIT_13
#define	MBX_12		BIT_12
#define	MBX_11		BIT_11
#define	MBX_10		BIT_10
#define	MBX_9		BIT_9
#define	MBX_8		BIT_8
#define	MBX_7		BIT_7
#define	MBX_6		BIT_6
#define	MBX_5		BIT_5
#define	MBX_4		BIT_4
#define	MBX_3		BIT_3
#define	MBX_2		BIT_2
#define	MBX_1		BIT_1
#define	MBX_0		BIT_0


#define FA_RISC_CODE_SEGMENTS	2
struct device_reg_fc {
#define FARX_DATA_FLAG	BIT_31
	uint32_t flash_addr;		/* Flash/NVRAM BIOS address. */

	uint32_t flash_data;		/* Flash/NVRAM BIOS data. */

	uint32_t ctrl_status;		/* Control/Status. */
#define CSRX_FLASH_ACCESS_ERROR	BIT_18	/* Flash/NVRAM Access Error. */
#define CSRX_DMA_ACTIVE		BIT_17	/* DMA Active status. */
#define CSRX_DMA_SHUTDOWN	BIT_16	/* DMA Shutdown control status. */
#define CSRX_FUNCTION		BIT_15	/* Function number. */
					/* Max Write Burst byte count. */
#define CSRX_MAX_WRT_BURST_MASK	(BIT_5|BIT_4)
#define MWB_512_BYTES		(0 << 4)
#define MWB_1024_BYTES		(1 << 4)
#define MWB_2048_BYTES		(2 << 4)
#define MWB_4096_BYTES		(3 << 4)

#define CSRX_64BIT_SLOT		BIT_2	/* PCI 64-Bit Bus Slot. */
#define CSRX_FLASH_ENABLE	BIT_1	/* Flash BIOS Read/Write enable. */
#define CSRX_ISP_SOFT_RESET	BIT_0	/* ISP soft reset. */

	uint32_t ictrl;			/* Interrupt control. */
#define ICRX_EN_RISC_INT	BIT_3	/* Enable RISC interrupts on PCI. */

	uint32_t istatus;		/* Interrupt status. */
#define ISRX_RISC_INT		BIT_3	/* RISC interrupt. */

	uint32_t unused_1[2];		/* Gap. */

					/* Request Queue. */
	uint32_t req_q_in;		/*  In-Pointer. */
	uint32_t req_q_out;		/*  Out-Pointer. */
					/* Response Queue. */
	uint32_t rsp_q_in;		/*  In-Pointer. */
	uint32_t rsp_q_out;		/*  Out-Pointer. */
					/* Priority Request Queue. */
	uint32_t preq_q_in;		/*  In-Pointer. */
	uint32_t preq_q_out;		/*  Out-Pointer. */

	uint32_t unused_2[2];		/* Gap. */

					/* ATIO Queue. */
	uint32_t atio_q_in;		/*  In-Pointer. */
	uint32_t atio_q_out;		/*  Out-Pointer. */

	uint32_t host_status;
#define HSRX_RISC_INT		BIT_15	/* RISC to Host interrupt. */
#define HSRX_RISC_PAUSED	BIT_8	/* RISC Paused. */

	uint32_t hccr;			/* Host command & control register. */
					/* HCCR statuses. */
#define HCCRX_HOST_INT		BIT_6	/* Host to RISC interrupt bit. */
#define HCCRX_RISC_RESET	BIT_5	/* RISC Reset mode bit. */
					/* HCCR commands. */
					/* NOOP. */
#define HCCRX_NOOP		0x00000000
					/* Set RISC Reset. */
#define HCCRX_SET_RISC_RESET	0x10000000
					/* Clear RISC Reset. */
#define HCCRX_CLR_RISC_RESET	0x20000000
					/* Set RISC Pause. */
#define HCCRX_SET_RISC_PAUSE	0x30000000
					/* Releases RISC Pause. */
#define HCCRX_REL_RISC_PAUSE	0x40000000
					/* Set HOST to RISC interrupt. */
#define HCCRX_SET_HOST_INT	0x50000000
					/* Clear HOST to RISC interrupt. */
#define HCCRX_CLR_HOST_INT	0x60000000
					/* Clear RISC to PCI interrupt. */
#define HCCRX_CLR_RISC_INT	0xA0000000

	uint32_t gpiod;			/* GPIO Data register. */

					/* LED update mask. */
#define GPDX_LED_UPDATE_MASK	(BIT_20|BIT_19|BIT_18)
					/* Data update mask. */
#define GPDX_DATA_UPDATE_MASK	(BIT_17|BIT_16)
					/* Data update mask. */
#define GPDX_DATA_UPDATE_2_MASK	(BIT_28|BIT_27|BIT_26|BIT_17|BIT_16)
					/* LED control mask. */
#define GPDX_LED_COLOR_MASK	(BIT_4|BIT_3|BIT_2)
					/* LED bit values. Color names as
					 * referenced in fw spec.
					 */
#define GPDX_LED_YELLOW_ON	BIT_2
#define GPDX_LED_GREEN_ON	BIT_3
#define GPDX_LED_AMBER_ON	BIT_4
					/* Data in/out. */
#define GPDX_DATA_INOUT		(BIT_1|BIT_0)

	uint32_t gpioe;			/* GPIO Enable register. */
					/* Enable update mask. */
#define GPEX_ENABLE_UPDATE_MASK	(BIT_17|BIT_16)
					/* Enable update mask. */
#define GPEX_ENABLE_UPDATE_2_MASK (BIT_28|BIT_27|BIT_26|BIT_17|BIT_16)
					/* Enable. */
#define GPEX_ENABLE		(BIT_1|BIT_0)

	uint32_t iobase_addr;		/* I/O Bus Base Address register. */

	uint32_t unused_3[10];		/* Gap. */

	uint16_t mailbox0;
	uint16_t mailbox1;
	uint16_t mailbox2;
	uint16_t mailbox3;
	uint16_t mailbox4;
	uint16_t mailbox5;
	uint16_t mailbox6;
	uint16_t mailbox7;
	uint16_t mailbox8;
	uint16_t mailbox9;
	uint16_t mailbox10;
	uint16_t mailbox11;
	uint16_t mailbox12;
	uint16_t mailbox13;
	uint16_t mailbox14;
	uint16_t mailbox15;
	uint16_t mailbox16;
	uint16_t mailbox17;
	uint16_t mailbox18;
	uint16_t mailbox19;
	uint16_t mailbox20;
	uint16_t mailbox21;
	uint16_t mailbox22;
	uint16_t mailbox23;
	uint16_t mailbox24;
	uint16_t mailbox25;
	uint16_t mailbox26;
	uint16_t mailbox27;
	uint16_t mailbox28;
	uint16_t mailbox29;
	uint16_t mailbox30;
	uint16_t mailbox31;

	uint32_t iobase_window;
	uint32_t iobase_c4;
	uint32_t iobase_c8;
	uint32_t unused_4_1[6];		/* Gap. */
	uint32_t iobase_q;
	uint32_t unused_5[2];		/* Gap. */
	uint32_t iobase_select;
	uint32_t unused_6[2];		/* Gap. */
	uint32_t iobase_sdata;
};

struct device_reg_mq {
	uint32_t req_q_in;
	uint32_t req_q_out;
	uint32_t rsp_q_in;
	uint32_t rsp_q_out;
};

typedef union {
	struct device_reg_fc fc;
	struct device_reg_mq mq;
} device_reg_t;


typedef struct {
	uint32_t	out_mb;		/* outbound from driver */
	uint32_t	in_mb;			/* Incoming from RISC */
	uint16_t	mb[MAILBOX_REGISTER_COUNT];
#define	MBX_TOV_SECONDS	30
	uint32_t	tov;
} mbx_cmd_t;

/*
 * Initialization Control Block.
 * Little endian except where noted.
 */
#define	FC_ICB_VERSION 1
struct init_cb_fc {
	uint16_t version;
	uint16_t reserved_1;

	uint16_t frame_payload_size;
	uint16_t reserved_2;
	uint16_t exchange_count;

	uint16_t hard_previous_addr;

#define WWN_SIZE		8
	uint8_t port_name[WWN_SIZE];/* 0C - 13 */
	uint8_t node_name[WWN_SIZE];/* 14 - 1B */

	uint16_t response_q_inpointer;
	uint16_t request_q_outpointer;

	uint16_t login_retry_count;

	uint16_t reserved_3; /* 22 - 23 */

	uint16_t response_q_length;
	uint16_t request_q_length;

	uint16_t link_down_on_nos;

	uint16_t reserved_4; /* 2A - 2B */

	uint32_t request_q_address[2]; /* 2C - 33 */
	uint32_t response_q_address[2]; /* 34 - 3B */
	uint32_t reserved_5[2]; /* 3C - 43 */

	uint16_t msix_vec_to_rsp_que;
	uint16_t msix_vec_to_atio_que;

	uint8_t reserved_6[4]; /* 48 - 4B */

	uint16_t atio_q_inpointer;
	uint16_t atio_q_length;
	uint32_t atio_q_address[2]; /* 50 - 57 */

	uint16_t interrupt_delay_timer;		/* 100us increments. */
	uint16_t login_timeout;

	uint32_t firmware_options_1;
	uint32_t firmware_options_2;
#define FC_DATA_RATE_AUTO    2
#define FC_DATA_RATE_4G      3
#define FC_DATA_RATE_8G      4
#define FC_DATA_RATE_16G     5
	uint32_t firmware_options_3;

#define DEFAULT_QUE_QOS 5
	uint16_t qos; /* QoS—Priority Value or Percentage of Link Bandwidth */

	uint8_t  reserved_7[6]; /* 6A - 6F */

	uint8_t enode_mac[6]; /* 70 - 75 */

	uint16_t discovery_timeout;

	uint8_t reserved_8[8];
};

typedef union {
	struct init_cb_fc fc;
} init_cb_t;

struct ep8324_hw_data {

	struct pci_dev    *pdev;
	volatile struct {
		uint32_t    mbox_int		:1;
		uint32_t    dcbx_int        :1;
		uint32_t    enable_64bit_addressing:1;
	} flags;

	spinlock_t  hardware_lock ____cacheline_aligned;
	int	        bars;

	uint8_t     port_no; /* Physical port of adapter */

#define MIN_IOBASE_LEN          0x100
	device_reg_t __iomem    *iobase;
	device_reg_t __iomem    *mqiobase;
#if 0 // SGA
	uint32_t		*bar0u;
#endif // 0 // SGA

	/* operation function for FC/FCoE or iSCSI */
	struct hw_operations    *hw_ops;

	volatile uint16_t    mailbox_out[MAILBOX_REGISTER_COUNT];
	mbx_cmd_t            *mcp;

#define EP8324_FC          1
#define EP8324_FCOE        2
#define EP8324_ISCSI       3
#define EP8324_ETHERNET    4
	uint32_t        func_type;

#define RISC_ROM_MODE    1
#define RISC_FW_MODE     2
#define RISC_FW_ERROR    3
	uint32_t        risc_mode;

#define EP8324_DMA_BUF_SIZE    (4096)
	void              *dma_buf;
	dma_addr_t        dma;

	init_cb_t         *init_cb;
	dma_addr_t        init_cb_dma;

#define QUEUE_ENTRY_CNT      2048
#define IOCB_SIZE            64
	void              *req_q;
	dma_addr_t        req_q_dma;
	void              *rsp_q;
    dma_addr_t        rsp_q_dma;

	struct ep8324_pci_func    *func;

#define FARX_ACCESS_FLASH_CONF    0x7FFD0000
#define FARX_ACCESS_FLASH_DATA    0x7F800000
#define FA_FLASH_LAYOUT_ADDR      0xFC400
	uint32_t        flt_region_flt;
#define FA_FC_FIRMWARE_ADDR      (0x900000 >> 2)
#define FA_FCOE_FIRMWARE_ADDR    (0x880000 >> 2)
	uint32_t        flt_region_fw;
	uint32_t        flt_region_fdt;

	uint32_t        fdt_wrt_disable;
	uint32_t        fdt_erase_cmd;
	uint32_t        fdt_block_size;
	uint32_t        fdt_unprotect_sec_cmd;
	uint32_t        fdt_protect_sec_cmd;

	uint32_t      loopback_path;
	uint32_t      data_transfer_count;
	uint32_t      seg_count;
	void          *tx_data;
	dma_addr_t    tx_data_dma;
	void          *tx_dsd;
	dma_addr_t    tx_dsd_dma;

	void          *rx_data;
	dma_addr_t    rx_data_dma;
	void          *rx_dsd;
	dma_addr_t    rx_dsd_dma;
};

#define OPTROM_SIZE          0x1000000
#define OPTROM_BURST_SIZE    0x1000
#define OPTROM_BURST_DWORDS	(OPTROM_BURST_SIZE / 4)

/* Flash Description Table ***************************************************/

struct ep8324_fdt_layout {
	uint8_t sig[4];
	uint16_t version;
	uint16_t len;
	uint16_t checksum;
	uint8_t unused1[2];
	uint8_t model[16];
	uint16_t man_id;
	uint16_t id;
	uint8_t flags;
	uint8_t erase_cmd;
	uint8_t alt_erase_cmd;
	uint8_t wrt_enable_cmd;
	uint8_t wrt_enable_bits;
	uint8_t wrt_sts_reg_cmd;
	uint8_t unprotect_sec_cmd;
	uint8_t read_man_id_cmd;
	uint32_t block_size;
	uint32_t alt_block_size;
	uint32_t flash_size;
	uint32_t wrt_enable_data;
	uint8_t read_id_addr_len;
	uint8_t wrt_disable_bits;
	uint8_t read_dev_id_len;
	uint8_t chip_erase_cmd;
	uint16_t read_timeout;
	uint8_t protect_sec_cmd;
	uint8_t unused2[65];
};

/* Flash Layout Table ********************************************************/

struct ep8324_flt_location {
	uint8_t sig[4];
	uint16_t start_lo;
	uint16_t start_hi;
	uint8_t version;
	uint8_t unused[5];
	uint16_t checksum;
};

struct ep8324_flt_header {
	uint16_t version;
	uint16_t length;
	uint16_t checksum;
	uint16_t unused;
};

#define FLT_REG_FW_FC		0x01
#define FLT_REG_FW_FCOE		0x0a
#define FLT_REG_BOOT_CODE	0x07
#define FLT_REG_VPD_0		0x14
#define FLT_REG_NVRAM_0		0x15
#define FLT_REG_VPD_1		0x16
#define FLT_REG_NVRAM_1		0x17
#define FLT_REG_FDT		0x1a
#define FLT_REG_FLT		0x1c
#define FLT_REG_HW_EVENT_0	0x1d
#define FLT_REG_HW_EVENT_1	0x1f
#define FLT_REG_NPIV_CONF_0	0x29
#define FLT_REG_NPIV_CONF_1	0x2a
#define FLT_REG_GOLD_FW		0x2f
#define FLT_REG_FCP_PRIO_0	0x87
#define FLT_REG_FCP_PRIO_1	0x88

struct ep8324_flt_region {
	uint32_t code;
	uint32_t size;
	uint32_t start;
	uint32_t end;
};

struct hw_operations {
	int (*pci_config) (struct ep8324_hw_data*);
	void (*reset_chip) (struct ep8324_hw_data*);
	int (*iospace_config)(struct ep8324_hw_data*);
	void (*poll) (struct ep8324_hw_data*);
	int (*load_risc) (struct ep8324_hw_data*, uint32_t *);
	int (*init_firmware) (struct ep8324_hw_data*);
};

#define MAX_PORTS_PER_HIC    2
struct ep8324_pci_func {
	struct list_head list;

#define NAME_STR_SIZE    20
	char        well_known_name[NAME_STR_SIZE + 1];
	uint16_t    bus;
	uint8_t     dev_num;
	uint8_t     func_num;

	struct ep8324_hw_data *hw;
};

struct fw_blob {
	char *name;
	uint32_t segs[4];
	const struct firmware *fw;
};

/* Data Segment Descriptor */
struct dsd {
		uint16_t data_seg_address[4];
		uint16_t data_seg_length[2];
};

#define EP8324_IOCTL_LIST_FUNC            _IO('e', 1)
#define EP8324_IOCTL_SETUP_CHIP           _IO('e', 2)
#define EP8324_IOCTL_RESET_CHIP           _IO('e', 3)
#define EP8324_IOCTL_SEND_MBX             _IOWR('e', 4, struct ep8324_ioctl_cb)
#define EP8324_IOCTL_LOAD_RISC            _IOWR('e', 5, struct ep8324_ioctl_cb)
#define EP8324_IOCTL_SFP_READ             _IOWR('e', 6, struct ep8324_ioctl_cb)
#define EP8324_IOCTL_SFP_WRITE            _IOWR('e', 7, struct ep8324_ioctl_cb)
#define EP8324_IOCTL_SPI_READ             _IOWR('e', 8, struct ep8324_ioctl_cb)
#define EP8324_IOCTL_SPI_WRITE            _IOWR('e', 9, struct ep8324_ioctl_cb)
#define EP8324_IOCTL_LOOPBACK_TEST        _IOWR('e', 10, struct ep8324_ioctl_cb)
#define EP8324_IOCTL_ECHO_TEST            _IOWR('e', 11, struct ep8324_ioctl_cb)
#define EP8324_IOCTL_GET_DEVINFO          _IOWR('e', 12, struct ep8324_ioctl_cb)

#define SFP_EEPROM_SIZE      256
//#define DWORD_BUFFER_SIZE    64
#define DWORD_BUFFER_SIZE    1024	// Must match user space
struct ep8324_ioctl_cb {
	char well_known_name[NAME_STR_SIZE + 1];
	union {
		mbx_cmd_t    mc;

		struct {
			int         fwloadbin;
			uint32_t    srisc_address;
		} lrcb;

		struct {
			uint16_t    mb0;
			uint8_t     device_address;
			uint16_t    offset;
			uint16_t    size;
			uint8_t     data[SFP_EEPROM_SIZE];
		} sfpcb;

		struct {
			uint32_t     faddr;
			uint32_t     dwords;
			uint32_t     dword_buf[DWORD_BUFFER_SIZE];
		} spicb;

		struct {
			uint32_t     device;
			uint32_t     func_type;
			uint32_t     version_major;
			uint32_t     version_minor;
			uint32_t     version_sub;
			uint32_t     version_build;
		} devinfo;

		struct {
#define EP8324_LOOPBACK_SETUP      1
#define EP8324_LOOPBACK_EXECUTE    2
#define EP8324_LOOPBACK_CLEANUP    3
			uint32_t    cmd;
#define EP8324_LOOPBACK_NO_ERROR       0
#define EP8324_LOOPBACK_TEST_ERROR     1
#define EP8324_LOOPBACK_NO_MEMORY      2
#define EP8324_LOOPBACK_SETUP_ERROR    3
			uint32_t    result;
#define EP8324_EXTERNAL_LOOPBACK    0
#define EP8324_INTERNAL_LOOPBACK    1
			uint32_t    path;
#define EP8324_LINK_SPEED_AUTO    1
#define EP8324_LINK_SPEED_4G      2
#define EP8324_LINK_SPEED_8G      3
#define EP8324_LINK_SPEED_16G     4
			uint32_t    link_speed;
			uint32_t    seg_count;    /* tx/rx segment count */
			uint32_t    seg_length;   /* segment length */
			uint32_t    pattern;
			uint16_t    mb[6]; /* mailbox status 0, 1, 2 ,3, 18, 19 */
		} loopbackcb;

		struct {
			uint16_t    mb[3]; /* mailbox status 0, 1, 3 */
		} echocb;
	};
};


int ep8324_mailbox_command(struct ep8324_hw_data *ha, mbx_cmd_t *mcp);

long ep8324_ioctl(struct file *file, unsigned int cmd, unsigned long arg);

int ep8324_load_ram(struct ep8324_hw_data *ha, dma_addr_t req_dma,
		uint32_t risc_addr, uint32_t risc_code_size);

struct fw_blob * ep8324_request_firmware(struct ep8324_hw_data *ha);

void ep8324_release_firmware(struct fw_blob *blob);

int ep8324_read_flash_data(struct ep8324_hw_data *ha, uint32_t *dwptr, uint32_t faddr,
		uint32_t dwords);

#endif /* __EP8324_DEF_H__ */
