/*
* Copyright 2015 NetApp, Inc.
*
* You may modify and redistribute the device driver code under the
* GNU General Public License (a copy of which is attached hereto as
* Exhibit A) published by the Free Software Foundation (version 2).
*
 *
 * EXHIBIT A
*
 *                                GNU GENERAL PUBLIC LICENSE
*                                   Version 2, June 1991
*
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
*  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*  Everyone is permitted to copy and distribute verbatim copies
*  of this license document, but changing it is not allowed.
*
 *                                                Preamble
*
 *   The licenses for most software are designed to take away your
* freedom to share and change it.  By contrast, the GNU General Public
* License is intended to guarantee your freedom to share and change free
* software--to make sure the software is free for all its users.  This
* General Public License applies to most of the Free Software
* Foundation's software and to any other program whose authors commit to
* using it.  (Some other Free Software Foundation software is covered by
* the GNU Lesser General Public License instead.)  You can apply it to
* your programs, too.
*
 *   When we speak of free software, we are referring to freedom, not
* price.  Our General Public Licenses are designed to make sure that you
* have the freedom to distribute copies of free software (and charge for
* this service if you wish), that you receive source code or can get it
* if you want it, that you can change the software or use pieces of it
* in new free programs; and that you know you can do these things.
*
 *   To protect your rights, we need to make restrictions that forbid
* anyone to deny you these rights or to ask you to surrender the rights.
* These restrictions translate to certain responsibilities for you if you
* distribute copies of the software, or if you modify it.
*
 *   For example, if you distribute copies of such a program, whether
* gratis or for a fee, you must give the recipients all the rights that
* you have.  You must make sure that they, too, receive or can get the
* source code.  And you must show them these terms so they know their
* rights.
*
 *   We protect your rights with two steps: (1) copyright the software, and
* (2) offer you this license which gives you legal permission to copy,
* distribute and/or modify the software.
*
 *   Also, for each author's protection and ours, we want to make certain
* that everyone understands that there is no warranty for this free
* software.  If the software is modified by someone else and passed on, we
* want its recipients to know that what they have is not the original, so
* that any problems introduced by others will not reflect on the original
* authors' reputations.
*
 *   Finally, any free program is threatened constantly by software
* patents.  We wish to avoid the danger that redistributors of a free
* program will individually obtain patent licenses, in effect making the
* program proprietary.  To prevent this, we have made it clear that any
* patent must be licensed for everyone's free use or not licensed at all.
*
 *   The precise terms and conditions for copying, distribution and
* modification follow.
*
 *                                GNU GENERAL PUBLIC LICENSE
*    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
*
 *   0. This License applies to any program or other work which contains
* a notice placed by the copyright holder saying it may be distributed
* under the terms of this General Public License.  The "Program", below,
* refers to any such program or work, and a "work based on the Program"
* means either the Program or any derivative work under copyright law:
* that is to say, a work containing the Program or a portion of it,
* either verbatim or with modifications and/or translated into another
* language.  (Hereinafter, translation is included without limitation in
* the term "modification".)  Each licensee is addressed as "you".
*
 * Activities other than copying, distribution and modification are not
* covered by this License; they are outside its scope.  The act of
* running the Program is not restricted, and the output from the Program
* is covered only if its contents constitute a work based on the
* Program (independent of having been made by running the Program).
* Whether that is true depends on what the Program does.
*
 *   1. You may copy and distribute verbatim copies of the Program's
* source code as you receive it, in any medium, provided that you
* conspicuously and appropriately publish on each copy an appropriate
* copyright notice and disclaimer of warranty; keep intact all the
* notices that refer to this License and to the absence of any warranty;
* and give any other recipients of the Program a copy of this License
* along with the Program.
*
 * You may charge a fee for the physical act of transferring a copy, and
* you may at your option offer warranty protection in exchange for a fee.
*
 *   2. You may modify your copy or copies of the Program or any portion
* of it, thus forming a work based on the Program, and copy and
* distribute such modifications or work under the terms of Section 1
* above, provided that you also meet all of these conditions:
*
 *     a) You must cause the modified files to carry prominent notices
*     stating that you changed the files and the date of any change.
*
 *     b) You must cause any work that you distribute or publish, that in
*     whole or in part contains or is derived from the Program or any
*     part thereof, to be licensed as a whole at no charge to all third
*     parties under the terms of this License.
*
 *     c) If the modified program normally reads commands interactively
*     when run, you must cause it, when started running for such
*     interactive use in the most ordinary way, to print or display an
*     announcement including an appropriate copyright notice and a
*     notice that there is no warranty (or else, saying that you provide
*     a warranty) and that users may redistribute the program under
*     these conditions, and telling the user how to view a copy of this
*     License.  (Exception: if the Program itself is interactive but
*     does not normally print such an announcement, your work based on
*     the Program is not required to print an announcement.)
*
 * These requirements apply to the modified work as a whole.  If
* identifiable sections of that work are not derived from the Program,
* and can be reasonably considered independent and separate works in
* themselves, then this License, and its terms, do not apply to those
* sections when you distribute them as separate works.  But when you
* distribute the same sections as part of a whole which is a work based
* on the Program, the distribution of the whole must be on the terms of
* this License, whose permissions for other licensees extend to the
* entire whole, and thus to each and every part regardless of who wrote it.
*
 * Thus, it is not the intent of this section to claim rights or contest
* your rights to work written entirely by you; rather, the intent is to
* exercise the right to control the distribution of derivative or
* collective works based on the Program.
*
 * In addition, mere aggregation of another work not based on the Program
* with the Program (or with a work based on the Program) on a volume of
* a storage or distribution medium does not bring the other work under
* the scope of this License.
*
 *   3. You may copy and distribute the Program (or a work based on it,
* under Section 2) in object code or executable form under the terms of
* Sections 1 and 2 above provided that you also do one of the following:
*
 *     a) Accompany it with the complete corresponding machine-readable
*     source code, which must be distributed under the terms of Sections
*     1 and 2 above on a medium customarily used for software interchange; or,
*
 *     b) Accompany it with a written offer, valid for at least three
*     years, to give any third party, for a charge no more than your
*     cost of physically performing source distribution, a complete
*     machine-readable copy of the corresponding source code, to be
*     distributed under the terms of Sections 1 and 2 above on a medium
*     customarily used for software interchange; or,
*
 *     c) Accompany it with the information you received as to the offer
*     to distribute corresponding source code.  (This alternative is
*     allowed only for noncommercial distribution and only if you
*     received the program in object code or executable form with such
*     an offer, in accord with Subsection b above.)
*
 * The source code for a work means the preferred form of the work for
* making modifications to it.  For an executable work, complete source
* code means all the source code for all modules it contains, plus any
* associated interface definition files, plus the scripts used to
* control compilation and installation of the executable.  However, as a
* special exception, the source code distributed need not include
* anything that is normally distributed (in either source or binary
* form) with the major components (compiler, kernel, and so on) of the
* operating system on which the executable runs, unless that component
* itself accompanies the executable.
*
 * If distribution of executable or object code is made by offering
* access to copy from a designated place, then offering equivalent
* access to copy the source code from the same place counts as
* distribution of the source code, even though third parties are not
* compelled to copy the source along with the object code.
*
 *   4. You may not copy, modify, sublicense, or distribute the Program
* except as expressly provided under this License.  Any attempt
* otherwise to copy, modify, sublicense or distribute the Program is
* void, and will automatically terminate your rights under this License.
* However, parties who have received copies, or rights, from you under
* this License will not have their licenses terminated so long as such
* parties remain in full compliance.
*
 *   5. You are not required to accept this License, since you have not
* signed it.  However, nothing else grants you permission to modify or
* distribute the Program or its derivative works.  These actions are
* prohibited by law if you do not accept this License.  Therefore, by
* modifying or distributing the Program (or any work based on the
* Program), you indicate your acceptance of this License to do so, and
* all its terms and conditions for copying, distributing or modifying
* the Program or works based on it.
*
 *   6. Each time you redistribute the Program (or any work based on the
* Program), the recipient automatically receives a license from the
* original licensor to copy, distribute or modify the Program subject to
* these terms and conditions.  You may not impose any further
* restrictions on the recipients' exercise of the rights granted herein.
* You are not responsible for enforcing compliance by third parties to
* this License.
*
 *   7. If, as a consequence of a court judgment or allegation of patent
* infringement or for any other reason (not limited to patent issues),
* conditions are imposed on you (whether by court order, agreement or
* otherwise) that contradict the conditions of this License, they do not
* excuse you from the conditions of this License.  If you cannot
* distribute so as to satisfy simultaneously your obligations under this
* License and any other pertinent obligations, then as a consequence you
* may not distribute the Program at all.  For example, if a patent
* license would not permit royalty-free redistribution of the Program by
* all those who receive copies directly or indirectly through you, then
* the only way you could satisfy both it and this License would be to
* refrain entirely from distribution of the Program.
*
 * If any portion of this section is held invalid or unenforceable under
* any particular circumstance, the balance of the section is intended to
* apply and the section as a whole is intended to apply in other
* circumstances.
*
 * It is not the purpose of this section to induce you to infringe any
* patents or other property right claims or to contest validity of any
* such claims; this section has the sole purpose of protecting the
* integrity of the free software distribution system, which is
* implemented by public license practices.  Many people have made
* generous contributions to the wide range of software distributed
* through that system in reliance on consistent application of that
* system; it is up to the author/donor to decide if he or she is willing
* to distribute software through any other system and a licensee cannot
* impose that choice.
*
 * This section is intended to make thoroughly clear what is believed to
* be a consequence of the rest of this License.
*
 *   8. If the distribution and/or use of the Program is restricted in
* certain countries either by patents or by copyrighted interfaces, the
* original copyright holder who places the Program under this License
* may add an explicit geographical distribution limitation excluding
* those countries, so that distribution is permitted only in or among
* countries not thus excluded.  In such case, this License incorporates
* the limitation as if written in the body of this License.
*
 *   9. The Free Software Foundation may publish revised and/or new versions
* of the General Public License from time to time.  Such new versions will
* be similar in spirit to the present version, but may differ in detail to
* address new problems or concerns.
*
 * Each version is given a distinguishing version number.  If the Program
* specifies a version number of this License which applies to it and "any
* later version", you have the option of following the terms and conditions
* either of that version or of any later version published by the Free
* Software Foundation.  If the Program does not specify a version number of
* this License, you may choose any version ever published by the Free Software
* Foundation.
*
 *   10. If you wish to incorporate parts of the Program into other free
* programs whose distribution conditions are different, write to the author
* to ask for permission.  For software which is copyrighted by the Free
* Software Foundation, write to the Free Software Foundation; we sometimes
* make exceptions for this.  Our decision will be guided by the two goals
* of preserving the free status of all derivatives of our free software and
* of promoting the sharing and reuse of software generally.
*
 *                                                NO WARRANTY
*
 *   11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
* FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
* OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
* PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
* OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
* TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
* PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
* REPAIR OR CORRECTION.
*
 *   12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
* WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
* REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
* INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
* OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
* TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
* YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
* PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGES.
*/
 

/*
 * Copyright (c) 2012 HON HAI PRECISION IND.CO.,LTD. (FOXCONN)
 */
#include <linux/delay.h>
#include <linux/sched.h>

#include "ep8324_def.h"

extern int fwloadbin;

int fc_data_rate = FC_DATA_RATE_AUTO;

static int
ep8324_fc_iospace_config(struct ep8324_hw_data *ha)
{

	if (pci_request_selected_regions(ha->pdev, ha->bars,
	    EP8324_DRIVER_NAME)) {
		printk(KERN_ERR "Failed to reserve PIO/MMIO regions (%s), aborting.\n",
		    pci_name(ha->pdev));

		goto iospace_error_exit;
	}

	/* Use MMIO operations for all accesses. */
	if (!(pci_resource_flags(ha->pdev, 0) & IORESOURCE_MEM)) {
		printk(KERN_ERR "Invalid pci I/O region size (%s).\n",
		    pci_name(ha->pdev));
		goto iospace_error_exit;
	}
	if (pci_resource_len(ha->pdev, 0) < MIN_IOBASE_LEN) {
		printk(KERN_ERR "Invalid PCI mem region size (%s), aborting\n",
			pci_name(ha->pdev));
		goto iospace_error_exit;
	}

#ifndef CONFIG_LSISAS3108_ROOT_COMPLEX
	ha->iobase = ioremap(pci_resource_start(ha->pdev, 0), MIN_IOBASE_LEN);
#else
	ha->iobase = ioremap(pci_resource_start(ha->pdev, 0) | 0x7000000000ULL, MIN_IOBASE_LEN); /* FIXME: LSI rootcomplex */
#endif
	if (!ha->iobase) {
		printk(KERN_ERR "Cannot remap MMIO (%s), aborting.\n",
		    pci_name(ha->pdev));
		goto iospace_error_exit;
	}

#ifndef CONFIG_LSISAS3108_ROOT_COMPLEX
	ha->mqiobase = ioremap(pci_resource_start(ha->pdev, 4),
			pci_resource_len(ha->pdev, 4));
#else
	ha->mqiobase = ioremap(pci_resource_start(ha->pdev, 4) | 0x7000000000ULL, /* FIXME: LSI rootcomplex */
			pci_resource_len(ha->pdev, 4));
#endif

	if (!ha->mqiobase) {
		printk(KERN_ERR "BAR2/region4 not enabled\n");
		goto iospace_error_exit;
	}

	/* TODO: will we need mq and msix ? */

#if 0 // SGA bar0 Version access
	/* SGA Get direct access to resource 0 for gp registers */
	ha->bar0u = (uint32_t*) pci_ioremap_bar(ha->pdev, 0);
	if (!ha->bar0u) {
		printk(KERN_ERR "BAR0 not mappable for SGA\n");
		goto iospace_error_exit;
	}
#endif // 0 // SGA bar0 Version access

	return 0;

iospace_error_exit:
	if (ha->iobase)
		iounmap(ha->iobase);

	return (-ENOMEM);
}

static int
ep8324_fc_pci_config(struct ep8324_hw_data *ha)
{
	uint16_t w;

	pci_set_master(ha->pdev);
	pci_try_set_mwi(ha->pdev);

	pci_read_config_word(ha->pdev, PCI_COMMAND, &w);
	w |= (PCI_COMMAND_PARITY | PCI_COMMAND_SERR);
	w &= ~PCI_COMMAND_INTX_DISABLE;
	pci_write_config_word(ha->pdev, PCI_COMMAND, w);

	/* PCIe -- adjust Maximum Read Request Size (2048). */
	if (pci_find_capability(ha->pdev, PCI_CAP_ID_EXP))
		pcie_set_readrq(ha->pdev, 2048);

	pci_disable_rom(ha->pdev);

	return 0;
}

static void
ep8324_fc_reset_chip(struct ep8324_hw_data *ha)
{
	unsigned long flags = 0;
	struct device_reg_fc __iomem *reg = &ha->iobase->fc;
	uint32_t cnt, d2;
	uint16_t wd;


	/* Perform RISC reset. */
	spin_lock_irqsave(&ha->hardware_lock, flags);

	/* Reset RISC. */
	WRT_REG_DWORD(&reg->ctrl_status, CSRX_DMA_SHUTDOWN|MWB_4096_BYTES);
	for (cnt = 0; cnt < 30000; cnt++) {
		if ((RD_REG_DWORD(&reg->ctrl_status) & CSRX_DMA_ACTIVE) == 0)
			break;

		udelay(10);
	}

	WRT_REG_DWORD(&reg->ctrl_status,
	    CSRX_ISP_SOFT_RESET|CSRX_DMA_SHUTDOWN|MWB_4096_BYTES);
	pci_read_config_word(ha->pdev, PCI_COMMAND, &wd);

	udelay(100);
	/* Wait for firmware to complete NVRAM accesses. */
	d2 = (uint32_t) RD_REG_WORD(&reg->mailbox0);
	for (cnt = 10000 ; cnt && d2; cnt--) {
		udelay(5);
		d2 = (uint32_t) RD_REG_WORD(&reg->mailbox0);
		barrier();
	}

	/* Wait for soft-reset to complete. */
	d2 = RD_REG_DWORD(&reg->ctrl_status);
	for (cnt = 6000000 ; cnt && (d2 & CSRX_ISP_SOFT_RESET); cnt--) {
		udelay(5);
		d2 = RD_REG_DWORD(&reg->ctrl_status);
		barrier();
	}

	WRT_REG_DWORD(&reg->hccr, HCCRX_SET_RISC_RESET);
	RD_REG_DWORD(&reg->hccr);

	WRT_REG_DWORD(&reg->hccr, HCCRX_REL_RISC_PAUSE);
	RD_REG_DWORD(&reg->hccr);

	WRT_REG_DWORD(&reg->hccr, HCCRX_CLR_RISC_RESET);
	RD_REG_DWORD(&reg->hccr);

	d2 = (uint32_t) RD_REG_WORD(&reg->mailbox0);
	for (cnt = 6000000 ; cnt && d2; cnt--) {
		udelay(5);
		d2 = (uint32_t) RD_REG_WORD(&reg->mailbox0);
		barrier();
	}

	spin_unlock_irqrestore(&ha->hardware_lock, flags);

	switch(LSW(d2)) {
	case FSC_ROM_READY:
		ha->risc_mode = RISC_ROM_MODE;
		break;
	case FSC_FW_RUNNING:
		ha->risc_mode = RISC_FW_MODE;
		break;
	case FSC_BOARD_ERROR:
	case FSC_FW_ERROR:
		ha->risc_mode = RISC_FW_ERROR;
		printk(KERN_ERR "Detect firmware error %x\n", d2);
		break;
	default:
		printk(KERN_ERR "Unknown firmware status %x\n", d2);
		break;
	}
}

static void ep8324_fc_mbx_completion(struct ep8324_hw_data *ha, uint16_t mb0)
{
	uint16_t	cnt;
	uint32_t	mboxes;
	uint16_t __iomem *wptr;
	struct device_reg_fc __iomem *reg = &ha->iobase->fc;

	/* Read all mbox registers? */
	mboxes = (1 << MAILBOX_REGISTER_COUNT) - 1;
	if (!ha->mcp)
		printk(KERN_INFO "MBX pointer ERROR.\n");
	else
		mboxes = ha->mcp->in_mb;

	/* Load return mailbox registers. */
	ha->flags.mbox_int = 1;
	ha->mailbox_out[0] = mb0;
	mboxes >>= 1;
	wptr = (uint16_t __iomem *)&reg->mailbox1;

	for (cnt = 1; cnt < MAILBOX_REGISTER_COUNT; cnt++) {
		if (mboxes & BIT_0)
			ha->mailbox_out[cnt] = RD_REG_WORD(wptr);

		mboxes >>= 1;
		wptr++;
	}
}

static void
ep8324_fc_poll(struct ep8324_hw_data *ha)
{
	struct device_reg_fc __iomem *reg;
	unsigned long	flags;
	unsigned long	iter;
	uint32_t	stat;
	uint32_t	hccr;
	uint16_t	mb[4];


	reg = &ha->iobase->fc;

	spin_lock_irqsave(&ha->hardware_lock, flags);

	for (iter = 50; iter--; ) {
		stat = RD_REG_DWORD(&reg->host_status);
		//dprintk("POLL HOST STATUS: %08x", reg->host_status);

		if (stat & HSRX_RISC_PAUSED) {
			if (unlikely(pci_channel_offline(ha->pdev)))
				break;

			hccr = RD_REG_DWORD(&reg->hccr);

			printk(KERN_INFO "RISC paused -- HCCR=%x\n", hccr);
			break;
		} else if ((stat & HSRX_RISC_INT) == 0)
			break;

		switch (stat & 0xff) {
		case 0x1:
		case 0x2:
		case 0x10:
		case 0x11:
			ep8324_fc_mbx_completion(ha, MSW(stat));

			break;
		case 0x12:
			mb[0] = MSW(stat);
			mb[1] = RD_REG_WORD(&reg->mailbox1);
			mb[2] = RD_REG_WORD(&reg->mailbox2);
			mb[3] = RD_REG_WORD(&reg->mailbox3);
			printk(KERN_INFO "async event %x\n", mb[0]);
			if (mb[0] == 0x8030)
				ha->flags.dcbx_int = 1; /* FIXME */
			break;
		case 0x13:
		case 0x14:
			printk(KERN_INFO "Pending rsp queue event ???\n");
			break;
		default:
			printk(KERN_INFO "Unrecognized interrupt type (%d)\n", stat * 0xff);
			break;
		}
		WRT_REG_DWORD(&reg->hccr, HCCRX_CLR_RISC_INT);
		RD_REG_DWORD_RELAXED(&reg->hccr);
	}
	spin_unlock_irqrestore(&ha->hardware_lock, flags);
}

static int
ep8324_fc_load_risc_flash(struct ep8324_hw_data *ha, uint32_t *srisc_addr,
		uint32_t faddr)
{
	int	ret = 0;
	int	segments, fragment;
	uint32_t *dcode, dlen;
	uint32_t risc_addr;
	uint32_t risc_size;
	uint32_t i;


	segments = FA_RISC_CODE_SEGMENTS;
	dcode = (uint32_t *)ha->dma_buf;
	*srisc_addr = 0;

	/* Validate firmware image by checking version. */
	ep8324_read_flash_data(ha, dcode, faddr + 4, 4);
	for (i = 0; i < 4; i++)
		dcode[i] = be32_to_cpu(dcode[i]);
	if ((dcode[0] == 0xffffffff && dcode[1] == 0xffffffff &&
	    dcode[2] == 0xffffffff && dcode[3] == 0xffffffff) ||
	    (dcode[0] == 0 && dcode[1] == 0 && dcode[2] == 0 &&
		dcode[3] == 0)) {
		printk(KERN_INFO "Unable to verify the integrity of flash firmware image.\n"
				"Firmware data: %08x %08x %08x %08x.\n",
		    dcode[0], dcode[1], dcode[2], dcode[3]);

		return -EINVAL;
	}

	while (segments && ret == 0) {
		/* Read segment's load information. */
		ep8324_read_flash_data(ha, dcode, faddr, 4);

		risc_addr = be32_to_cpu(dcode[2]);
		*srisc_addr = *srisc_addr == 0 ? risc_addr : *srisc_addr;
		risc_size = be32_to_cpu(dcode[3]);

		fragment = 0;
		while (risc_size > 0 && ret == 0) {
			dlen = (uint32_t)(EP8324_DMA_BUF_SIZE >> 2);
			if (dlen > risc_size)
				dlen = risc_size;

			ep8324_read_flash_data(ha, dcode, faddr, dlen);
			for (i = 0; i < dlen; i++)
				dcode[i] = swab32(dcode[i]);

			ret = ep8324_load_ram(ha, ha->dma, risc_addr,
			    dlen);
			if (ret) {
				printk(KERN_INFO "Failed to load segment %d of firmware.\n",
				    fragment);
				break;
			}

			faddr += dlen;
			risc_addr += dlen;
			risc_size -= dlen;
			fragment++;
		}

		/* Next segment. */
		segments--;
	}

	return ret;
}

static int
ep8324_fc_load_risc_blob(struct ep8324_hw_data *ha, uint32_t *srisc_addr)
{
	int ret = 0;
	int	segments, fragment;
	uint32_t *dcode, dlen;
	uint32_t risc_addr;
	uint32_t risc_size;
	uint32_t *fwcode, fwclen;
	uint32_t i;
	struct fw_blob *blob;

	blob = ep8324_request_firmware(ha);
	if (!blob) {
		ret = -ENODEV;
		goto out;
	}

	segments = FA_RISC_CODE_SEGMENTS;
	dcode = (uint32_t *)ha->dma_buf;
	*srisc_addr = 0;
	fwcode = (uint32_t *)blob->fw->data;
	fwclen = 0;

	/* Validate firmware image by checking version. */
	if (blob->fw->size < 8 * sizeof(uint32_t)) {
		printk(KERN_INFO "Firmware Image too small: (%Zd).\n",
		    blob->fw->size);
		ret = -EINVAL;
		goto out;
	}
	for (i = 0; i < 4; i++)
		dcode[i] = be32_to_cpu(fwcode[i + 4]);
	if ((dcode[0] == 0xffffffff && dcode[1] == 0xffffffff &&
	    dcode[2] == 0xffffffff && dcode[3] == 0xffffffff) ||
	    (dcode[0] == 0 && dcode[1] == 0 && dcode[2] == 0 &&
		dcode[3] == 0)) {
		printk(KERN_INFO "Firmware image header fails basic integrity tests: (%Zd).\n"
				"Firmware data: %08x %08x %08x %08x.\n",
				blob->fw->size,  dcode[0], dcode[1], dcode[2], dcode[3]);
		ret = -EINVAL;
		goto out;
	}

	// mikeh: header diag output
	printk(KERN_INFO
"Firmware image load address %08x array size dwords %08x; array size bytes %08x\n"
"Firmware ver major %08x minor %08x subminor %08x fwattr %08x\n",

		be32_to_cpu(fwcode[2]), be32_to_cpu(fwcode[3]),
		(unsigned int) (be32_to_cpu(fwcode[3]) * sizeof(uint32_t)),
		be32_to_cpu(fwcode[4]), be32_to_cpu(fwcode[5]),
		be32_to_cpu(fwcode[6]), be32_to_cpu(fwcode[7]));

	while (segments && !ret) {
		risc_addr = be32_to_cpu(fwcode[2]);
		*srisc_addr = *srisc_addr == 0 ? risc_addr : *srisc_addr;
		risc_size = be32_to_cpu(fwcode[3]);

		/* Validate firmware image size. */
		fwclen += risc_size * sizeof(uint32_t);
		printk(KERN_INFO
	"Firmware image segment %d size (%u) fwclen (%u).\n",
			(segments == 2? 1 : 2), (uint32_t)blob->fw->size, fwclen);
		if (blob->fw->size < fwclen) {
			printk(KERN_INFO
	"Firmware image segment %d size check failed (%u) fwclen (%u).\n",
			(segments == 2? 1 : 2), (uint32_t)blob->fw->size, fwclen);

			ret = -EINVAL;
			goto out;
		}

		fragment = 0;
		while (risc_size > 0 && !ret) {
			dlen = (uint32_t)(EP8324_DMA_BUF_SIZE >> 2);
			if (dlen > risc_size)
				dlen = risc_size;

			for (i = 0; i < dlen; i++)
				dcode[i] = swab32(fwcode[i]);

			ret = ep8324_load_ram(ha, ha->dma, risc_addr,
			    dlen);
			if (ret) {
				printk(KERN_INFO "Failed to load segment %d of firmware.\n",
				    fragment);
				break;
			}

			fwcode += dlen;
			risc_addr += dlen;
			risc_size -= dlen;
			fragment++;
		}

		/* Next segment. */
		segments--;
	}
out:
	if (blob)
		ep8324_release_firmware(blob);

	return ret;
}

static int
ep8324_fc_load_risc(struct ep8324_hw_data *ha, uint32_t *srisc_addr)
{

	if (fwloadbin || !ha->flt_region_fw)
		return ep8324_fc_load_risc_blob(ha, srisc_addr);

	return ep8324_fc_load_risc_flash(ha, srisc_addr,
			ha->flt_region_fw);
}

static int
ep8324_fc_init_firmware(struct ep8324_hw_data *ha)
{
	int ret;
	unsigned long flags;
	struct device_reg_fc __iomem *ioreg = &ha->iobase->fc;
	struct device_reg_mq __iomem *mqreg = &ha->mqiobase->mq;
	struct init_cb_fc *icb;
	mbx_cmd_t mc;
	mbx_cmd_t *mcp = &mc;

	spin_lock_irqsave(&ha->hardware_lock, flags);

	/* Setup ring parameters in initialization control block. */
	icb = (struct init_cb_fc *)ha->init_cb;

	icb->version = __constant_cpu_to_le16(FC_ICB_VERSION);
	icb->frame_payload_size = __constant_cpu_to_le16(2048);
	icb->exchange_count = __constant_cpu_to_le16(0);
	icb->port_name[0] = 0x21;
	icb->port_name[1] = 0x00 + ha->port_no;
	icb->port_name[2] = 0x00;
	icb->port_name[3] = 0xe0;
	icb->port_name[4] = 0x8b;
	icb->port_name[5] = 0x1c;
	icb->port_name[6] = 0x55;
	icb->port_name[7] = 0x86;
	icb->node_name[0] = 0x20;
	icb->node_name[1] = 0x00;
	icb->node_name[2] = 0x00;
	icb->node_name[3] = 0xe0;
	icb->node_name[4] = 0x8b;
	icb->node_name[5] = 0x1c;
	icb->node_name[6] = 0x55;
	icb->node_name[7] = 0x86;
	icb->login_retry_count = __constant_cpu_to_le16(8);
	icb->interrupt_delay_timer = __constant_cpu_to_le16(0);
	icb->login_timeout = __constant_cpu_to_le16(0);
	icb->firmware_options_1 =
	  __constant_cpu_to_le32(BIT_14|BIT_13|BIT_2|BIT_1);
	icb->firmware_options_2 = __constant_cpu_to_le32(2 << 4);
	icb->firmware_options_2 |= __constant_cpu_to_le32(BIT_12);
	icb->firmware_options_3 = __constant_cpu_to_le32(fc_data_rate << 13);
	icb->enode_mac[0] = 0x00;
	icb->enode_mac[1] = 0xC0;
	icb->enode_mac[2] = 0xDD;
	icb->enode_mac[3] = 0x04;
	icb->enode_mac[4] = 0x05;
	icb->enode_mac[5] = 0x06 + ha->port_no;


	icb->request_q_outpointer = __constant_cpu_to_le16(0);
	icb->response_q_inpointer = __constant_cpu_to_le16(0);
	icb->request_q_length = cpu_to_le16(QUEUE_ENTRY_CNT);
	icb->response_q_length = cpu_to_le16(QUEUE_ENTRY_CNT);
	icb->request_q_address[0] = cpu_to_le32(LSD(ha->req_q_dma));
	icb->request_q_address[1] = cpu_to_le32(MSD(ha->req_q_dma));
	icb->response_q_address[0] = cpu_to_le32(LSD(ha->rsp_q_dma));
	icb->response_q_address[1] = cpu_to_le32(MSD(ha->rsp_q_dma));

	icb->qos = __constant_cpu_to_le16(DEFAULT_QUE_QOS);
	icb->firmware_options_2 |=
		__constant_cpu_to_le32(BIT_22);
	icb->firmware_options_2 |= __constant_cpu_to_le32(BIT_23);

	WRT_REG_DWORD(&mqreg->req_q_in, 0);
	WRT_REG_DWORD(&mqreg->req_q_out, 0);
	WRT_REG_DWORD(&mqreg->rsp_q_in, 0);
	WRT_REG_DWORD(&mqreg->rsp_q_out, 0);
	/* PCI posting */
	RD_REG_DWORD(&ioreg->hccr);

	spin_unlock_irqrestore(&ha->hardware_lock, flags);

	memset(mcp, 0, sizeof(mcp));
	mcp->mb[0] = MBC_INITIALIZE_FIRMWARE;

	mcp->mb[1] = 0;
	mcp->mb[2] = MSW(ha->init_cb_dma);
	mcp->mb[3] = LSW(ha->init_cb_dma);
	mcp->mb[6] = MSW(MSD(ha->init_cb_dma));
	mcp->mb[7] = LSW(MSD(ha->init_cb_dma));
	mcp->out_mb = MBX_7|MBX_6|MBX_3|MBX_2|MBX_1|MBX_0;
	mcp->out_mb |= MBX_14|MBX_13|MBX_12|MBX_11|MBX_10;
	mcp->in_mb = MBX_2|MBX_1|MBX_0; // 1 and 2 should normally be captured.
	mcp->in_mb  |= MBX_3; // mb3 is additional info about the installed SFP.
	mcp->tov = MBX_TOV_SECONDS;
	ret = ep8324_mailbox_command(ha, mcp);
	if (!ret)
		ha->risc_mode = RISC_FW_MODE;
	else
		printk(KERN_INFO "Initialize firmware failed, mbs: %04x-%04x-%04x-%04x\n",
				mcp->mb[0], mcp->mb[1], mcp->mb[2], mcp->mb[3]);

	dprintk("Initialize firmware, fc_data_rate = %d\n", fc_data_rate);

	return ret;
}

struct hw_operations fc_ops = {
	.pci_config = ep8324_fc_pci_config,
	.reset_chip = ep8324_fc_reset_chip,
	.iospace_config = ep8324_fc_iospace_config,
	.poll = ep8324_fc_poll,
	.load_risc = ep8324_fc_load_risc,
	.init_firmware = ep8324_fc_init_firmware,
};
