/*
* Copyright 2015 NetApp, Inc.
*
* You may modify and redistribute the device driver code under the
* GNU General Public License (a copy of which is attached hereto as
* Exhibit A) published by the Free Software Foundation (version 2).
*
 *
 * EXHIBIT A
*
 *                                GNU GENERAL PUBLIC LICENSE
*                                   Version 2, June 1991
*
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
*  51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*  Everyone is permitted to copy and distribute verbatim copies
*  of this license document, but changing it is not allowed.
*
 *                                                Preamble
*
 *   The licenses for most software are designed to take away your
* freedom to share and change it.  By contrast, the GNU General Public
* License is intended to guarantee your freedom to share and change free
* software--to make sure the software is free for all its users.  This
* General Public License applies to most of the Free Software
* Foundation's software and to any other program whose authors commit to
* using it.  (Some other Free Software Foundation software is covered by
* the GNU Lesser General Public License instead.)  You can apply it to
* your programs, too.
*
 *   When we speak of free software, we are referring to freedom, not
* price.  Our General Public Licenses are designed to make sure that you
* have the freedom to distribute copies of free software (and charge for
* this service if you wish), that you receive source code or can get it
* if you want it, that you can change the software or use pieces of it
* in new free programs; and that you know you can do these things.
*
 *   To protect your rights, we need to make restrictions that forbid
* anyone to deny you these rights or to ask you to surrender the rights.
* These restrictions translate to certain responsibilities for you if you
* distribute copies of the software, or if you modify it.
*
 *   For example, if you distribute copies of such a program, whether
* gratis or for a fee, you must give the recipients all the rights that
* you have.  You must make sure that they, too, receive or can get the
* source code.  And you must show them these terms so they know their
* rights.
*
 *   We protect your rights with two steps: (1) copyright the software, and
* (2) offer you this license which gives you legal permission to copy,
* distribute and/or modify the software.
*
 *   Also, for each author's protection and ours, we want to make certain
* that everyone understands that there is no warranty for this free
* software.  If the software is modified by someone else and passed on, we
* want its recipients to know that what they have is not the original, so
* that any problems introduced by others will not reflect on the original
* authors' reputations.
*
 *   Finally, any free program is threatened constantly by software
* patents.  We wish to avoid the danger that redistributors of a free
* program will individually obtain patent licenses, in effect making the
* program proprietary.  To prevent this, we have made it clear that any
* patent must be licensed for everyone's free use or not licensed at all.
*
 *   The precise terms and conditions for copying, distribution and
* modification follow.
*
 *                                GNU GENERAL PUBLIC LICENSE
*    TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION
*
 *   0. This License applies to any program or other work which contains
* a notice placed by the copyright holder saying it may be distributed
* under the terms of this General Public License.  The "Program", below,
* refers to any such program or work, and a "work based on the Program"
* means either the Program or any derivative work under copyright law:
* that is to say, a work containing the Program or a portion of it,
* either verbatim or with modifications and/or translated into another
* language.  (Hereinafter, translation is included without limitation in
* the term "modification".)  Each licensee is addressed as "you".
*
 * Activities other than copying, distribution and modification are not
* covered by this License; they are outside its scope.  The act of
* running the Program is not restricted, and the output from the Program
* is covered only if its contents constitute a work based on the
* Program (independent of having been made by running the Program).
* Whether that is true depends on what the Program does.
*
 *   1. You may copy and distribute verbatim copies of the Program's
* source code as you receive it, in any medium, provided that you
* conspicuously and appropriately publish on each copy an appropriate
* copyright notice and disclaimer of warranty; keep intact all the
* notices that refer to this License and to the absence of any warranty;
* and give any other recipients of the Program a copy of this License
* along with the Program.
*
 * You may charge a fee for the physical act of transferring a copy, and
* you may at your option offer warranty protection in exchange for a fee.
*
 *   2. You may modify your copy or copies of the Program or any portion
* of it, thus forming a work based on the Program, and copy and
* distribute such modifications or work under the terms of Section 1
* above, provided that you also meet all of these conditions:
*
 *     a) You must cause the modified files to carry prominent notices
*     stating that you changed the files and the date of any change.
*
 *     b) You must cause any work that you distribute or publish, that in
*     whole or in part contains or is derived from the Program or any
*     part thereof, to be licensed as a whole at no charge to all third
*     parties under the terms of this License.
*
 *     c) If the modified program normally reads commands interactively
*     when run, you must cause it, when started running for such
*     interactive use in the most ordinary way, to print or display an
*     announcement including an appropriate copyright notice and a
*     notice that there is no warranty (or else, saying that you provide
*     a warranty) and that users may redistribute the program under
*     these conditions, and telling the user how to view a copy of this
*     License.  (Exception: if the Program itself is interactive but
*     does not normally print such an announcement, your work based on
*     the Program is not required to print an announcement.)
*
 * These requirements apply to the modified work as a whole.  If
* identifiable sections of that work are not derived from the Program,
* and can be reasonably considered independent and separate works in
* themselves, then this License, and its terms, do not apply to those
* sections when you distribute them as separate works.  But when you
* distribute the same sections as part of a whole which is a work based
* on the Program, the distribution of the whole must be on the terms of
* this License, whose permissions for other licensees extend to the
* entire whole, and thus to each and every part regardless of who wrote it.
*
 * Thus, it is not the intent of this section to claim rights or contest
* your rights to work written entirely by you; rather, the intent is to
* exercise the right to control the distribution of derivative or
* collective works based on the Program.
*
 * In addition, mere aggregation of another work not based on the Program
* with the Program (or with a work based on the Program) on a volume of
* a storage or distribution medium does not bring the other work under
* the scope of this License.
*
 *   3. You may copy and distribute the Program (or a work based on it,
* under Section 2) in object code or executable form under the terms of
* Sections 1 and 2 above provided that you also do one of the following:
*
 *     a) Accompany it with the complete corresponding machine-readable
*     source code, which must be distributed under the terms of Sections
*     1 and 2 above on a medium customarily used for software interchange; or,
*
 *     b) Accompany it with a written offer, valid for at least three
*     years, to give any third party, for a charge no more than your
*     cost of physically performing source distribution, a complete
*     machine-readable copy of the corresponding source code, to be
*     distributed under the terms of Sections 1 and 2 above on a medium
*     customarily used for software interchange; or,
*
 *     c) Accompany it with the information you received as to the offer
*     to distribute corresponding source code.  (This alternative is
*     allowed only for noncommercial distribution and only if you
*     received the program in object code or executable form with such
*     an offer, in accord with Subsection b above.)
*
 * The source code for a work means the preferred form of the work for
* making modifications to it.  For an executable work, complete source
* code means all the source code for all modules it contains, plus any
* associated interface definition files, plus the scripts used to
* control compilation and installation of the executable.  However, as a
* special exception, the source code distributed need not include
* anything that is normally distributed (in either source or binary
* form) with the major components (compiler, kernel, and so on) of the
* operating system on which the executable runs, unless that component
* itself accompanies the executable.
*
 * If distribution of executable or object code is made by offering
* access to copy from a designated place, then offering equivalent
* access to copy the source code from the same place counts as
* distribution of the source code, even though third parties are not
* compelled to copy the source along with the object code.
*
 *   4. You may not copy, modify, sublicense, or distribute the Program
* except as expressly provided under this License.  Any attempt
* otherwise to copy, modify, sublicense or distribute the Program is
* void, and will automatically terminate your rights under this License.
* However, parties who have received copies, or rights, from you under
* this License will not have their licenses terminated so long as such
* parties remain in full compliance.
*
 *   5. You are not required to accept this License, since you have not
* signed it.  However, nothing else grants you permission to modify or
* distribute the Program or its derivative works.  These actions are
* prohibited by law if you do not accept this License.  Therefore, by
* modifying or distributing the Program (or any work based on the
* Program), you indicate your acceptance of this License to do so, and
* all its terms and conditions for copying, distributing or modifying
* the Program or works based on it.
*
 *   6. Each time you redistribute the Program (or any work based on the
* Program), the recipient automatically receives a license from the
* original licensor to copy, distribute or modify the Program subject to
* these terms and conditions.  You may not impose any further
* restrictions on the recipients' exercise of the rights granted herein.
* You are not responsible for enforcing compliance by third parties to
* this License.
*
 *   7. If, as a consequence of a court judgment or allegation of patent
* infringement or for any other reason (not limited to patent issues),
* conditions are imposed on you (whether by court order, agreement or
* otherwise) that contradict the conditions of this License, they do not
* excuse you from the conditions of this License.  If you cannot
* distribute so as to satisfy simultaneously your obligations under this
* License and any other pertinent obligations, then as a consequence you
* may not distribute the Program at all.  For example, if a patent
* license would not permit royalty-free redistribution of the Program by
* all those who receive copies directly or indirectly through you, then
* the only way you could satisfy both it and this License would be to
* refrain entirely from distribution of the Program.
*
 * If any portion of this section is held invalid or unenforceable under
* any particular circumstance, the balance of the section is intended to
* apply and the section as a whole is intended to apply in other
* circumstances.
*
 * It is not the purpose of this section to induce you to infringe any
* patents or other property right claims or to contest validity of any
* such claims; this section has the sole purpose of protecting the
* integrity of the free software distribution system, which is
* implemented by public license practices.  Many people have made
* generous contributions to the wide range of software distributed
* through that system in reliance on consistent application of that
* system; it is up to the author/donor to decide if he or she is willing
* to distribute software through any other system and a licensee cannot
* impose that choice.
*
 * This section is intended to make thoroughly clear what is believed to
* be a consequence of the rest of this License.
*
 *   8. If the distribution and/or use of the Program is restricted in
* certain countries either by patents or by copyrighted interfaces, the
* original copyright holder who places the Program under this License
* may add an explicit geographical distribution limitation excluding
* those countries, so that distribution is permitted only in or among
* countries not thus excluded.  In such case, this License incorporates
* the limitation as if written in the body of this License.
*
 *   9. The Free Software Foundation may publish revised and/or new versions
* of the General Public License from time to time.  Such new versions will
* be similar in spirit to the present version, but may differ in detail to
* address new problems or concerns.
*
 * Each version is given a distinguishing version number.  If the Program
* specifies a version number of this License which applies to it and "any
* later version", you have the option of following the terms and conditions
* either of that version or of any later version published by the Free
* Software Foundation.  If the Program does not specify a version number of
* this License, you may choose any version ever published by the Free Software
* Foundation.
*
 *   10. If you wish to incorporate parts of the Program into other free
* programs whose distribution conditions are different, write to the author
* to ask for permission.  For software which is copyrighted by the Free
* Software Foundation, write to the Free Software Foundation; we sometimes
* make exceptions for this.  Our decision will be guided by the two goals
* of preserving the free status of all derivatives of our free software and
* of promoting the sharing and reuse of software generally.
*
 *                                                NO WARRANTY
*
 *   11. BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
* FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT WHEN
* OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
* PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED
* OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.  THE ENTIRE RISK AS
* TO THE QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU.  SHOULD THE
* PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY SERVICING,
* REPAIR OR CORRECTION.
*
 *   12. IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
* WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
* REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR DAMAGES,
* INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING
* OUT OF THE USE OR INABILITY TO USE THE PROGRAM (INCLUDING BUT NOT LIMITED
* TO LOSS OF DATA OR DATA BEING RENDERED INACCURATE OR LOSSES SUSTAINED BY
* YOU OR THIRD PARTIES OR A FAILURE OF THE PROGRAM TO OPERATE WITH ANY OTHER
* PROGRAMS), EVEN IF SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGES.
*/
 

/*
 * Copyright (c) 2012 HON HAI PRECISION IND.CO.,LTD. (FOXCONN)
 */
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/aer.h>
#include <linux/fs.h>

#include "ep8324_def.h"

// TODO: Update for Blackduck
MODULE_DESCRIPTION("SGA PGE Driver for Qlogic Hilda based Samoa HIC");
//MODULE_LICENSE("GPL");
MODULE_VERSION("0.1.0");
// Module firmware is currently handled in ep8324_util.c ep8324_request_firmware()
// MODULE_FIRMWARE("Samoa.bin"); ep8324_request_firmware


int fwloadbin = 0;
module_param(fwloadbin, int, S_IRUGO|S_IWUSR);
MODULE_PARM_DESC(fwloadbin,
		"Option to specify location from which to load EP firmware:.\n"
		" 1 -- load firmware via the request_firmware() (hotplug).\n"
		"      interface.\n"
		" 0 -- load firmware from flash.\n");

static struct ep8324_pci_func* ep8324_add_entry(char *well_known_name, uint16_t bus,
		uint8_t dev_num, uint8_t func_num);

extern struct hw_operations fc_ops;

static int dev_major;
static struct class *ep8324_class;

LIST_HEAD(ep8324_func_list);

static struct ep8324_pci_func*
ep8324_register_func(struct ep8324_hw_data *ha)
{
	struct pci_dev *pdev = ha->pdev;
	struct ep8324_pci_func *func;
	char well_known_name[NAME_STR_SIZE + 1];
	//static int fc_hic     = 0;
	//static int fcoe_hic   = 0;
	//static int iscsi_hic  = 0;
	//static int eth_hic    = 0;
	static int fc_port    = 0;
	static int fcoe_port  = 0;
	static int iscsi_port = 0;
	static int eth_port   = 0;

    static int chip       = -1;
    static int pcibus     = -1;

#if 1 // SGA single entry per chip

    // Number our Hildas and ports based on PCI bus relative
    if (pdev->bus->number > pcibus) {
        // We've encountered a new chip on a new bus; increment hic and reset port
        pcibus = pdev->bus->number;
        chip += 1;
        fc_port = fcoe_port = iscsi_port = eth_port = 0;

        // Add a generic common name to first port of each new chip encountered
		snprintf(well_known_name, NAME_STR_SIZE+1,
				"EP8324-HILDA-%d", chip);
	    func = ep8324_add_entry(well_known_name, pdev->bus->number,
			PCI_SLOT(pdev->devfn), PCI_FUNC(pdev->devfn));
	    if (!func)
		return NULL;

	    func->hw = ha;	//
	    ha->func = func;	//
    } else {
	// ep8324_diag_probe_one doesn't handle this well; see notes there
	// so we'll just skip all entries where the function is not zero
	// and then we shouldn't get here (where ep8324_diag_probe_one doesn't
	// handle null func return)
	func = NULL;
	ha->func = NULL;
    }

#else // 1 // SGA single entry per chip

// TODO: The reference hic and port counting is innacurate and misleading.
// In particular it's presumed the first you see anything that it's on hic 0
// when this may not be the case. In particular for FC mode, for example,
// if HIC 1 is in FC mode this code will show it was HIC 0 since it'll be the
// first time this code has seen it (as "FC" is exclusive OR with {FCOE;ISCSI;ENET})
// So you'll get EP8324-FC-H0P0 even though it'd be hic 1 not hic 0
//
// The functions et all should still be OK - just misleading well known name
//
// DONE: come up with something more deterministic (really track relative
// bus # changes perhaps)

	switch (ha->func_type) {
	case EP8324_FC:
		snprintf(well_known_name, NAME_STR_SIZE+1,
				"EP8324-FC-H%dP%d", chip, fc_port);
		fc_port++;
		break;
	case EP8324_FCOE:
		snprintf(well_known_name, NAME_STR_SIZE+1,
				"EP8324-FCOE-H%dP%d", chip, fcoe_port);
		fcoe_port++;
		break;
	case EP8324_ISCSI:
		snprintf(well_known_name, NAME_STR_SIZE+1,
				"EP8324-ISCSI-H%dP%d", chip, iscsi_port);
		iscsi_port++;
		break;
	case EP8324_ETHERNET:
		snprintf(well_known_name, NAME_STR_SIZE+1,
				"EP8324-ENET-H%dP%d", chip, eth_port);
		eth_port++;
		break;
	default:
		return NULL;
	}

	func = ep8324_add_entry(well_known_name, pdev->bus->number,
			PCI_SLOT(pdev->devfn), PCI_FUNC(pdev->devfn));

	if (!func)
		return NULL;

	func->hw = ha;
	ha->func = func;

#endif // 1 // SGA single entry per chip

	return func;
}

static void
ep8324_config_dma_addressing(struct ep8324_hw_data *ha)
{
	/* Assume a 32bit DMA mask. */
	ha->flags.enable_64bit_addressing = 0;

	if (!dma_set_mask(&ha->pdev->dev, DMA_BIT_MASK(64))) {
		/* Any upper-dword bits set? */
		if (MSD(dma_get_required_mask(&ha->pdev->dev)) &&
		    !dma_set_coherent_mask(&ha->pdev->dev, DMA_BIT_MASK(64))) {
			/* Ok, a 64bit DMA mask is applicable. */
			ha->flags.enable_64bit_addressing = 1;
			return;
		}
	}

	dma_set_mask(&ha->pdev->dev, DMA_BIT_MASK(32));
	dma_set_coherent_mask(&ha->pdev->dev, DMA_BIT_MASK(32));
}

static void
ep8324_get_flt_info(struct ep8324_hw_data *ha, uint32_t flt_addr)
{
	uint16_t *wptr;
	uint16_t cnt, chksum;
	uint32_t start;
	struct ep8324_flt_header *flt;
	struct ep8324_flt_region *region;


	ha->flt_region_flt = flt_addr;
	wptr = (uint16_t *)ha->dma_buf;
	flt = (struct ep8324_flt_header *)ha->dma_buf;
	region = (struct ep8324_flt_region *)&flt[1];

	ep8324_read_flash_data(ha, (uint32_t*) ha->dma_buf, flt_addr, OPTROM_BURST_SIZE >> 2);

	if (*wptr == __constant_cpu_to_le16(0xffff))
		return;
	if (flt->version != __constant_cpu_to_le16(1)) {
		printk(KERN_INFO "Unsupported FLT detected: version=0x%x length=0x%x checksum=0x%x.\n",
		    le16_to_cpu(flt->version), le16_to_cpu(flt->length),
		    le16_to_cpu(flt->checksum));
		return;
	}

	cnt = (sizeof(struct ep8324_flt_header) + le16_to_cpu(flt->length)) >> 1;
	for (chksum = 0; cnt; cnt--)
		chksum += le16_to_cpu(*wptr++);
	if (chksum) {
		printk(KERN_INFO "Inconsistent FLT detected: version=0x%x length=0x%x checksum=0x%x.\n",
		    le16_to_cpu(flt->version), le16_to_cpu(flt->length),
		    le16_to_cpu(flt->checksum));
		return;
	}

	cnt = le16_to_cpu(flt->length) / sizeof(struct ep8324_flt_region);
	for ( ; cnt; cnt--, region++) {
		/* Store addresses as DWORD offsets. */
		start = le32_to_cpu(region->start) >> 2;
		dprintk("FLT[%02x]: start=0x%x end=0x%x size=0x%x.\n",
			le32_to_cpu(region->code),
		    start, le32_to_cpu(region->end) >> 2,
		    le32_to_cpu(region->size));

		switch (le32_to_cpu(region->code) & 0xff) {
		case FLT_REG_FW_FC:
			if (ha->func_type == EP8324_FC)
				ha->flt_region_fw = start;
			break;
		case FLT_REG_FW_FCOE:
			if (ha->func_type == EP8324_FCOE)
			ha->flt_region_fw = start;
			break;
		case FLT_REG_FDT:
			ha->flt_region_fdt = start;
			break;
		}
	}
	dprintk(KERN_INFO "FLT: fw=0x%x, flt=0x%x\n",
			ha->flt_region_fw, ha->flt_region_fdt);
}

static void
ep8324_get_fdt_info(struct ep8324_hw_data *ha)
{
	uint16_t cnt, chksum;
	uint16_t *wptr;
	struct ep8324_fdt_layout *fdt;
	uint16_t mid = 0, fid = 0;

	wptr = (uint16_t *)ha->dma_buf;
	fdt = (struct ep8324_fdt_layout *)ha->dma_buf;
	ep8324_read_flash_data(ha, (uint32_t*) ha->dma_buf,
			ha->flt_region_fdt, OPTROM_BURST_SIZE >> 2);
	if (*wptr == __constant_cpu_to_le16(0xffff))
		goto no_flash_data;
	if (fdt->sig[0] != 'Q' || fdt->sig[1] != 'L' || fdt->sig[2] != 'I' ||
	    fdt->sig[3] != 'D')
		goto no_flash_data;

	for (cnt = 0, chksum = 0; cnt < sizeof(struct ep8324_fdt_layout) >> 1;
	    cnt++)
		chksum += le16_to_cpu(*wptr++);
	if (chksum) {
		printk(KERN_INFO "Inconsistent FDT detected:"
		    " checksum=0x%x id=%c version0x%x.\n", chksum,
		    fdt->sig[0], le16_to_cpu(fdt->version));
		goto no_flash_data;
	}

	mid = le16_to_cpu(fdt->man_id);
	fid = le16_to_cpu(fdt->id);
	ha->fdt_wrt_disable = fdt->wrt_disable_bits;
	ha->fdt_erase_cmd = FARX_ACCESS_FLASH_CONF | 0x0300 | fdt->erase_cmd;
	ha->fdt_block_size = le32_to_cpu(fdt->block_size);
	if (fdt->unprotect_sec_cmd) {
		ha->fdt_unprotect_sec_cmd = FARX_ACCESS_FLASH_CONF | 0x0300 |
		    fdt->unprotect_sec_cmd;
		ha->fdt_protect_sec_cmd = fdt->protect_sec_cmd ?
		    (FARX_ACCESS_FLASH_CONF | 0x0300 | fdt->protect_sec_cmd) :
		    (FARX_ACCESS_FLASH_CONF | 0x0336);
	}
	goto done;
no_flash_data:
	printk(KERN_INFO "FDT unavailable, using defaults !!!\n");
	ha->fdt_wrt_disable = 0xbc;
	ha->fdt_erase_cmd = FARX_ACCESS_FLASH_CONF | 0x0300 | 0xd8;
	ha->fdt_block_size = 0x10000;
done:
	dprintk("FDT: (0x%x/0x%x) erase=0x%x "
	    "pr=%x unpr=%x wrtd=0x%x blk=0x%x.\n",
	    mid, fid,
	    ha->fdt_erase_cmd, ha->fdt_protect_sec_cmd, ha->fdt_unprotect_sec_cmd,
	    ha->fdt_wrt_disable, ha->fdt_block_size);
}

static int
ep8324_get_flash_info(struct ep8324_hw_data *ha)
{

	ep8324_get_flt_info(ha, FA_FLASH_LAYOUT_ADDR);

	ep8324_get_fdt_info(ha);

	return 0;
}

static int
ep8324_initialize_adapter(struct ep8324_hw_data *ha)
{
	int ret;

	dprintk("Configuring PCI space...\n");

	ret = ha->hw_ops->pci_config(ha);
	if (ret) {
		printk(KERN_ERR "Unable to configure PCI space\n");
		return ret;
	}

	ha->hw_ops->reset_chip(ha);

	ep8324_get_flash_info(ha);
	if (ret)
		printk(KERN_ERR "Unable to validate FLASH data\n");

	return 0;
}

static int
ep8324_mem_alloc(struct ep8324_hw_data *ha)
{

	ha->dma_buf = dma_alloc_coherent(&ha->pdev->dev,
			EP8324_DMA_BUF_SIZE, &ha->dma, GFP_KERNEL);
	if (!ha->dma_buf)
		goto failed;

	ha->init_cb = dma_alloc_coherent(&ha->pdev->dev, sizeof(init_cb_t),
		&ha->init_cb_dma, GFP_KERNEL);
	if (!ha->init_cb)
		goto failed;

	ha->req_q = dma_alloc_coherent(&ha->pdev->dev,
			(QUEUE_ENTRY_CNT + 1) * IOCB_SIZE,
			&ha->req_q_dma, GFP_KERNEL);
	if (!ha->req_q)
		goto failed;

	ha->rsp_q = dma_alloc_coherent(&ha->pdev->dev,
			(QUEUE_ENTRY_CNT + 1) * IOCB_SIZE,
			&ha->rsp_q_dma, GFP_KERNEL);
	if (!ha->rsp_q)
		goto failed;

	return 0;
failed:

	if (ha->dma && ha->dma_buf)
		dma_free_coherent(&ha->pdev->dev, EP8324_DMA_BUF_SIZE,
				ha->dma_buf, ha->dma);

	if (ha->init_cb && ha->init_cb_dma)
		dma_free_coherent(&ha->pdev->dev, sizeof(init_cb_t),
				ha->init_cb, ha->init_cb_dma);

	if (ha->req_q && ha->req_q_dma)
		dma_free_coherent(&ha->pdev->dev, (QUEUE_ENTRY_CNT + 1) * IOCB_SIZE,
				ha->req_q, ha->req_q_dma);

	if (ha->rsp_q && ha->req_q_dma)
		dma_free_coherent(&ha->pdev->dev, (QUEUE_ENTRY_CNT + 1) * IOCB_SIZE,
				ha->rsp_q, ha->rsp_q_dma);

	return -ENOMEM;
}

static void
ep8324_mem_free(struct ep8324_hw_data *ha)
{

	if (ha->dma && ha->dma_buf)
		dma_free_coherent(&ha->pdev->dev, EP8324_DMA_BUF_SIZE,
				ha->dma_buf, ha->dma);

	if (ha->init_cb && ha->init_cb_dma)
		dma_free_coherent(&ha->pdev->dev, sizeof(init_cb_t),
				ha->init_cb, ha->init_cb_dma);

	if (ha->req_q && ha->req_q_dma)
		dma_free_coherent(&ha->pdev->dev, (QUEUE_ENTRY_CNT + 1) * IOCB_SIZE,
				ha->req_q, ha->req_q_dma);

	if (ha->rsp_q && ha->req_q_dma)
		dma_free_coherent(&ha->pdev->dev, (QUEUE_ENTRY_CNT + 1) * IOCB_SIZE,
				ha->rsp_q, ha->rsp_q_dma);
}

static int
ep8324_diag_probe_one(struct pci_dev *pdev, const struct pci_device_id *id)
{
	int	ret = -ENODEV;
	int bars;
	struct ep8324_hw_data *ha;
	struct ep8324_pci_func *func;

#if 1 // SGA
	// SGA: We only need to operate on the first function for each HILDA
	// chip. The reference driver gave personality specific
	// "well known names" that
	// made it difficult to operate on a chip without knowing the
	// personality in advance. So SGA gives a EP8324-HILDA-N
	// format "well known name" name and to only the first
	// function (eg zero) of each chip.
	//
	// The problem is if we don't give a un-needed name in
	// ep8324_register_func then this routine's error path doesn't clean
	// up well. Instead of fixing up this poorly reference source
	// from FOXCON we'll just skip all functions other than zero and
	// avoid the entire issue. If we needed to do more than flash and
	// change personality then we'd need to revisit later.
	if (0 != pdev->devfn) return -ENODEV;
#endif // 1 // SGA

	bars = pci_select_bars(pdev, IORESOURCE_MEM);
	if (pci_enable_device_mem(pdev))
		goto probe_out;

	pci_enable_pcie_error_reporting(pdev);

	ha = kzalloc(sizeof(struct ep8324_hw_data), GFP_KERNEL);
	if (!ha) {
		ret = -ENOMEM;
		printk(KERN_ERR "Unable to allocate memory for ha.\n");
		goto probe_out;
	}

	ha->pdev = pdev;
	ha->bars = bars;

	spin_lock_init(&ha->hardware_lock);

	/* Get adapter physical port no from interrupt pin register. */
	pci_read_config_byte(ha->pdev, PCI_INTERRUPT_PIN, &ha->port_no);

	switch (pdev->device) {
	case PCI_DEVICE_ID_QLOGIC_ISP2031:
	case PCI_DEVICE_ID_QLOGIC_EP2831:
		ha->func_type = EP8324_FC;
		ha->hw_ops = &fc_ops;
		ha->flt_region_fw = FA_FC_FIRMWARE_ADDR;
		break;
	case PCI_DEVICE_ID_QLOGIC_ISP8031:
	case PCI_DEVICE_ID_QLOGIC_EP8831:
		ha->func_type = EP8324_FCOE;
		ha->hw_ops = &fc_ops;
		ha->flt_region_fw = FA_FCOE_FIRMWARE_ADDR;
		break;

	case PCI_DEVICE_ID_QLOGIC_ISP8032:
	case PCI_DEVICE_ID_QLOGIC_EP8832:
		ha->func_type = EP8324_ISCSI;
		goto register_func; /* TODO */
	case PCI_DEVICE_ID_QLOGIC_ISP8030:
	case PCI_DEVICE_ID_QLOGIC_EP8830:
		ha->func_type = EP8324_ETHERNET;
		goto register_func; /* TODO*/
	default:
		printk(KERN_ERR "Unsupported device(%04x)\n", pdev->device);
		goto probe_hw_failed;
	}

	ret = ha->hw_ops->iospace_config(ha);
	if (ret)
		goto probe_hw_failed;

	ep8324_config_dma_addressing(ha);

	dprintk("64 Bit addressing is %s.\n",
	    ha->flags.enable_64bit_addressing ? "enable" :
	    "disable");

	/* allocate dma buffer */
	ret = ep8324_mem_alloc(ha);
	if (ret) {
		printk(KERN_INFO "Failed to allocate dma buffer\n");
		goto probe_hw_failed;
	}

	if (ep8324_initialize_adapter(ha)) {
		printk(KERN_ERR "Failed to initialize adapter\n");
		ret = -ENODEV;
		goto probe_hw_failed;
	}

register_func:
	// SGA: TODO: for just per-chip well known names we
	// only do 1st per chip eg EP8324-HILDA-0 and the rest
	// we don't claim (I think don't return func) ; The
	// code works but we have spurious memory free's of unset values
	// that need cleaning up. At this point the reference code doesn't
	// correctly nor completely clean up all that is established in
	// an error (or in our case skip at this point).
	// For now we'll register a name and a function, and doesn't handle error case
	func = ep8324_register_func(ha);
	if (!func) {
		ret = -ENODEV;
		goto probe_hw_failed;
	}
	pci_set_drvdata(pdev, func);

	return 0;

probe_hw_failed:
	ep8324_mem_free(ha);

	if (ha->iobase)
		iounmap(ha->iobase);

	if (ha->mqiobase)
		iounmap(ha->mqiobase);

	pci_release_selected_regions(ha->pdev, ha->bars);

	kfree(ha);
	ha = NULL;

probe_out:
	pci_disable_device(pdev);
	return ret;
}

static void
ep8324_diag_remove_one(struct pci_dev *pdev)
{
	struct ep8324_pci_func *func;
	struct ep8324_hw_data  *ha;

	func = pci_get_drvdata(pdev);
	ha = func->hw;

	ep8324_mem_free(ha);

	if (ha->iobase)
		iounmap(ha->iobase);

	if (ha->mqiobase)
		iounmap(ha->mqiobase);

	pci_release_selected_regions(ha->pdev, ha->bars);
	kfree(ha);
	func->hw = NULL;

	pci_disable_pcie_error_reporting(pdev);
	pci_disable_device(pdev);
	pci_set_drvdata(pdev, NULL);
}

static struct pci_device_id ep8324_pci_tbl[] = {
	{ PCI_DEVICE(PCI_VENDOR_ID_QLOGIC, PCI_DEVICE_ID_QLOGIC_ISP2031) }, /* FC */
	{ PCI_DEVICE(PCI_VENDOR_ID_QLOGIC, PCI_DEVICE_ID_QLOGIC_ISP8031) }, /* FCoE */
	{ PCI_DEVICE(PCI_VENDOR_ID_QLOGIC, PCI_DEVICE_ID_QLOGIC_ISP8032) }, /* iSCSI */
	{ PCI_DEVICE(PCI_VENDOR_ID_QLOGIC, PCI_DEVICE_ID_QLOGIC_ISP8030) }, /* NIC */
	{ PCI_DEVICE(PCI_VENDOR_ID_QLOGIC, PCI_DEVICE_ID_QLOGIC_EP2831) }, /* FC */
	{ PCI_DEVICE(PCI_VENDOR_ID_QLOGIC, PCI_DEVICE_ID_QLOGIC_EP8831) }, /* FCoE */
	{ PCI_DEVICE(PCI_VENDOR_ID_QLOGIC, PCI_DEVICE_ID_QLOGIC_EP8832) }, /* iSCSI */
	{ PCI_DEVICE(PCI_VENDOR_ID_QLOGIC, PCI_DEVICE_ID_QLOGIC_EP8830) }, /* NIC */
	{ 0 },
};

static  struct pci_driver ep8324_diag_pci_driver = {
	.name		= EP8324_DRIVER_NAME,
	.driver		= {
		.owner		= THIS_MODULE,
	},
	.id_table	= ep8324_pci_tbl,
	.probe		= ep8324_diag_probe_one,
	.remove		= ep8324_diag_remove_one,
	//.shutdown	= ,
	//.err_handler	= ,
};

static struct file_operations ep8324_fops = {
	.owner = THIS_MODULE,
	.unlocked_ioctl = ep8324_ioctl,
	.llseek		= noop_llseek,
};

static struct ep8324_pci_func*
ep8324_add_entry(char *well_known_name, uint16_t bus,
		uint8_t dev_num, uint8_t func_num)
{
	struct ep8324_pci_func *func;

	func = kzalloc(sizeof(struct ep8324_pci_func), GFP_KERNEL);
	if (!func) {
		printk(KERN_INFO "Failed to allocate ep8324 function entry\n");
		return NULL;
	}

	INIT_LIST_HEAD(&func->list);

	strcpy(func->well_known_name, well_known_name);
	func->bus = bus;
	func->dev_num = dev_num;
	func->func_num = func_num;

	list_add_tail(&func->list, &ep8324_func_list);

	printk(KERN_INFO "%s: %s (%04x:%02x:%02x)\n", __func__,
			func->well_known_name, bus, dev_num, func_num);

	return func;
}

static void
ep8324_free_entries(void)
{
	struct list_head *pos, *next;
	struct ep8324_pci_func *func;

	list_for_each_safe(pos, next, &ep8324_func_list) {
		func = list_entry(pos, struct ep8324_pci_func, list);

		list_del_init(&func->list);
		kfree(func);
	}
}

static int __init
ep8324_diag_init(void)
{
	int ret;

	dev_major = register_chrdev(0, EP8324_DEV, &ep8324_fops);
	if (dev_major < 0) {
		printk(KERN_ERR "EP8324: unable to register char device\n");
		return -ENODEV;
	}

	if (dev_major >= 0) {
		ep8324_class = class_create(THIS_MODULE, EP8324_DEV);
		device_create(ep8324_class, NULL, MKDEV(dev_major, 0), NULL, "%s", EP8324_DEV);
	}

	ret = pci_register_driver(&ep8324_diag_pci_driver);

	return ret;
}

static void __exit
ep8324_diag_exit(void)
{

	pci_unregister_driver(&ep8324_diag_pci_driver);

	ep8324_free_entries();

	device_destroy(ep8324_class, MKDEV(dev_major, 0));

	class_destroy(ep8324_class);

	unregister_chrdev(dev_major, EP8324_DEV);
}

module_init(ep8324_diag_init);
module_exit(ep8324_diag_exit);


MODULE_AUTHOR("cloud.ch.chen@foxconn.com");
MODULE_LICENSE("GPL");
