/* QLogic (R)NIC Driver/Library
 * Copyright (c) 2010-2017  Cavium, Inc.
 *
 * This software is available to you under a choice of one of two
 * licenses.  You may choose to be licensed under the terms of the GNU
 * General Public License (GPL) Version 2, available from the file
 * COPYING in the main directory of this source tree, or the
 * OpenIB.org BSD license below:
 *
 *     Redistribution and use in source and binary forms, with or
 *     without modification, are permitted provided that the following
 *     conditions are met:
 *
 *      - Redistributions of source code must retain the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer.
 *
 *      - Redistributions in binary form must reproduce the above
 *        copyright notice, this list of conditions and the following
 *        disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef _QED_ISCSI_IF_H
#define _QED_ISCSI_IF_H
#include <linux/types.h>
#include <linux/delay.h>
#include <linux/if_ether.h>
#include "qed_if.h"
typedef int (*iscsi_event_cb_t) (void *context,
				 u8 fw_event_code, void *fw_handle);

struct qed_iscsi_stats {
	u64 iscsi_rx_bytes_cnt;
	u64 iscsi_rx_packet_cnt;
	u64 iscsi_rx_new_ooo_isle_events_cnt;
	u32 iscsi_cmdq_threshold_cnt;
	u32 iscsi_rq_threshold_cnt;
	u32 iscsi_immq_threshold_cnt;

	u64 iscsi_rx_dropped_pdus_task_not_valid;

	u64 iscsi_rx_data_pdu_cnt;
	u64 iscsi_rx_r2t_pdu_cnt;
	u64 iscsi_rx_total_pdu_cnt;

	u64 iscsi_tx_go_to_slow_start_event_cnt;
	u64 iscsi_tx_fast_retransmit_event_cnt;

	u64 iscsi_tx_data_pdu_cnt;
	u64 iscsi_tx_r2t_pdu_cnt;
	u64 iscsi_tx_total_pdu_cnt;

	u64 iscsi_tx_bytes_cnt;
	u64 iscsi_tx_packet_cnt;

	u64 iscsi_rx_tcp_payload_bytes_cnt;
	u64 iscsi_rx_tcp_pkt_cnt;
	u64 iscsi_rx_pure_ack_cnt;

	u64 iscsi_rx_dup_ack_cnt;

	u64 iscsi_tx_pure_ack_cnt;
	u64 iscsi_tx_delayed_ack_cnt;

	u64 iscsi_tx_tcp_payload_bytes_cnt;
	u64 iscsi_tx_tcp_pkt_cnt;
};

struct qed_iscsi_tcp_stats {
	u64 iscsi_tcp_tx_packets_cnt;
	u64 iscsi_tcp_tx_bytes_cnt;
	u64 iscsi_tcp_tx_rxmit_cnt;
	u64 iscsi_tcp_rx_packets_cnt;
	u64 iscsi_tcp_rx_bytes_cnt;
	u64 iscsi_tcp_rx_dup_ack_cnt;
	u32 iscsi_tcp_rx_chksum_err_cnt;
};

struct qed_dev_iscsi_info {
	struct qed_dev_info common;

	void __iomem *primary_dbq_rq_addr;
	void __iomem *secondary_bdq_rq_addr;

	u8 num_cqs;
};

struct qed_iscsi_id_params {
	u8 mac[ETH_ALEN];
	u32 ip[4];
	u16 port;
};

struct qed_iscsi_params_offload {
	u8 layer_code;
	dma_addr_t sq_pbl_addr;
	u32 initial_ack;

	struct qed_iscsi_id_params src;
	struct qed_iscsi_id_params dst;
	u16 vlan_id;
	u8 tcp_flags;
	u8 ip_version;
	u8 default_cq;

	u8 ka_max_probe_cnt;
	u8 dup_ack_theshold;
	u32 rcv_next;
	u32 snd_una;
	u32 snd_next;
	u32 snd_max;
	u32 snd_wnd;
	u32 rcv_wnd;
	u32 snd_wl1;
	u32 cwnd;
	u32 ss_thresh;
	u16 srtt;
	u16 rtt_var;
	u32 ts_recent;
	u32 ts_recent_age;
	u32 total_rt;
	u32 ka_timeout_delta;
	u32 rt_timeout_delta;
	u8 dup_ack_cnt;
	u8 snd_wnd_probe_cnt;
	u8 ka_probe_cnt;
	u8 rt_cnt;
	u32 flow_label;
	u32 ka_timeout;
	u32 ka_interval;
	u32 max_rt_time;
	u32 initial_rcv_wnd;
	u8 ttl;
	u8 tos_or_tc;
	u16 remote_port;
	u16 local_port;
	u16 mss;
	u8 snd_wnd_scale;
	u8 rcv_wnd_scale;
	u16 da_timeout_value;
	u8 ack_frequency;
};

struct qed_iscsi_params_update {
	u8 update_flag;
#define QED_ISCSI_CONN_HD_EN            0x01
#define QED_ISCSI_CONN_DD_EN            0x02
#define QED_ISCSI_CONN_INITIAL_R2T      0x04
#define QED_ISCSI_CONN_IMMEDIATE_DATA   0x08
	u32 max_seq_size;
	u32 max_recv_pdu_length;
	u32 max_send_pdu_length;
	u32 first_seq_length;
	u32 exp_stat_sn;
};

#define MAX_TID_BLOCKS_ISCSI (512)
struct qed_iscsi_tid {
	u32 size;		/* In bytes per task */
	u32 num_tids_per_block;
	u8 *blocks[MAX_TID_BLOCKS_ISCSI];
};

struct qed_iscsi_cb_ops {
	struct qed_common_cb_ops common;

	/* TODO - need to add handler for ansync. events */
};

/**
 * struct qed_iscsi_ops - qed iSCSI operations.
 * @common:		common operations pointer
 * @ll2:		light L2 operations pointer
 * @fill_dev_info:	fills iSCSI specific information
 *			@param cdev
 *			@param info
 *			@return 0 on sucesss, otherwise error value.
 * @register_ops:	register iscsi operations
 *			@param cdev
 *			@param ops - specified using qed_iscsi_cb_ops
 *			@param cookie - driver private
 * @start:		iscsi in FW
 *			@param cdev
 *			@param tasks - qed will fill information about tasks
 *			return 0 on success, otherwise error value.
 * @stop:		iscsi in FW
 *			@param cdev
 *			return 0 on success, otherwise error value.
 * @acquire_conn:	acquire a new iscsi connection
 *			@param cdev
 *			@param handle - qed will fill handle that should be
 *				used henceforth as identifier of the
 *				connection.
 *			@param p_doorbell - qed will fill the address of the
 *				doorbell.
 *			@return 0 on sucesss, otherwise error value.
 * @release_conn:	release a previously acquired iscsi connection
 *			@param cdev
 *			@param handle - the connection handle.
 *			@return 0 on success, otherwise error value.
 * @offload_conn:	configures an offloaded connection
 *			@param cdev
 *			@param handle - the connection handle.
 *			@param conn_info - the configuration to use for the
 *				offload.
 *			@return 0 on success, otherwise error value.
 * @update_conn:	updates an offloaded connection
 *			@param cdev
 *			@param handle - the connection handle.
 *			@param conn_info - the configuration to use for the
 *				offload.
 *			@return 0 on success, otherwise error value.
 * @destroy_conn:	stops an offloaded connection
 *			@param cdev
 *			@param handle - the connection handle.
 *			@return 0 on success, otherwise error value.
 * @clear_sq:		clear all task in sq
 *			@param cdev
 *			@param handle - the connection handle.
 *			@return 0 on success, otherwise error value.
 * @get_stats:		iSCSI related statistics
 *			@param cdev
 *			@param stats - pointer to struck that would be filled
 *				we stats
 *			@return 0 on success, error otherwise.
 * @change_mac		Change MAC of interface
 *			@param cdev
 *			@param handle - the connection handle.
 *			@param mac - new MAC to configure.
 *			@return 0 on success, otherwise error value.
 */
struct qed_iscsi_ops {
	const struct qed_common_ops *common;

	const struct qed_ll2_ops *ll2;

	int (*fill_dev_info) (struct qed_dev
			      * cdev, struct qed_dev_iscsi_info * info);

	void (*register_ops) (struct qed_dev
			      * cdev,
			      struct qed_iscsi_cb_ops * ops, void *cookie);

	int (*start) (struct qed_dev * cdev,
		      struct qed_iscsi_tid * tasks,
		      void *event_context, iscsi_event_cb_t async_event_cb);

	int (*stop) (struct qed_dev * cdev);

	int (*acquire_conn) (struct qed_dev * cdev,
			     u32 * handle,
			     u32 * fw_cid, void __iomem ** p_doorbell);

	int (*release_conn) (struct qed_dev * cdev, u32 handle);

	int (*offload_conn) (struct qed_dev
			     * cdev,
			     u32
			     handle,
			     struct qed_iscsi_params_offload * conn_info);

	int (*update_conn) (struct qed_dev
			    * cdev,
			    u32
			    handle, struct qed_iscsi_params_update * conn_info);

	int (*destroy_conn) (struct qed_dev * cdev, u32 handle, u8 abrt_conn);

	int (*clear_sq) (struct qed_dev * cdev, u32 handle);

	int (*get_stats) (struct qed_dev
			  * cdev, struct qed_iscsi_stats * stats);

	int (*change_mac) (struct qed_dev * cdev, u32 handle, const u8 * mac);
};

#ifdef QED_UPSTREAM
const struct qed_iscsi_ops *qed_get_iscsi_ops(void);
#else
const struct qed_iscsi_ops *qed_get_iscsi_ops(u32 version);
#endif
void qed_put_iscsi_ops(void);
#endif
