# Backend

The contribution guidelines for Grafana backend developers contain a lot of information for anyone who wants to contribute to our open source project.
But you don't necessarily have to read all of it, so long as you read what is most relevant to you.

## Guidelines everyone should read

We recommend that all contributors read the [backend style guide](/contribute/backend/style-guide.md) to get a sense for how we try to ensure that the Grafana codebase is consistent and accessible.
The rest of the backend contributor documentation tends to be more relevant to reviewers and contributors who want to make changes of greater size or quantity.

## Guidelines specifically for backend developers

For anyone who reviews code for the Grafana backend, get a basic understanding of the content of the following files:

- [Currently recommended practices](/contribute/backend/recommended-practices.md)
- [Services](/contribute/backend/services.md)
- [Communication](/contribute/backend/communication.md)
- [Database](/contribute/backend/database.md)
- [HTTP API](/pkg/api/README.md)

## Guidelines for contributors who make or review large changes to the backend

If you want to make or review large changes to the backend, be sure to habitually familiarize yourself with the entire contents of
[/contribute/backend](/contribute/backend) from time to time.

## Guidelines for dependency management

If you work with a dependency that requires an upgrade, refer to [Upgrade dependencies](/contribute/backend/upgrade-dependencies.md).
