// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by client-gen. DO NOT EDIT.

package v0alpha1

import (
	"context"

	v0alpha1 "github.com/grafana/grafana/pkg/aggregator/apis/aggregation/v0alpha1"
	aggregationv0alpha1 "github.com/grafana/grafana/pkg/aggregator/generated/applyconfiguration/aggregation/v0alpha1"
	scheme "github.com/grafana/grafana/pkg/aggregator/generated/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// DataPlaneServicesGetter has a method to return a DataPlaneServiceInterface.
// A group's client should implement this interface.
type DataPlaneServicesGetter interface {
	DataPlaneServices() DataPlaneServiceInterface
}

// DataPlaneServiceInterface has methods to work with DataPlaneService resources.
type DataPlaneServiceInterface interface {
	Create(ctx context.Context, dataPlaneService *v0alpha1.DataPlaneService, opts v1.CreateOptions) (*v0alpha1.DataPlaneService, error)
	Update(ctx context.Context, dataPlaneService *v0alpha1.DataPlaneService, opts v1.UpdateOptions) (*v0alpha1.DataPlaneService, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, dataPlaneService *v0alpha1.DataPlaneService, opts v1.UpdateOptions) (*v0alpha1.DataPlaneService, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v0alpha1.DataPlaneService, error)
	List(ctx context.Context, opts v1.ListOptions) (*v0alpha1.DataPlaneServiceList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v0alpha1.DataPlaneService, err error)
	Apply(ctx context.Context, dataPlaneService *aggregationv0alpha1.DataPlaneServiceApplyConfiguration, opts v1.ApplyOptions) (result *v0alpha1.DataPlaneService, err error)
	// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
	ApplyStatus(ctx context.Context, dataPlaneService *aggregationv0alpha1.DataPlaneServiceApplyConfiguration, opts v1.ApplyOptions) (result *v0alpha1.DataPlaneService, err error)
	DataPlaneServiceExpansion
}

// dataPlaneServices implements DataPlaneServiceInterface
type dataPlaneServices struct {
	*gentype.ClientWithListAndApply[*v0alpha1.DataPlaneService, *v0alpha1.DataPlaneServiceList, *aggregationv0alpha1.DataPlaneServiceApplyConfiguration]
}

// newDataPlaneServices returns a DataPlaneServices
func newDataPlaneServices(c *AggregationV0alpha1Client) *dataPlaneServices {
	return &dataPlaneServices{
		gentype.NewClientWithListAndApply[*v0alpha1.DataPlaneService, *v0alpha1.DataPlaneServiceList, *aggregationv0alpha1.DataPlaneServiceApplyConfiguration](
			"dataplaneservices",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v0alpha1.DataPlaneService { return &v0alpha1.DataPlaneService{} },
			func() *v0alpha1.DataPlaneServiceList { return &v0alpha1.DataPlaneServiceList{} }),
	}
}
