// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v0alpha1 "github.com/grafana/grafana/pkg/aggregator/apis/aggregation/v0alpha1"
	aggregationv0alpha1 "github.com/grafana/grafana/pkg/aggregator/generated/applyconfiguration/aggregation/v0alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeDataPlaneServices implements DataPlaneServiceInterface
type FakeDataPlaneServices struct {
	Fake *FakeAggregationV0alpha1
}

var dataplaneservicesResource = v0alpha1.SchemeGroupVersion.WithResource("dataplaneservices")

var dataplaneservicesKind = v0alpha1.SchemeGroupVersion.WithKind("DataPlaneService")

// Get takes name of the dataPlaneService, and returns the corresponding dataPlaneService object, and an error if there is any.
func (c *FakeDataPlaneServices) Get(ctx context.Context, name string, options v1.GetOptions) (result *v0alpha1.DataPlaneService, err error) {
	emptyResult := &v0alpha1.DataPlaneService{}
	obj, err := c.Fake.
		Invokes(testing.NewRootGetActionWithOptions(dataplaneservicesResource, name, options), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.DataPlaneService), err
}

// List takes label and field selectors, and returns the list of DataPlaneServices that match those selectors.
func (c *FakeDataPlaneServices) List(ctx context.Context, opts v1.ListOptions) (result *v0alpha1.DataPlaneServiceList, err error) {
	emptyResult := &v0alpha1.DataPlaneServiceList{}
	obj, err := c.Fake.
		Invokes(testing.NewRootListActionWithOptions(dataplaneservicesResource, dataplaneservicesKind, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v0alpha1.DataPlaneServiceList{ListMeta: obj.(*v0alpha1.DataPlaneServiceList).ListMeta}
	for _, item := range obj.(*v0alpha1.DataPlaneServiceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested dataPlaneServices.
func (c *FakeDataPlaneServices) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewRootWatchActionWithOptions(dataplaneservicesResource, opts))
}

// Create takes the representation of a dataPlaneService and creates it.  Returns the server's representation of the dataPlaneService, and an error, if there is any.
func (c *FakeDataPlaneServices) Create(ctx context.Context, dataPlaneService *v0alpha1.DataPlaneService, opts v1.CreateOptions) (result *v0alpha1.DataPlaneService, err error) {
	emptyResult := &v0alpha1.DataPlaneService{}
	obj, err := c.Fake.
		Invokes(testing.NewRootCreateActionWithOptions(dataplaneservicesResource, dataPlaneService, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.DataPlaneService), err
}

// Update takes the representation of a dataPlaneService and updates it. Returns the server's representation of the dataPlaneService, and an error, if there is any.
func (c *FakeDataPlaneServices) Update(ctx context.Context, dataPlaneService *v0alpha1.DataPlaneService, opts v1.UpdateOptions) (result *v0alpha1.DataPlaneService, err error) {
	emptyResult := &v0alpha1.DataPlaneService{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateActionWithOptions(dataplaneservicesResource, dataPlaneService, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.DataPlaneService), err
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *FakeDataPlaneServices) UpdateStatus(ctx context.Context, dataPlaneService *v0alpha1.DataPlaneService, opts v1.UpdateOptions) (result *v0alpha1.DataPlaneService, err error) {
	emptyResult := &v0alpha1.DataPlaneService{}
	obj, err := c.Fake.
		Invokes(testing.NewRootUpdateSubresourceActionWithOptions(dataplaneservicesResource, "status", dataPlaneService, opts), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.DataPlaneService), err
}

// Delete takes name of the dataPlaneService and deletes it. Returns an error if one occurs.
func (c *FakeDataPlaneServices) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewRootDeleteActionWithOptions(dataplaneservicesResource, name, opts), &v0alpha1.DataPlaneService{})
	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeDataPlaneServices) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewRootDeleteCollectionActionWithOptions(dataplaneservicesResource, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v0alpha1.DataPlaneServiceList{})
	return err
}

// Patch applies the patch and returns the patched dataPlaneService.
func (c *FakeDataPlaneServices) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v0alpha1.DataPlaneService, err error) {
	emptyResult := &v0alpha1.DataPlaneService{}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceActionWithOptions(dataplaneservicesResource, name, pt, data, opts, subresources...), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.DataPlaneService), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied dataPlaneService.
func (c *FakeDataPlaneServices) Apply(ctx context.Context, dataPlaneService *aggregationv0alpha1.DataPlaneServiceApplyConfiguration, opts v1.ApplyOptions) (result *v0alpha1.DataPlaneService, err error) {
	if dataPlaneService == nil {
		return nil, fmt.Errorf("dataPlaneService provided to Apply must not be nil")
	}
	data, err := json.Marshal(dataPlaneService)
	if err != nil {
		return nil, err
	}
	name := dataPlaneService.Name
	if name == nil {
		return nil, fmt.Errorf("dataPlaneService.Name must be provided to Apply")
	}
	emptyResult := &v0alpha1.DataPlaneService{}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceActionWithOptions(dataplaneservicesResource, *name, types.ApplyPatchType, data, opts.ToPatchOptions()), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.DataPlaneService), err
}

// ApplyStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating ApplyStatus().
func (c *FakeDataPlaneServices) ApplyStatus(ctx context.Context, dataPlaneService *aggregationv0alpha1.DataPlaneServiceApplyConfiguration, opts v1.ApplyOptions) (result *v0alpha1.DataPlaneService, err error) {
	if dataPlaneService == nil {
		return nil, fmt.Errorf("dataPlaneService provided to Apply must not be nil")
	}
	data, err := json.Marshal(dataPlaneService)
	if err != nil {
		return nil, err
	}
	name := dataPlaneService.Name
	if name == nil {
		return nil, fmt.Errorf("dataPlaneService.Name must be provided to Apply")
	}
	emptyResult := &v0alpha1.DataPlaneService{}
	obj, err := c.Fake.
		Invokes(testing.NewRootPatchSubresourceActionWithOptions(dataplaneservicesResource, *name, types.ApplyPatchType, data, opts.ToPatchOptions(), "status"), emptyResult)
	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.DataPlaneService), err
}
