// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v0alpha1

import (
	v0alpha1 "github.com/grafana/grafana/pkg/apimachinery/apis/common/v0alpha1"
)

// IntegrationApplyConfiguration represents a declarative configuration of the Integration type for use
// with apply.
type IntegrationApplyConfiguration struct {
	DisableResolveMessage *bool                  `json:"disableResolveMessage,omitempty"`
	SecureFields          map[string]bool        `json:"secureFields,omitempty"`
	Settings              *v0alpha1.Unstructured `json:"settings,omitempty"`
	Type                  *string                `json:"type,omitempty"`
	Uid                   *string                `json:"uid,omitempty"`
}

// IntegrationApplyConfiguration constructs a declarative configuration of the Integration type for use with
// apply.
func Integration() *IntegrationApplyConfiguration {
	return &IntegrationApplyConfiguration{}
}

// WithDisableResolveMessage sets the DisableResolveMessage field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DisableResolveMessage field is set to the value of the last call.
func (b *IntegrationApplyConfiguration) WithDisableResolveMessage(value bool) *IntegrationApplyConfiguration {
	b.DisableResolveMessage = &value
	return b
}

// WithSecureFields puts the entries into the SecureFields field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the SecureFields field,
// overwriting an existing map entries in SecureFields field with the same key.
func (b *IntegrationApplyConfiguration) WithSecureFields(entries map[string]bool) *IntegrationApplyConfiguration {
	if b.SecureFields == nil && len(entries) > 0 {
		b.SecureFields = make(map[string]bool, len(entries))
	}
	for k, v := range entries {
		b.SecureFields[k] = v
	}
	return b
}

// WithSettings sets the Settings field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Settings field is set to the value of the last call.
func (b *IntegrationApplyConfiguration) WithSettings(value v0alpha1.Unstructured) *IntegrationApplyConfiguration {
	b.Settings = &value
	return b
}

// WithType sets the Type field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Type field is set to the value of the last call.
func (b *IntegrationApplyConfiguration) WithType(value string) *IntegrationApplyConfiguration {
	b.Type = &value
	return b
}

// WithUid sets the Uid field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Uid field is set to the value of the last call.
func (b *IntegrationApplyConfiguration) WithUid(value string) *IntegrationApplyConfiguration {
	b.Uid = &value
	return b
}
