// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v0alpha1 "github.com/grafana/grafana/pkg/apis/alerting_notifications/v0alpha1"
	alertingnotificationsv0alpha1 "github.com/grafana/grafana/pkg/generated/applyconfiguration/alerting_notifications/v0alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTemplateGroups implements TemplateGroupInterface
type FakeTemplateGroups struct {
	Fake *FakeNotificationsV0alpha1
	ns   string
}

var templategroupsResource = v0alpha1.SchemeGroupVersion.WithResource("templategroups")

var templategroupsKind = v0alpha1.SchemeGroupVersion.WithKind("TemplateGroup")

// Get takes name of the templateGroup, and returns the corresponding templateGroup object, and an error if there is any.
func (c *FakeTemplateGroups) Get(ctx context.Context, name string, options v1.GetOptions) (result *v0alpha1.TemplateGroup, err error) {
	emptyResult := &v0alpha1.TemplateGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(templategroupsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TemplateGroup), err
}

// List takes label and field selectors, and returns the list of TemplateGroups that match those selectors.
func (c *FakeTemplateGroups) List(ctx context.Context, opts v1.ListOptions) (result *v0alpha1.TemplateGroupList, err error) {
	emptyResult := &v0alpha1.TemplateGroupList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(templategroupsResource, templategroupsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v0alpha1.TemplateGroupList{ListMeta: obj.(*v0alpha1.TemplateGroupList).ListMeta}
	for _, item := range obj.(*v0alpha1.TemplateGroupList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested templateGroups.
func (c *FakeTemplateGroups) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(templategroupsResource, c.ns, opts))

}

// Create takes the representation of a templateGroup and creates it.  Returns the server's representation of the templateGroup, and an error, if there is any.
func (c *FakeTemplateGroups) Create(ctx context.Context, templateGroup *v0alpha1.TemplateGroup, opts v1.CreateOptions) (result *v0alpha1.TemplateGroup, err error) {
	emptyResult := &v0alpha1.TemplateGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(templategroupsResource, c.ns, templateGroup, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TemplateGroup), err
}

// Update takes the representation of a templateGroup and updates it. Returns the server's representation of the templateGroup, and an error, if there is any.
func (c *FakeTemplateGroups) Update(ctx context.Context, templateGroup *v0alpha1.TemplateGroup, opts v1.UpdateOptions) (result *v0alpha1.TemplateGroup, err error) {
	emptyResult := &v0alpha1.TemplateGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(templategroupsResource, c.ns, templateGroup, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TemplateGroup), err
}

// Delete takes name of the templateGroup and deletes it. Returns an error if one occurs.
func (c *FakeTemplateGroups) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(templategroupsResource, c.ns, name, opts), &v0alpha1.TemplateGroup{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTemplateGroups) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(templategroupsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v0alpha1.TemplateGroupList{})
	return err
}

// Patch applies the patch and returns the patched templateGroup.
func (c *FakeTemplateGroups) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v0alpha1.TemplateGroup, err error) {
	emptyResult := &v0alpha1.TemplateGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(templategroupsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TemplateGroup), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied templateGroup.
func (c *FakeTemplateGroups) Apply(ctx context.Context, templateGroup *alertingnotificationsv0alpha1.TemplateGroupApplyConfiguration, opts v1.ApplyOptions) (result *v0alpha1.TemplateGroup, err error) {
	if templateGroup == nil {
		return nil, fmt.Errorf("templateGroup provided to Apply must not be nil")
	}
	data, err := json.Marshal(templateGroup)
	if err != nil {
		return nil, err
	}
	name := templateGroup.Name
	if name == nil {
		return nil, fmt.Errorf("templateGroup.Name must be provided to Apply")
	}
	emptyResult := &v0alpha1.TemplateGroup{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(templategroupsResource, c.ns, *name, types.ApplyPatchType, data, opts.ToPatchOptions()), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TemplateGroup), err
}
