// SPDX-License-Identifier: AGPL-3.0-only

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"
	json "encoding/json"
	"fmt"

	v0alpha1 "github.com/grafana/grafana/pkg/apis/alerting_notifications/v0alpha1"
	alertingnotificationsv0alpha1 "github.com/grafana/grafana/pkg/generated/applyconfiguration/alerting_notifications/v0alpha1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeTimeIntervals implements TimeIntervalInterface
type FakeTimeIntervals struct {
	Fake *FakeNotificationsV0alpha1
	ns   string
}

var timeintervalsResource = v0alpha1.SchemeGroupVersion.WithResource("timeintervals")

var timeintervalsKind = v0alpha1.SchemeGroupVersion.WithKind("TimeInterval")

// Get takes name of the timeInterval, and returns the corresponding timeInterval object, and an error if there is any.
func (c *FakeTimeIntervals) Get(ctx context.Context, name string, options v1.GetOptions) (result *v0alpha1.TimeInterval, err error) {
	emptyResult := &v0alpha1.TimeInterval{}
	obj, err := c.Fake.
		Invokes(testing.NewGetActionWithOptions(timeintervalsResource, c.ns, name, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TimeInterval), err
}

// List takes label and field selectors, and returns the list of TimeIntervals that match those selectors.
func (c *FakeTimeIntervals) List(ctx context.Context, opts v1.ListOptions) (result *v0alpha1.TimeIntervalList, err error) {
	emptyResult := &v0alpha1.TimeIntervalList{}
	obj, err := c.Fake.
		Invokes(testing.NewListActionWithOptions(timeintervalsResource, timeintervalsKind, c.ns, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v0alpha1.TimeIntervalList{ListMeta: obj.(*v0alpha1.TimeIntervalList).ListMeta}
	for _, item := range obj.(*v0alpha1.TimeIntervalList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested timeIntervals.
func (c *FakeTimeIntervals) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchActionWithOptions(timeintervalsResource, c.ns, opts))

}

// Create takes the representation of a timeInterval and creates it.  Returns the server's representation of the timeInterval, and an error, if there is any.
func (c *FakeTimeIntervals) Create(ctx context.Context, timeInterval *v0alpha1.TimeInterval, opts v1.CreateOptions) (result *v0alpha1.TimeInterval, err error) {
	emptyResult := &v0alpha1.TimeInterval{}
	obj, err := c.Fake.
		Invokes(testing.NewCreateActionWithOptions(timeintervalsResource, c.ns, timeInterval, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TimeInterval), err
}

// Update takes the representation of a timeInterval and updates it. Returns the server's representation of the timeInterval, and an error, if there is any.
func (c *FakeTimeIntervals) Update(ctx context.Context, timeInterval *v0alpha1.TimeInterval, opts v1.UpdateOptions) (result *v0alpha1.TimeInterval, err error) {
	emptyResult := &v0alpha1.TimeInterval{}
	obj, err := c.Fake.
		Invokes(testing.NewUpdateActionWithOptions(timeintervalsResource, c.ns, timeInterval, opts), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TimeInterval), err
}

// Delete takes name of the timeInterval and deletes it. Returns an error if one occurs.
func (c *FakeTimeIntervals) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(timeintervalsResource, c.ns, name, opts), &v0alpha1.TimeInterval{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeTimeIntervals) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionActionWithOptions(timeintervalsResource, c.ns, opts, listOpts)

	_, err := c.Fake.Invokes(action, &v0alpha1.TimeIntervalList{})
	return err
}

// Patch applies the patch and returns the patched timeInterval.
func (c *FakeTimeIntervals) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v0alpha1.TimeInterval, err error) {
	emptyResult := &v0alpha1.TimeInterval{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(timeintervalsResource, c.ns, name, pt, data, opts, subresources...), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TimeInterval), err
}

// Apply takes the given apply declarative configuration, applies it and returns the applied timeInterval.
func (c *FakeTimeIntervals) Apply(ctx context.Context, timeInterval *alertingnotificationsv0alpha1.TimeIntervalApplyConfiguration, opts v1.ApplyOptions) (result *v0alpha1.TimeInterval, err error) {
	if timeInterval == nil {
		return nil, fmt.Errorf("timeInterval provided to Apply must not be nil")
	}
	data, err := json.Marshal(timeInterval)
	if err != nil {
		return nil, err
	}
	name := timeInterval.Name
	if name == nil {
		return nil, fmt.Errorf("timeInterval.Name must be provided to Apply")
	}
	emptyResult := &v0alpha1.TimeInterval{}
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceActionWithOptions(timeintervalsResource, c.ns, *name, types.ApplyPatchType, data, opts.ToPatchOptions()), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v0alpha1.TimeInterval), err
}
