// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: query_service.proto

package api_v3

import (
	context "context"
	fmt "fmt"
	_ "github.com/gogo/protobuf/gogoproto"
	proto "github.com/gogo/protobuf/proto"
	types "github.com/gogo/protobuf/types"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	math "math"
	time "time"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// Request object to get a trace.
type GetTraceRequest struct {
	// Hex encoded 64 or 128 bit trace ID.
	TraceId string `protobuf:"bytes,1,opt,name=trace_id,json=traceId,proto3" json:"trace_id,omitempty"`
	// Optional. The start time to search trace ID.
	StartTime *time.Time `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3,stdtime" json:"start_time,omitempty"`
	// Optional. The end time to search trace ID.
	EndTime              *time.Time `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3,stdtime" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetTraceRequest) Reset()         { *m = GetTraceRequest{} }
func (m *GetTraceRequest) String() string { return proto.CompactTextString(m) }
func (*GetTraceRequest) ProtoMessage()    {}
func (*GetTraceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{0}
}
func (m *GetTraceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTraceRequest.Unmarshal(m, b)
}
func (m *GetTraceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTraceRequest.Marshal(b, m, deterministic)
}
func (m *GetTraceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTraceRequest.Merge(m, src)
}
func (m *GetTraceRequest) XXX_Size() int {
	return xxx_messageInfo_GetTraceRequest.Size(m)
}
func (m *GetTraceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTraceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTraceRequest proto.InternalMessageInfo

func (m *GetTraceRequest) GetTraceId() string {
	if m != nil {
		return m.TraceId
	}
	return ""
}

func (m *GetTraceRequest) GetStartTime() *time.Time {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *GetTraceRequest) GetEndTime() *time.Time {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// Query parameters to find traces. Except for num_traces, all fields should be treated
// as forming a conjunction, e.g., "service_name='X' AND operation_name='Y' AND ...".
// All fields are matched against individual spans, not at the trace level.
// The returned results contain traces where at least one span matches the conditions.
// When num_traces results in fewer traces returned, there is no required ordering.
//
// Note: num_traces should restrict the number of traces returned, but not all backends
// interpret it this way. For instance, in Cassandra this limits the number of _spans_
// that match the conditions, and the resulting number of traces can be less.
//
// Note: some storage implementations do not guarantee the correct implementation of all parameters.
//
type TraceQueryParameters struct {
	ServiceName   string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	OperationName string `protobuf:"bytes,2,opt,name=operation_name,json=operationName,proto3" json:"operation_name,omitempty"`
	// Attributes are matched against Span and Resource attributes.
	// At least one span in a trace must match all specified attributes.
	Attributes map[string]string `protobuf:"bytes,3,rep,name=attributes,proto3" json:"attributes,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Span min start time in. REST API uses RFC-3339ns format. Required.
	StartTimeMin *types.Timestamp `protobuf:"bytes,4,opt,name=start_time_min,json=startTimeMin,proto3" json:"start_time_min,omitempty"`
	// Span max start time. REST API uses RFC-3339ns format. Required.
	StartTimeMax *types.Timestamp `protobuf:"bytes,5,opt,name=start_time_max,json=startTimeMax,proto3" json:"start_time_max,omitempty"`
	// Span min duration. REST API uses Golang's time format e.g. 10s.
	DurationMin *types.Duration `protobuf:"bytes,6,opt,name=duration_min,json=durationMin,proto3" json:"duration_min,omitempty"`
	// Span max duration. REST API uses Golang's time format e.g. 10s.
	DurationMax *types.Duration `protobuf:"bytes,7,opt,name=duration_max,json=durationMax,proto3" json:"duration_max,omitempty"`
	// Maximum number of traces in the response.
	NumTraces            int32    `protobuf:"varint,8,opt,name=num_traces,json=numTraces,proto3" json:"num_traces,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TraceQueryParameters) Reset()         { *m = TraceQueryParameters{} }
func (m *TraceQueryParameters) String() string { return proto.CompactTextString(m) }
func (*TraceQueryParameters) ProtoMessage()    {}
func (*TraceQueryParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{1}
}
func (m *TraceQueryParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TraceQueryParameters.Unmarshal(m, b)
}
func (m *TraceQueryParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TraceQueryParameters.Marshal(b, m, deterministic)
}
func (m *TraceQueryParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TraceQueryParameters.Merge(m, src)
}
func (m *TraceQueryParameters) XXX_Size() int {
	return xxx_messageInfo_TraceQueryParameters.Size(m)
}
func (m *TraceQueryParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_TraceQueryParameters.DiscardUnknown(m)
}

var xxx_messageInfo_TraceQueryParameters proto.InternalMessageInfo

func (m *TraceQueryParameters) GetServiceName() string {
	if m != nil {
		return m.ServiceName
	}
	return ""
}

func (m *TraceQueryParameters) GetOperationName() string {
	if m != nil {
		return m.OperationName
	}
	return ""
}

func (m *TraceQueryParameters) GetAttributes() map[string]string {
	if m != nil {
		return m.Attributes
	}
	return nil
}

func (m *TraceQueryParameters) GetStartTimeMin() *types.Timestamp {
	if m != nil {
		return m.StartTimeMin
	}
	return nil
}

func (m *TraceQueryParameters) GetStartTimeMax() *types.Timestamp {
	if m != nil {
		return m.StartTimeMax
	}
	return nil
}

func (m *TraceQueryParameters) GetDurationMin() *types.Duration {
	if m != nil {
		return m.DurationMin
	}
	return nil
}

func (m *TraceQueryParameters) GetDurationMax() *types.Duration {
	if m != nil {
		return m.DurationMax
	}
	return nil
}

func (m *TraceQueryParameters) GetNumTraces() int32 {
	if m != nil {
		return m.NumTraces
	}
	return 0
}

// Request object to search traces.
type FindTracesRequest struct {
	Query                *TraceQueryParameters `protobuf:"bytes,1,opt,name=query,proto3" json:"query,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *FindTracesRequest) Reset()         { *m = FindTracesRequest{} }
func (m *FindTracesRequest) String() string { return proto.CompactTextString(m) }
func (*FindTracesRequest) ProtoMessage()    {}
func (*FindTracesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{2}
}
func (m *FindTracesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FindTracesRequest.Unmarshal(m, b)
}
func (m *FindTracesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FindTracesRequest.Marshal(b, m, deterministic)
}
func (m *FindTracesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FindTracesRequest.Merge(m, src)
}
func (m *FindTracesRequest) XXX_Size() int {
	return xxx_messageInfo_FindTracesRequest.Size(m)
}
func (m *FindTracesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FindTracesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FindTracesRequest proto.InternalMessageInfo

func (m *FindTracesRequest) GetQuery() *TraceQueryParameters {
	if m != nil {
		return m.Query
	}
	return nil
}

// Request object to get service names.
type GetServicesRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServicesRequest) Reset()         { *m = GetServicesRequest{} }
func (m *GetServicesRequest) String() string { return proto.CompactTextString(m) }
func (*GetServicesRequest) ProtoMessage()    {}
func (*GetServicesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{3}
}
func (m *GetServicesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServicesRequest.Unmarshal(m, b)
}
func (m *GetServicesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServicesRequest.Marshal(b, m, deterministic)
}
func (m *GetServicesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServicesRequest.Merge(m, src)
}
func (m *GetServicesRequest) XXX_Size() int {
	return xxx_messageInfo_GetServicesRequest.Size(m)
}
func (m *GetServicesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServicesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetServicesRequest proto.InternalMessageInfo

// Response object to get service names.
type GetServicesResponse struct {
	Services             []string `protobuf:"bytes,1,rep,name=services,proto3" json:"services,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetServicesResponse) Reset()         { *m = GetServicesResponse{} }
func (m *GetServicesResponse) String() string { return proto.CompactTextString(m) }
func (*GetServicesResponse) ProtoMessage()    {}
func (*GetServicesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{4}
}
func (m *GetServicesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetServicesResponse.Unmarshal(m, b)
}
func (m *GetServicesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetServicesResponse.Marshal(b, m, deterministic)
}
func (m *GetServicesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetServicesResponse.Merge(m, src)
}
func (m *GetServicesResponse) XXX_Size() int {
	return xxx_messageInfo_GetServicesResponse.Size(m)
}
func (m *GetServicesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetServicesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetServicesResponse proto.InternalMessageInfo

func (m *GetServicesResponse) GetServices() []string {
	if m != nil {
		return m.Services
	}
	return nil
}

// Request object to get operation names.
type GetOperationsRequest struct {
	// Required service name.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Optional span kind.
	SpanKind             string   `protobuf:"bytes,2,opt,name=span_kind,json=spanKind,proto3" json:"span_kind,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOperationsRequest) Reset()         { *m = GetOperationsRequest{} }
func (m *GetOperationsRequest) String() string { return proto.CompactTextString(m) }
func (*GetOperationsRequest) ProtoMessage()    {}
func (*GetOperationsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{5}
}
func (m *GetOperationsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOperationsRequest.Unmarshal(m, b)
}
func (m *GetOperationsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOperationsRequest.Marshal(b, m, deterministic)
}
func (m *GetOperationsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOperationsRequest.Merge(m, src)
}
func (m *GetOperationsRequest) XXX_Size() int {
	return xxx_messageInfo_GetOperationsRequest.Size(m)
}
func (m *GetOperationsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOperationsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOperationsRequest proto.InternalMessageInfo

func (m *GetOperationsRequest) GetService() string {
	if m != nil {
		return m.Service
	}
	return ""
}

func (m *GetOperationsRequest) GetSpanKind() string {
	if m != nil {
		return m.SpanKind
	}
	return ""
}

// Operation encapsulates information about operation.
type Operation struct {
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	SpanKind             string   `protobuf:"bytes,2,opt,name=span_kind,json=spanKind,proto3" json:"span_kind,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Operation) Reset()         { *m = Operation{} }
func (m *Operation) String() string { return proto.CompactTextString(m) }
func (*Operation) ProtoMessage()    {}
func (*Operation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{6}
}
func (m *Operation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Operation.Unmarshal(m, b)
}
func (m *Operation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Operation.Marshal(b, m, deterministic)
}
func (m *Operation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Operation.Merge(m, src)
}
func (m *Operation) XXX_Size() int {
	return xxx_messageInfo_Operation.Size(m)
}
func (m *Operation) XXX_DiscardUnknown() {
	xxx_messageInfo_Operation.DiscardUnknown(m)
}

var xxx_messageInfo_Operation proto.InternalMessageInfo

func (m *Operation) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Operation) GetSpanKind() string {
	if m != nil {
		return m.SpanKind
	}
	return ""
}

// Response object to get operation names.
type GetOperationsResponse struct {
	Operations           []*Operation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *GetOperationsResponse) Reset()         { *m = GetOperationsResponse{} }
func (m *GetOperationsResponse) String() string { return proto.CompactTextString(m) }
func (*GetOperationsResponse) ProtoMessage()    {}
func (*GetOperationsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{7}
}
func (m *GetOperationsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOperationsResponse.Unmarshal(m, b)
}
func (m *GetOperationsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOperationsResponse.Marshal(b, m, deterministic)
}
func (m *GetOperationsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOperationsResponse.Merge(m, src)
}
func (m *GetOperationsResponse) XXX_Size() int {
	return xxx_messageInfo_GetOperationsResponse.Size(m)
}
func (m *GetOperationsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOperationsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GetOperationsResponse proto.InternalMessageInfo

func (m *GetOperationsResponse) GetOperations() []*Operation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// GRPCGatewayError is the type returned when GRPC server returns an error.
// Example: {"error":{"grpcCode":2,"httpCode":500,"message":"...","httpStatus":"text..."}}.
type GRPCGatewayError struct {
	Error                *GRPCGatewayError_GRPCGatewayErrorDetails `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *GRPCGatewayError) Reset()         { *m = GRPCGatewayError{} }
func (m *GRPCGatewayError) String() string { return proto.CompactTextString(m) }
func (*GRPCGatewayError) ProtoMessage()    {}
func (*GRPCGatewayError) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{8}
}
func (m *GRPCGatewayError) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GRPCGatewayError.Unmarshal(m, b)
}
func (m *GRPCGatewayError) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GRPCGatewayError.Marshal(b, m, deterministic)
}
func (m *GRPCGatewayError) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GRPCGatewayError.Merge(m, src)
}
func (m *GRPCGatewayError) XXX_Size() int {
	return xxx_messageInfo_GRPCGatewayError.Size(m)
}
func (m *GRPCGatewayError) XXX_DiscardUnknown() {
	xxx_messageInfo_GRPCGatewayError.DiscardUnknown(m)
}

var xxx_messageInfo_GRPCGatewayError proto.InternalMessageInfo

func (m *GRPCGatewayError) GetError() *GRPCGatewayError_GRPCGatewayErrorDetails {
	if m != nil {
		return m.Error
	}
	return nil
}

type GRPCGatewayError_GRPCGatewayErrorDetails struct {
	GrpcCode             int32    `protobuf:"varint,1,opt,name=grpcCode,proto3" json:"grpcCode,omitempty"`
	HttpCode             int32    `protobuf:"varint,2,opt,name=httpCode,proto3" json:"httpCode,omitempty"`
	Message              string   `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
	HttpStatus           string   `protobuf:"bytes,4,opt,name=httpStatus,proto3" json:"httpStatus,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GRPCGatewayError_GRPCGatewayErrorDetails) Reset() {
	*m = GRPCGatewayError_GRPCGatewayErrorDetails{}
}
func (m *GRPCGatewayError_GRPCGatewayErrorDetails) String() string { return proto.CompactTextString(m) }
func (*GRPCGatewayError_GRPCGatewayErrorDetails) ProtoMessage()    {}
func (*GRPCGatewayError_GRPCGatewayErrorDetails) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{8, 0}
}
func (m *GRPCGatewayError_GRPCGatewayErrorDetails) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GRPCGatewayError_GRPCGatewayErrorDetails.Unmarshal(m, b)
}
func (m *GRPCGatewayError_GRPCGatewayErrorDetails) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GRPCGatewayError_GRPCGatewayErrorDetails.Marshal(b, m, deterministic)
}
func (m *GRPCGatewayError_GRPCGatewayErrorDetails) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GRPCGatewayError_GRPCGatewayErrorDetails.Merge(m, src)
}
func (m *GRPCGatewayError_GRPCGatewayErrorDetails) XXX_Size() int {
	return xxx_messageInfo_GRPCGatewayError_GRPCGatewayErrorDetails.Size(m)
}
func (m *GRPCGatewayError_GRPCGatewayErrorDetails) XXX_DiscardUnknown() {
	xxx_messageInfo_GRPCGatewayError_GRPCGatewayErrorDetails.DiscardUnknown(m)
}

var xxx_messageInfo_GRPCGatewayError_GRPCGatewayErrorDetails proto.InternalMessageInfo

func (m *GRPCGatewayError_GRPCGatewayErrorDetails) GetGrpcCode() int32 {
	if m != nil {
		return m.GrpcCode
	}
	return 0
}

func (m *GRPCGatewayError_GRPCGatewayErrorDetails) GetHttpCode() int32 {
	if m != nil {
		return m.HttpCode
	}
	return 0
}

func (m *GRPCGatewayError_GRPCGatewayErrorDetails) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func (m *GRPCGatewayError_GRPCGatewayErrorDetails) GetHttpStatus() string {
	if m != nil {
		return m.HttpStatus
	}
	return ""
}

// GRPCGatewayWrapper wraps streaming responses from GetTrace/FindTraces for HTTP.
// Today there is always only one response because internally the HTTP server gets
// data from QueryService that does not support multiple responses. But in the
// future the server may return multiple responeses using Transfer-Encoding: chunked.
// In case of errors, GRPCGatewayError above is used.
//
// Example:
//     {"result": {"resourceSpans": ...}}
//
// See https://github.com/grpc-ecosystem/grpc-gateway/issues/2189
//
type GRPCGatewayWrapper struct {
	Result               *TracesData `protobuf:"bytes,1,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *GRPCGatewayWrapper) Reset()         { *m = GRPCGatewayWrapper{} }
func (m *GRPCGatewayWrapper) String() string { return proto.CompactTextString(m) }
func (*GRPCGatewayWrapper) ProtoMessage()    {}
func (*GRPCGatewayWrapper) Descriptor() ([]byte, []int) {
	return fileDescriptor_5fcb6756dc1afb8d, []int{9}
}
func (m *GRPCGatewayWrapper) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GRPCGatewayWrapper.Unmarshal(m, b)
}
func (m *GRPCGatewayWrapper) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GRPCGatewayWrapper.Marshal(b, m, deterministic)
}
func (m *GRPCGatewayWrapper) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GRPCGatewayWrapper.Merge(m, src)
}
func (m *GRPCGatewayWrapper) XXX_Size() int {
	return xxx_messageInfo_GRPCGatewayWrapper.Size(m)
}
func (m *GRPCGatewayWrapper) XXX_DiscardUnknown() {
	xxx_messageInfo_GRPCGatewayWrapper.DiscardUnknown(m)
}

var xxx_messageInfo_GRPCGatewayWrapper proto.InternalMessageInfo

func (m *GRPCGatewayWrapper) GetResult() *TracesData {
	if m != nil {
		return m.Result
	}
	return nil
}

func init() {
	proto.RegisterType((*GetTraceRequest)(nil), "jaeger.api_v3.GetTraceRequest")
	proto.RegisterType((*TraceQueryParameters)(nil), "jaeger.api_v3.TraceQueryParameters")
	proto.RegisterMapType((map[string]string)(nil), "jaeger.api_v3.TraceQueryParameters.AttributesEntry")
	proto.RegisterType((*FindTracesRequest)(nil), "jaeger.api_v3.FindTracesRequest")
	proto.RegisterType((*GetServicesRequest)(nil), "jaeger.api_v3.GetServicesRequest")
	proto.RegisterType((*GetServicesResponse)(nil), "jaeger.api_v3.GetServicesResponse")
	proto.RegisterType((*GetOperationsRequest)(nil), "jaeger.api_v3.GetOperationsRequest")
	proto.RegisterType((*Operation)(nil), "jaeger.api_v3.Operation")
	proto.RegisterType((*GetOperationsResponse)(nil), "jaeger.api_v3.GetOperationsResponse")
	proto.RegisterType((*GRPCGatewayError)(nil), "jaeger.api_v3.GRPCGatewayError")
	proto.RegisterType((*GRPCGatewayError_GRPCGatewayErrorDetails)(nil), "jaeger.api_v3.GRPCGatewayError.GRPCGatewayErrorDetails")
	proto.RegisterType((*GRPCGatewayWrapper)(nil), "jaeger.api_v3.GRPCGatewayWrapper")
}

func init() { proto.RegisterFile("query_service.proto", fileDescriptor_5fcb6756dc1afb8d) }

var fileDescriptor_5fcb6756dc1afb8d = []byte{
	// 819 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0xdd, 0x6e, 0xdc, 0x44,
	0x14, 0xae, 0x77, 0xb3, 0xc9, 0xfa, 0x6c, 0xd2, 0x96, 0xe9, 0xa2, 0xba, 0x46, 0xa4, 0x1b, 0x17,
	0xa4, 0xbd, 0x72, 0xc8, 0xe6, 0x82, 0x02, 0x45, 0x94, 0x36, 0x65, 0x85, 0x50, 0x4a, 0x3b, 0xa9,
	0x0a, 0x42, 0x95, 0xac, 0x49, 0x7c, 0x30, 0xa6, 0xeb, 0xb1, 0x3b, 0x33, 0x5e, 0xb2, 0xcf, 0xc0,
	0x0d, 0x12, 0x6f, 0xc1, 0x4b, 0xf1, 0x08, 0xbc, 0x00, 0x17, 0xc8, 0x33, 0x63, 0x77, 0xd7, 0x0b,
	0x21, 0xb9, 0xb2, 0xcf, 0x99, 0xef, 0x3b, 0x3f, 0xdf, 0x9c, 0x33, 0x70, 0xeb, 0x4d, 0x89, 0x62,
	0x11, 0x49, 0x14, 0xf3, 0xf4, 0x0c, 0xc3, 0x42, 0xe4, 0x2a, 0x27, 0x3b, 0x3f, 0x33, 0x4c, 0x50,
	0x84, 0xac, 0x48, 0xa3, 0xf9, 0xa1, 0x3f, 0xce, 0x0b, 0xe4, 0x0a, 0x67, 0x98, 0xa1, 0x12, 0x8b,
	0x7d, 0x8d, 0xd9, 0x57, 0x82, 0x9d, 0xe1, 0xfe, 0xfc, 0xc0, 0xfc, 0x18, 0xa2, 0x3f, 0x4c, 0xf2,
	0x24, 0x37, 0xe7, 0xd5, 0x9f, 0xf5, 0xde, 0x4d, 0xf2, 0x3c, 0x99, 0xa1, 0x21, 0x9e, 0x96, 0x3f,
	0xee, 0xab, 0x34, 0x43, 0xa9, 0x58, 0x56, 0x58, 0xc0, 0x6e, 0x1b, 0x10, 0x97, 0x82, 0xa9, 0x34,
	0xe7, 0xe6, 0x3c, 0xf8, 0xc3, 0x81, 0x1b, 0x53, 0x54, 0x2f, 0xaa, 0x4c, 0x14, 0xdf, 0x94, 0x28,
	0x15, 0xb9, 0x03, 0x7d, 0x9d, 0x39, 0x4a, 0x63, 0xcf, 0x19, 0x39, 0x63, 0x97, 0x6e, 0x69, 0xfb,
	0xeb, 0x98, 0x7c, 0x01, 0x20, 0x15, 0x13, 0x2a, 0xaa, 0xf2, 0x78, 0x9d, 0x91, 0x33, 0x1e, 0x4c,
	0xfc, 0xd0, 0xe4, 0x08, 0xeb, 0x1c, 0xe1, 0x8b, 0xba, 0x88, 0x47, 0x1b, 0xbf, 0xfd, 0x79, 0xd7,
	0xa1, 0xae, 0xe6, 0x54, 0x5e, 0xf2, 0x19, 0xf4, 0x91, 0xc7, 0x86, 0xde, 0xbd, 0x24, 0x7d, 0x0b,
	0x79, 0x5c, 0xf9, 0x82, 0xdf, 0x37, 0x60, 0xa8, 0x2b, 0x7d, 0x5e, 0x29, 0xfb, 0x8c, 0x09, 0x96,
	0xa1, 0x42, 0x21, 0xc9, 0x1e, 0x6c, 0x5b, 0x99, 0x23, 0xce, 0x32, 0xb4, 0x55, 0x0f, 0xac, 0xef,
	0x29, 0xcb, 0x90, 0x7c, 0x08, 0xd7, 0xf3, 0x02, 0x4d, 0xef, 0x06, 0xd4, 0xd1, 0xa0, 0x9d, 0xc6,
	0xab, 0x61, 0x27, 0x00, 0x4c, 0x29, 0x91, 0x9e, 0x96, 0x0a, 0xa5, 0xd7, 0x1d, 0x75, 0xc7, 0x83,
	0xc9, 0x61, 0xb8, 0x72, 0x69, 0xe1, 0xbf, 0x95, 0x10, 0x7e, 0xd9, 0xb0, 0x9e, 0x70, 0x25, 0x16,
	0x74, 0x29, 0x0c, 0x79, 0x08, 0xd7, 0xdf, 0xaa, 0x16, 0x65, 0x29, 0xf7, 0x36, 0xfe, 0xaf, 0x75,
	0xba, 0xdd, 0x68, 0x76, 0x9c, 0xf2, 0x76, 0x04, 0x76, 0xee, 0xf5, 0xae, 0x12, 0x81, 0x9d, 0x93,
	0x07, 0xb0, 0x5d, 0x5f, 0xbd, 0xae, 0x60, 0x53, 0xf3, 0xef, 0xac, 0xf1, 0x8f, 0x2c, 0x88, 0x0e,
	0x6a, 0x78, 0x95, 0x7f, 0x85, 0xcd, 0xce, 0xbd, 0xad, 0xcb, 0xb3, 0xd9, 0x39, 0x79, 0x1f, 0x80,
	0x97, 0x59, 0xa4, 0x87, 0x48, 0x7a, 0xfd, 0x91, 0x33, 0xee, 0x51, 0x97, 0x97, 0x99, 0x16, 0x52,
	0xfa, 0x9f, 0xc3, 0x8d, 0x96, 0x7a, 0xe4, 0x26, 0x74, 0x5f, 0xe3, 0xc2, 0xde, 0x63, 0xf5, 0x4b,
	0x86, 0xd0, 0x9b, 0xb3, 0x59, 0x59, 0x5f, 0x9b, 0x31, 0x3e, 0xed, 0xdc, 0x77, 0x82, 0xa7, 0xf0,
	0xce, 0x57, 0x29, 0x8f, 0x4d, 0xb0, 0x7a, 0x86, 0x3f, 0x81, 0x9e, 0x5e, 0x3f, 0x1d, 0x62, 0x30,
	0xb9, 0x77, 0x89, 0x2b, 0xa4, 0x86, 0x11, 0x0c, 0x81, 0x4c, 0x51, 0x9d, 0x98, 0xd9, 0xa9, 0x03,
	0x06, 0x07, 0x70, 0x6b, 0xc5, 0x2b, 0x8b, 0x9c, 0x4b, 0x24, 0x3e, 0xf4, 0xed, 0x94, 0x49, 0xcf,
	0x19, 0x75, 0xc7, 0x2e, 0x6d, 0xec, 0xe0, 0x18, 0x86, 0x53, 0x54, 0xdf, 0xd6, 0xf3, 0xd5, 0xd4,
	0xe6, 0xc1, 0x96, 0xc5, 0xd4, 0xeb, 0x65, 0x4d, 0xf2, 0x1e, 0xb8, 0xb2, 0x60, 0x3c, 0x7a, 0x9d,
	0xf2, 0xd8, 0x36, 0xda, 0xaf, 0x1c, 0xdf, 0xa4, 0x3c, 0x0e, 0x1e, 0x80, 0xdb, 0xc4, 0x22, 0x04,
	0x36, 0x96, 0x26, 0x5d, 0xff, 0x5f, 0xcc, 0x7e, 0x0e, 0xef, 0xb6, 0x8a, 0xb1, 0x1d, 0xdc, 0x07,
	0x68, 0x56, 0xc0, 0xf4, 0x30, 0x98, 0x78, 0x2d, 0xb9, 0x1a, 0x1a, 0x5d, 0xc2, 0x06, 0x7f, 0x39,
	0x70, 0x73, 0x4a, 0x9f, 0x3d, 0x9e, 0x32, 0x85, 0xbf, 0xb0, 0xc5, 0x13, 0x21, 0x72, 0x41, 0x8e,
	0xa1, 0x87, 0xd5, 0x8f, 0x15, 0xfe, 0xe3, 0x56, 0xa4, 0x36, 0x7e, 0xcd, 0x71, 0x84, 0x8a, 0xa5,
	0x33, 0x49, 0x4d, 0x14, 0xff, 0x57, 0x07, 0x6e, 0xff, 0x07, 0xa4, 0xd2, 0x3e, 0x11, 0xc5, 0xd9,
	0xe3, 0x3c, 0x36, 0x3a, 0xf4, 0x68, 0x63, 0x57, 0x67, 0x3f, 0x29, 0x55, 0xe8, 0xb3, 0x8e, 0x39,
	0xab, 0xed, 0x4a, 0xff, 0x0c, 0xa5, 0x64, 0x89, 0x79, 0x82, 0x5c, 0x5a, 0x9b, 0x64, 0x17, 0xa0,
	0x42, 0x9d, 0x28, 0xa6, 0x4a, 0xa9, 0x97, 0xd4, 0xa5, 0x4b, 0x9e, 0xe0, 0x25, 0x90, 0xa5, 0x62,
	0xbe, 0x13, 0xac, 0x28, 0x50, 0x90, 0x87, 0xb0, 0x29, 0x50, 0x96, 0x33, 0x65, 0x7b, 0x1e, 0x87,
	0x2b, 0xaf, 0xba, 0xd9, 0x8e, 0xd0, 0x3c, 0xe6, 0xf3, 0x03, 0x33, 0x7b, 0xf2, 0x88, 0x29, 0x46,
	0x2d, 0x6f, 0xf2, 0x77, 0x07, 0xb6, 0xf5, 0x34, 0xda, 0xf9, 0x22, 0xdf, 0x43, 0xbf, 0x7e, 0x95,
	0xc9, 0x6e, 0x5b, 0xc2, 0xd5, 0xe7, 0xda, 0xbf, 0x74, 0xba, 0xe0, 0xda, 0x47, 0x0e, 0x79, 0x05,
	0xf0, 0x76, 0x5b, 0xc8, 0xa8, 0x15, 0x7b, 0x6d, 0x91, 0xae, 0x18, 0xfd, 0x25, 0x0c, 0x96, 0xb6,
	0x84, 0xec, 0xad, 0x97, 0xde, 0xda, 0x2b, 0x3f, 0xb8, 0x08, 0x62, 0x46, 0x34, 0xb8, 0x46, 0x5e,
	0xc1, 0xce, 0xca, 0xf4, 0x92, 0x7b, 0xeb, 0xb4, 0xb5, 0x45, 0xf3, 0x3f, 0xb8, 0x18, 0x54, 0x47,
	0x7f, 0xb4, 0x07, 0xb7, 0xd3, 0xdc, 0x62, 0xab, 0xce, 0x52, 0x9e, 0x58, 0xca, 0x0f, 0x9b, 0xe6,
	0x7b, 0xba, 0xa9, 0xfb, 0x3e, 0xfc, 0x27, 0x00, 0x00, 0xff, 0xff, 0x04, 0x2f, 0x8b, 0x11, 0xd5,
	0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// QueryServiceClient is the client API for QueryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type QueryServiceClient interface {
	// GetTrace returns a single trace.
	// Note that the JSON response over HTTP is wrapped into result envelope "{"result": ...}"
	// It means that the JSON response cannot be directly unmarshalled using JSONPb.
	// This can be fixed by first parsing into user-defined envelope with standard JSON library
	// or string manipulation to remove the envelope. Alternatively generate objects using OpenAPI.
	GetTrace(ctx context.Context, in *GetTraceRequest, opts ...grpc.CallOption) (QueryService_GetTraceClient, error)
	// FindTraces searches for traces.
	// See GetTrace for JSON unmarshalling.
	FindTraces(ctx context.Context, in *FindTracesRequest, opts ...grpc.CallOption) (QueryService_FindTracesClient, error)
	// GetServices returns service names.
	GetServices(ctx context.Context, in *GetServicesRequest, opts ...grpc.CallOption) (*GetServicesResponse, error)
	// GetOperations returns operation names.
	GetOperations(ctx context.Context, in *GetOperationsRequest, opts ...grpc.CallOption) (*GetOperationsResponse, error)
}

type queryServiceClient struct {
	cc *grpc.ClientConn
}

func NewQueryServiceClient(cc *grpc.ClientConn) QueryServiceClient {
	return &queryServiceClient{cc}
}

func (c *queryServiceClient) GetTrace(ctx context.Context, in *GetTraceRequest, opts ...grpc.CallOption) (QueryService_GetTraceClient, error) {
	stream, err := c.cc.NewStream(ctx, &_QueryService_serviceDesc.Streams[0], "/jaeger.api_v3.QueryService/GetTrace", opts...)
	if err != nil {
		return nil, err
	}
	x := &queryServiceGetTraceClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type QueryService_GetTraceClient interface {
	Recv() (*TracesData, error)
	grpc.ClientStream
}

type queryServiceGetTraceClient struct {
	grpc.ClientStream
}

func (x *queryServiceGetTraceClient) Recv() (*TracesData, error) {
	m := new(TracesData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *queryServiceClient) FindTraces(ctx context.Context, in *FindTracesRequest, opts ...grpc.CallOption) (QueryService_FindTracesClient, error) {
	stream, err := c.cc.NewStream(ctx, &_QueryService_serviceDesc.Streams[1], "/jaeger.api_v3.QueryService/FindTraces", opts...)
	if err != nil {
		return nil, err
	}
	x := &queryServiceFindTracesClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type QueryService_FindTracesClient interface {
	Recv() (*TracesData, error)
	grpc.ClientStream
}

type queryServiceFindTracesClient struct {
	grpc.ClientStream
}

func (x *queryServiceFindTracesClient) Recv() (*TracesData, error) {
	m := new(TracesData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *queryServiceClient) GetServices(ctx context.Context, in *GetServicesRequest, opts ...grpc.CallOption) (*GetServicesResponse, error) {
	out := new(GetServicesResponse)
	err := c.cc.Invoke(ctx, "/jaeger.api_v3.QueryService/GetServices", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *queryServiceClient) GetOperations(ctx context.Context, in *GetOperationsRequest, opts ...grpc.CallOption) (*GetOperationsResponse, error) {
	out := new(GetOperationsResponse)
	err := c.cc.Invoke(ctx, "/jaeger.api_v3.QueryService/GetOperations", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// QueryServiceServer is the server API for QueryService service.
type QueryServiceServer interface {
	// GetTrace returns a single trace.
	// Note that the JSON response over HTTP is wrapped into result envelope "{"result": ...}"
	// It means that the JSON response cannot be directly unmarshalled using JSONPb.
	// This can be fixed by first parsing into user-defined envelope with standard JSON library
	// or string manipulation to remove the envelope. Alternatively generate objects using OpenAPI.
	GetTrace(*GetTraceRequest, QueryService_GetTraceServer) error
	// FindTraces searches for traces.
	// See GetTrace for JSON unmarshalling.
	FindTraces(*FindTracesRequest, QueryService_FindTracesServer) error
	// GetServices returns service names.
	GetServices(context.Context, *GetServicesRequest) (*GetServicesResponse, error)
	// GetOperations returns operation names.
	GetOperations(context.Context, *GetOperationsRequest) (*GetOperationsResponse, error)
}

// UnimplementedQueryServiceServer can be embedded to have forward compatible implementations.
type UnimplementedQueryServiceServer struct {
}

func (*UnimplementedQueryServiceServer) GetTrace(req *GetTraceRequest, srv QueryService_GetTraceServer) error {
	return status.Errorf(codes.Unimplemented, "method GetTrace not implemented")
}
func (*UnimplementedQueryServiceServer) FindTraces(req *FindTracesRequest, srv QueryService_FindTracesServer) error {
	return status.Errorf(codes.Unimplemented, "method FindTraces not implemented")
}
func (*UnimplementedQueryServiceServer) GetServices(ctx context.Context, req *GetServicesRequest) (*GetServicesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServices not implemented")
}
func (*UnimplementedQueryServiceServer) GetOperations(ctx context.Context, req *GetOperationsRequest) (*GetOperationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOperations not implemented")
}

func RegisterQueryServiceServer(s *grpc.Server, srv QueryServiceServer) {
	s.RegisterService(&_QueryService_serviceDesc, srv)
}

func _QueryService_GetTrace_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTraceRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(QueryServiceServer).GetTrace(m, &queryServiceGetTraceServer{stream})
}

type QueryService_GetTraceServer interface {
	Send(*TracesData) error
	grpc.ServerStream
}

type queryServiceGetTraceServer struct {
	grpc.ServerStream
}

func (x *queryServiceGetTraceServer) Send(m *TracesData) error {
	return x.ServerStream.SendMsg(m)
}

func _QueryService_FindTraces_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindTracesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(QueryServiceServer).FindTraces(m, &queryServiceFindTracesServer{stream})
}

type QueryService_FindTracesServer interface {
	Send(*TracesData) error
	grpc.ServerStream
}

type queryServiceFindTracesServer struct {
	grpc.ServerStream
}

func (x *queryServiceFindTracesServer) Send(m *TracesData) error {
	return x.ServerStream.SendMsg(m)
}

func _QueryService_GetServices_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServiceServer).GetServices(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/jaeger.api_v3.QueryService/GetServices",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServiceServer).GetServices(ctx, req.(*GetServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _QueryService_GetOperations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(QueryServiceServer).GetOperations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/jaeger.api_v3.QueryService/GetOperations",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(QueryServiceServer).GetOperations(ctx, req.(*GetOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _QueryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "jaeger.api_v3.QueryService",
	HandlerType: (*QueryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetServices",
			Handler:    _QueryService_GetServices_Handler,
		},
		{
			MethodName: "GetOperations",
			Handler:    _QueryService_GetOperations_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetTrace",
			Handler:       _QueryService_GetTrace_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindTraces",
			Handler:       _QueryService_FindTraces_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "query_service.proto",
}
