// Copyright (c) The Jaeger Authors.
// SPDX-License-Identifier: Apache-2.0
//
// Run 'make generate-mocks' to regenerate.

// Code generated by mockery. DO NOT EDIT.

package mocks

import (
	client "github.com/jaegertracing/jaeger/pkg/es/client"
	mock "github.com/stretchr/testify/mock"
)

// IndexAPI is an autogenerated mock type for the IndexAPI type
type IndexAPI struct {
	mock.Mock
}

// CreateAlias provides a mock function with given fields: aliases
func (_m *IndexAPI) CreateAlias(aliases []client.Alias) error {
	ret := _m.Called(aliases)

	if len(ret) == 0 {
		panic("no return value specified for CreateAlias")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func([]client.Alias) error); ok {
		r0 = rf(aliases)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CreateIndex provides a mock function with given fields: index
func (_m *IndexAPI) CreateIndex(index string) error {
	ret := _m.Called(index)

	if len(ret) == 0 {
		panic("no return value specified for CreateIndex")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string) error); ok {
		r0 = rf(index)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CreateTemplate provides a mock function with given fields: template, name
func (_m *IndexAPI) CreateTemplate(template string, name string) error {
	ret := _m.Called(template, name)

	if len(ret) == 0 {
		panic("no return value specified for CreateTemplate")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string) error); ok {
		r0 = rf(template, name)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteAlias provides a mock function with given fields: aliases
func (_m *IndexAPI) DeleteAlias(aliases []client.Alias) error {
	ret := _m.Called(aliases)

	if len(ret) == 0 {
		panic("no return value specified for DeleteAlias")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func([]client.Alias) error); ok {
		r0 = rf(aliases)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// DeleteIndices provides a mock function with given fields: indices
func (_m *IndexAPI) DeleteIndices(indices []client.Index) error {
	ret := _m.Called(indices)

	if len(ret) == 0 {
		panic("no return value specified for DeleteIndices")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func([]client.Index) error); ok {
		r0 = rf(indices)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetJaegerIndices provides a mock function with given fields: prefix
func (_m *IndexAPI) GetJaegerIndices(prefix string) ([]client.Index, error) {
	ret := _m.Called(prefix)

	if len(ret) == 0 {
		panic("no return value specified for GetJaegerIndices")
	}

	var r0 []client.Index
	var r1 error
	if rf, ok := ret.Get(0).(func(string) ([]client.Index, error)); ok {
		return rf(prefix)
	}
	if rf, ok := ret.Get(0).(func(string) []client.Index); ok {
		r0 = rf(prefix)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]client.Index)
		}
	}

	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(prefix)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Rollover provides a mock function with given fields: rolloverTarget, conditions
func (_m *IndexAPI) Rollover(rolloverTarget string, conditions map[string]any) error {
	ret := _m.Called(rolloverTarget, conditions)

	if len(ret) == 0 {
		panic("no return value specified for Rollover")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, map[string]any) error); ok {
		r0 = rf(rolloverTarget, conditions)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NewIndexAPI creates a new instance of IndexAPI. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewIndexAPI(t interface {
	mock.TestingT
	Cleanup(func())
}) *IndexAPI {
	mock := &IndexAPI{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
