// Copyright (c) The Jaeger Authors.
// SPDX-License-Identifier: Apache-2.0
//
// Run 'make generate-mocks' to regenerate.

// Code generated by mockery. DO NOT EDIT.

package mocks

import (
	context "context"

	es "github.com/jaegertracing/jaeger/pkg/es"
	elastic "github.com/olivere/elastic"

	mock "github.com/stretchr/testify/mock"
)

// SearchService is an autogenerated mock type for the SearchService type
type SearchService struct {
	mock.Mock
}

// Aggregation provides a mock function with given fields: name, aggregation
func (_m *SearchService) Aggregation(name string, aggregation elastic.Aggregation) es.SearchService {
	ret := _m.Called(name, aggregation)

	if len(ret) == 0 {
		panic("no return value specified for Aggregation")
	}

	var r0 es.SearchService
	if rf, ok := ret.Get(0).(func(string, elastic.Aggregation) es.SearchService); ok {
		r0 = rf(name, aggregation)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(es.SearchService)
		}
	}

	return r0
}

// Do provides a mock function with given fields: ctx
func (_m *SearchService) Do(ctx context.Context) (*elastic.SearchResult, error) {
	ret := _m.Called(ctx)

	if len(ret) == 0 {
		panic("no return value specified for Do")
	}

	var r0 *elastic.SearchResult
	var r1 error
	if rf, ok := ret.Get(0).(func(context.Context) (*elastic.SearchResult, error)); ok {
		return rf(ctx)
	}
	if rf, ok := ret.Get(0).(func(context.Context) *elastic.SearchResult); ok {
		r0 = rf(ctx)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*elastic.SearchResult)
		}
	}

	if rf, ok := ret.Get(1).(func(context.Context) error); ok {
		r1 = rf(ctx)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// IgnoreUnavailable provides a mock function with given fields: ignoreUnavailable
func (_m *SearchService) IgnoreUnavailable(ignoreUnavailable bool) es.SearchService {
	ret := _m.Called(ignoreUnavailable)

	if len(ret) == 0 {
		panic("no return value specified for IgnoreUnavailable")
	}

	var r0 es.SearchService
	if rf, ok := ret.Get(0).(func(bool) es.SearchService); ok {
		r0 = rf(ignoreUnavailable)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(es.SearchService)
		}
	}

	return r0
}

// Query provides a mock function with given fields: query
func (_m *SearchService) Query(query elastic.Query) es.SearchService {
	ret := _m.Called(query)

	if len(ret) == 0 {
		panic("no return value specified for Query")
	}

	var r0 es.SearchService
	if rf, ok := ret.Get(0).(func(elastic.Query) es.SearchService); ok {
		r0 = rf(query)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(es.SearchService)
		}
	}

	return r0
}

// Size provides a mock function with given fields: size
func (_m *SearchService) Size(size int) es.SearchService {
	ret := _m.Called(size)

	if len(ret) == 0 {
		panic("no return value specified for Size")
	}

	var r0 es.SearchService
	if rf, ok := ret.Get(0).(func(int) es.SearchService); ok {
		r0 = rf(size)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(es.SearchService)
		}
	}

	return r0
}

// NewSearchService creates a new instance of SearchService. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewSearchService(t interface {
	mock.TestingT
	Cleanup(func())
}) *SearchService {
	mock := &SearchService{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
