// Copyright (c) The Jaeger Authors.
// SPDX-License-Identifier: Apache-2.0
//
// Run 'make generate-mocks' to regenerate.

// Code generated by mockery. DO NOT EDIT.

package mocks

import (
	model "github.com/jaegertracing/jaeger/cmd/collector/app/sampling/model"
	mock "github.com/stretchr/testify/mock"

	time "time"
)

// Store is an autogenerated mock type for the Store type
type Store struct {
	mock.Mock
}

// GetLatestProbabilities provides a mock function with given fields:
func (_m *Store) GetLatestProbabilities() (model.ServiceOperationProbabilities, error) {
	ret := _m.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetLatestProbabilities")
	}

	var r0 model.ServiceOperationProbabilities
	var r1 error
	if rf, ok := ret.Get(0).(func() (model.ServiceOperationProbabilities, error)); ok {
		return rf()
	}
	if rf, ok := ret.Get(0).(func() model.ServiceOperationProbabilities); ok {
		r0 = rf()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(model.ServiceOperationProbabilities)
		}
	}

	if rf, ok := ret.Get(1).(func() error); ok {
		r1 = rf()
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetThroughput provides a mock function with given fields: start, end
func (_m *Store) GetThroughput(start time.Time, end time.Time) ([]*model.Throughput, error) {
	ret := _m.Called(start, end)

	if len(ret) == 0 {
		panic("no return value specified for GetThroughput")
	}

	var r0 []*model.Throughput
	var r1 error
	if rf, ok := ret.Get(0).(func(time.Time, time.Time) ([]*model.Throughput, error)); ok {
		return rf(start, end)
	}
	if rf, ok := ret.Get(0).(func(time.Time, time.Time) []*model.Throughput); ok {
		r0 = rf(start, end)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*model.Throughput)
		}
	}

	if rf, ok := ret.Get(1).(func(time.Time, time.Time) error); ok {
		r1 = rf(start, end)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// InsertProbabilitiesAndQPS provides a mock function with given fields: hostname, probabilities, qps
func (_m *Store) InsertProbabilitiesAndQPS(hostname string, probabilities model.ServiceOperationProbabilities, qps model.ServiceOperationQPS) error {
	ret := _m.Called(hostname, probabilities, qps)

	if len(ret) == 0 {
		panic("no return value specified for InsertProbabilitiesAndQPS")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func(string, model.ServiceOperationProbabilities, model.ServiceOperationQPS) error); ok {
		r0 = rf(hostname, probabilities, qps)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// InsertThroughput provides a mock function with given fields: throughput
func (_m *Store) InsertThroughput(throughput []*model.Throughput) error {
	ret := _m.Called(throughput)

	if len(ret) == 0 {
		panic("no return value specified for InsertThroughput")
	}

	var r0 error
	if rf, ok := ret.Get(0).(func([]*model.Throughput) error); ok {
		r0 = rf(throughput)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NewStore creates a new instance of Store. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewStore(t interface {
	mock.TestingT
	Cleanup(func())
}) *Store {
	mock := &Store{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}
