
/*
 * Copyright (C) 2024 NetApp
 */


#ifndef _NGX_SHARED_METRICS_H_INCLUDED_
#define _NGX_SHARED_METRICS_H_INCLUDED_

#include <ngx_config.h>
#include <ngx_core.h>

typedef volatile ngx_atomic_int_t sg_atomic_t;

typedef enum {
    NGX_ZERO_REQ_CONN = 0,
    NGX_ONE_REQ_CONN,
    NGX_REUSED_CONN,
    NGX_COMPLETED_CONN,
    NGX_COMPLETED_REQ,
    NGX_INIT_HTTP_CONN = 5,
    NGX_TOTAL_IDLE_UPSTREAM_CONN,
    NGX_NEW_UPSTREAM_CONN,
    NGX_REUSED_UPSTREAM_CONN,
} ngx_metric_type_e;

struct ngx_conn_metrics_s {
    ngx_atomic_t  ngx_zero_req_conn;
    ngx_atomic_t  ngx_one_req_conn;
    ngx_atomic_t  ngx_reused_req_conn;
    ngx_atomic_t  ngx_completed_conn;
    ngx_atomic_t  ngx_completed_req;
    ngx_atomic_t  ngx_initiated_http_conn;
    sg_atomic_t   ngx_total_idle_upstream_conn;
    ngx_atomic_t  ngx_new_upstream_conn;
    ngx_atomic_t  ngx_reused_upstream_conn;
};
typedef struct ngx_conn_metrics_s    ngx_conn_metrics_t;


extern volatile ngx_conn_metrics_t* ngx_conn_metrics;

int ngx_init_shared_metrics();
void ngx_unlink_shared_metrics();

int ngx_fetch_add_shared_metrics(int metricType, ngx_int_t delta);
int ngx_fetch_sub_shared_metrics(int metricType, ngx_int_t delta);

ngx_atomic_uint_t ngx_fetch_shared_metric(int metricType);


#endif /* _NGX_SHARED_METRICS_H_INCLUDED_ */
