// Code generated by smithy-go-codegen DO NOT EDIT.

//go:build snapshot

package awsrestjson

import (
	"context"
	"errors"
	"fmt"
	"github.com/aws/smithy-go/middleware"
	"io"
	"io/fs"
	"os"
	"testing"
)

const ssprefix = "snapshot"

type snapshotOK struct{}

func (snapshotOK) Error() string { return "error: success" }

func createp(path string) (*os.File, error) {
	if err := os.Mkdir(ssprefix, 0700); err != nil && !errors.Is(err, fs.ErrExist) {
		return nil, err
	}
	return os.Create(path)
}

func sspath(op string) string {
	return fmt.Sprintf("%s/api_op_%s.go.snap", ssprefix, op)
}

func updateSnapshot(stack *middleware.Stack, operation string) error {
	f, err := createp(sspath(operation))
	if err != nil {
		return err
	}
	defer f.Close()
	if _, err := f.Write([]byte(stack.String())); err != nil {
		return err
	}
	return snapshotOK{}
}

func testSnapshot(stack *middleware.Stack, operation string) error {
	f, err := os.Open(sspath(operation))
	if errors.Is(err, fs.ErrNotExist) {
		return snapshotOK{}
	}
	if err != nil {
		return err
	}
	defer f.Close()
	expected, err := io.ReadAll(f)
	if err != nil {
		return err
	}
	if actual := stack.String(); actual != string(expected) {
		return fmt.Errorf("%s != %s", expected, actual)
	}
	return snapshotOK{}
}
func TestCheckSnapshot_AllQueryStringTypes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.AllQueryStringTypes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "AllQueryStringTypes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_ConstantAndVariableQueryString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ConstantAndVariableQueryString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "ConstantAndVariableQueryString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_ConstantQueryString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ConstantQueryString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "ConstantQueryString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_ContentTypeParameters(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ContentTypeParameters(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "ContentTypeParameters")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_DatetimeOffsets(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DatetimeOffsets(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "DatetimeOffsets")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_DocumentType(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DocumentType(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "DocumentType")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_DocumentTypeAsMapValue(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DocumentTypeAsMapValue(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "DocumentTypeAsMapValue")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_DocumentTypeAsPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DocumentTypeAsPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "DocumentTypeAsPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_EmptyInputAndEmptyOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EmptyInputAndEmptyOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "EmptyInputAndEmptyOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_EndpointOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "EndpointOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_EndpointWithHostLabelOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointWithHostLabelOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "EndpointWithHostLabelOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_FractionalSeconds(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FractionalSeconds(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "FractionalSeconds")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_GreetingWithErrors(t *testing.T) {
	svc := New(Options{})
	_, err := svc.GreetingWithErrors(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "GreetingWithErrors")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HostWithPathOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HostWithPathOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HostWithPathOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpChecksumRequired(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpChecksumRequired(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpChecksumRequired")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpEnumPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpEnumPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpEnumPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadTraits(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadTraits(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadTraits")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadTraitsWithMediaType(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadTraitsWithMediaType(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadTraitsWithMediaType")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadWithStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadWithStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadWithUnion(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithUnion(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadWithUnion")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPrefixHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPrefixHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPrefixHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPrefixHeadersInResponse(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPrefixHeadersInResponse(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPrefixHeadersInResponse")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithFloatLabels(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithFloatLabels(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithFloatLabels")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithGreedyLabelInPath(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithGreedyLabelInPath(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithGreedyLabelInPath")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithLabels(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithLabels(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithLabels")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithLabelsAndTimestampFormat(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithLabelsAndTimestampFormat(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithLabelsAndTimestampFormat")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithRegexLiteral(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithRegexLiteral(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithRegexLiteral")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpResponseCode(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpResponseCode(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpResponseCode")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpStringPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpStringPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpStringPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_IgnoreQueryParamsInResponse(t *testing.T) {
	svc := New(Options{})
	_, err := svc.IgnoreQueryParamsInResponse(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "IgnoreQueryParamsInResponse")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_InputAndOutputWithHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.InputAndOutputWithHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "InputAndOutputWithHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_JsonBlobs(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonBlobs(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "JsonBlobs")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_JsonEnums(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonEnums(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "JsonEnums")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_JsonIntEnums(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonIntEnums(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "JsonIntEnums")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_JsonLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "JsonLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_JsonMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "JsonMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_JsonTimestamps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonTimestamps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "JsonTimestamps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_JsonUnions(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonUnions(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "JsonUnions")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedAcceptWithBody(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedAcceptWithBody(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedAcceptWithBody")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedAcceptWithGenericString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedAcceptWithGenericString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedAcceptWithGenericString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedAcceptWithPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedAcceptWithPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedAcceptWithPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedBlob(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedBlob(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedBlob")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedBoolean(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedBoolean(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedBoolean")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedByte(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedByte(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedByte")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedContentTypeWithBody(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithBody(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedContentTypeWithBody")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedContentTypeWithGenericString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithGenericString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedContentTypeWithGenericString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedContentTypeWithoutBody(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithoutBody(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedContentTypeWithoutBody")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedContentTypeWithoutBodyEmptyInput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithoutBodyEmptyInput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedContentTypeWithoutBodyEmptyInput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedContentTypeWithPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedContentTypeWithPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedDouble(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedDouble(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedDouble")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedFloat(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedFloat(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedFloat")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedInteger(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedInteger(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedInteger")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedList(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedList(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedList")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedLong(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedLong(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedLong")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedMap(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedMap(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedMap")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedRequestBody(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedRequestBody(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedRequestBody")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedShort(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedShort(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedShort")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampBodyDateTime(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampBodyDateTime(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampBodyDateTime")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampBodyDefault(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampBodyDefault(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampBodyDefault")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampBodyHttpDate(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampBodyHttpDate(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampBodyHttpDate")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampHeaderDateTime(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampHeaderDateTime(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampHeaderDateTime")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampHeaderDefault(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampHeaderDefault(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampHeaderDefault")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampHeaderEpoch(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampHeaderEpoch(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampHeaderEpoch")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampPathDefault(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampPathDefault(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampPathDefault")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampPathEpoch(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampPathEpoch(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampPathEpoch")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampPathHttpDate(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampPathHttpDate(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampPathHttpDate")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampQueryDefault(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampQueryDefault(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampQueryDefault")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampQueryEpoch(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampQueryEpoch(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampQueryEpoch")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedTimestampQueryHttpDate(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampQueryHttpDate(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedTimestampQueryHttpDate")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MalformedUnion(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedUnion(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MalformedUnion")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_MediaTypeHeader(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MediaTypeHeader(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "MediaTypeHeader")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NoInputAndNoOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NoInputAndNoOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NoInputAndNoOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NoInputAndOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NoInputAndOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NoInputAndOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NullAndEmptyHeadersClient(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NullAndEmptyHeadersClient(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NullAndEmptyHeadersClient")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NullAndEmptyHeadersServer(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NullAndEmptyHeadersServer(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NullAndEmptyHeadersServer")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_OmitsNullSerializesEmptyString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OmitsNullSerializesEmptyString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "OmitsNullSerializesEmptyString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_OmitsSerializingEmptyLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OmitsSerializingEmptyLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "OmitsSerializingEmptyLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_OperationWithDefaults(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OperationWithDefaults(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "OperationWithDefaults")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_OperationWithNestedStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OperationWithNestedStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "OperationWithNestedStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_PostPlayerAction(t *testing.T) {
	svc := New(Options{})
	_, err := svc.PostPlayerAction(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "PostPlayerAction")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_PostUnionWithJsonName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.PostUnionWithJsonName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "PostUnionWithJsonName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_PutWithContentEncoding(t *testing.T) {
	svc := New(Options{})
	_, err := svc.PutWithContentEncoding(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "PutWithContentEncoding")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_QueryIdempotencyTokenAutoFill(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryIdempotencyTokenAutoFill(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "QueryIdempotencyTokenAutoFill")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_QueryParamsAsStringListMap(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryParamsAsStringListMap(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "QueryParamsAsStringListMap")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_QueryPrecedence(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryPrecedence(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "QueryPrecedence")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_RecursiveShapes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.RecursiveShapes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "RecursiveShapes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_ResponseCodeHttpFallback(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ResponseCodeHttpFallback(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "ResponseCodeHttpFallback")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_ResponseCodeRequired(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ResponseCodeRequired(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "ResponseCodeRequired")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_SimpleScalarProperties(t *testing.T) {
	svc := New(Options{})
	_, err := svc.SimpleScalarProperties(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "SimpleScalarProperties")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_SparseJsonLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.SparseJsonLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "SparseJsonLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_SparseJsonMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.SparseJsonMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "SparseJsonMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_StreamingTraits(t *testing.T) {
	svc := New(Options{})
	_, err := svc.StreamingTraits(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "StreamingTraits")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_StreamingTraitsRequireLength(t *testing.T) {
	svc := New(Options{})
	_, err := svc.StreamingTraitsRequireLength(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "StreamingTraitsRequireLength")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_StreamingTraitsWithMediaType(t *testing.T) {
	svc := New(Options{})
	_, err := svc.StreamingTraitsWithMediaType(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "StreamingTraitsWithMediaType")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TestBodyStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestBodyStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TestBodyStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TestGetNoInputNoPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestGetNoInputNoPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TestGetNoInputNoPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TestGetNoPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestGetNoPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TestGetNoPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TestPayloadBlob(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestPayloadBlob(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TestPayloadBlob")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TestPayloadStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestPayloadStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TestPayloadStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TestPostNoInputNoPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestPostNoInputNoPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TestPostNoInputNoPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TestPostNoPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestPostNoPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TestPostNoPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TimestampFormatHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TimestampFormatHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TimestampFormatHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_UnitInputAndOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.UnitInputAndOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "UnitInputAndOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}
func TestUpdateSnapshot_AllQueryStringTypes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.AllQueryStringTypes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "AllQueryStringTypes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_ConstantAndVariableQueryString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ConstantAndVariableQueryString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "ConstantAndVariableQueryString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_ConstantQueryString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ConstantQueryString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "ConstantQueryString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_ContentTypeParameters(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ContentTypeParameters(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "ContentTypeParameters")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_DatetimeOffsets(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DatetimeOffsets(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "DatetimeOffsets")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_DocumentType(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DocumentType(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "DocumentType")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_DocumentTypeAsMapValue(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DocumentTypeAsMapValue(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "DocumentTypeAsMapValue")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_DocumentTypeAsPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DocumentTypeAsPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "DocumentTypeAsPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_EmptyInputAndEmptyOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EmptyInputAndEmptyOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "EmptyInputAndEmptyOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_EndpointOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "EndpointOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_EndpointWithHostLabelOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointWithHostLabelOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "EndpointWithHostLabelOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_FractionalSeconds(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FractionalSeconds(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "FractionalSeconds")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_GreetingWithErrors(t *testing.T) {
	svc := New(Options{})
	_, err := svc.GreetingWithErrors(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "GreetingWithErrors")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HostWithPathOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HostWithPathOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HostWithPathOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpChecksumRequired(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpChecksumRequired(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpChecksumRequired")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpEnumPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpEnumPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpEnumPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadTraits(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadTraits(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadTraits")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadTraitsWithMediaType(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadTraitsWithMediaType(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadTraitsWithMediaType")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadWithStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadWithStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadWithUnion(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithUnion(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadWithUnion")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPrefixHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPrefixHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPrefixHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPrefixHeadersInResponse(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPrefixHeadersInResponse(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPrefixHeadersInResponse")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithFloatLabels(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithFloatLabels(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithFloatLabels")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithGreedyLabelInPath(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithGreedyLabelInPath(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithGreedyLabelInPath")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithLabels(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithLabels(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithLabels")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithLabelsAndTimestampFormat(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithLabelsAndTimestampFormat(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithLabelsAndTimestampFormat")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithRegexLiteral(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithRegexLiteral(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithRegexLiteral")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpResponseCode(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpResponseCode(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpResponseCode")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpStringPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpStringPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpStringPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_IgnoreQueryParamsInResponse(t *testing.T) {
	svc := New(Options{})
	_, err := svc.IgnoreQueryParamsInResponse(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "IgnoreQueryParamsInResponse")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_InputAndOutputWithHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.InputAndOutputWithHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "InputAndOutputWithHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_JsonBlobs(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonBlobs(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "JsonBlobs")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_JsonEnums(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonEnums(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "JsonEnums")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_JsonIntEnums(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonIntEnums(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "JsonIntEnums")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_JsonLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "JsonLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_JsonMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "JsonMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_JsonTimestamps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonTimestamps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "JsonTimestamps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_JsonUnions(t *testing.T) {
	svc := New(Options{})
	_, err := svc.JsonUnions(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "JsonUnions")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedAcceptWithBody(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedAcceptWithBody(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedAcceptWithBody")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedAcceptWithGenericString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedAcceptWithGenericString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedAcceptWithGenericString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedAcceptWithPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedAcceptWithPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedAcceptWithPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedBlob(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedBlob(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedBlob")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedBoolean(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedBoolean(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedBoolean")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedByte(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedByte(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedByte")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedContentTypeWithBody(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithBody(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedContentTypeWithBody")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedContentTypeWithGenericString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithGenericString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedContentTypeWithGenericString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedContentTypeWithoutBody(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithoutBody(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedContentTypeWithoutBody")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedContentTypeWithoutBodyEmptyInput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithoutBodyEmptyInput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedContentTypeWithoutBodyEmptyInput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedContentTypeWithPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedContentTypeWithPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedContentTypeWithPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedDouble(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedDouble(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedDouble")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedFloat(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedFloat(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedFloat")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedInteger(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedInteger(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedInteger")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedList(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedList(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedList")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedLong(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedLong(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedLong")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedMap(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedMap(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedMap")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedRequestBody(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedRequestBody(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedRequestBody")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedShort(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedShort(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedShort")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampBodyDateTime(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampBodyDateTime(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampBodyDateTime")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampBodyDefault(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampBodyDefault(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampBodyDefault")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampBodyHttpDate(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampBodyHttpDate(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampBodyHttpDate")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampHeaderDateTime(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampHeaderDateTime(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampHeaderDateTime")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampHeaderDefault(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampHeaderDefault(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampHeaderDefault")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampHeaderEpoch(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampHeaderEpoch(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampHeaderEpoch")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampPathDefault(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampPathDefault(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampPathDefault")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampPathEpoch(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampPathEpoch(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampPathEpoch")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampPathHttpDate(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampPathHttpDate(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampPathHttpDate")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampQueryDefault(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampQueryDefault(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampQueryDefault")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampQueryEpoch(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampQueryEpoch(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampQueryEpoch")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedTimestampQueryHttpDate(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedTimestampQueryHttpDate(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedTimestampQueryHttpDate")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MalformedUnion(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MalformedUnion(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MalformedUnion")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_MediaTypeHeader(t *testing.T) {
	svc := New(Options{})
	_, err := svc.MediaTypeHeader(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "MediaTypeHeader")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NoInputAndNoOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NoInputAndNoOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NoInputAndNoOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NoInputAndOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NoInputAndOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NoInputAndOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NullAndEmptyHeadersClient(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NullAndEmptyHeadersClient(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NullAndEmptyHeadersClient")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NullAndEmptyHeadersServer(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NullAndEmptyHeadersServer(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NullAndEmptyHeadersServer")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_OmitsNullSerializesEmptyString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OmitsNullSerializesEmptyString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "OmitsNullSerializesEmptyString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_OmitsSerializingEmptyLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OmitsSerializingEmptyLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "OmitsSerializingEmptyLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_OperationWithDefaults(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OperationWithDefaults(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "OperationWithDefaults")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_OperationWithNestedStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OperationWithNestedStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "OperationWithNestedStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_PostPlayerAction(t *testing.T) {
	svc := New(Options{})
	_, err := svc.PostPlayerAction(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "PostPlayerAction")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_PostUnionWithJsonName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.PostUnionWithJsonName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "PostUnionWithJsonName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_PutWithContentEncoding(t *testing.T) {
	svc := New(Options{})
	_, err := svc.PutWithContentEncoding(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "PutWithContentEncoding")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_QueryIdempotencyTokenAutoFill(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryIdempotencyTokenAutoFill(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "QueryIdempotencyTokenAutoFill")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_QueryParamsAsStringListMap(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryParamsAsStringListMap(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "QueryParamsAsStringListMap")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_QueryPrecedence(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryPrecedence(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "QueryPrecedence")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_RecursiveShapes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.RecursiveShapes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "RecursiveShapes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_ResponseCodeHttpFallback(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ResponseCodeHttpFallback(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "ResponseCodeHttpFallback")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_ResponseCodeRequired(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ResponseCodeRequired(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "ResponseCodeRequired")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_SimpleScalarProperties(t *testing.T) {
	svc := New(Options{})
	_, err := svc.SimpleScalarProperties(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "SimpleScalarProperties")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_SparseJsonLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.SparseJsonLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "SparseJsonLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_SparseJsonMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.SparseJsonMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "SparseJsonMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_StreamingTraits(t *testing.T) {
	svc := New(Options{})
	_, err := svc.StreamingTraits(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "StreamingTraits")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_StreamingTraitsRequireLength(t *testing.T) {
	svc := New(Options{})
	_, err := svc.StreamingTraitsRequireLength(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "StreamingTraitsRequireLength")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_StreamingTraitsWithMediaType(t *testing.T) {
	svc := New(Options{})
	_, err := svc.StreamingTraitsWithMediaType(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "StreamingTraitsWithMediaType")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TestBodyStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestBodyStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TestBodyStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TestGetNoInputNoPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestGetNoInputNoPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TestGetNoInputNoPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TestGetNoPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestGetNoPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TestGetNoPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TestPayloadBlob(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestPayloadBlob(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TestPayloadBlob")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TestPayloadStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestPayloadStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TestPayloadStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TestPostNoInputNoPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestPostNoInputNoPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TestPostNoInputNoPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TestPostNoPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TestPostNoPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TestPostNoPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TimestampFormatHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TimestampFormatHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TimestampFormatHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_UnitInputAndOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.UnitInputAndOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "UnitInputAndOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}
