// Code generated by smithy-go-codegen DO NOT EDIT.

//go:build snapshot

package restxml

import (
	"context"
	"errors"
	"fmt"
	"github.com/aws/smithy-go/middleware"
	"io"
	"io/fs"
	"os"
	"testing"
)

const ssprefix = "snapshot"

type snapshotOK struct{}

func (snapshotOK) Error() string { return "error: success" }

func createp(path string) (*os.File, error) {
	if err := os.Mkdir(ssprefix, 0700); err != nil && !errors.Is(err, fs.ErrExist) {
		return nil, err
	}
	return os.Create(path)
}

func sspath(op string) string {
	return fmt.Sprintf("%s/api_op_%s.go.snap", ssprefix, op)
}

func updateSnapshot(stack *middleware.Stack, operation string) error {
	f, err := createp(sspath(operation))
	if err != nil {
		return err
	}
	defer f.Close()
	if _, err := f.Write([]byte(stack.String())); err != nil {
		return err
	}
	return snapshotOK{}
}

func testSnapshot(stack *middleware.Stack, operation string) error {
	f, err := os.Open(sspath(operation))
	if errors.Is(err, fs.ErrNotExist) {
		return snapshotOK{}
	}
	if err != nil {
		return err
	}
	defer f.Close()
	expected, err := io.ReadAll(f)
	if err != nil {
		return err
	}
	if actual := stack.String(); actual != string(expected) {
		return fmt.Errorf("%s != %s", expected, actual)
	}
	return snapshotOK{}
}
func TestCheckSnapshot_AllQueryStringTypes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.AllQueryStringTypes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "AllQueryStringTypes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_BodyWithXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.BodyWithXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "BodyWithXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_ConstantAndVariableQueryString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ConstantAndVariableQueryString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "ConstantAndVariableQueryString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_ConstantQueryString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ConstantQueryString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "ConstantQueryString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_ContentTypeParameters(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ContentTypeParameters(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "ContentTypeParameters")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_DatetimeOffsets(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DatetimeOffsets(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "DatetimeOffsets")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_EmptyInputAndEmptyOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EmptyInputAndEmptyOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "EmptyInputAndEmptyOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_EndpointOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "EndpointOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_EndpointWithHostLabelHeaderOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointWithHostLabelHeaderOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "EndpointWithHostLabelHeaderOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_EndpointWithHostLabelOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointWithHostLabelOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "EndpointWithHostLabelOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_FlattenedXmlMap(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FlattenedXmlMap(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "FlattenedXmlMap")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_FlattenedXmlMapWithXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FlattenedXmlMapWithXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "FlattenedXmlMapWithXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_FlattenedXmlMapWithXmlNamespace(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FlattenedXmlMapWithXmlNamespace(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "FlattenedXmlMapWithXmlNamespace")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_FractionalSeconds(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FractionalSeconds(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "FractionalSeconds")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_GreetingWithErrors(t *testing.T) {
	svc := New(Options{})
	_, err := svc.GreetingWithErrors(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "GreetingWithErrors")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpEnumPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpEnumPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpEnumPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadTraits(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadTraits(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadTraits")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadTraitsWithMediaType(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadTraitsWithMediaType(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadTraitsWithMediaType")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadWithMemberXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithMemberXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadWithMemberXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadWithStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadWithStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadWithUnion(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithUnion(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadWithUnion")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadWithXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadWithXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadWithXmlNamespace(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithXmlNamespace(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadWithXmlNamespace")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPayloadWithXmlNamespaceAndPrefix(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithXmlNamespaceAndPrefix(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPayloadWithXmlNamespaceAndPrefix")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpPrefixHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPrefixHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpPrefixHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithFloatLabels(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithFloatLabels(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithFloatLabels")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithGreedyLabelInPath(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithGreedyLabelInPath(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithGreedyLabelInPath")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithLabels(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithLabels(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithLabels")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpRequestWithLabelsAndTimestampFormat(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithLabelsAndTimestampFormat(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpRequestWithLabelsAndTimestampFormat")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpResponseCode(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpResponseCode(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpResponseCode")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_HttpStringPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpStringPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "HttpStringPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_IgnoreQueryParamsInResponse(t *testing.T) {
	svc := New(Options{})
	_, err := svc.IgnoreQueryParamsInResponse(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "IgnoreQueryParamsInResponse")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_InputAndOutputWithHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.InputAndOutputWithHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "InputAndOutputWithHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NestedXmlMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NestedXmlMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NestedXmlMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NestedXmlMapWithXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NestedXmlMapWithXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NestedXmlMapWithXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NoInputAndNoOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NoInputAndNoOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NoInputAndNoOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NoInputAndOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NoInputAndOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NoInputAndOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NullAndEmptyHeadersClient(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NullAndEmptyHeadersClient(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NullAndEmptyHeadersClient")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_NullAndEmptyHeadersServer(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NullAndEmptyHeadersServer(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "NullAndEmptyHeadersServer")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_OmitsNullSerializesEmptyString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OmitsNullSerializesEmptyString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "OmitsNullSerializesEmptyString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_PutWithContentEncoding(t *testing.T) {
	svc := New(Options{})
	_, err := svc.PutWithContentEncoding(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "PutWithContentEncoding")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_QueryIdempotencyTokenAutoFill(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryIdempotencyTokenAutoFill(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "QueryIdempotencyTokenAutoFill")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_QueryParamsAsStringListMap(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryParamsAsStringListMap(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "QueryParamsAsStringListMap")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_QueryPrecedence(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryPrecedence(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "QueryPrecedence")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_RecursiveShapes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.RecursiveShapes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "RecursiveShapes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_SimpleScalarProperties(t *testing.T) {
	svc := New(Options{})
	_, err := svc.SimpleScalarProperties(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "SimpleScalarProperties")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_TimestampFormatHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TimestampFormatHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "TimestampFormatHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlAttributes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlAttributes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlAttributes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlAttributesOnPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlAttributesOnPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlAttributesOnPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlBlobs(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlBlobs(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlBlobs")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlEmptyBlobs(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEmptyBlobs(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlEmptyBlobs")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlEmptyLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEmptyLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlEmptyLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlEmptyMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEmptyMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlEmptyMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlEmptyStrings(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEmptyStrings(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlEmptyStrings")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlEnums(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEnums(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlEnums")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlIntEnums(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlIntEnums(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlIntEnums")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlMapsXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlMapsXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlMapsXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlMapWithXmlNamespace(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlMapWithXmlNamespace(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlMapWithXmlNamespace")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlNamespaces(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlNamespaces(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlNamespaces")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlTimestamps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlTimestamps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlTimestamps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestCheckSnapshot_XmlUnions(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlUnions(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return testSnapshot(stack, "XmlUnions")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}
func TestUpdateSnapshot_AllQueryStringTypes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.AllQueryStringTypes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "AllQueryStringTypes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_BodyWithXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.BodyWithXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "BodyWithXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_ConstantAndVariableQueryString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ConstantAndVariableQueryString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "ConstantAndVariableQueryString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_ConstantQueryString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ConstantQueryString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "ConstantQueryString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_ContentTypeParameters(t *testing.T) {
	svc := New(Options{})
	_, err := svc.ContentTypeParameters(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "ContentTypeParameters")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_DatetimeOffsets(t *testing.T) {
	svc := New(Options{})
	_, err := svc.DatetimeOffsets(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "DatetimeOffsets")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_EmptyInputAndEmptyOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EmptyInputAndEmptyOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "EmptyInputAndEmptyOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_EndpointOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "EndpointOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_EndpointWithHostLabelHeaderOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointWithHostLabelHeaderOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "EndpointWithHostLabelHeaderOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_EndpointWithHostLabelOperation(t *testing.T) {
	svc := New(Options{})
	_, err := svc.EndpointWithHostLabelOperation(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "EndpointWithHostLabelOperation")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_FlattenedXmlMap(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FlattenedXmlMap(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "FlattenedXmlMap")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_FlattenedXmlMapWithXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FlattenedXmlMapWithXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "FlattenedXmlMapWithXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_FlattenedXmlMapWithXmlNamespace(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FlattenedXmlMapWithXmlNamespace(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "FlattenedXmlMapWithXmlNamespace")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_FractionalSeconds(t *testing.T) {
	svc := New(Options{})
	_, err := svc.FractionalSeconds(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "FractionalSeconds")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_GreetingWithErrors(t *testing.T) {
	svc := New(Options{})
	_, err := svc.GreetingWithErrors(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "GreetingWithErrors")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpEnumPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpEnumPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpEnumPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadTraits(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadTraits(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadTraits")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadTraitsWithMediaType(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadTraitsWithMediaType(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadTraitsWithMediaType")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadWithMemberXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithMemberXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadWithMemberXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadWithStructure(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithStructure(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadWithStructure")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadWithUnion(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithUnion(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadWithUnion")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadWithXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadWithXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadWithXmlNamespace(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithXmlNamespace(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadWithXmlNamespace")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPayloadWithXmlNamespaceAndPrefix(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPayloadWithXmlNamespaceAndPrefix(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPayloadWithXmlNamespaceAndPrefix")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpPrefixHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpPrefixHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpPrefixHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithFloatLabels(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithFloatLabels(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithFloatLabels")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithGreedyLabelInPath(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithGreedyLabelInPath(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithGreedyLabelInPath")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithLabels(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithLabels(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithLabels")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpRequestWithLabelsAndTimestampFormat(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpRequestWithLabelsAndTimestampFormat(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpRequestWithLabelsAndTimestampFormat")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpResponseCode(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpResponseCode(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpResponseCode")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_HttpStringPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.HttpStringPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "HttpStringPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_IgnoreQueryParamsInResponse(t *testing.T) {
	svc := New(Options{})
	_, err := svc.IgnoreQueryParamsInResponse(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "IgnoreQueryParamsInResponse")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_InputAndOutputWithHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.InputAndOutputWithHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "InputAndOutputWithHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NestedXmlMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NestedXmlMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NestedXmlMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NestedXmlMapWithXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NestedXmlMapWithXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NestedXmlMapWithXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NoInputAndNoOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NoInputAndNoOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NoInputAndNoOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NoInputAndOutput(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NoInputAndOutput(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NoInputAndOutput")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NullAndEmptyHeadersClient(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NullAndEmptyHeadersClient(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NullAndEmptyHeadersClient")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_NullAndEmptyHeadersServer(t *testing.T) {
	svc := New(Options{})
	_, err := svc.NullAndEmptyHeadersServer(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "NullAndEmptyHeadersServer")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_OmitsNullSerializesEmptyString(t *testing.T) {
	svc := New(Options{})
	_, err := svc.OmitsNullSerializesEmptyString(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "OmitsNullSerializesEmptyString")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_PutWithContentEncoding(t *testing.T) {
	svc := New(Options{})
	_, err := svc.PutWithContentEncoding(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "PutWithContentEncoding")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_QueryIdempotencyTokenAutoFill(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryIdempotencyTokenAutoFill(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "QueryIdempotencyTokenAutoFill")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_QueryParamsAsStringListMap(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryParamsAsStringListMap(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "QueryParamsAsStringListMap")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_QueryPrecedence(t *testing.T) {
	svc := New(Options{})
	_, err := svc.QueryPrecedence(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "QueryPrecedence")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_RecursiveShapes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.RecursiveShapes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "RecursiveShapes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_SimpleScalarProperties(t *testing.T) {
	svc := New(Options{})
	_, err := svc.SimpleScalarProperties(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "SimpleScalarProperties")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_TimestampFormatHeaders(t *testing.T) {
	svc := New(Options{})
	_, err := svc.TimestampFormatHeaders(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "TimestampFormatHeaders")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlAttributes(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlAttributes(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlAttributes")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlAttributesOnPayload(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlAttributesOnPayload(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlAttributesOnPayload")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlBlobs(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlBlobs(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlBlobs")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlEmptyBlobs(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEmptyBlobs(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlEmptyBlobs")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlEmptyLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEmptyLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlEmptyLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlEmptyMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEmptyMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlEmptyMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlEmptyStrings(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEmptyStrings(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlEmptyStrings")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlEnums(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlEnums(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlEnums")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlIntEnums(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlIntEnums(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlIntEnums")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlLists(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlLists(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlLists")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlMaps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlMaps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlMaps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlMapsXmlName(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlMapsXmlName(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlMapsXmlName")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlMapWithXmlNamespace(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlMapWithXmlNamespace(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlMapWithXmlNamespace")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlNamespaces(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlNamespaces(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlNamespaces")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlTimestamps(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlTimestamps(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlTimestamps")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}

func TestUpdateSnapshot_XmlUnions(t *testing.T) {
	svc := New(Options{})
	_, err := svc.XmlUnions(context.Background(), nil, func(o *Options) {
		o.APIOptions = append(o.APIOptions, func(stack *middleware.Stack) error {
			return updateSnapshot(stack, "XmlUnions")
		})
	})
	if _, ok := err.(snapshotOK); !ok && err != nil {
		t.Fatal(err)
	}
}
