// Code generated by smithy-go-codegen DO NOT EDIT.

package accessanalyzer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/accessanalyzer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about the specified finding. GetFinding and GetFindingV2
// both use access-analyzer:GetFinding in the Action element of an IAM policy
// statement. You must have permission to perform the access-analyzer:GetFinding
// action.
func (c *Client) GetFindingV2(ctx context.Context, params *GetFindingV2Input, optFns ...func(*Options)) (*GetFindingV2Output, error) {
	if params == nil {
		params = &GetFindingV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFindingV2", params, optFns, c.addOperationGetFindingV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFindingV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFindingV2Input struct {

	// The [ARN of the analyzer] that generated the finding.
	//
	// [ARN of the analyzer]: https://docs.aws.amazon.com/IAM/latest/UserGuide/access-analyzer-getting-started.html#permission-resources
	//
	// This member is required.
	AnalyzerArn *string

	// The ID of the finding to retrieve.
	//
	// This member is required.
	Id *string

	// The maximum number of results to return in the response.
	MaxResults *int32

	// A token used for pagination of results returned.
	NextToken *string

	noSmithyDocumentSerde
}

type GetFindingV2Output struct {

	// The time at which the resource-based policy or IAM entity that generated the
	// finding was analyzed.
	//
	// This member is required.
	AnalyzedAt *time.Time

	// The time at which the finding was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// A localized message that explains the finding and provides guidance on how to
	// address it.
	//
	// This member is required.
	FindingDetails []types.FindingDetails

	// The ID of the finding to retrieve.
	//
	// This member is required.
	Id *string

	// Tye Amazon Web Services account ID that owns the resource.
	//
	// This member is required.
	ResourceOwnerAccount *string

	// The type of the resource identified in the finding.
	//
	// This member is required.
	ResourceType types.ResourceType

	// The status of the finding.
	//
	// This member is required.
	Status types.FindingStatus

	// The time at which the finding was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// An error.
	Error *string

	// The type of the finding. For external access analyzers, the type is
	// ExternalAccess . For unused access analyzers, the type can be UnusedIAMRole ,
	// UnusedIAMUserAccessKey , UnusedIAMUserPassword , or UnusedPermission .
	FindingType types.FindingType

	// A token used for pagination of results returned.
	NextToken *string

	// The resource that generated the finding.
	Resource *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFindingV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFindingV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFindingV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFindingV2"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetFindingV2ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFindingV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetFindingV2PaginatorOptions is the paginator options for GetFindingV2
type GetFindingV2PaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetFindingV2Paginator is a paginator for GetFindingV2
type GetFindingV2Paginator struct {
	options   GetFindingV2PaginatorOptions
	client    GetFindingV2APIClient
	params    *GetFindingV2Input
	nextToken *string
	firstPage bool
}

// NewGetFindingV2Paginator returns a new GetFindingV2Paginator
func NewGetFindingV2Paginator(client GetFindingV2APIClient, params *GetFindingV2Input, optFns ...func(*GetFindingV2PaginatorOptions)) *GetFindingV2Paginator {
	if params == nil {
		params = &GetFindingV2Input{}
	}

	options := GetFindingV2PaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetFindingV2Paginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetFindingV2Paginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetFindingV2 page.
func (p *GetFindingV2Paginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetFindingV2Output, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetFindingV2(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetFindingV2APIClient is a client that implements the GetFindingV2 operation.
type GetFindingV2APIClient interface {
	GetFindingV2(context.Context, *GetFindingV2Input, ...func(*Options)) (*GetFindingV2Output, error)
}

var _ GetFindingV2APIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetFindingV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFindingV2",
	}
}
