// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Represents the different branches of a repository for building, deploying, and
// hosting an Amplify app.
type App struct {

	// The Amazon Resource Name (ARN) of the Amplify app.
	//
	// This member is required.
	AppArn *string

	// The unique ID of the Amplify app.
	//
	// This member is required.
	AppId *string

	// A timestamp of when Amplify created the application.
	//
	// This member is required.
	CreateTime *time.Time

	// The default domain for the Amplify app.
	//
	// This member is required.
	DefaultDomain *string

	// The description for the Amplify app.
	//
	// This member is required.
	Description *string

	// Enables basic authorization for the Amplify app's branches.
	//
	// This member is required.
	EnableBasicAuth *bool

	// Enables the auto-building of branches for the Amplify app.
	//
	// This member is required.
	EnableBranchAutoBuild *bool

	// The environment variables for the Amplify app.
	//
	// For a list of the environment variables that are accessible to Amplify by
	// default, see [Amplify Environment variables]in the Amplify Hosting User Guide.
	//
	// [Amplify Environment variables]: https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html
	//
	// This member is required.
	EnvironmentVariables map[string]string

	// The name for the Amplify app.
	//
	// This member is required.
	Name *string

	// The platform for the Amplify app. For a static app, set the platform type to WEB
	// . For a dynamic server-side rendered (SSR) app, set the platform type to
	// WEB_COMPUTE . For an app requiring Amplify Hosting's original SSR support only,
	// set the platform type to WEB_DYNAMIC .
	//
	// If you are deploying an SSG only app with Next.js 14 or later, you must use the
	// platform type WEB_COMPUTE .
	//
	// This member is required.
	Platform Platform

	// The Git repository for the Amplify app.
	//
	// This member is required.
	Repository *string

	// A timestamp of when Amplify updated the application.
	//
	// This member is required.
	UpdateTime *time.Time

	// Describes the automated branch creation configuration for the Amplify app.
	AutoBranchCreationConfig *AutoBranchCreationConfig

	// Describes the automated branch creation glob patterns for the Amplify app.
	AutoBranchCreationPatterns []string

	// The basic authorization credentials for branches for the Amplify app. You must
	// base64-encode the authorization credentials and provide them in the format
	// user:password .
	BasicAuthCredentials *string

	// Describes the content of the build specification (build spec) for the Amplify
	// app.
	BuildSpec *string

	// The cache configuration for the Amplify app. If you don't specify the cache
	// configuration type , Amplify uses the default AMPLIFY_MANAGED setting.
	CacheConfig *CacheConfig

	// The Amazon Resource Name (ARN) of the IAM role for an SSR app. The Compute role
	// allows the Amplify Hosting compute service to securely access specific Amazon
	// Web Services resources based on the role's permissions. For more information
	// about the SSR Compute role, see [Adding an SSR Compute role]in the Amplify User Guide.
	//
	// [Adding an SSR Compute role]: https://docs.aws.amazon.com/latest/userguide/amplify-SSR-compute-role.html
	ComputeRoleArn *string

	// Describes the custom HTTP headers for the Amplify app.
	CustomHeaders *string

	// Describes the custom redirect and rewrite rules for the Amplify app.
	CustomRules []CustomRule

	// Enables automated branch creation for the Amplify app.
	EnableAutoBranchCreation *bool

	// Automatically disconnect a branch in the Amplify console when you delete a
	// branch from your Git repository.
	EnableBranchAutoDeletion *bool

	// The Amazon Resource Name (ARN) of the IAM service role for the Amplify app.
	IamServiceRoleArn *string

	// Describes the information about a production branch of the Amplify app.
	ProductionBranch *ProductionBranch

	// This is for internal use.
	//
	// The Amplify service uses this parameter to specify the authentication protocol
	// to use to access the Git repository for an Amplify app. Amplify specifies TOKEN
	// for a GitHub repository, SIGV4 for an Amazon Web Services CodeCommit
	// repository, and SSH for GitLab and Bitbucket repositories.
	RepositoryCloneMethod RepositoryCloneMethod

	// The tag for the Amplify app.
	Tags map[string]string

	// Describes the Firewall configuration for the Amplify app. Firewall support
	// enables you to protect your hosted applications with a direct integration with
	// WAF.
	WafConfiguration *WafConfiguration

	// A timestamp of when Amplify created the webhook in your Git repository.
	WebhookCreateTime *time.Time

	noSmithyDocumentSerde
}

// Describes an artifact.
type Artifact struct {

	// The file name for the artifact.
	//
	// This member is required.
	ArtifactFileName *string

	// The unique ID for the artifact.
	//
	// This member is required.
	ArtifactId *string

	noSmithyDocumentSerde
}

// Describes the automated branch creation configuration.
type AutoBranchCreationConfig struct {

	// The basic authorization credentials for the autocreated branch. You must
	// base64-encode the authorization credentials and provide them in the format
	// user:password .
	BasicAuthCredentials *string

	// The build specification (build spec) for the autocreated branch.
	BuildSpec *string

	// Enables auto building for the autocreated branch.
	EnableAutoBuild *bool

	// Enables basic authorization for the autocreated branch.
	EnableBasicAuth *bool

	// Enables performance mode for the branch.
	//
	// Performance mode optimizes for faster hosting performance by keeping content
	// cached at the edge for a longer interval. When performance mode is enabled,
	// hosting configuration or code changes can take up to 10 minutes to roll out.
	EnablePerformanceMode *bool

	// Enables pull request previews for the autocreated branch.
	EnablePullRequestPreview *bool

	// The environment variables for the autocreated branch.
	EnvironmentVariables map[string]string

	// The framework for the autocreated branch.
	Framework *string

	// The Amplify environment name for the pull request.
	PullRequestEnvironmentName *string

	// Describes the current stage for the autocreated branch.
	Stage Stage

	noSmithyDocumentSerde
}

// Describes the backend associated with an Amplify Branch .
//
// This property is available to Amplify Gen 2 apps only. When you deploy an
// application with Amplify Gen 2, you provision the app's backend infrastructure
// using Typescript code.
type Backend struct {

	// The Amazon Resource Name (ARN) for the CloudFormation stack.
	StackArn *string

	noSmithyDocumentSerde
}

// Describes the backend environment associated with a Branch of a Gen 1 Amplify
// app. Amplify Gen 1 applications are created using Amplify Studio or the Amplify
// command line interface (CLI).
type BackendEnvironment struct {

	// The Amazon Resource Name (ARN) for a backend environment that is part of an
	// Amplify app.
	//
	// This member is required.
	BackendEnvironmentArn *string

	// The creation date and time for a backend environment that is part of an Amplify
	// app.
	//
	// This member is required.
	CreateTime *time.Time

	// The name for a backend environment that is part of an Amplify app.
	//
	// This member is required.
	EnvironmentName *string

	// The last updated date and time for a backend environment that is part of an
	// Amplify app.
	//
	// This member is required.
	UpdateTime *time.Time

	// The name of deployment artifacts.
	DeploymentArtifacts *string

	// The AWS CloudFormation stack name of a backend environment.
	StackName *string

	noSmithyDocumentSerde
}

// The branch for an Amplify app, which maps to a third-party repository branch.
type Branch struct {

	//  The ID of the active job for a branch of an Amplify app.
	//
	// This member is required.
	ActiveJobId *string

	//  The Amazon Resource Name (ARN) for a branch that is part of an Amplify app.
	//
	// This member is required.
	BranchArn *string

	//  The name for the branch that is part of an Amplify app.
	//
	// This member is required.
	BranchName *string

	// A timestamp of when Amplify created the branch.
	//
	// This member is required.
	CreateTime *time.Time

	//  The custom domains for a branch of an Amplify app.
	//
	// This member is required.
	CustomDomains []string

	//  The description for the branch that is part of an Amplify app.
	//
	// This member is required.
	Description *string

	//  The display name for the branch. This is used as the default domain prefix.
	//
	// This member is required.
	DisplayName *string

	//  Enables auto-building on push for a branch of an Amplify app.
	//
	// This member is required.
	EnableAutoBuild *bool

	//  Enables basic authorization for a branch of an Amplify app.
	//
	// This member is required.
	EnableBasicAuth *bool

	//  Enables notifications for a branch that is part of an Amplify app.
	//
	// This member is required.
	EnableNotification *bool

	//  Enables pull request previews for the branch.
	//
	// This member is required.
	EnablePullRequestPreview *bool

	//  The environment variables specific to a branch of an Amplify app.
	//
	// This member is required.
	EnvironmentVariables map[string]string

	//  The framework for a branch of an Amplify app.
	//
	// This member is required.
	Framework *string

	//  The current stage for the branch that is part of an Amplify app.
	//
	// This member is required.
	Stage Stage

	//  The total number of jobs that are part of an Amplify app.
	//
	// This member is required.
	TotalNumberOfJobs *string

	//  The content Time to Live (TTL) for the website in seconds.
	//
	// This member is required.
	Ttl *string

	// A timestamp for the last updated time for a branch.
	//
	// This member is required.
	UpdateTime *time.Time

	//  A list of custom resources that are linked to this branch.
	AssociatedResources []string

	// Describes the backend associated with an Amplify Branch .
	//
	// This property is available to Amplify Gen 2 apps only. When you deploy an
	// application with Amplify Gen 2, you provision the app's backend infrastructure
	// using Typescript code.
	Backend *Backend

	//  The Amazon Resource Name (ARN) for a backend environment that is part of an
	// Amplify app.
	//
	// This property is available to Amplify Gen 1 apps only. When you deploy an
	// application with Amplify Gen 2, you provision the app's backend infrastructure
	// using Typescript code.
	BackendEnvironmentArn *string

	//  The basic authorization credentials for a branch of an Amplify app. You must
	// base64-encode the authorization credentials and provide them in the format
	// user:password .
	BasicAuthCredentials *string

	//  The build specification (build spec) content for the branch of an Amplify app.
	BuildSpec *string

	// The Amazon Resource Name (ARN) of the IAM role for a branch of an SSR app. The
	// Compute role allows the Amplify Hosting compute service to securely access
	// specific Amazon Web Services resources based on the role's permissions. For more
	// information about the SSR Compute role, see [Adding an SSR Compute role]in the Amplify User Guide.
	//
	// [Adding an SSR Compute role]: https://docs.aws.amazon.com/latest/userguide/amplify-SSR-compute-role.html
	ComputeRoleArn *string

	//  The destination branch if the branch is a pull request branch.
	DestinationBranch *string

	// Enables performance mode for the branch.
	//
	// Performance mode optimizes for faster hosting performance by keeping content
	// cached at the edge for a longer interval. When performance mode is enabled,
	// hosting configuration or code changes can take up to 10 minutes to roll out.
	EnablePerformanceMode *bool

	//  The Amplify environment name for the pull request.
	PullRequestEnvironmentName *string

	//  The source branch if the branch is a pull request branch.
	SourceBranch *string

	//  The tag for the branch of an Amplify app.
	Tags map[string]string

	//  The thumbnail URL for the branch of an Amplify app.
	ThumbnailUrl *string

	noSmithyDocumentSerde
}

// Describes the cache configuration for an Amplify app.
//
// For more information about how Amplify applies an optimal cache configuration
// for your app based on the type of content that is being served, see [Managing cache configuration]in the
// Amplify User guide.
//
// [Managing cache configuration]: https://docs.aws.amazon.com/amplify/latest/userguide/managing-cache-configuration
type CacheConfig struct {

	// The type of cache configuration to use for an Amplify app.
	//
	// The AMPLIFY_MANAGED cache configuration automatically applies an optimized
	// cache configuration for your app based on its platform, routing rules, and
	// rewrite rules. This is the default setting.
	//
	// The AMPLIFY_MANAGED_NO_COOKIES cache configuration type is the same as
	// AMPLIFY_MANAGED , except that it excludes all cookies from the cache key.
	//
	// This member is required.
	Type CacheConfigType

	noSmithyDocumentSerde
}

// Describes the current SSL/TLS certificate that is in use for the domain. If you
// are using CreateDomainAssociation to create a new domain association,
// Certificate describes the new certificate that you are creating.
type Certificate struct {

	// The type of SSL/TLS certificate that you want to use.
	//
	// Specify AMPLIFY_MANAGED to use the default certificate that Amplify provisions
	// for you.
	//
	// Specify CUSTOM to use your own certificate that you have already added to
	// Certificate Manager in your Amazon Web Services account. Make sure you request
	// (or import) the certificate in the US East (N. Virginia) Region (us-east-1). For
	// more information about using ACM, see [Importing certificates into Certificate Manager]in the ACM User guide.
	//
	// [Importing certificates into Certificate Manager]: https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html
	//
	// This member is required.
	Type CertificateType

	// The DNS record for certificate verification.
	CertificateVerificationDNSRecord *string

	// The Amazon resource name (ARN) for a custom certificate that you have already
	// added to Certificate Manager in your Amazon Web Services account.
	//
	// This field is required only when the certificate type is CUSTOM .
	CustomCertificateArn *string

	noSmithyDocumentSerde
}

// The type of SSL/TLS certificate to use for your custom domain. If a certificate
// type isn't specified, Amplify uses the default AMPLIFY_MANAGED certificate.
type CertificateSettings struct {

	// The certificate type.
	//
	// Specify AMPLIFY_MANAGED to use the default certificate that Amplify provisions
	// for you.
	//
	// Specify CUSTOM to use your own certificate that you have already added to
	// Certificate Manager in your Amazon Web Services account. Make sure you request
	// (or import) the certificate in the US East (N. Virginia) Region (us-east-1). For
	// more information about using ACM, see [Importing certificates into Certificate Manager]in the ACM User guide.
	//
	// [Importing certificates into Certificate Manager]: https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html
	//
	// This member is required.
	Type CertificateType

	// The Amazon resource name (ARN) for the custom certificate that you have already
	// added to Certificate Manager in your Amazon Web Services account.
	//
	// This field is required only when the certificate type is CUSTOM .
	CustomCertificateArn *string

	noSmithyDocumentSerde
}

// Describes a custom rewrite or redirect rule.
type CustomRule struct {

	// The source pattern for a URL rewrite or redirect rule.
	//
	// This member is required.
	Source *string

	// The target pattern for a URL rewrite or redirect rule.
	//
	// This member is required.
	Target *string

	// The condition for a URL rewrite or redirect rule, such as a country code.
	Condition *string

	// The status code for a URL rewrite or redirect rule.
	//
	// 200 Represents a 200 rewrite rule.
	//
	// 301 Represents a 301 (moved permanently) redirect rule. This and all future
	// requests should be directed to the target URL.
	//
	// 302 Represents a 302 temporary redirect rule.
	//
	// 404 Represents a 404 redirect rule.
	//
	// 404-200 Represents a 404 rewrite rule.
	Status *string

	noSmithyDocumentSerde
}

// Describes the association between a custom domain and an Amplify app.
type DomainAssociation struct {

	//  The Amazon Resource Name (ARN) for the domain association.
	//
	// This member is required.
	DomainAssociationArn *string

	//  The name of the domain.
	//
	// This member is required.
	DomainName *string

	//  The current status of the domain association.
	//
	// This member is required.
	DomainStatus DomainStatus

	//  Enables the automated creation of subdomains for branches.
	//
	// This member is required.
	EnableAutoSubDomain *bool

	//  Additional information that describes why the domain association is in the
	// current state.
	//
	// This member is required.
	StatusReason *string

	//  The subdomains for the domain association.
	//
	// This member is required.
	SubDomains []SubDomain

	//  Sets branch patterns for automatic subdomain creation.
	AutoSubDomainCreationPatterns []string

	//  The required AWS Identity and Access Management (IAM) service role for the
	// Amazon Resource Name (ARN) for automatically creating subdomains.
	AutoSubDomainIAMRole *string

	// Describes the SSL/TLS certificate for the domain association. This can be your
	// own custom certificate or the default certificate that Amplify provisions for
	// you.
	//
	// If you are updating your domain to use a different certificate, certificate
	// points to the new certificate that is being created instead of the current
	// active certificate. Otherwise, certificate points to the current active
	// certificate.
	Certificate *Certificate

	//  The DNS record for certificate verification.
	CertificateVerificationDNSRecord *string

	// The status of the domain update operation that is currently in progress. The
	// following list describes the valid update states.
	//
	// REQUESTING_CERTIFICATE The certificate is in the process of being updated.
	//
	// PENDING_VERIFICATION Indicates that an Amplify managed certificate is in the
	// process of being verified. This occurs during the creation of a custom domain or
	// when a custom domain is updated to use a managed certificate.
	//
	// IMPORTING_CUSTOM_CERTIFICATE Indicates that an Amplify custom certificate is in
	// the process of being imported. This occurs during the creation of a custom
	// domain or when a custom domain is updated to use a custom certificate.
	//
	// PENDING_DEPLOYMENT Indicates that the subdomain or certificate changes are
	// being propagated.
	//
	// AWAITING_APP_CNAME Amplify is waiting for CNAME records corresponding to
	// subdomains to be propagated. If your custom domain is on Route 53, Amplify
	// handles this for you automatically. For more information about custom domains,
	// see [Setting up custom domains]in the Amplify Hosting User Guide.
	//
	// UPDATE_COMPLETE The certificate has been associated with a domain.
	//
	// UPDATE_FAILED The certificate has failed to be provisioned or associated, and
	// there is no existing active certificate to roll back to.
	//
	// [Setting up custom domains]: https://docs.aws.amazon.com/amplify/latest/userguide/custom-domains.html
	UpdateStatus UpdateStatus

	noSmithyDocumentSerde
}

// Describes an execution job for an Amplify app.
type Job struct {

	//  The execution steps for an execution job, for an Amplify app.
	//
	// This member is required.
	Steps []Step

	//  Describes the summary for an execution job for an Amplify app.
	//
	// This member is required.
	Summary *JobSummary

	noSmithyDocumentSerde
}

// Describes the summary for an execution job for an Amplify app.
type JobSummary struct {

	//  The commit ID from a third-party repository provider for the job.
	//
	// This member is required.
	CommitId *string

	//  The commit message from a third-party repository provider for the job.
	//
	// This member is required.
	CommitMessage *string

	// The commit date and time for the job.
	//
	// This member is required.
	CommitTime *time.Time

	//  The Amazon Resource Name (ARN) for the job.
	//
	// This member is required.
	JobArn *string

	//  The unique ID for the job.
	//
	// This member is required.
	JobId *string

	//  The type for the job. If the value is RELEASE , the job was manually released
	// from its source by using the StartJob API. This value is available only for
	// apps that are connected to a repository.
	//
	// If the value is RETRY , the job was manually retried using the StartJob API. If
	// the value is WEB_HOOK , the job was automatically triggered by webhooks. If the
	// value is MANUAL , the job is for a manually deployed app. Manually deployed apps
	// are not connected to a Git repository.
	//
	// This member is required.
	JobType JobType

	//  The start date and time for the job.
	//
	// This member is required.
	StartTime *time.Time

	//  The current status for the job.
	//
	// This member is required.
	Status JobStatus

	//  The end date and time for the job.
	EndTime *time.Time

	// The source URL for the files to deploy. The source URL can be either an HTTP
	// GET URL that is publicly accessible and downloads a single .zip file, or an
	// Amazon S3 bucket and prefix.
	SourceUrl *string

	// The type of source specified by the sourceURL . If the value is ZIP , the source
	// is a .zip file. If the value is BUCKET_PREFIX , the source is an Amazon S3
	// bucket and prefix. If no value is specified, the default is ZIP .
	SourceUrlType SourceUrlType

	noSmithyDocumentSerde
}

// Describes the information about a production branch for an Amplify app.
type ProductionBranch struct {

	// The branch name for the production branch.
	BranchName *string

	// The last deploy time of the production branch.
	LastDeployTime *time.Time

	// The status of the production branch.
	Status *string

	// The thumbnail URL for the production branch.
	ThumbnailUrl *string

	noSmithyDocumentSerde
}

// Describes an execution step, for an execution job, for an Amplify app.
type Step struct {

	//  The end date and time of the execution step.
	//
	// This member is required.
	EndTime *time.Time

	//  The start date and time of the execution step.
	//
	// This member is required.
	StartTime *time.Time

	//  The status of the execution step.
	//
	// This member is required.
	Status JobStatus

	//  The name of the execution step.
	//
	// This member is required.
	StepName *string

	//  The URL to the artifact for the execution step.
	ArtifactsUrl *string

	//  The context for the current step. Includes a build image if the step is build.
	Context *string

	//  The URL to the logs for the execution step.
	LogUrl *string

	//  The list of screenshot URLs for the execution step, if relevant.
	Screenshots map[string]string

	//  The reason for the current step status.
	StatusReason *string

	//  The URL to the test artifact for the execution step.
	TestArtifactsUrl *string

	//  The URL to the test configuration for the execution step.
	TestConfigUrl *string

	noSmithyDocumentSerde
}

// The subdomain for the domain association.
type SubDomain struct {

	//  The DNS record for the subdomain.
	//
	// This member is required.
	DnsRecord *string

	//  Describes the settings for the subdomain.
	//
	// This member is required.
	SubDomainSetting *SubDomainSetting

	//  The verified status of the subdomain
	//
	// This member is required.
	Verified *bool

	noSmithyDocumentSerde
}

// Describes the settings for the subdomain.
type SubDomainSetting struct {

	//  The branch name setting for the subdomain.
	//
	// This member is required.
	BranchName *string

	//  The prefix setting for the subdomain.
	//
	// This member is required.
	Prefix *string

	noSmithyDocumentSerde
}

// Describes the Firewall configuration for a hosted Amplify application. Firewall
// support enables you to protect your web applications with a direct integration
// with WAF. For more information about using WAF protections for an Amplify
// application, see [Firewall support for hosted sites]in the Amplify User Guide.
//
// [Firewall support for hosted sites]: https://docs.aws.amazon.com/amplify/latest/userguide/WAF-integration.html
type WafConfiguration struct {

	// The reason for the current status of the Firewall configuration.
	StatusReason *string

	// The status of the process to associate or disassociate a web ACL to an Amplify
	// app.
	WafStatus WafStatus

	// The Amazon Resource Name (ARN) for the web ACL associated with an Amplify app.
	WebAclArn *string

	noSmithyDocumentSerde
}

// Describes a webhook that connects repository events to an Amplify app.
type Webhook struct {

	// The name for a branch that is part of an Amplify app.
	//
	// This member is required.
	BranchName *string

	// A timestamp of when Amplify created the webhook in your Git repository.
	//
	// This member is required.
	CreateTime *time.Time

	// The description for a webhook.
	//
	// This member is required.
	Description *string

	// A timestamp of when Amplify updated the webhook in your Git repository.
	//
	// This member is required.
	UpdateTime *time.Time

	// The Amazon Resource Name (ARN) for the webhook.
	//
	// This member is required.
	WebhookArn *string

	// The ID of the webhook.
	//
	// This member is required.
	WebhookId *string

	// The URL of the webhook.
	//
	// This member is required.
	WebhookUrl *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
