// Code generated by smithy-go-codegen DO NOT EDIT.

package apptest

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apptest/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists test configurations.
func (c *Client) ListTestConfigurations(ctx context.Context, params *ListTestConfigurationsInput, optFns ...func(*Options)) (*ListTestConfigurationsOutput, error) {
	if params == nil {
		params = &ListTestConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTestConfigurations", params, optFns, c.addOperationListTestConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTestConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTestConfigurationsInput struct {

	// The maximum results of the test configuration.
	MaxResults *int32

	// The next token for the test configurations.
	NextToken *string

	// The configuration IDs of the test configurations.
	TestConfigurationIds []string

	noSmithyDocumentSerde
}

type ListTestConfigurationsOutput struct {

	// The test configurations.
	//
	// This member is required.
	TestConfigurations []types.TestConfigurationSummary

	// The next token in the test configurations.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTestConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTestConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTestConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTestConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTestConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTestConfigurationsPaginatorOptions is the paginator options for
// ListTestConfigurations
type ListTestConfigurationsPaginatorOptions struct {
	// The maximum results of the test configuration.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTestConfigurationsPaginator is a paginator for ListTestConfigurations
type ListTestConfigurationsPaginator struct {
	options   ListTestConfigurationsPaginatorOptions
	client    ListTestConfigurationsAPIClient
	params    *ListTestConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListTestConfigurationsPaginator returns a new ListTestConfigurationsPaginator
func NewListTestConfigurationsPaginator(client ListTestConfigurationsAPIClient, params *ListTestConfigurationsInput, optFns ...func(*ListTestConfigurationsPaginatorOptions)) *ListTestConfigurationsPaginator {
	if params == nil {
		params = &ListTestConfigurationsInput{}
	}

	options := ListTestConfigurationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTestConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTestConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTestConfigurations page.
func (p *ListTestConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTestConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTestConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTestConfigurationsAPIClient is a client that implements the
// ListTestConfigurations operation.
type ListTestConfigurationsAPIClient interface {
	ListTestConfigurations(context.Context, *ListTestConfigurationsInput, ...func(*Options)) (*ListTestConfigurationsOutput, error)
}

var _ ListTestConfigurationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTestConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTestConfigurations",
	}
}
