// Code generated by smithy-go-codegen DO NOT EDIT.

package apptest

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/apptest/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists test suites.
func (c *Client) ListTestSuites(ctx context.Context, params *ListTestSuitesInput, optFns ...func(*Options)) (*ListTestSuitesOutput, error) {
	if params == nil {
		params = &ListTestSuitesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTestSuites", params, optFns, c.addOperationListTestSuitesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTestSuitesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTestSuitesInput struct {

	// The maximum number of test suites to return in one page of results.
	MaxResults *int32

	// The token from a previous request to retrieve the next page of results.
	NextToken *string

	// The suite ID of the test suites.
	TestSuiteIds []string

	noSmithyDocumentSerde
}

type ListTestSuitesOutput struct {

	// The test suites returned with the response query.
	//
	// This member is required.
	TestSuites []types.TestSuiteSummary

	// The token from a previous request to retrieve the next page of test suites
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTestSuitesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTestSuites{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTestSuites{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTestSuites"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTestSuites(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTestSuitesPaginatorOptions is the paginator options for ListTestSuites
type ListTestSuitesPaginatorOptions struct {
	// The maximum number of test suites to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTestSuitesPaginator is a paginator for ListTestSuites
type ListTestSuitesPaginator struct {
	options   ListTestSuitesPaginatorOptions
	client    ListTestSuitesAPIClient
	params    *ListTestSuitesInput
	nextToken *string
	firstPage bool
}

// NewListTestSuitesPaginator returns a new ListTestSuitesPaginator
func NewListTestSuitesPaginator(client ListTestSuitesAPIClient, params *ListTestSuitesInput, optFns ...func(*ListTestSuitesPaginatorOptions)) *ListTestSuitesPaginator {
	if params == nil {
		params = &ListTestSuitesInput{}
	}

	options := ListTestSuitesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTestSuitesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTestSuitesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTestSuites page.
func (p *ListTestSuitesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTestSuitesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTestSuites(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTestSuitesAPIClient is a client that implements the ListTestSuites
// operation.
type ListTestSuitesAPIClient interface {
	ListTestSuites(context.Context, *ListTestSuitesInput, ...func(*Options)) (*ListTestSuitesOutput, error)
}

var _ ListTestSuitesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTestSuites(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTestSuites",
	}
}
