// Code generated by smithy-go-codegen DO NOT EDIT.

package arczonalshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/arczonalshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the status of autoshift observer notification. Autoshift observer
// notification enables you to be notified, through Amazon EventBridge, when there
// is an autoshift event for zonal autoshift.
//
// If the status is ENABLED , Route 53 ARC includes all autoshift events when you
// use the EventBridge pattern Autoshift In Progress . When the status is DISABLED
// , Route 53 ARC includes only autoshift events for autoshifts when one or more of
// your resources is included in the autoshift.
//
// For more information, see [Notifications for practice runs and autoshifts] in the Amazon Route 53 Application Recovery
// Controller Developer Guide.
//
// [Notifications for practice runs and autoshifts]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html#ZAShiftNotification
func (c *Client) GetAutoshiftObserverNotificationStatus(ctx context.Context, params *GetAutoshiftObserverNotificationStatusInput, optFns ...func(*Options)) (*GetAutoshiftObserverNotificationStatusOutput, error) {
	if params == nil {
		params = &GetAutoshiftObserverNotificationStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAutoshiftObserverNotificationStatus", params, optFns, c.addOperationGetAutoshiftObserverNotificationStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAutoshiftObserverNotificationStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAutoshiftObserverNotificationStatusInput struct {
	noSmithyDocumentSerde
}

type GetAutoshiftObserverNotificationStatusOutput struct {

	// The status of autoshift observer notification. If the status is ENABLED , Route
	// 53 ARC includes all autoshift events when you use the Amazon EventBridge pattern
	// Autoshift In Progress . When the status is DISABLED , Route 53 ARC includes only
	// autoshift events for autoshifts when one or more of your resources is included
	// in the autoshift.
	//
	// This member is required.
	Status types.AutoshiftObserverNotificationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAutoshiftObserverNotificationStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAutoshiftObserverNotificationStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAutoshiftObserverNotificationStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAutoshiftObserverNotificationStatus"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAutoshiftObserverNotificationStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAutoshiftObserverNotificationStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAutoshiftObserverNotificationStatus",
	}
}
