// Code generated by smithy-go-codegen DO NOT EDIT.

package b2bi

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/b2bi/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the capabilities associated with your Amazon Web Services account for
// your current or specified region. A trading capability contains the information
// required to transform incoming EDI documents into JSON or XML outputs.
func (c *Client) ListCapabilities(ctx context.Context, params *ListCapabilitiesInput, optFns ...func(*Options)) (*ListCapabilitiesOutput, error) {
	if params == nil {
		params = &ListCapabilitiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCapabilities", params, optFns, c.addOperationListCapabilitiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCapabilitiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCapabilitiesInput struct {

	// Specifies the maximum number of capabilities to return.
	MaxResults *int32

	// When additional results are obtained from the command, a NextToken parameter is
	// returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCapabilitiesOutput struct {

	// Returns one or more capabilities associated with this partnership.
	//
	// This member is required.
	Capabilities []types.CapabilitySummary

	// When additional results are obtained from the command, a NextToken parameter is
	// returned in the output. You can then pass the NextToken parameter in a
	// subsequent command to continue listing additional resources.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCapabilitiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListCapabilities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListCapabilities{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCapabilities"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCapabilities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListCapabilitiesPaginatorOptions is the paginator options for ListCapabilities
type ListCapabilitiesPaginatorOptions struct {
	// Specifies the maximum number of capabilities to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCapabilitiesPaginator is a paginator for ListCapabilities
type ListCapabilitiesPaginator struct {
	options   ListCapabilitiesPaginatorOptions
	client    ListCapabilitiesAPIClient
	params    *ListCapabilitiesInput
	nextToken *string
	firstPage bool
}

// NewListCapabilitiesPaginator returns a new ListCapabilitiesPaginator
func NewListCapabilitiesPaginator(client ListCapabilitiesAPIClient, params *ListCapabilitiesInput, optFns ...func(*ListCapabilitiesPaginatorOptions)) *ListCapabilitiesPaginator {
	if params == nil {
		params = &ListCapabilitiesInput{}
	}

	options := ListCapabilitiesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCapabilitiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCapabilitiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCapabilities page.
func (p *ListCapabilitiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCapabilitiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCapabilities(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCapabilitiesAPIClient is a client that implements the ListCapabilities
// operation.
type ListCapabilitiesAPIClient interface {
	ListCapabilities(context.Context, *ListCapabilitiesInput, ...func(*Options)) (*ListCapabilitiesOutput, error)
}

var _ ListCapabilitiesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCapabilities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCapabilities",
	}
}
