// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// This operation returns a list of recovery points that have an associated index,
// belonging to the specified account.
//
// Optional parameters you can include are: MaxResults; NextToken;
// SourceResourceArns; CreatedBefore; CreatedAfter; and ResourceType.
func (c *Client) ListIndexedRecoveryPoints(ctx context.Context, params *ListIndexedRecoveryPointsInput, optFns ...func(*Options)) (*ListIndexedRecoveryPointsOutput, error) {
	if params == nil {
		params = &ListIndexedRecoveryPointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListIndexedRecoveryPoints", params, optFns, c.addOperationListIndexedRecoveryPointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListIndexedRecoveryPointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListIndexedRecoveryPointsInput struct {

	// Returns only indexed recovery points that were created after the specified date.
	CreatedAfter *time.Time

	// Returns only indexed recovery points that were created before the specified
	// date.
	CreatedBefore *time.Time

	// Include this parameter to filter the returned list by the indicated statuses.
	//
	// Accepted values: PENDING | ACTIVE | FAILED | DELETING
	//
	// A recovery point with an index that has the status of ACTIVE can be included in
	// a search.
	IndexStatus types.IndexStatus

	// The maximum number of resource list items to be returned.
	MaxResults *int32

	// The next item following a partial list of returned recovery points.
	//
	// For example, if a request is made to return MaxResults number of indexed
	// recovery points, NextToken allows you to return more items in your list
	// starting at the location pointed to by the next token.
	NextToken *string

	// Returns a list of indexed recovery points for the specified resource type(s).
	//
	// Accepted values include:
	//
	//   - EBS for Amazon Elastic Block Store
	//
	//   - S3 for Amazon Simple Storage Service (Amazon S3)
	ResourceType *string

	// A string of the Amazon Resource Name (ARN) that uniquely identifies the source
	// resource.
	SourceResourceArn *string

	noSmithyDocumentSerde
}

type ListIndexedRecoveryPointsOutput struct {

	// This is a list of recovery points that have an associated index, belonging to
	// the specified account.
	IndexedRecoveryPoints []types.IndexedRecoveryPoint

	// The next item following a partial list of returned recovery points.
	//
	// For example, if a request is made to return MaxResults number of indexed
	// recovery points, NextToken allows you to return more items in your list
	// starting at the location pointed to by the next token.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListIndexedRecoveryPointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListIndexedRecoveryPoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListIndexedRecoveryPoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListIndexedRecoveryPoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListIndexedRecoveryPoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListIndexedRecoveryPointsPaginatorOptions is the paginator options for
// ListIndexedRecoveryPoints
type ListIndexedRecoveryPointsPaginatorOptions struct {
	// The maximum number of resource list items to be returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListIndexedRecoveryPointsPaginator is a paginator for ListIndexedRecoveryPoints
type ListIndexedRecoveryPointsPaginator struct {
	options   ListIndexedRecoveryPointsPaginatorOptions
	client    ListIndexedRecoveryPointsAPIClient
	params    *ListIndexedRecoveryPointsInput
	nextToken *string
	firstPage bool
}

// NewListIndexedRecoveryPointsPaginator returns a new
// ListIndexedRecoveryPointsPaginator
func NewListIndexedRecoveryPointsPaginator(client ListIndexedRecoveryPointsAPIClient, params *ListIndexedRecoveryPointsInput, optFns ...func(*ListIndexedRecoveryPointsPaginatorOptions)) *ListIndexedRecoveryPointsPaginator {
	if params == nil {
		params = &ListIndexedRecoveryPointsInput{}
	}

	options := ListIndexedRecoveryPointsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListIndexedRecoveryPointsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListIndexedRecoveryPointsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListIndexedRecoveryPoints page.
func (p *ListIndexedRecoveryPointsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListIndexedRecoveryPointsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListIndexedRecoveryPoints(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListIndexedRecoveryPointsAPIClient is a client that implements the
// ListIndexedRecoveryPoints operation.
type ListIndexedRecoveryPointsAPIClient interface {
	ListIndexedRecoveryPoints(context.Context, *ListIndexedRecoveryPointsInput, ...func(*Options)) (*ListIndexedRecoveryPointsOutput, error)
}

var _ ListIndexedRecoveryPointsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListIndexedRecoveryPoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListIndexedRecoveryPoints",
	}
}
