// Code generated by smithy-go-codegen DO NOT EDIT.

package backup

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/backup/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of restore testing plans.
func (c *Client) ListRestoreTestingPlans(ctx context.Context, params *ListRestoreTestingPlansInput, optFns ...func(*Options)) (*ListRestoreTestingPlansOutput, error) {
	if params == nil {
		params = &ListRestoreTestingPlansInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRestoreTestingPlans", params, optFns, c.addOperationListRestoreTestingPlansMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRestoreTestingPlansOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRestoreTestingPlansInput struct {

	// The maximum number of items to be returned.
	MaxResults *int32

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the
	// nexttoken.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRestoreTestingPlansOutput struct {

	// This is a returned list of restore testing plans.
	//
	// This member is required.
	RestoreTestingPlans []types.RestoreTestingPlanForList

	// The next item following a partial list of returned items. For example, if a
	// request is made to return MaxResults number of items, NextToken allows you to
	// return more items in your list starting at the location pointed to by the
	// nexttoken.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRestoreTestingPlansMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRestoreTestingPlans{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRestoreTestingPlans{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRestoreTestingPlans"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRestoreTestingPlans(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListRestoreTestingPlansPaginatorOptions is the paginator options for
// ListRestoreTestingPlans
type ListRestoreTestingPlansPaginatorOptions struct {
	// The maximum number of items to be returned.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRestoreTestingPlansPaginator is a paginator for ListRestoreTestingPlans
type ListRestoreTestingPlansPaginator struct {
	options   ListRestoreTestingPlansPaginatorOptions
	client    ListRestoreTestingPlansAPIClient
	params    *ListRestoreTestingPlansInput
	nextToken *string
	firstPage bool
}

// NewListRestoreTestingPlansPaginator returns a new
// ListRestoreTestingPlansPaginator
func NewListRestoreTestingPlansPaginator(client ListRestoreTestingPlansAPIClient, params *ListRestoreTestingPlansInput, optFns ...func(*ListRestoreTestingPlansPaginatorOptions)) *ListRestoreTestingPlansPaginator {
	if params == nil {
		params = &ListRestoreTestingPlansInput{}
	}

	options := ListRestoreTestingPlansPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRestoreTestingPlansPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRestoreTestingPlansPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRestoreTestingPlans page.
func (p *ListRestoreTestingPlansPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRestoreTestingPlansOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRestoreTestingPlans(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRestoreTestingPlansAPIClient is a client that implements the
// ListRestoreTestingPlans operation.
type ListRestoreTestingPlansAPIClient interface {
	ListRestoreTestingPlans(context.Context, *ListRestoreTestingPlansInput, ...func(*Options)) (*ListRestoreTestingPlansOutput, error)
}

var _ ListRestoreTestingPlansAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRestoreTestingPlans(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRestoreTestingPlans",
	}
}
