// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Delete commitment that you have created in a Bill Scenario. You can only
//
// delete a commitment that you had added and cannot model deletion (or removal) of
// a existing commitment. If you want model deletion of an existing commitment, see
// the negate [BillScenarioCommitmentModificationAction]of [BatchCreateBillScenarioCommitmentModification] operation.
//
// The BatchDeleteBillScenarioCommitmentModification operation doesn't have its
// own IAM permission. To authorize this operation for Amazon Web Services
// principals, include the permission
// bcm-pricing-calculator:DeleteBillScenarioCommitmentModification in your policies.
//
// [BillScenarioCommitmentModificationAction]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BillScenarioCommitmentModificationAction.html
// [BatchCreateBillScenarioCommitmentModification]: https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AWSBCMPricingCalculator_BatchCreateBillScenarioUsageModification.html
func (c *Client) BatchDeleteBillScenarioCommitmentModification(ctx context.Context, params *BatchDeleteBillScenarioCommitmentModificationInput, optFns ...func(*Options)) (*BatchDeleteBillScenarioCommitmentModificationOutput, error) {
	if params == nil {
		params = &BatchDeleteBillScenarioCommitmentModificationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDeleteBillScenarioCommitmentModification", params, optFns, c.addOperationBatchDeleteBillScenarioCommitmentModificationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDeleteBillScenarioCommitmentModificationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDeleteBillScenarioCommitmentModificationInput struct {

	//  The ID of the Bill Scenario for which you want to delete the modeled
	// commitment.
	//
	// This member is required.
	BillScenarioId *string

	//  List of commitments that you want to delete from the Bill Scenario.
	//
	// This member is required.
	Ids []string

	noSmithyDocumentSerde
}

type BatchDeleteBillScenarioCommitmentModificationOutput struct {

	//  Returns the list of errors reason and the commitment item keys that cannot be
	// deleted from the Bill Scenario.
	Errors []types.BatchDeleteBillScenarioCommitmentModificationError

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDeleteBillScenarioCommitmentModificationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpBatchDeleteBillScenarioCommitmentModification{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpBatchDeleteBillScenarioCommitmentModification{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchDeleteBillScenarioCommitmentModification"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpBatchDeleteBillScenarioCommitmentModificationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDeleteBillScenarioCommitmentModification(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDeleteBillScenarioCommitmentModification(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchDeleteBillScenarioCommitmentModification",
	}
}
