// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Update a newly added or existing usage lines. You can update the usage
//
// amounts, usage hour, and usage group based on a usage ID and a Bill scenario ID.
//
// The BatchUpdateBillScenarioUsageModification operation doesn't have its own IAM
// permission. To authorize this operation for Amazon Web Services principals,
// include the permission
// bcm-pricing-calculator:UpdateBillScenarioUsageModification in your policies.
func (c *Client) BatchUpdateBillScenarioUsageModification(ctx context.Context, params *BatchUpdateBillScenarioUsageModificationInput, optFns ...func(*Options)) (*BatchUpdateBillScenarioUsageModificationOutput, error) {
	if params == nil {
		params = &BatchUpdateBillScenarioUsageModificationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchUpdateBillScenarioUsageModification", params, optFns, c.addOperationBatchUpdateBillScenarioUsageModificationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchUpdateBillScenarioUsageModificationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchUpdateBillScenarioUsageModificationInput struct {

	//  The ID of the Bill Scenario for which you want to modify the usage lines.
	//
	// This member is required.
	BillScenarioId *string

	//  List of usage lines that you want to update in a Bill Scenario identified by
	// the usage ID.
	//
	// This member is required.
	UsageModifications []types.BatchUpdateBillScenarioUsageModificationEntry

	noSmithyDocumentSerde
}

type BatchUpdateBillScenarioUsageModificationOutput struct {

	//  Returns the list of error reasons and usage line item IDs that could not be
	// updated for the Bill Scenario.
	Errors []types.BatchUpdateBillScenarioUsageModificationError

	//  Returns the list of successful usage line items that were updated for a Bill
	// Scenario.
	Items []types.BillScenarioUsageModificationItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchUpdateBillScenarioUsageModificationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpBatchUpdateBillScenarioUsageModification{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpBatchUpdateBillScenarioUsageModification{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchUpdateBillScenarioUsageModification"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpBatchUpdateBillScenarioUsageModificationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchUpdateBillScenarioUsageModification(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchUpdateBillScenarioUsageModification(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchUpdateBillScenarioUsageModification",
	}
}
