// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the commitment modifications associated with a bill scenario.
func (c *Client) ListBillScenarioCommitmentModifications(ctx context.Context, params *ListBillScenarioCommitmentModificationsInput, optFns ...func(*Options)) (*ListBillScenarioCommitmentModificationsOutput, error) {
	if params == nil {
		params = &ListBillScenarioCommitmentModificationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListBillScenarioCommitmentModifications", params, optFns, c.addOperationListBillScenarioCommitmentModificationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListBillScenarioCommitmentModificationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListBillScenarioCommitmentModificationsInput struct {

	//  The unique identifier of the bill scenario to list commitment modifications
	// for.
	//
	// This member is required.
	BillScenarioId *string

	//  The maximum number of results to return per page.
	MaxResults *int32

	//  A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListBillScenarioCommitmentModificationsOutput struct {

	//  The list of commitment modifications associated with the bill scenario.
	Items []types.BillScenarioCommitmentModificationItem

	//  A token to retrieve the next page of results, if any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListBillScenarioCommitmentModificationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListBillScenarioCommitmentModifications{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListBillScenarioCommitmentModifications{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListBillScenarioCommitmentModifications"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListBillScenarioCommitmentModificationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListBillScenarioCommitmentModifications(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListBillScenarioCommitmentModificationsPaginatorOptions is the paginator
// options for ListBillScenarioCommitmentModifications
type ListBillScenarioCommitmentModificationsPaginatorOptions struct {
	//  The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListBillScenarioCommitmentModificationsPaginator is a paginator for
// ListBillScenarioCommitmentModifications
type ListBillScenarioCommitmentModificationsPaginator struct {
	options   ListBillScenarioCommitmentModificationsPaginatorOptions
	client    ListBillScenarioCommitmentModificationsAPIClient
	params    *ListBillScenarioCommitmentModificationsInput
	nextToken *string
	firstPage bool
}

// NewListBillScenarioCommitmentModificationsPaginator returns a new
// ListBillScenarioCommitmentModificationsPaginator
func NewListBillScenarioCommitmentModificationsPaginator(client ListBillScenarioCommitmentModificationsAPIClient, params *ListBillScenarioCommitmentModificationsInput, optFns ...func(*ListBillScenarioCommitmentModificationsPaginatorOptions)) *ListBillScenarioCommitmentModificationsPaginator {
	if params == nil {
		params = &ListBillScenarioCommitmentModificationsInput{}
	}

	options := ListBillScenarioCommitmentModificationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListBillScenarioCommitmentModificationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListBillScenarioCommitmentModificationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListBillScenarioCommitmentModifications page.
func (p *ListBillScenarioCommitmentModificationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListBillScenarioCommitmentModificationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListBillScenarioCommitmentModifications(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListBillScenarioCommitmentModificationsAPIClient is a client that implements
// the ListBillScenarioCommitmentModifications operation.
type ListBillScenarioCommitmentModificationsAPIClient interface {
	ListBillScenarioCommitmentModifications(context.Context, *ListBillScenarioCommitmentModificationsInput, ...func(*Options)) (*ListBillScenarioCommitmentModificationsOutput, error)
}

var _ ListBillScenarioCommitmentModificationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListBillScenarioCommitmentModifications(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListBillScenarioCommitmentModifications",
	}
}
