// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the usage associated with a workload estimate.
func (c *Client) ListWorkloadEstimateUsage(ctx context.Context, params *ListWorkloadEstimateUsageInput, optFns ...func(*Options)) (*ListWorkloadEstimateUsageOutput, error) {
	if params == nil {
		params = &ListWorkloadEstimateUsageInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWorkloadEstimateUsage", params, optFns, c.addOperationListWorkloadEstimateUsageMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWorkloadEstimateUsageOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListWorkloadEstimateUsageInput struct {

	//  The unique identifier of the workload estimate to list usage for.
	//
	// This member is required.
	WorkloadEstimateId *string

	//  Filters to apply to the list of usage items.
	Filters []types.ListUsageFilter

	//  The maximum number of results to return per page.
	MaxResults *int32

	//  A token to retrieve the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListWorkloadEstimateUsageOutput struct {

	//  The list of usage items associated with the workload estimate.
	Items []types.WorkloadEstimateUsageItem

	//  A token to retrieve the next page of results, if any.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWorkloadEstimateUsageMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListWorkloadEstimateUsage{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListWorkloadEstimateUsage{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWorkloadEstimateUsage"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListWorkloadEstimateUsageValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWorkloadEstimateUsage(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListWorkloadEstimateUsagePaginatorOptions is the paginator options for
// ListWorkloadEstimateUsage
type ListWorkloadEstimateUsagePaginatorOptions struct {
	//  The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWorkloadEstimateUsagePaginator is a paginator for ListWorkloadEstimateUsage
type ListWorkloadEstimateUsagePaginator struct {
	options   ListWorkloadEstimateUsagePaginatorOptions
	client    ListWorkloadEstimateUsageAPIClient
	params    *ListWorkloadEstimateUsageInput
	nextToken *string
	firstPage bool
}

// NewListWorkloadEstimateUsagePaginator returns a new
// ListWorkloadEstimateUsagePaginator
func NewListWorkloadEstimateUsagePaginator(client ListWorkloadEstimateUsageAPIClient, params *ListWorkloadEstimateUsageInput, optFns ...func(*ListWorkloadEstimateUsagePaginatorOptions)) *ListWorkloadEstimateUsagePaginator {
	if params == nil {
		params = &ListWorkloadEstimateUsageInput{}
	}

	options := ListWorkloadEstimateUsagePaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWorkloadEstimateUsagePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWorkloadEstimateUsagePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWorkloadEstimateUsage page.
func (p *ListWorkloadEstimateUsagePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWorkloadEstimateUsageOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListWorkloadEstimateUsage(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListWorkloadEstimateUsageAPIClient is a client that implements the
// ListWorkloadEstimateUsage operation.
type ListWorkloadEstimateUsageAPIClient interface {
	ListWorkloadEstimateUsage(context.Context, *ListWorkloadEstimateUsageInput, ...func(*Options)) (*ListWorkloadEstimateUsageOutput, error)
}

var _ ListWorkloadEstimateUsageAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListWorkloadEstimateUsage(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWorkloadEstimateUsage",
	}
}
