// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates dedicated throughput for a base or custom model with the model units
// and for the duration that you specify. For pricing details, see [Amazon Bedrock Pricing]. For more
// information, see [Provisioned Throughput]in the [Amazon Bedrock User Guide].
//
// [Amazon Bedrock Pricing]: http://aws.amazon.com/bedrock/pricing/
// [Provisioned Throughput]: https://docs.aws.amazon.com/bedrock/latest/userguide/prov-throughput.html
// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html
func (c *Client) CreateProvisionedModelThroughput(ctx context.Context, params *CreateProvisionedModelThroughputInput, optFns ...func(*Options)) (*CreateProvisionedModelThroughputOutput, error) {
	if params == nil {
		params = &CreateProvisionedModelThroughputInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProvisionedModelThroughput", params, optFns, c.addOperationCreateProvisionedModelThroughputMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProvisionedModelThroughputOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateProvisionedModelThroughputInput struct {

	// The Amazon Resource Name (ARN) or name of the model to associate with this
	// Provisioned Throughput. For a list of models for which you can purchase
	// Provisioned Throughput, see [Amazon Bedrock model IDs for purchasing Provisioned Throughput]in the [Amazon Bedrock User Guide].
	//
	// [Amazon Bedrock model IDs for purchasing Provisioned Throughput]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-ids.html#prov-throughput-models
	// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html
	//
	// This member is required.
	ModelId *string

	// Number of model units to allocate. A model unit delivers a specific throughput
	// level for the specified model. The throughput level of a model unit specifies
	// the total number of input and output tokens that it can process and generate
	// within a span of one minute. By default, your account has no model units for
	// purchasing Provisioned Throughputs with commitment. You must first visit the [Amazon Web Services support center]to
	// request MUs.
	//
	// For model unit quotas, see [Provisioned Throughput quotas] in the [Amazon Bedrock User Guide].
	//
	// For more information about what an MU specifies, contact your Amazon Web
	// Services account manager.
	//
	// [Amazon Web Services support center]: https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase
	// [Provisioned Throughput quotas]: https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html#prov-thru-quotas
	// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html
	//
	// This member is required.
	ModelUnits *int32

	// The name for this Provisioned Throughput.
	//
	// This member is required.
	ProvisionedModelName *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency]in
	// the Amazon S3 User Guide.
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientRequestToken *string

	// The commitment duration requested for the Provisioned Throughput. Billing
	// occurs hourly and is discounted for longer commitment terms. To request a
	// no-commit Provisioned Throughput, omit this field.
	//
	// Custom models support all levels of commitment. To see which base models
	// support no commitment, see [Supported regions and models for Provisioned Throughput]in the [Amazon Bedrock User Guide]
	//
	// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html
	// [Supported regions and models for Provisioned Throughput]: https://docs.aws.amazon.com/bedrock/latest/userguide/pt-supported.html
	CommitmentDuration types.CommitmentDuration

	// Tags to associate with this Provisioned Throughput.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateProvisionedModelThroughputOutput struct {

	// The Amazon Resource Name (ARN) for this Provisioned Throughput.
	//
	// This member is required.
	ProvisionedModelArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProvisionedModelThroughputMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateProvisionedModelThroughput{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateProvisionedModelThroughput{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateProvisionedModelThroughput"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateProvisionedModelThroughputMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateProvisionedModelThroughputValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProvisionedModelThroughput(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateProvisionedModelThroughput struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateProvisionedModelThroughput) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateProvisionedModelThroughput) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateProvisionedModelThroughputInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateProvisionedModelThroughputInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateProvisionedModelThroughputMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateProvisionedModelThroughput{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateProvisionedModelThroughput(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateProvisionedModelThroughput",
	}
}
