// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Get the properties associated with a Amazon Bedrock custom model that you have
// created.For more information, see [Custom models]in the [Amazon Bedrock User Guide].
//
// [Custom models]: https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html
// [Amazon Bedrock User Guide]: https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-service.html
func (c *Client) GetCustomModel(ctx context.Context, params *GetCustomModelInput, optFns ...func(*Options)) (*GetCustomModelOutput, error) {
	if params == nil {
		params = &GetCustomModelInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCustomModel", params, optFns, c.addOperationGetCustomModelMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCustomModelOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCustomModelInput struct {

	// Name or Amazon Resource Name (ARN) of the custom model.
	//
	// This member is required.
	ModelIdentifier *string

	noSmithyDocumentSerde
}

type GetCustomModelOutput struct {

	// Amazon Resource Name (ARN) of the base model.
	//
	// This member is required.
	BaseModelArn *string

	// Creation time of the model.
	//
	// This member is required.
	CreationTime *time.Time

	// Job Amazon Resource Name (ARN) associated with this model.
	//
	// This member is required.
	JobArn *string

	// Amazon Resource Name (ARN) associated with this model.
	//
	// This member is required.
	ModelArn *string

	// Model name associated with this model.
	//
	// This member is required.
	ModelName *string

	// Output data configuration associated with this custom model.
	//
	// This member is required.
	OutputDataConfig *types.OutputDataConfig

	// Contains information about the training dataset.
	//
	// This member is required.
	TrainingDataConfig *types.TrainingDataConfig

	// The customization configuration for the custom model.
	CustomizationConfig types.CustomizationConfig

	// The type of model customization.
	CustomizationType types.CustomizationType

	// Hyperparameter values associated with this model. For details on the format for
	// different models, see [Custom model hyperparameters].
	//
	// [Custom model hyperparameters]: https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html
	HyperParameters map[string]string

	// Job name associated with this model.
	JobName *string

	// The custom model is encrypted at rest using this key.
	ModelKmsKeyArn *string

	// Contains training metrics from the job creation.
	TrainingMetrics *types.TrainingMetrics

	// Contains information about the validation dataset.
	ValidationDataConfig *types.ValidationDataConfig

	// The validation metrics from the job creation.
	ValidationMetrics []types.ValidatorMetric

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCustomModelMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCustomModel{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCustomModel{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCustomModel"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetCustomModelValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCustomModel(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCustomModel(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCustomModel",
	}
}
