// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists all existing evaluation jobs.
func (c *Client) ListEvaluationJobs(ctx context.Context, params *ListEvaluationJobsInput, optFns ...func(*Options)) (*ListEvaluationJobsOutput, error) {
	if params == nil {
		params = &ListEvaluationJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEvaluationJobs", params, optFns, c.addOperationListEvaluationJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEvaluationJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEvaluationJobsInput struct {

	// A filter to only list evaluation jobs that are either model evaluations or
	// knowledge base evaluations.
	ApplicationTypeEquals types.ApplicationType

	// A filter to only list evaluation jobs created after a specified time.
	CreationTimeAfter *time.Time

	// A filter to only list evaluation jobs created before a specified time.
	CreationTimeBefore *time.Time

	// The maximum number of results to return.
	MaxResults *int32

	// A filter to only list evaluation jobs that contain a specified string in the
	// job name.
	NameContains *string

	// Continuation token from the previous response, for Amazon Bedrock to list the
	// next set of results.
	NextToken *string

	// Specifies a creation time to sort the list of evaluation jobs by when they were
	// created.
	SortBy types.SortJobsBy

	// Specifies whether to sort the list of evaluation jobs by either ascending or
	// descending order.
	SortOrder types.SortOrder

	// A filter to only list evaluation jobs that are of a certain status.
	StatusEquals types.EvaluationJobStatus

	noSmithyDocumentSerde
}

type ListEvaluationJobsOutput struct {

	// A list of summaries of the evaluation jobs.
	JobSummaries []types.EvaluationSummary

	// Continuation token from the previous response, for Amazon Bedrock to list the
	// next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEvaluationJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEvaluationJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEvaluationJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEvaluationJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEvaluationJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListEvaluationJobsPaginatorOptions is the paginator options for
// ListEvaluationJobs
type ListEvaluationJobsPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEvaluationJobsPaginator is a paginator for ListEvaluationJobs
type ListEvaluationJobsPaginator struct {
	options   ListEvaluationJobsPaginatorOptions
	client    ListEvaluationJobsAPIClient
	params    *ListEvaluationJobsInput
	nextToken *string
	firstPage bool
}

// NewListEvaluationJobsPaginator returns a new ListEvaluationJobsPaginator
func NewListEvaluationJobsPaginator(client ListEvaluationJobsAPIClient, params *ListEvaluationJobsInput, optFns ...func(*ListEvaluationJobsPaginatorOptions)) *ListEvaluationJobsPaginator {
	if params == nil {
		params = &ListEvaluationJobsInput{}
	}

	options := ListEvaluationJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEvaluationJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEvaluationJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEvaluationJobs page.
func (p *ListEvaluationJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEvaluationJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEvaluationJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEvaluationJobsAPIClient is a client that implements the ListEvaluationJobs
// operation.
type ListEvaluationJobsAPIClient interface {
	ListEvaluationJobs(context.Context, *ListEvaluationJobsInput, ...func(*Options)) (*ListEvaluationJobsOutput, error)
}

var _ ListEvaluationJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEvaluationJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEvaluationJobs",
	}
}
