// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the endpoints for models from Amazon Bedrock Marketplace in your Amazon
// Web Services account.
func (c *Client) ListMarketplaceModelEndpoints(ctx context.Context, params *ListMarketplaceModelEndpointsInput, optFns ...func(*Options)) (*ListMarketplaceModelEndpointsOutput, error) {
	if params == nil {
		params = &ListMarketplaceModelEndpointsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMarketplaceModelEndpoints", params, optFns, c.addOperationListMarketplaceModelEndpointsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMarketplaceModelEndpointsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMarketplaceModelEndpointsInput struct {

	// The maximum number of results to return in a single call. If more results are
	// available, the operation returns a NextToken value.
	MaxResults *int32

	// If specified, only endpoints for the given model source identifier are returned.
	ModelSourceEquals *string

	// The token for the next set of results. You receive this token from a previous
	// ListMarketplaceModelEndpoints call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMarketplaceModelEndpointsOutput struct {

	// An array of endpoint summaries.
	MarketplaceModelEndpoints []types.MarketplaceModelEndpointSummary

	// The token for the next set of results. Use this token to get the next set of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMarketplaceModelEndpointsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMarketplaceModelEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMarketplaceModelEndpoints{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMarketplaceModelEndpoints"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMarketplaceModelEndpoints(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListMarketplaceModelEndpointsPaginatorOptions is the paginator options for
// ListMarketplaceModelEndpoints
type ListMarketplaceModelEndpointsPaginatorOptions struct {
	// The maximum number of results to return in a single call. If more results are
	// available, the operation returns a NextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMarketplaceModelEndpointsPaginator is a paginator for
// ListMarketplaceModelEndpoints
type ListMarketplaceModelEndpointsPaginator struct {
	options   ListMarketplaceModelEndpointsPaginatorOptions
	client    ListMarketplaceModelEndpointsAPIClient
	params    *ListMarketplaceModelEndpointsInput
	nextToken *string
	firstPage bool
}

// NewListMarketplaceModelEndpointsPaginator returns a new
// ListMarketplaceModelEndpointsPaginator
func NewListMarketplaceModelEndpointsPaginator(client ListMarketplaceModelEndpointsAPIClient, params *ListMarketplaceModelEndpointsInput, optFns ...func(*ListMarketplaceModelEndpointsPaginatorOptions)) *ListMarketplaceModelEndpointsPaginator {
	if params == nil {
		params = &ListMarketplaceModelEndpointsInput{}
	}

	options := ListMarketplaceModelEndpointsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMarketplaceModelEndpointsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMarketplaceModelEndpointsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMarketplaceModelEndpoints page.
func (p *ListMarketplaceModelEndpointsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMarketplaceModelEndpointsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListMarketplaceModelEndpoints(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListMarketplaceModelEndpointsAPIClient is a client that implements the
// ListMarketplaceModelEndpoints operation.
type ListMarketplaceModelEndpointsAPIClient interface {
	ListMarketplaceModelEndpoints(context.Context, *ListMarketplaceModelEndpointsInput, ...func(*Options)) (*ListMarketplaceModelEndpointsOutput, error)
}

var _ ListMarketplaceModelEndpointsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListMarketplaceModelEndpoints(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMarketplaceModelEndpoints",
	}
}
