// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of prompt routers.
func (c *Client) ListPromptRouters(ctx context.Context, params *ListPromptRoutersInput, optFns ...func(*Options)) (*ListPromptRoutersOutput, error) {
	if params == nil {
		params = &ListPromptRoutersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPromptRouters", params, optFns, c.addOperationListPromptRoutersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPromptRoutersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPromptRoutersInput struct {

	// The maximum number of prompt routers to return in one page of results.
	MaxResults *int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListPromptRoutersOutput struct {

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	// A list of prompt router summaries.
	PromptRouterSummaries []types.PromptRouterSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPromptRoutersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListPromptRouters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListPromptRouters{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPromptRouters"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPromptRouters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListPromptRoutersPaginatorOptions is the paginator options for ListPromptRouters
type ListPromptRoutersPaginatorOptions struct {
	// The maximum number of prompt routers to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPromptRoutersPaginator is a paginator for ListPromptRouters
type ListPromptRoutersPaginator struct {
	options   ListPromptRoutersPaginatorOptions
	client    ListPromptRoutersAPIClient
	params    *ListPromptRoutersInput
	nextToken *string
	firstPage bool
}

// NewListPromptRoutersPaginator returns a new ListPromptRoutersPaginator
func NewListPromptRoutersPaginator(client ListPromptRoutersAPIClient, params *ListPromptRoutersInput, optFns ...func(*ListPromptRoutersPaginatorOptions)) *ListPromptRoutersPaginator {
	if params == nil {
		params = &ListPromptRoutersInput{}
	}

	options := ListPromptRoutersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPromptRoutersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPromptRoutersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPromptRouters page.
func (p *ListPromptRoutersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPromptRoutersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPromptRouters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPromptRoutersAPIClient is a client that implements the ListPromptRouters
// operation.
type ListPromptRoutersAPIClient interface {
	ListPromptRouters(context.Context, *ListPromptRoutersInput, ...func(*Options)) (*ListPromptRoutersOutput, error)
}

var _ ListPromptRoutersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPromptRouters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPromptRouters",
	}
}
