// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"github.com/aws/aws-sdk-go-v2/service/bedrock/document"
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The configuration details of an automated evaluation job. The
// EvaluationDatasetMetricConfig object is used to specify the prompt datasets,
// task type, and metric names.
type AutomatedEvaluationConfig struct {

	// Configuration details of the prompt datasets and metrics you want to use for
	// your evaluation job.
	//
	// This member is required.
	DatasetMetricConfigs []EvaluationDatasetMetricConfig

	// Contains the evaluator model configuration details. EvaluatorModelConfig is
	// required for evaluation jobs that use a knowledge base or in model evaluation
	// job that use a model as judge. This model computes all evaluation related
	// metrics.
	EvaluatorModelConfig EvaluatorModelConfig

	noSmithyDocumentSerde
}

// A JSON array that provides the status of the evaluation jobs being deleted.
type BatchDeleteEvaluationJobError struct {

	// A HTTP status code of the evaluation job being deleted.
	//
	// This member is required.
	Code *string

	// The ARN of the evaluation job being deleted.
	//
	// This member is required.
	JobIdentifier *string

	// A status message about the evaluation job deletion.
	Message *string

	noSmithyDocumentSerde
}

// An evaluation job for deletion, and it’s current status.
type BatchDeleteEvaluationJobItem struct {

	// The Amazon Resource Name (ARN) of the evaluation job for deletion.
	//
	// This member is required.
	JobIdentifier *string

	// The status of the evaluation job for deletion.
	//
	// This member is required.
	JobStatus EvaluationJobStatus

	noSmithyDocumentSerde
}

// The evaluator model used in knowledge base evaluation job or in model
// evaluation job that use a model as judge. This model computes all evaluation
// related metrics.
type BedrockEvaluatorModel struct {

	// The Amazon Resource Name (ARN) of the evaluator model used used in knowledge
	// base evaluation job or in model evaluation job that use a model as judge.
	//
	// This member is required.
	ModelIdentifier *string

	noSmithyDocumentSerde
}

// Contains the document contained in the wrapper object, along with its
// attributes/fields.
type ByteContentDoc struct {

	// The MIME type of the document contained in the wrapper object.
	//
	// This member is required.
	ContentType *string

	// The byte value of the file to upload, encoded as a Base-64 string.
	//
	// This member is required.
	Data []byte

	// The file name of the document contained in the wrapper object.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

// CloudWatch logging configuration.
type CloudWatchConfig struct {

	// The log group name.
	//
	// This member is required.
	LogGroupName *string

	// The role Amazon Resource Name (ARN).
	//
	// This member is required.
	RoleArn *string

	// S3 configuration for delivering a large amount of data.
	LargeDataDeliveryS3Config *S3Config

	noSmithyDocumentSerde
}

// A model customization configuration
//
// The following types satisfy this interface:
//
//	CustomizationConfigMemberDistillationConfig
type CustomizationConfig interface {
	isCustomizationConfig()
}

// The distillation configuration for the custom model.
type CustomizationConfigMemberDistillationConfig struct {
	Value DistillationConfig

	noSmithyDocumentSerde
}

func (*CustomizationConfigMemberDistillationConfig) isCustomizationConfig() {}

// Summary information for a custom model.
type CustomModelSummary struct {

	// The base model Amazon Resource Name (ARN).
	//
	// This member is required.
	BaseModelArn *string

	// The base model name.
	//
	// This member is required.
	BaseModelName *string

	// Creation time of the model.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the custom model.
	//
	// This member is required.
	ModelArn *string

	// The name of the custom model.
	//
	// This member is required.
	ModelName *string

	// Specifies whether to carry out continued pre-training of a model or whether to
	// fine-tune it. For more information, see [Custom models].
	//
	// [Custom models]: https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html
	CustomizationType CustomizationType

	// The unique identifier of the account that owns the model.
	OwnerAccountId *string

	noSmithyDocumentSerde
}

// Settings for distilling a foundation model into a smaller and more efficient
// model.
type DistillationConfig struct {

	// The teacher model configuration.
	//
	// This member is required.
	TeacherModelConfig *TeacherModelConfig

	noSmithyDocumentSerde
}

// Specifies the configuration for the endpoint.
//
// The following types satisfy this interface:
//
//	EndpointConfigMemberSageMaker
type EndpointConfig interface {
	isEndpointConfig()
}

// The configuration specific to Amazon SageMaker for the endpoint.
type EndpointConfigMemberSageMaker struct {
	Value SageMakerEndpoint

	noSmithyDocumentSerde
}

func (*EndpointConfigMemberSageMaker) isEndpointConfig() {}

// Contains the ARN of the Amazon Bedrock model or [inference profile] specified in your evaluation
// job. Each Amazon Bedrock model supports different inferenceParams . To learn
// more about supported inference parameters for Amazon Bedrock models, see [Inference parameters for foundation models].
//
// The inferenceParams are specified using JSON. To successfully insert JSON as
// string make sure that all quotations are properly escaped. For example,
// "temperature":"0.25" key value pair would need to be formatted as
// \"temperature\":\"0.25\" to successfully accepted in the request.
//
// [Inference parameters for foundation models]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-parameters.html
// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
type EvaluationBedrockModel struct {

	// The ARN of the Amazon Bedrock model or inference profile specified.
	//
	// This member is required.
	ModelIdentifier *string

	// Each Amazon Bedrock support different inference parameters that change how the
	// model behaves during inference.
	InferenceParams *string

	// Specifies performance settings for the model or inference profile.
	PerformanceConfig *PerformanceConfiguration

	noSmithyDocumentSerde
}

// The configuration details of either an automated or human-based evaluation job.
//
// The following types satisfy this interface:
//
//	EvaluationConfigMemberAutomated
//	EvaluationConfigMemberHuman
type EvaluationConfig interface {
	isEvaluationConfig()
}

// Contains the configuration details of an automated evaluation job that computes
// metrics.
type EvaluationConfigMemberAutomated struct {
	Value AutomatedEvaluationConfig

	noSmithyDocumentSerde
}

func (*EvaluationConfigMemberAutomated) isEvaluationConfig() {}

// Contains the configuration details of an evaluation job that uses human workers.
type EvaluationConfigMemberHuman struct {
	Value HumanEvaluationConfig

	noSmithyDocumentSerde
}

func (*EvaluationConfigMemberHuman) isEvaluationConfig() {}

// Used to specify the name of a built-in prompt dataset and optionally, the
// Amazon S3 bucket where a custom prompt dataset is saved.
type EvaluationDataset struct {

	// Used to specify supported built-in prompt datasets. Valid values are
	// Builtin.Bold , Builtin.BoolQ , Builtin.NaturalQuestions , Builtin.Gigaword ,
	// Builtin.RealToxicityPrompts , Builtin.TriviaQA , Builtin.T-Rex ,
	// Builtin.WomensEcommerceClothingReviews and Builtin.Wikitext2 .
	//
	// This member is required.
	Name *string

	// For custom prompt datasets, you must specify the location in Amazon S3 where
	// the prompt dataset is saved.
	DatasetLocation EvaluationDatasetLocation

	noSmithyDocumentSerde
}

// The location in Amazon S3 where your prompt dataset is stored.
//
// The following types satisfy this interface:
//
//	EvaluationDatasetLocationMemberS3Uri
type EvaluationDatasetLocation interface {
	isEvaluationDatasetLocation()
}

// The S3 URI of the S3 bucket specified in the job.
type EvaluationDatasetLocationMemberS3Uri struct {
	Value string

	noSmithyDocumentSerde
}

func (*EvaluationDatasetLocationMemberS3Uri) isEvaluationDatasetLocation() {}

// Defines the prompt datasets, built-in metric names and custom metric names, and
// the task type.
type EvaluationDatasetMetricConfig struct {

	// Specifies the prompt dataset.
	//
	// This member is required.
	Dataset *EvaluationDataset

	// The names of the metrics you want to use for your evaluation job.
	//
	// For knowledge base evaluation jobs that evaluate retrieval only, valid values
	// are " Builtin.ContextRelevance ", " Builtin.ContextConverage ".
	//
	// For knowledge base evaluation jobs that evaluate retrieval with response
	// generation, valid values are " Builtin.Correctness ", " Builtin.Completeness ", "
	// Builtin.Helpfulness ", " Builtin.LogicalCoherence ", " Builtin.Faithfulness ", "
	// Builtin.Harmfulness ", " Builtin.Stereotyping ", " Builtin.Refusal ".
	//
	// For automated model evaluation jobs, valid values are " Builtin.Accuracy ", "
	// Builtin.Robustness ", and " Builtin.Toxicity ". In model evaluation jobs that
	// use a LLM as judge you can specify " Builtin.Correctness ", "
	// Builtin.Completeness" , " Builtin.Faithfulness" , " Builtin.Helpfulness ", "
	// Builtin.Coherence ", " Builtin.Relevance ", " Builtin.FollowingInstructions ", "
	// Builtin.ProfessionalStyleAndTone ", You can also specify the following
	// responsible AI related metrics only for model evaluation job that use a LLM as
	// judge " Builtin.Harmfulness ", " Builtin.Stereotyping ", and " Builtin.Refusal ".
	//
	// For human-based model evaluation jobs, the list of strings must match the name
	// parameter specified in HumanEvaluationCustomMetric .
	//
	// This member is required.
	MetricNames []string

	// The the type of task you want to evaluate for your evaluation job. This applies
	// only to model evaluation jobs and is ignored for knowledge base evaluation jobs.
	//
	// This member is required.
	TaskType EvaluationTaskType

	noSmithyDocumentSerde
}

// The configuration details of the inference model for an evaluation job.
//
// For automated model evaluation jobs, only a single model is supported.
//
// For human-based model evaluation jobs, your annotator can compare the responses
// for up to two different models.
//
// The following types satisfy this interface:
//
//	EvaluationInferenceConfigMemberModels
//	EvaluationInferenceConfigMemberRagConfigs
type EvaluationInferenceConfig interface {
	isEvaluationInferenceConfig()
}

// Specifies the inference models.
type EvaluationInferenceConfigMemberModels struct {
	Value []EvaluationModelConfig

	noSmithyDocumentSerde
}

func (*EvaluationInferenceConfigMemberModels) isEvaluationInferenceConfig() {}

// Contains the configuration details of the inference for a knowledge base
// evaluation job, including either the retrieval only configuration or the
// retrieval with response generation configuration.
type EvaluationInferenceConfigMemberRagConfigs struct {
	Value []RAGConfig

	noSmithyDocumentSerde
}

func (*EvaluationInferenceConfigMemberRagConfigs) isEvaluationInferenceConfig() {}

// Defines the models used in the model evaluation job.
//
// The following types satisfy this interface:
//
//	EvaluationModelConfigMemberBedrockModel
type EvaluationModelConfig interface {
	isEvaluationModelConfig()
}

// Defines the Amazon Bedrock model or inference profile and inference parameters
// you want used.
type EvaluationModelConfigMemberBedrockModel struct {
	Value EvaluationBedrockModel

	noSmithyDocumentSerde
}

func (*EvaluationModelConfigMemberBedrockModel) isEvaluationModelConfig() {}

// The Amazon S3 location where the results of your evaluation job are saved.
type EvaluationOutputDataConfig struct {

	// The Amazon S3 URI where the results of the evaluation job are saved.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Summary information of an evaluation job.
type EvaluationSummary struct {

	// The time the evaluation job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The type of task for model evaluation.
	//
	// This member is required.
	EvaluationTaskTypes []EvaluationTaskType

	// The Amazon Resource Name (ARN) of the evaluation job.
	//
	// This member is required.
	JobArn *string

	// The name for the evaluation job.
	//
	// This member is required.
	JobName *string

	// Specifies whether the evaluation job is automated or human-based.
	//
	// This member is required.
	JobType EvaluationJobType

	// The current status of the evaluation job.
	//
	// This member is required.
	Status EvaluationJobStatus

	// Specifies whether the evaluation job is for evaluating a model or evaluating a
	// knowledge base (retrieval and response generation).
	ApplicationType ApplicationType

	// The Amazon Resource Names (ARNs) of the models used to compute the metrics for
	// a knowledge base evaluation job.
	EvaluatorModelIdentifiers []string

	// The Amazon Resource Names (ARNs) of the model(s) used for the evaluation job.
	ModelIdentifiers []string

	// The Amazon Resource Names (ARNs) of the knowledge base resources used for a
	// knowledge base evaluation job.
	RagIdentifiers []string

	noSmithyDocumentSerde
}

// Specifies the model configuration for the evaluator model. EvaluatorModelConfig
// is required for evaluation jobs that use a knowledge base or in model evaluation
// job that use a model as judge. This model computes all evaluation related
// metrics.
//
// The following types satisfy this interface:
//
//	EvaluatorModelConfigMemberBedrockEvaluatorModels
type EvaluatorModelConfig interface {
	isEvaluatorModelConfig()
}

// The evaluator model used in knowledge base evaluation job or in model
// evaluation job that use a model as judge. This model computes all evaluation
// related metrics.
type EvaluatorModelConfigMemberBedrockEvaluatorModels struct {
	Value []BedrockEvaluatorModel

	noSmithyDocumentSerde
}

func (*EvaluatorModelConfigMemberBedrockEvaluatorModels) isEvaluatorModelConfig() {}

// The unique external source of the content contained in the wrapper object.
type ExternalSource struct {

	// The source type of the external source wrapper object.
	//
	// This member is required.
	SourceType ExternalSourceType

	// The identifier, content type, and data of the external source wrapper object.
	ByteContent *ByteContentDoc

	// The S3 location of the external source wrapper object.
	S3Location *S3ObjectDoc

	noSmithyDocumentSerde
}

// The response generation configuration of the external source wrapper object.
type ExternalSourcesGenerationConfiguration struct {

	// Additional model parameters and their corresponding values not included in the
	// text inference configuration for an external source. Takes in custom model
	// parameters specific to the language model being used.
	AdditionalModelRequestFields map[string]document.Interface

	// Configuration details for the guardrail.
	GuardrailConfiguration *GuardrailConfiguration

	// Configuration details for inference when using RetrieveAndGenerate to generate
	// responses while using an external source.
	KbInferenceConfig *KbInferenceConfig

	// Contains the template for the prompt for the external source wrapper object.
	PromptTemplate *PromptTemplate

	noSmithyDocumentSerde
}

// The configuration of the external source wrapper object in the
// retrieveAndGenerate function.
type ExternalSourcesRetrieveAndGenerateConfiguration struct {

	// The Amazon Resource Name (ARN) of the foundation model or [inference profile] used to generate
	// responses.
	//
	// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
	//
	// This member is required.
	ModelArn *string

	// The document for the external source wrapper object in the retrieveAndGenerate
	// function.
	//
	// This member is required.
	Sources []ExternalSource

	// Contains configurations details for response generation based on retrieved text
	// chunks.
	GenerationConfiguration *ExternalSourcesGenerationConfiguration

	noSmithyDocumentSerde
}

// Specifies the name of the metadata attribute/field to apply filters. You must
// match the name of the attribute/field in your data source/document metadata.
type FilterAttribute struct {

	// The name of metadata attribute/field, which must match the name in your data
	// source/document metadata.
	//
	// This member is required.
	Key *string

	// The value of the metadata attribute/field.
	//
	// This member is required.
	Value document.Interface

	noSmithyDocumentSerde
}

// Information about a foundation model.
type FoundationModelDetails struct {

	// The model Amazon Resource Name (ARN).
	//
	// This member is required.
	ModelArn *string

	// The model identifier.
	//
	// This member is required.
	ModelId *string

	// The customization that the model supports.
	CustomizationsSupported []ModelCustomization

	// The inference types that the model supports.
	InferenceTypesSupported []InferenceType

	// The input modalities that the model supports.
	InputModalities []ModelModality

	// Contains details about whether a model version is available or deprecated
	ModelLifecycle *FoundationModelLifecycle

	// The model name.
	ModelName *string

	// The output modalities that the model supports.
	OutputModalities []ModelModality

	// The model's provider name.
	ProviderName *string

	// Indicates whether the model supports streaming.
	ResponseStreamingSupported *bool

	noSmithyDocumentSerde
}

// Details about whether a model version is available or deprecated.
type FoundationModelLifecycle struct {

	// Specifies whether a model version is available ( ACTIVE ) or deprecated ( LEGACY
	// .
	//
	// This member is required.
	Status FoundationModelLifecycleStatus

	noSmithyDocumentSerde
}

// Summary information for a foundation model.
type FoundationModelSummary struct {

	// The Amazon Resource Name (ARN) of the foundation model.
	//
	// This member is required.
	ModelArn *string

	// The model ID of the foundation model.
	//
	// This member is required.
	ModelId *string

	// Whether the model supports fine-tuning or continual pre-training.
	CustomizationsSupported []ModelCustomization

	// The inference types that the model supports.
	InferenceTypesSupported []InferenceType

	// The input modalities that the model supports.
	InputModalities []ModelModality

	// Contains details about whether a model version is available or deprecated.
	ModelLifecycle *FoundationModelLifecycle

	// The name of the model.
	ModelName *string

	// The output modalities that the model supports.
	OutputModalities []ModelModality

	// The model's provider name.
	ProviderName *string

	// Indicates whether the model supports streaming.
	ResponseStreamingSupported *bool

	noSmithyDocumentSerde
}

// The configuration details for response generation based on retrieved text
// chunks.
type GenerationConfiguration struct {

	// Additional model parameters and corresponding values not included in the
	// textInferenceConfig structure for a knowledge base. This allows you to provide
	// custom model parameters specific to the language model being used.
	AdditionalModelRequestFields map[string]document.Interface

	// Contains configuration details for the guardrail.
	GuardrailConfiguration *GuardrailConfiguration

	// Contains configuration details for inference for knowledge base retrieval and
	// response generation.
	KbInferenceConfig *KbInferenceConfig

	// Contains the template for the prompt that's sent to the model for response
	// generation.
	PromptTemplate *PromptTemplate

	noSmithyDocumentSerde
}

// The configuration details for the guardrail.
type GuardrailConfiguration struct {

	// The unique identifier for the guardrail.
	//
	// This member is required.
	GuardrailId *string

	// The version of the guardrail.
	//
	// This member is required.
	GuardrailVersion *string

	noSmithyDocumentSerde
}

// Contains filter strengths for harmful content. Guardrails support the following
// content filters to detect and filter harmful user inputs and FM-generated
// outputs.
//
//   - Hate – Describes language or a statement that discriminates, criticizes,
//     insults, denounces, or dehumanizes a person or group on the basis of an identity
//     (such as race, ethnicity, gender, religion, sexual orientation, ability, and
//     national origin).
//
//   - Insults – Describes language or a statement that includes demeaning,
//     humiliating, mocking, insulting, or belittling language. This type of language
//     is also labeled as bullying.
//
//   - Sexual – Describes language or a statement that indicates sexual interest,
//     activity, or arousal using direct or indirect references to body parts, physical
//     traits, or sex.
//
//   - Violence – Describes language or a statement that includes glorification of
//     or threats to inflict physical pain, hurt, or injury toward a person, group or
//     thing.
//
// Content filtering depends on the confidence classification of user inputs and
// FM responses across each of the four harmful categories. All input and output
// statements are classified into one of four confidence levels (NONE, LOW, MEDIUM,
// HIGH) for each harmful category. For example, if a statement is classified as
// Hate with HIGH confidence, the likelihood of the statement representing hateful
// content is high. A single statement can be classified across multiple categories
// with varying confidence levels. For example, a single statement can be
// classified as Hate with HIGH confidence, Insults with LOW confidence, Sexual
// with NONE confidence, and Violence with MEDIUM confidence.
//
// For more information, see [Guardrails content filters].
//
// This data type is used in the following API operations:
//
// [GetGuardrail response body]
//
// [GetGuardrail response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax
// [Guardrails content filters]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html
type GuardrailContentFilter struct {

	// The strength of the content filter to apply to prompts. As you increase the
	// filter strength, the likelihood of filtering harmful content increases and the
	// probability of seeing harmful content in your application reduces.
	//
	// This member is required.
	InputStrength GuardrailFilterStrength

	// The strength of the content filter to apply to model responses. As you increase
	// the filter strength, the likelihood of filtering harmful content increases and
	// the probability of seeing harmful content in your application reduces.
	//
	// This member is required.
	OutputStrength GuardrailFilterStrength

	// The harmful category that the content filter is applied to.
	//
	// This member is required.
	Type GuardrailContentFilterType

	// The input modalities selected for the guardrail content filter.
	InputModalities []GuardrailModality

	// The output modalities selected for the guardrail content filter.
	OutputModalities []GuardrailModality

	noSmithyDocumentSerde
}

// Contains filter strengths for harmful content. Guardrails support the following
// content filters to detect and filter harmful user inputs and FM-generated
// outputs.
//
//   - Hate – Describes language or a statement that discriminates, criticizes,
//     insults, denounces, or dehumanizes a person or group on the basis of an identity
//     (such as race, ethnicity, gender, religion, sexual orientation, ability, and
//     national origin).
//
//   - Insults – Describes language or a statement that includes demeaning,
//     humiliating, mocking, insulting, or belittling language. This type of language
//     is also labeled as bullying.
//
//   - Sexual – Describes language or a statement that indicates sexual interest,
//     activity, or arousal using direct or indirect references to body parts, physical
//     traits, or sex.
//
//   - Violence – Describes language or a statement that includes glorification of
//     or threats to inflict physical pain, hurt, or injury toward a person, group or
//     thing.
//
// Content filtering depends on the confidence classification of user inputs and
// FM responses across each of the four harmful categories. All input and output
// statements are classified into one of four confidence levels (NONE, LOW, MEDIUM,
// HIGH) for each harmful category. For example, if a statement is classified as
// Hate with HIGH confidence, the likelihood of the statement representing hateful
// content is high. A single statement can be classified across multiple categories
// with varying confidence levels. For example, a single statement can be
// classified as Hate with HIGH confidence, Insults with LOW confidence, Sexual
// with NONE confidence, and Violence with MEDIUM confidence.
//
// For more information, see [Guardrails content filters].
//
// [Guardrails content filters]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters.html
type GuardrailContentFilterConfig struct {

	// The strength of the content filter to apply to prompts. As you increase the
	// filter strength, the likelihood of filtering harmful content increases and the
	// probability of seeing harmful content in your application reduces.
	//
	// This member is required.
	InputStrength GuardrailFilterStrength

	// The strength of the content filter to apply to model responses. As you increase
	// the filter strength, the likelihood of filtering harmful content increases and
	// the probability of seeing harmful content in your application reduces.
	//
	// This member is required.
	OutputStrength GuardrailFilterStrength

	// The harmful category that the content filter is applied to.
	//
	// This member is required.
	Type GuardrailContentFilterType

	// The input modalities selected for the guardrail content filter configuration.
	InputModalities []GuardrailModality

	// The output modalities selected for the guardrail content filter configuration.
	OutputModalities []GuardrailModality

	noSmithyDocumentSerde
}

// Contains details about how to handle harmful content.
//
// This data type is used in the following API operations:
//
// [GetGuardrail response body]
//
// [GetGuardrail response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax
type GuardrailContentPolicy struct {

	// Contains the type of the content filter and how strongly it should apply to
	// prompts and model responses.
	Filters []GuardrailContentFilter

	noSmithyDocumentSerde
}

// Contains details about how to handle harmful content.
type GuardrailContentPolicyConfig struct {

	// Contains the type of the content filter and how strongly it should apply to
	// prompts and model responses.
	//
	// This member is required.
	FiltersConfig []GuardrailContentFilterConfig

	noSmithyDocumentSerde
}

// The details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingFilter struct {

	// The threshold details for the guardrails contextual grounding filter.
	//
	// This member is required.
	Threshold *float64

	// The filter type details for the guardrails contextual grounding filter.
	//
	// This member is required.
	Type GuardrailContextualGroundingFilterType

	noSmithyDocumentSerde
}

// The filter configuration details for the guardrails contextual grounding filter.
type GuardrailContextualGroundingFilterConfig struct {

	// The threshold details for the guardrails contextual grounding filter.
	//
	// This member is required.
	Threshold *float64

	// The filter details for the guardrails contextual grounding filter.
	//
	// This member is required.
	Type GuardrailContextualGroundingFilterType

	noSmithyDocumentSerde
}

// The details for the guardrails contextual grounding policy.
type GuardrailContextualGroundingPolicy struct {

	// The filter details for the guardrails contextual grounding policy.
	//
	// This member is required.
	Filters []GuardrailContextualGroundingFilter

	noSmithyDocumentSerde
}

// The policy configuration details for the guardrails contextual grounding policy.
type GuardrailContextualGroundingPolicyConfig struct {

	// The filter configuration details for the guardrails contextual grounding policy.
	//
	// This member is required.
	FiltersConfig []GuardrailContextualGroundingFilterConfig

	noSmithyDocumentSerde
}

// The managed word list that was configured for the guardrail. (This is a list of
// words that are pre-defined and managed by guardrails only.)
type GuardrailManagedWords struct {

	// ManagedWords$type The managed word type that was configured for the guardrail.
	// (For now, we only offer profanity word list)
	//
	// This member is required.
	Type GuardrailManagedWordsType

	noSmithyDocumentSerde
}

// The managed word list to configure for the guardrail.
type GuardrailManagedWordsConfig struct {

	// The managed word type to configure for the guardrail.
	//
	// This member is required.
	Type GuardrailManagedWordsType

	noSmithyDocumentSerde
}

// The PII entity configured for the guardrail.
type GuardrailPiiEntity struct {

	// The configured guardrail action when PII entity is detected.
	//
	// This member is required.
	Action GuardrailSensitiveInformationAction

	// The type of PII entity. For example, Social Security Number.
	//
	// This member is required.
	Type GuardrailPiiEntityType

	noSmithyDocumentSerde
}

// The PII entity to configure for the guardrail.
type GuardrailPiiEntityConfig struct {

	// Configure guardrail action when the PII entity is detected.
	//
	// This member is required.
	Action GuardrailSensitiveInformationAction

	// Configure guardrail type when the PII entity is detected.
	//
	// The following PIIs are used to block or mask sensitive information:
	//
	//   - General
	//
	//   - ADDRESS
	//
	// A physical address, such as "100 Main Street, Anytown, USA" or "Suite #12,
	//   Building 123". An address can include information such as the street, building,
	//   location, city, state, country, county, zip code, precinct, and neighborhood.
	//
	//   - AGE
	//
	// An individual's age, including the quantity and unit of time. For example, in
	//   the phrase "I am 40 years old," Guardrails recognizes "40 years" as an age.
	//
	//   - NAME
	//
	// An individual's name. This entity type does not include titles, such as Dr.,
	//   Mr., Mrs., or Miss. guardrails doesn't apply this entity type to names that are
	//   part of organizations or addresses. For example, guardrails recognizes the "John
	//   Doe Organization" as an organization, and it recognizes "Jane Doe Street" as an
	//   address.
	//
	//   - EMAIL
	//
	// An email address, such as marymajor@email.com.
	//
	//   - PHONE
	//
	// A phone number. This entity type also includes fax and pager numbers.
	//
	//   - USERNAME
	//
	// A user name that identifies an account, such as a login name, screen name, nick
	//   name, or handle.
	//
	//   - PASSWORD
	//
	// An alphanumeric string that is used as a password, such as
	//   "*very20special#pass*".
	//
	//   - DRIVER_ID
	//
	// The number assigned to a driver's license, which is an official document
	//   permitting an individual to operate one or more motorized vehicles on a public
	//   road. A driver's license number consists of alphanumeric characters.
	//
	//   - LICENSE_PLATE
	//
	// A license plate for a vehicle is issued by the state or country where the
	//   vehicle is registered. The format for passenger vehicles is typically five to
	//   eight digits, consisting of upper-case letters and numbers. The format varies
	//   depending on the location of the issuing state or country.
	//
	//   - VEHICLE_IDENTIFICATION_NUMBER
	//
	// A Vehicle Identification Number (VIN) uniquely identifies a vehicle. VIN
	//   content and format are defined in the ISO 3779 specification. Each country has
	//   specific codes and formats for VINs.
	//
	//   - Finance
	//
	//   - CREDIT_DEBIT_CARD_CVV
	//
	// A three-digit card verification code (CVV) that is present on VISA, MasterCard,
	//   and Discover credit and debit cards. For American Express credit or debit cards,
	//   the CVV is a four-digit numeric code.
	//
	//   - CREDIT_DEBIT_CARD_EXPIRY
	//
	// The expiration date for a credit or debit card. This number is usually four
	//   digits long and is often formatted as month/year or MM/YY. Guardrails recognizes
	//   expiration dates such as 01/21, 01/2021, and Jan 2021.
	//
	//   - CREDIT_DEBIT_CARD_NUMBER
	//
	// The number for a credit or debit card. These numbers can vary from 13 to 16
	//   digits in length. However, Amazon Comprehend also recognizes credit or debit
	//   card numbers when only the last four digits are present.
	//
	//   - PIN
	//
	// A four-digit personal identification number (PIN) with which you can access
	//   your bank account.
	//
	//   - INTERNATIONAL_BANK_ACCOUNT_NUMBER
	//
	// An International Bank Account Number has specific formats in each country. For
	//   more information, see [www.iban.com/structure].
	//
	//   - SWIFT_CODE
	//
	// A SWIFT code is a standard format of Bank Identifier Code (BIC) used to specify
	//   a particular bank or branch. Banks use these codes for money transfers such as
	//   international wire transfers.
	//
	// SWIFT codes consist of eight or 11 characters. The 11-digit codes refer to
	//   specific branches, while eight-digit codes (or 11-digit codes ending in 'XXX')
	//   refer to the head or primary office.
	//
	//   - IT
	//
	//   - IP_ADDRESS
	//
	// An IPv4 address, such as 198.51.100.0.
	//
	//   - MAC_ADDRESS
	//
	// A media access control (MAC) address is a unique identifier assigned to a
	//   network interface controller (NIC).
	//
	//   - URL
	//
	// A web address, such as www.example.com.
	//
	//   - AWS_ACCESS_KEY
	//
	// A unique identifier that's associated with a secret access key; you use the
	//   access key ID and secret access key to sign programmatic Amazon Web Services
	//   requests cryptographically.
	//
	//   - AWS_SECRET_KEY
	//
	// A unique identifier that's associated with an access key. You use the access
	//   key ID and secret access key to sign programmatic Amazon Web Services requests
	//   cryptographically.
	//
	//   - USA specific
	//
	//   - US_BANK_ACCOUNT_NUMBER
	//
	// A US bank account number, which is typically 10 to 12 digits long.
	//
	//   - US_BANK_ROUTING_NUMBER
	//
	// A US bank account routing number. These are typically nine digits long,
	//
	//   - US_INDIVIDUAL_TAX_IDENTIFICATION_NUMBER
	//
	// A US Individual Taxpayer Identification Number (ITIN) is a nine-digit number
	//   that starts with a "9" and contain a "7" or "8" as the fourth digit. An ITIN can
	//   be formatted with a space or a dash after the third and forth digits.
	//
	//   - US_PASSPORT_NUMBER
	//
	// A US passport number. Passport numbers range from six to nine alphanumeric
	//   characters.
	//
	//   - US_SOCIAL_SECURITY_NUMBER
	//
	// A US Social Security Number (SSN) is a nine-digit number that is issued to US
	//   citizens, permanent residents, and temporary working residents.
	//
	//   - Canada specific
	//
	//   - CA_HEALTH_NUMBER
	//
	// A Canadian Health Service Number is a 10-digit unique identifier, required for
	//   individuals to access healthcare benefits.
	//
	//   - CA_SOCIAL_INSURANCE_NUMBER
	//
	// A Canadian Social Insurance Number (SIN) is a nine-digit unique identifier,
	//   required for individuals to access government programs and benefits.
	//
	// The SIN is formatted as three groups of three digits, such as 123-456-789. A
	//   SIN can be validated through a simple check-digit process called the [Luhn algorithm].
	//
	//   - UK Specific
	//
	//   - UK_NATIONAL_HEALTH_SERVICE_NUMBER
	//
	// A UK National Health Service Number is a 10-17 digit number, such as 485 777
	//   3456. The current system formats the 10-digit number with spaces after the third
	//   and sixth digits. The final digit is an error-detecting checksum.
	//
	//   - UK_NATIONAL_INSURANCE_NUMBER
	//
	// A UK National Insurance Number (NINO) provides individuals with access to
	//   National Insurance (social security) benefits. It is also used for some purposes
	//   in the UK tax system.
	//
	// The number is nine digits long and starts with two letters, followed by six
	//   numbers and one letter. A NINO can be formatted with a space or a dash after the
	//   two letters and after the second, forth, and sixth digits.
	//
	//   - UK_UNIQUE_TAXPAYER_REFERENCE_NUMBER
	//
	// A UK Unique Taxpayer Reference (UTR) is a 10-digit number that identifies a
	//   taxpayer or a business.
	//
	//   - Custom
	//
	//   - Regex filter - You can use a regular expressions to define patterns for a
	//   guardrail to recognize and act upon such as serial number, booking ID etc..
	//
	// [Luhn algorithm]: https://www.wikipedia.org/wiki/Luhn_algorithm
	// [www.iban.com/structure]: https://www.iban.com/structure
	//
	// This member is required.
	Type GuardrailPiiEntityType

	noSmithyDocumentSerde
}

// The regular expression configured for the guardrail.
type GuardrailRegex struct {

	// The action taken when a match to the regular expression is detected.
	//
	// This member is required.
	Action GuardrailSensitiveInformationAction

	// The name of the regular expression for the guardrail.
	//
	// This member is required.
	Name *string

	// The pattern of the regular expression configured for the guardrail.
	//
	// This member is required.
	Pattern *string

	// The description of the regular expression for the guardrail.
	Description *string

	noSmithyDocumentSerde
}

// The regular expression to configure for the guardrail.
type GuardrailRegexConfig struct {

	// The guardrail action to configure when matching regular expression is detected.
	//
	// This member is required.
	Action GuardrailSensitiveInformationAction

	// The name of the regular expression to configure for the guardrail.
	//
	// This member is required.
	Name *string

	// The regular expression pattern to configure for the guardrail.
	//
	// This member is required.
	Pattern *string

	// The description of the regular expression to configure for the guardrail.
	Description *string

	noSmithyDocumentSerde
}

// Contains details about PII entities and regular expressions configured for the
// guardrail.
type GuardrailSensitiveInformationPolicy struct {

	// The list of PII entities configured for the guardrail.
	PiiEntities []GuardrailPiiEntity

	// The list of regular expressions configured for the guardrail.
	Regexes []GuardrailRegex

	noSmithyDocumentSerde
}

// Contains details about PII entities and regular expressions to configure for
// the guardrail.
type GuardrailSensitiveInformationPolicyConfig struct {

	// A list of PII entities to configure to the guardrail.
	PiiEntitiesConfig []GuardrailPiiEntityConfig

	// A list of regular expressions to configure to the guardrail.
	RegexesConfig []GuardrailRegexConfig

	noSmithyDocumentSerde
}

// Contains details about a guardrail.
//
// This data type is used in the following API operations:
//
// [ListGuardrails response body]
//
// [ListGuardrails response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListGuardrails.html#API_ListGuardrails_ResponseSyntax
type GuardrailSummary struct {

	// The ARN of the guardrail.
	//
	// This member is required.
	Arn *string

	// The date and time at which the guardrail was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the guardrail.
	//
	// This member is required.
	Id *string

	// The name of the guardrail.
	//
	// This member is required.
	Name *string

	// The status of the guardrail.
	//
	// This member is required.
	Status GuardrailStatus

	// The date and time at which the guardrail was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the guardrail.
	//
	// This member is required.
	Version *string

	// A description of the guardrail.
	Description *string

	noSmithyDocumentSerde
}

// Details about topics for the guardrail to identify and deny.
//
// This data type is used in the following API operations:
//
// [GetGuardrail response body]
//
// [GetGuardrail response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax
type GuardrailTopic struct {

	// A definition of the topic to deny.
	//
	// This member is required.
	Definition *string

	// The name of the topic to deny.
	//
	// This member is required.
	Name *string

	// A list of prompts, each of which is an example of a prompt that can be
	// categorized as belonging to the topic.
	Examples []string

	// Specifies to deny the topic.
	Type GuardrailTopicType

	noSmithyDocumentSerde
}

// Details about topics for the guardrail to identify and deny.
type GuardrailTopicConfig struct {

	// A definition of the topic to deny.
	//
	// This member is required.
	Definition *string

	// The name of the topic to deny.
	//
	// This member is required.
	Name *string

	// Specifies to deny the topic.
	//
	// This member is required.
	Type GuardrailTopicType

	// A list of prompts, each of which is an example of a prompt that can be
	// categorized as belonging to the topic.
	Examples []string

	noSmithyDocumentSerde
}

// Contains details about topics that the guardrail should identify and deny.
//
// This data type is used in the following API operations:
//
// [GetGuardrail response body]
//
// [GetGuardrail response body]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GetGuardrail.html#API_GetGuardrail_ResponseSyntax
type GuardrailTopicPolicy struct {

	// A list of policies related to topics that the guardrail should deny.
	//
	// This member is required.
	Topics []GuardrailTopic

	noSmithyDocumentSerde
}

// Contains details about topics that the guardrail should identify and deny.
type GuardrailTopicPolicyConfig struct {

	// A list of policies related to topics that the guardrail should deny.
	//
	// This member is required.
	TopicsConfig []GuardrailTopicConfig

	noSmithyDocumentSerde
}

// A word configured for the guardrail.
type GuardrailWord struct {

	// Text of the word configured for the guardrail to block.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// A word to configure for the guardrail.
type GuardrailWordConfig struct {

	// Text of the word configured for the guardrail to block.
	//
	// This member is required.
	Text *string

	noSmithyDocumentSerde
}

// Contains details about the word policy configured for the guardrail.
type GuardrailWordPolicy struct {

	// A list of managed words configured for the guardrail.
	ManagedWordLists []GuardrailManagedWords

	// A list of words configured for the guardrail.
	Words []GuardrailWord

	noSmithyDocumentSerde
}

// Contains details about the word policy to configured for the guardrail.
type GuardrailWordPolicyConfig struct {

	// A list of managed words to configure for the guardrail.
	ManagedWordListsConfig []GuardrailManagedWordsConfig

	// A list of words to configure for the guardrail.
	WordsConfig []GuardrailWordConfig

	noSmithyDocumentSerde
}

// Specifies the custom metrics, how tasks will be rated, the flow definition ARN,
// and your custom prompt datasets. Model evaluation jobs use human workers only
// support the use of custom prompt datasets. To learn more about custom prompt
// datasets and the required format, see [Custom prompt datasets].
//
// When you create custom metrics in HumanEvaluationCustomMetric you must specify
// the metric's name . The list of names specified in the
// HumanEvaluationCustomMetric array, must match the metricNames array of strings
// specified in EvaluationDatasetMetricConfig . For example, if in the
// HumanEvaluationCustomMetric array your specified the names "accuracy",
// "toxicity", "readability" as custom metrics then the metricNames array would
// need to look like the following ["accuracy", "toxicity", "readability"] in
// EvaluationDatasetMetricConfig .
//
// [Custom prompt datasets]: https://docs.aws.amazon.com/bedrock/latest/userguide/model-evaluation-prompt-datasets-custom.html
type HumanEvaluationConfig struct {

	// Use to specify the metrics, task, and prompt dataset to be used in your model
	// evaluation job.
	//
	// This member is required.
	DatasetMetricConfigs []EvaluationDatasetMetricConfig

	// A HumanEvaluationCustomMetric object. It contains the names the metrics, how
	// the metrics are to be evaluated, an optional description.
	CustomMetrics []HumanEvaluationCustomMetric

	// The parameters of the human workflow.
	HumanWorkflowConfig *HumanWorkflowConfig

	noSmithyDocumentSerde
}

// In a model evaluation job that uses human workers you must define the name of
// the metric, and how you want that metric rated ratingMethod , and an optional
// description of the metric.
type HumanEvaluationCustomMetric struct {

	// The name of the metric. Your human evaluators will see this name in the
	// evaluation UI.
	//
	// This member is required.
	Name *string

	// Choose how you want your human workers to evaluation your model. Valid values
	// for rating methods are ThumbsUpDown , IndividualLikertScale ,
	// ComparisonLikertScale , ComparisonChoice , and ComparisonRank
	//
	// This member is required.
	RatingMethod *string

	// An optional description of the metric. Use this parameter to provide more
	// details about the metric.
	Description *string

	noSmithyDocumentSerde
}

// Contains SageMakerFlowDefinition object. The object is used to specify the
// prompt dataset, task type, rating method and metric names.
type HumanWorkflowConfig struct {

	// The Amazon Resource Number (ARN) for the flow definition
	//
	// This member is required.
	FlowDefinitionArn *string

	// Instructions for the flow definition
	Instructions *string

	noSmithyDocumentSerde
}

// Information about the imported model.
type ImportedModelSummary struct {

	// Creation time of the imported model.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the imported model.
	//
	// This member is required.
	ModelArn *string

	// Name of the imported model.
	//
	// This member is required.
	ModelName *string

	// Specifies if the imported model supports converse.
	InstructSupported *bool

	// The architecture of the imported model.
	ModelArchitecture *string

	noSmithyDocumentSerde
}

// Contains information about a model.
type InferenceProfileModel struct {

	// The Amazon Resource Name (ARN) of the model.
	ModelArn *string

	noSmithyDocumentSerde
}

// Contains information about the model or system-defined inference profile that
// is the source for an inference profile..
//
// The following types satisfy this interface:
//
//	InferenceProfileModelSourceMemberCopyFrom
type InferenceProfileModelSource interface {
	isInferenceProfileModelSource()
}

// The ARN of the model or system-defined inference profile that is the source for
// the inference profile.
type InferenceProfileModelSourceMemberCopyFrom struct {
	Value string

	noSmithyDocumentSerde
}

func (*InferenceProfileModelSourceMemberCopyFrom) isInferenceProfileModelSource() {}

// Contains information about an inference profile.
type InferenceProfileSummary struct {

	// The Amazon Resource Name (ARN) of the inference profile.
	//
	// This member is required.
	InferenceProfileArn *string

	// The unique identifier of the inference profile.
	//
	// This member is required.
	InferenceProfileId *string

	// The name of the inference profile.
	//
	// This member is required.
	InferenceProfileName *string

	// A list of information about each model in the inference profile.
	//
	// This member is required.
	Models []InferenceProfileModel

	// The status of the inference profile. ACTIVE means that the inference profile is
	// ready to be used.
	//
	// This member is required.
	Status InferenceProfileStatus

	// The type of the inference profile. The following types are possible:
	//
	//   - SYSTEM_DEFINED – The inference profile is defined by Amazon Bedrock. You can
	//   route inference requests across regions with these inference profiles.
	//
	//   - APPLICATION – The inference profile was created by a user. This type of
	//   inference profile can track metrics and costs when invoking the model in it. The
	//   inference profile may route requests to one or multiple regions.
	//
	// This member is required.
	Type InferenceProfileType

	// The time at which the inference profile was created.
	CreatedAt *time.Time

	// The description of the inference profile.
	Description *string

	// The time at which the inference profile was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Settings for using invocation logs to customize a model.
type InvocationLogsConfig struct {

	// The source of the invocation logs.
	//
	// This member is required.
	InvocationLogSource InvocationLogSource

	// Rules for filtering invocation logs based on request metadata.
	RequestMetadataFilters RequestMetadataFilters

	// Whether to use the model's response for training, or just the prompt. The
	// default value is False .
	UsePromptResponse bool

	noSmithyDocumentSerde
}

// A storage location for invocation logs.
//
// The following types satisfy this interface:
//
//	InvocationLogSourceMemberS3Uri
type InvocationLogSource interface {
	isInvocationLogSource()
}

// The URI of an invocation log in a bucket.
type InvocationLogSourceMemberS3Uri struct {
	Value string

	noSmithyDocumentSerde
}

func (*InvocationLogSourceMemberS3Uri) isInvocationLogSource() {}

// Contains configuration details of the inference for knowledge base retrieval
// and response generation.
type KbInferenceConfig struct {

	// Contains configuration details for text generation using a language model via
	// the RetrieveAndGenerate function.
	TextInferenceConfig *TextInferenceConfig

	noSmithyDocumentSerde
}

// The configuration details for retrieving information from a knowledge base and
// generating responses.
//
// The following types satisfy this interface:
//
//	KnowledgeBaseConfigMemberRetrieveAndGenerateConfig
//	KnowledgeBaseConfigMemberRetrieveConfig
type KnowledgeBaseConfig interface {
	isKnowledgeBaseConfig()
}

// Contains configuration details for retrieving information from a knowledge base
// and generating responses.
type KnowledgeBaseConfigMemberRetrieveAndGenerateConfig struct {
	Value RetrieveAndGenerateConfiguration

	noSmithyDocumentSerde
}

func (*KnowledgeBaseConfigMemberRetrieveAndGenerateConfig) isKnowledgeBaseConfig() {}

// Contains configuration details for retrieving information from a knowledge base.
type KnowledgeBaseConfigMemberRetrieveConfig struct {
	Value RetrieveConfig

	noSmithyDocumentSerde
}

func (*KnowledgeBaseConfigMemberRetrieveConfig) isKnowledgeBaseConfig() {}

// Contains configuration details for retrieving information from a knowledge base.
type KnowledgeBaseRetrievalConfiguration struct {

	// Contains configuration details for returning the results from the vector search.
	//
	// This member is required.
	VectorSearchConfiguration *KnowledgeBaseVectorSearchConfiguration

	noSmithyDocumentSerde
}

// Contains configuration details for retrieving information from a knowledge base
// and generating responses.
type KnowledgeBaseRetrieveAndGenerateConfiguration struct {

	// The unique identifier of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// The Amazon Resource Name (ARN) of the foundation model or [inference profile] used to generate
	// responses.
	//
	// [inference profile]: https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html
	//
	// This member is required.
	ModelArn *string

	// Contains configurations details for response generation based on retrieved text
	// chunks.
	GenerationConfiguration *GenerationConfiguration

	// Contains configuration details for the model to process the prompt prior to
	// retrieval and response generation.
	OrchestrationConfiguration *OrchestrationConfiguration

	// Contains configuration details for retrieving text chunks.
	RetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// The configuration details for returning the results from the knowledge base
// vector search.
type KnowledgeBaseVectorSearchConfiguration struct {

	// Specifies the filters to use on the metadata fields in the knowledge base data
	// sources before returning results.
	Filter RetrievalFilter

	// The number of text chunks to retrieve; the number of results to return.
	NumberOfResults *int32

	// By default, Amazon Bedrock decides a search strategy for you. If you're using
	// an Amazon OpenSearch Serverless vector store that contains a filterable text
	// field, you can specify whether to query the knowledge base with a HYBRID search
	// using both vector embeddings and raw text, or SEMANTIC search using only vector
	// embeddings. For other vector store configurations, only SEMANTIC search is
	// available.
	OverrideSearchType SearchType

	noSmithyDocumentSerde
}

// Configuration fields for invocation logging.
type LoggingConfig struct {

	// CloudWatch logging configuration.
	CloudWatchConfig *CloudWatchConfig

	// Set to include embeddings data in the log delivery.
	EmbeddingDataDeliveryEnabled *bool

	// Set to include image data in the log delivery.
	ImageDataDeliveryEnabled *bool

	// S3 configuration for storing log data.
	S3Config *S3Config

	// Set to include text data in the log delivery.
	TextDataDeliveryEnabled *bool

	// Set to include video data in the log delivery.
	VideoDataDeliveryEnabled *bool

	noSmithyDocumentSerde
}

// Contains details about an endpoint for a model from Amazon Bedrock Marketplace.
type MarketplaceModelEndpoint struct {

	// The timestamp when the endpoint was registered.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The configuration of the endpoint, including the number and type of instances
	// used.
	//
	// This member is required.
	EndpointConfig EndpointConfig

	// The current status of the endpoint (e.g., Creating, InService, Updating,
	// Failed).
	//
	// This member is required.
	EndpointStatus *string

	// The ARN of the model from Amazon Bedrock Marketplace that is deployed on this
	// endpoint.
	//
	// This member is required.
	ModelSourceIdentifier *string

	// The timestamp when the endpoint was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Additional information about the endpoint status, if available.
	EndpointStatusMessage *string

	// The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE,
	// INACTIVE).
	Status Status

	// Additional information about the overall status, if available.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Provides a summary of an endpoint for a model from Amazon Bedrock Marketplace.
type MarketplaceModelEndpointSummary struct {

	// The timestamp when the endpoint was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the endpoint.
	//
	// This member is required.
	EndpointArn *string

	// The ARN of the model from Amazon Bedrock Marketplace that is deployed on this
	// endpoint.
	//
	// This member is required.
	ModelSourceIdentifier *string

	// The timestamp when the endpoint was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The overall status of the endpoint in Amazon Bedrock Marketplace.
	Status Status

	// Additional information about the overall status, if available.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Contains details about each model copy job.
//
// This data type is used in the following API operations:
//
// [ListModelCopyJobs response]
//
// [ListModelCopyJobs response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListModelCopyJobs.html#API_ListModelCopyJobs_ResponseSyntax
type ModelCopyJobSummary struct {

	// The time that the model copy job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resoource Name (ARN) of the model copy job.
	//
	// This member is required.
	JobArn *string

	// The unique identifier of the account that the model being copied originated
	// from.
	//
	// This member is required.
	SourceAccountId *string

	// The Amazon Resource Name (ARN) of the original model being copied.
	//
	// This member is required.
	SourceModelArn *string

	// The status of the model copy job.
	//
	// This member is required.
	Status ModelCopyJobStatus

	// The Amazon Resource Name (ARN) of the copied model.
	//
	// This member is required.
	TargetModelArn *string

	// If a model fails to be copied, a message describing why the job failed is
	// included here.
	FailureMessage *string

	// The name of the original model being copied.
	SourceModelName *string

	// The Amazon Resource Name (ARN) of the KMS key used to encrypt the copied model.
	TargetModelKmsKeyArn *string

	// The name of the copied model.
	TargetModelName *string

	// Tags associated with the copied model.
	TargetModelTags []Tag

	noSmithyDocumentSerde
}

// Information about one customization job
type ModelCustomizationJobSummary struct {

	// Amazon Resource Name (ARN) of the base model.
	//
	// This member is required.
	BaseModelArn *string

	// Creation time of the custom model.
	//
	// This member is required.
	CreationTime *time.Time

	// Amazon Resource Name (ARN) of the customization job.
	//
	// This member is required.
	JobArn *string

	// Name of the customization job.
	//
	// This member is required.
	JobName *string

	// Status of the customization job.
	//
	// This member is required.
	Status ModelCustomizationJobStatus

	// Amazon Resource Name (ARN) of the custom model.
	CustomModelArn *string

	// Name of the custom model.
	CustomModelName *string

	// Specifies whether to carry out continued pre-training of a model or whether to
	// fine-tune it. For more information, see [Custom models].
	//
	// [Custom models]: https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models.html
	CustomizationType CustomizationType

	// Time that the customization job ended.
	EndTime *time.Time

	// Time that the customization job was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Data source for the imported model.
//
// The following types satisfy this interface:
//
//	ModelDataSourceMemberS3DataSource
type ModelDataSource interface {
	isModelDataSource()
}

// The Amazon S3 data source of the imported model.
type ModelDataSourceMemberS3DataSource struct {
	Value S3DataSource

	noSmithyDocumentSerde
}

func (*ModelDataSourceMemberS3DataSource) isModelDataSource() {}

// Information about the import job.
type ModelImportJobSummary struct {

	// The time import job was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the import job.
	//
	// This member is required.
	JobArn *string

	// The name of the import job.
	//
	// This member is required.
	JobName *string

	// The status of the imported job.
	//
	// This member is required.
	Status ModelImportJobStatus

	// The time when import job ended.
	EndTime *time.Time

	// The Amazon resource Name (ARN) of the imported model.
	ImportedModelArn *string

	// The name of the imported model.
	ImportedModelName *string

	// The time when the import job was last modified.
	LastModifiedTime *time.Time

	noSmithyDocumentSerde
}

// Details about the location of the input to the batch inference job.
//
// The following types satisfy this interface:
//
//	ModelInvocationJobInputDataConfigMemberS3InputDataConfig
type ModelInvocationJobInputDataConfig interface {
	isModelInvocationJobInputDataConfig()
}

// Contains the configuration of the S3 location of the input data.
type ModelInvocationJobInputDataConfigMemberS3InputDataConfig struct {
	Value ModelInvocationJobS3InputDataConfig

	noSmithyDocumentSerde
}

func (*ModelInvocationJobInputDataConfigMemberS3InputDataConfig) isModelInvocationJobInputDataConfig() {
}

// Contains the configuration of the S3 location of the output data.
//
// The following types satisfy this interface:
//
//	ModelInvocationJobOutputDataConfigMemberS3OutputDataConfig
type ModelInvocationJobOutputDataConfig interface {
	isModelInvocationJobOutputDataConfig()
}

// Contains the configuration of the S3 location of the output data.
type ModelInvocationJobOutputDataConfigMemberS3OutputDataConfig struct {
	Value ModelInvocationJobS3OutputDataConfig

	noSmithyDocumentSerde
}

func (*ModelInvocationJobOutputDataConfigMemberS3OutputDataConfig) isModelInvocationJobOutputDataConfig() {
}

// Contains the configuration of the S3 location of the input data.
type ModelInvocationJobS3InputDataConfig struct {

	// The S3 location of the input data.
	//
	// This member is required.
	S3Uri *string

	// The ID of the Amazon Web Services account that owns the S3 bucket containing
	// the input data.
	S3BucketOwner *string

	// The format of the input data.
	S3InputFormat S3InputFormat

	noSmithyDocumentSerde
}

// Contains the configuration of the S3 location of the output data.
type ModelInvocationJobS3OutputDataConfig struct {

	// The S3 location of the output data.
	//
	// This member is required.
	S3Uri *string

	// The ID of the Amazon Web Services account that owns the S3 bucket containing
	// the output data.
	S3BucketOwner *string

	// The unique identifier of the key that encrypts the S3 location of the output
	// data.
	S3EncryptionKeyId *string

	noSmithyDocumentSerde
}

// A summary of a batch inference job.
type ModelInvocationJobSummary struct {

	// Details about the location of the input to the batch inference job.
	//
	// This member is required.
	InputDataConfig ModelInvocationJobInputDataConfig

	// The Amazon Resource Name (ARN) of the batch inference job.
	//
	// This member is required.
	JobArn *string

	// The name of the batch inference job.
	//
	// This member is required.
	JobName *string

	// The unique identifier of the foundation model used for model inference.
	//
	// This member is required.
	ModelId *string

	// Details about the location of the output of the batch inference job.
	//
	// This member is required.
	OutputDataConfig ModelInvocationJobOutputDataConfig

	// The Amazon Resource Name (ARN) of the service role with permissions to carry
	// out and manage batch inference. You can use the console to create a default
	// service role or follow the steps at [Create a service role for batch inference].
	//
	// [Create a service role for batch inference]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-iam-sr.html
	//
	// This member is required.
	RoleArn *string

	// The time at which the batch inference job was submitted.
	//
	// This member is required.
	SubmitTime *time.Time

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientRequestToken *string

	// The time at which the batch inference job ended.
	EndTime *time.Time

	// The time at which the batch inference job times or timed out.
	JobExpirationTime *time.Time

	// The time at which the batch inference job was last modified.
	LastModifiedTime *time.Time

	// If the batch inference job failed, this field contains a message describing why
	// the job failed.
	Message *string

	// The status of the batch inference job.
	//
	// The following statuses are possible:
	//
	//   - Submitted – This job has been submitted to a queue for validation.
	//
	//   - Validating – This job is being validated for the requirements described in [Format and upload your batch inference data]
	//   . The criteria include the following:
	//
	//   - Your IAM service role has access to the Amazon S3 buckets containing your
	//   files.
	//
	//   - Your files are .jsonl files and each individual record is a JSON object in
	//   the correct format. Note that validation doesn't check if the modelInput value
	//   matches the request body for the model.
	//
	//   - Your files fulfill the requirements for file size and number of records.
	//   For more information, see [Quotas for Amazon Bedrock].
	//
	//   - Scheduled – This job has been validated and is now in a queue. The job will
	//   automatically start when it reaches its turn.
	//
	//   - Expired – This job timed out because it was scheduled but didn't begin
	//   before the set timeout duration. Submit a new job request.
	//
	//   - InProgress – This job has begun. You can start viewing the results in the
	//   output S3 location.
	//
	//   - Completed – This job has successfully completed. View the output files in
	//   the output S3 location.
	//
	//   - PartiallyCompleted – This job has partially completed. Not all of your
	//   records could be processed in time. View the output files in the output S3
	//   location.
	//
	//   - Failed – This job has failed. Check the failure message for any further
	//   details. For further assistance, reach out to the [Amazon Web Services Support Center].
	//
	//   - Stopped – This job was stopped by a user.
	//
	//   - Stopping – This job is being stopped by a user.
	//
	// [Format and upload your batch inference data]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-inference-data.html
	// [Quotas for Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/quotas.html
	// [Amazon Web Services Support Center]: https://console.aws.amazon.com/support/home/
	Status ModelInvocationJobStatus

	// The number of hours after which the batch inference job was set to time out.
	TimeoutDurationInHours *int32

	// The configuration of the Virtual Private Cloud (VPC) for the data in the batch
	// inference job. For more information, see [Protect batch inference jobs using a VPC].
	//
	// [Protect batch inference jobs using a VPC]: https://docs.aws.amazon.com/bedrock/latest/userguide/batch-vpc
	VpcConfig *VpcConfig

	noSmithyDocumentSerde
}

// The configuration details for the model to process the prompt prior to
// retrieval and response generation.
type OrchestrationConfiguration struct {

	// Contains configuration details for transforming the prompt.
	//
	// This member is required.
	QueryTransformationConfiguration *QueryTransformationConfiguration

	noSmithyDocumentSerde
}

// S3 Location of the output data.
type OutputDataConfig struct {

	// The S3 URI where the output data is stored.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// Contains performance settings for a model.
type PerformanceConfiguration struct {

	// Specifies whether to use the latency-optimized or standard version of a model
	// or inference profile.
	Latency PerformanceConfigLatency

	noSmithyDocumentSerde
}

// Details about a prompt router.
type PromptRouterSummary struct {

	// The router's fallback model.
	//
	// This member is required.
	FallbackModel *PromptRouterTargetModel

	// The router's models.
	//
	// This member is required.
	Models []PromptRouterTargetModel

	// The router's ARN.
	//
	// This member is required.
	PromptRouterArn *string

	// The router's name.
	//
	// This member is required.
	PromptRouterName *string

	// The router's routing criteria.
	//
	// This member is required.
	RoutingCriteria *RoutingCriteria

	// The router's status.
	//
	// This member is required.
	Status PromptRouterStatus

	// The summary's type.
	//
	// This member is required.
	Type PromptRouterType

	// When the router was created.
	CreatedAt *time.Time

	// The router's description.
	Description *string

	// When the router was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The target model for a prompt router.
type PromptRouterTargetModel struct {

	// The target model's ARN.
	ModelArn *string

	noSmithyDocumentSerde
}

// The template for the prompt that's sent to the model for response generation.
type PromptTemplate struct {

	// The template for the prompt that's sent to the model for response generation.
	// You can include prompt placeholders, which become replaced before the prompt is
	// sent to the model to provide instructions and context to the model. In addition,
	// you can include XML tags to delineate meaningful sections of the prompt
	// template.
	//
	// For more information, see [Knowledge base prompt template] and [Use XML tags with Anthropic Claude models].
	//
	// [Knowledge base prompt template]: https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html
	// [Use XML tags with Anthropic Claude models]: https://docs.anthropic.com/en/docs/build-with-claude/prompt-engineering/use-xml-tags
	TextPromptTemplate *string

	noSmithyDocumentSerde
}

// A summary of information about a Provisioned Throughput.
//
// This data type is used in the following API operations:
//
// [ListProvisionedThroughputs response]
//
// [ListProvisionedThroughputs response]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListProvisionedModelThroughputs.html#API_ListProvisionedModelThroughputs_ResponseSyntax
type ProvisionedModelSummary struct {

	// The time that the Provisioned Throughput was created.
	//
	// This member is required.
	CreationTime *time.Time

	// The Amazon Resource Name (ARN) of the model requested to be associated to this
	// Provisioned Throughput. This value differs from the modelArn if updating hasn't
	// completed.
	//
	// This member is required.
	DesiredModelArn *string

	// The number of model units that was requested to be allocated to the Provisioned
	// Throughput.
	//
	// This member is required.
	DesiredModelUnits *int32

	// The Amazon Resource Name (ARN) of the base model for which the Provisioned
	// Throughput was created, or of the base model that the custom model for which the
	// Provisioned Throughput was created was customized.
	//
	// This member is required.
	FoundationModelArn *string

	// The time that the Provisioned Throughput was last modified.
	//
	// This member is required.
	LastModifiedTime *time.Time

	// The Amazon Resource Name (ARN) of the model associated with the Provisioned
	// Throughput.
	//
	// This member is required.
	ModelArn *string

	// The number of model units allocated to the Provisioned Throughput.
	//
	// This member is required.
	ModelUnits *int32

	// The Amazon Resource Name (ARN) of the Provisioned Throughput.
	//
	// This member is required.
	ProvisionedModelArn *string

	// The name of the Provisioned Throughput.
	//
	// This member is required.
	ProvisionedModelName *string

	// The status of the Provisioned Throughput.
	//
	// This member is required.
	Status ProvisionedModelStatus

	// The duration for which the Provisioned Throughput was committed.
	CommitmentDuration CommitmentDuration

	// The timestamp for when the commitment term of the Provisioned Throughput
	// expires.
	CommitmentExpirationTime *time.Time

	noSmithyDocumentSerde
}

// The configuration details for transforming the prompt.
type QueryTransformationConfiguration struct {

	// The type of transformation to apply to the prompt.
	//
	// This member is required.
	Type QueryTransformationType

	noSmithyDocumentSerde
}

// Contains configuration details for retrieval of information and response
// generation.
//
// The following types satisfy this interface:
//
//	RAGConfigMemberKnowledgeBaseConfig
type RAGConfig interface {
	isRAGConfig()
}

// Contains configuration details for knowledge base retrieval and response
// generation.
type RAGConfigMemberKnowledgeBaseConfig struct {
	Value KnowledgeBaseConfig

	noSmithyDocumentSerde
}

func (*RAGConfigMemberKnowledgeBaseConfig) isRAGConfig() {}

// A mapping of a metadata key to a value that it should or should not equal.
type RequestMetadataBaseFilters struct {

	// Include results where the key equals the value.
	Equals map[string]string

	// Include results where the key does not equal the value.
	NotEquals map[string]string

	noSmithyDocumentSerde
}

// Rules for filtering invocation logs. A filter can be a mapping of a metadata
// key to a value that it should or should not equal (a base filter), or a list of
// base filters that are all applied with AND or OR logical operators
//
// The following types satisfy this interface:
//
//	RequestMetadataFiltersMemberAndAll
//	RequestMetadataFiltersMemberEquals
//	RequestMetadataFiltersMemberNotEquals
//	RequestMetadataFiltersMemberOrAll
type RequestMetadataFilters interface {
	isRequestMetadataFilters()
}

// Include results where all of the based filters match.
type RequestMetadataFiltersMemberAndAll struct {
	Value []RequestMetadataBaseFilters

	noSmithyDocumentSerde
}

func (*RequestMetadataFiltersMemberAndAll) isRequestMetadataFilters() {}

// Include results where the key equals the value.
type RequestMetadataFiltersMemberEquals struct {
	Value map[string]string

	noSmithyDocumentSerde
}

func (*RequestMetadataFiltersMemberEquals) isRequestMetadataFilters() {}

// Include results where the key does not equal the value.
type RequestMetadataFiltersMemberNotEquals struct {
	Value map[string]string

	noSmithyDocumentSerde
}

func (*RequestMetadataFiltersMemberNotEquals) isRequestMetadataFilters() {}

// Include results where any of the base filters match.
type RequestMetadataFiltersMemberOrAll struct {
	Value []RequestMetadataBaseFilters

	noSmithyDocumentSerde
}

func (*RequestMetadataFiltersMemberOrAll) isRequestMetadataFilters() {}

// Specifies the filters to use on the metadata attributes/fields in the knowledge
// base data sources before returning results.
//
// The following types satisfy this interface:
//
//	RetrievalFilterMemberAndAll
//	RetrievalFilterMemberEquals
//	RetrievalFilterMemberGreaterThan
//	RetrievalFilterMemberGreaterThanOrEquals
//	RetrievalFilterMemberIn
//	RetrievalFilterMemberLessThan
//	RetrievalFilterMemberLessThanOrEquals
//	RetrievalFilterMemberListContains
//	RetrievalFilterMemberNotEquals
//	RetrievalFilterMemberNotIn
//	RetrievalFilterMemberOrAll
//	RetrievalFilterMemberStartsWith
//	RetrievalFilterMemberStringContains
type RetrievalFilter interface {
	isRetrievalFilter()
}

// Knowledge base data sources are returned if their metadata attributes fulfill
// all the filter conditions inside this list.
type RetrievalFilterMemberAndAll struct {
	Value []RetrievalFilter

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberAndAll) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value matches the value in this object.
//
// The following example would return data sources with an animal attribute whose
// value is 'cat': "equals": { "key": "animal", "value": "cat" }
type RetrievalFilterMemberEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is greater than the value in this
// object.
//
// The following example would return data sources with an year attribute whose
// value is greater than '1989': "greaterThan": { "key": "year", "value": 1989 }
type RetrievalFilterMemberGreaterThan struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberGreaterThan) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is greater than or equal to the value
// in this object.
//
// The following example would return data sources with an year attribute whose
// value is greater than or equal to '1989': "greaterThanOrEquals": { "key":
// "year", "value": 1989 }
type RetrievalFilterMemberGreaterThanOrEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberGreaterThanOrEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is in the list specified in the value
// in this object.
//
// The following example would return data sources with an animal attribute that
// is either 'cat' or 'dog': "in": { "key": "animal", "value": ["cat", "dog"] }
type RetrievalFilterMemberIn struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberIn) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is less than the value in this
// object.
//
// The following example would return data sources with an year attribute whose
// value is less than to '1989': "lessThan": { "key": "year", "value": 1989 }
type RetrievalFilterMemberLessThan struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberLessThan) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is less than or equal to the value in
// this object.
//
// The following example would return data sources with an year attribute whose
// value is less than or equal to '1989': "lessThanOrEquals": { "key": "year",
// "value": 1989 }
type RetrievalFilterMemberLessThanOrEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberLessThanOrEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is a list that contains the value as
// one of its members.
//
// The following example would return data sources with an animals attribute that
// is a list containing a cat member (for example, ["dog", "cat"] ):
// "listContains": { "key": "animals", "value": "cat" }
type RetrievalFilterMemberListContains struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberListContains) isRetrievalFilter() {}

// Knowledge base data sources that contain a metadata attribute whose name
// matches the key and whose value doesn't match the value in this object are
// returned.
//
// The following example would return data sources that don't contain an animal
// attribute whose value is 'cat': "notEquals": { "key": "animal", "value": "cat" }
type RetrievalFilterMemberNotEquals struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberNotEquals) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value isn't in the list specified in the
// value in this object.
//
// The following example would return data sources whose animal attribute is
// neither 'cat' nor 'dog': "notIn": { "key": "animal", "value": ["cat", "dog"] }
type RetrievalFilterMemberNotIn struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberNotIn) isRetrievalFilter() {}

// Knowledge base data sources are returned if their metadata attributes fulfill
// at least one of the filter conditions inside this list.
type RetrievalFilterMemberOrAll struct {
	Value []RetrievalFilter

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberOrAll) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value starts with the value in this object.
// This filter is currently only supported for Amazon OpenSearch Serverless vector
// stores.
//
// The following example would return data sources with an animal attribute starts
// with 'ca' (for example, 'cat' or 'camel'). "startsWith": { "key": "animal",
// "value": "ca" }
type RetrievalFilterMemberStartsWith struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberStartsWith) isRetrievalFilter() {}

// Knowledge base data sources are returned if they contain a metadata attribute
// whose name matches the key and whose value is one of the following:
//
// A string that contains the value as a substring. The following example would
// return data sources with an animal attribute that contains the substring at (for
// example, 'cat'): "stringContains": { "key": "animal", "value": "at" }
//
// A list with a member that contains the value as a substring. The following
// example would return data sources with an animals attribute that is a list
// containing a member that contains the substring at (for example, ["dog", "cat"]
// ): "stringContains": { "key": "animals", "value": "at" }
type RetrievalFilterMemberStringContains struct {
	Value FilterAttribute

	noSmithyDocumentSerde
}

func (*RetrievalFilterMemberStringContains) isRetrievalFilter() {}

// Contains configuration details for a knowledge base retrieval and response
// generation.
type RetrieveAndGenerateConfiguration struct {

	// The type of resource that contains your data for retrieving information and
	// generating responses.
	//
	// If you choose to use EXTERNAL_SOURCES , then currently only Claude 3 Sonnet
	// models for knowledge bases are supported.
	//
	// This member is required.
	Type RetrieveAndGenerateType

	// The configuration for the external source wrapper object in the
	// retrieveAndGenerate function.
	ExternalSourcesConfiguration *ExternalSourcesRetrieveAndGenerateConfiguration

	// Contains configuration details for the knowledge base retrieval and response
	// generation.
	KnowledgeBaseConfiguration *KnowledgeBaseRetrieveAndGenerateConfiguration

	noSmithyDocumentSerde
}

// The configuration details for retrieving information from a knowledge base.
type RetrieveConfig struct {

	// The unique identifier of the knowledge base.
	//
	// This member is required.
	KnowledgeBaseId *string

	// Contains configuration details for knowledge base retrieval.
	//
	// This member is required.
	KnowledgeBaseRetrievalConfiguration *KnowledgeBaseRetrievalConfiguration

	noSmithyDocumentSerde
}

// Routing criteria for a prompt router.
type RoutingCriteria struct {

	// The criteria's response quality difference.
	//
	// This member is required.
	ResponseQualityDifference *float64

	noSmithyDocumentSerde
}

// S3 configuration for storing log data.
type S3Config struct {

	// S3 bucket name.
	//
	// This member is required.
	BucketName *string

	// S3 prefix.
	KeyPrefix *string

	noSmithyDocumentSerde
}

// The Amazon S3 data source of the imported job.
type S3DataSource struct {

	// The URI of the Amazon S3 data source.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// The unique wrapper object of the document from the S3 location.
type S3ObjectDoc struct {

	// The S3 URI location for the wrapper object of the document.
	//
	// This member is required.
	Uri *string

	noSmithyDocumentSerde
}

// Specifies the configuration for a Amazon SageMaker endpoint.
type SageMakerEndpoint struct {

	// The ARN of the IAM role that Amazon SageMaker can assume to access model
	// artifacts and docker image for deployment on Amazon EC2 compute instances or for
	// batch transform jobs.
	//
	// This member is required.
	ExecutionRole *string

	// The number of Amazon EC2 compute instances to deploy for initial endpoint
	// creation.
	//
	// This member is required.
	InitialInstanceCount *int32

	// The Amazon EC2 compute instance type to deploy for hosting the model.
	//
	// This member is required.
	InstanceType *string

	// The Amazon Web Services KMS key that Amazon SageMaker uses to encrypt data on
	// the storage volume attached to the Amazon EC2 compute instance that hosts the
	// endpoint.
	KmsEncryptionKey *string

	// The VPC configuration for the endpoint.
	Vpc *VpcConfig

	noSmithyDocumentSerde
}

// Definition of the key/value pair for a tag.
type Tag struct {

	// Key for the tag.
	//
	// This member is required.
	Key *string

	// Value for the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Details about a teacher model used for model customization.
type TeacherModelConfig struct {

	// The identifier of the teacher model.
	//
	// This member is required.
	TeacherModelIdentifier *string

	// The maximum number of tokens requested when the customization job invokes the
	// teacher model.
	MaxResponseLengthForInference *int32

	noSmithyDocumentSerde
}

// The configuration details for text generation using a language model via the
// RetrieveAndGenerate function.
type TextInferenceConfig struct {

	// The maximum number of tokens to generate in the output text. Do not use the
	// minimum of 0 or the maximum of 65536. The limit values described here are
	// arbitrary values, for actual values consult the limits defined by your specific
	// model.
	MaxTokens *int32

	// A list of sequences of characters that, if generated, will cause the model to
	// stop generating further tokens. Do not use a minimum length of 1 or a maximum
	// length of 1000. The limit values described here are arbitrary values, for actual
	// values consult the limits defined by your specific model.
	StopSequences []string

	// Controls the random-ness of text generated by the language model, influencing
	// how much the model sticks to the most predictable next words versus exploring
	// more surprising options. A lower temperature value (e.g. 0.2 or 0.3) makes model
	// outputs more deterministic or predictable, while a higher temperature (e.g. 0.8
	// or 0.9) makes the outputs more creative or unpredictable.
	Temperature *float32

	// A probability distribution threshold which controls what the model considers
	// for the set of possible next tokens. The model will only consider the top p% of
	// the probability distribution when generating the next token.
	TopP *float32

	noSmithyDocumentSerde
}

// S3 Location of the training data.
type TrainingDataConfig struct {

	// Settings for using invocation logs to customize a model.
	InvocationLogsConfig *InvocationLogsConfig

	// The S3 URI where the training data is stored.
	S3Uri *string

	noSmithyDocumentSerde
}

// Metrics associated with the custom job.
type TrainingMetrics struct {

	// Loss metric associated with the custom job.
	TrainingLoss *float32

	noSmithyDocumentSerde
}

// Array of up to 10 validators.
type ValidationDataConfig struct {

	// Information about the validators.
	//
	// This member is required.
	Validators []Validator

	noSmithyDocumentSerde
}

// Information about a validator.
type Validator struct {

	// The S3 URI where the validation data is stored.
	//
	// This member is required.
	S3Uri *string

	noSmithyDocumentSerde
}

// The metric for the validator.
type ValidatorMetric struct {

	// The validation loss associated with this validator.
	ValidationLoss *float32

	noSmithyDocumentSerde
}

// The configuration of a virtual private cloud (VPC). For more information, see [Protect your data using Amazon Virtual Private Cloud and Amazon Web Services PrivateLink].
//
// [Protect your data using Amazon Virtual Private Cloud and Amazon Web Services PrivateLink]: https://docs.aws.amazon.com/bedrock/latest/userguide/usingVPC.html
type VpcConfig struct {

	// An array of IDs for each security group in the VPC to use.
	//
	// This member is required.
	SecurityGroupIds []string

	// An array of IDs for each subnet in the VPC to use.
	//
	// This member is required.
	SubnetIds []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isCustomizationConfig()                {}
func (*UnknownUnionMember) isEndpointConfig()                     {}
func (*UnknownUnionMember) isEvaluationConfig()                   {}
func (*UnknownUnionMember) isEvaluationDatasetLocation()          {}
func (*UnknownUnionMember) isEvaluationInferenceConfig()          {}
func (*UnknownUnionMember) isEvaluationModelConfig()              {}
func (*UnknownUnionMember) isEvaluatorModelConfig()               {}
func (*UnknownUnionMember) isInferenceProfileModelSource()        {}
func (*UnknownUnionMember) isInvocationLogSource()                {}
func (*UnknownUnionMember) isKnowledgeBaseConfig()                {}
func (*UnknownUnionMember) isModelDataSource()                    {}
func (*UnknownUnionMember) isModelInvocationJobInputDataConfig()  {}
func (*UnknownUnionMember) isModelInvocationJobOutputDataConfig() {}
func (*UnknownUnionMember) isRAGConfig()                          {}
func (*UnknownUnionMember) isRequestMetadataFilters()             {}
func (*UnknownUnionMember) isRetrievalFilter()                    {}
