// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a prompt flow that you can use to send an input through various steps
// to yield an output. Configure nodes, each of which corresponds to a step of the
// flow, and create connections between the nodes to create paths to different
// outputs. For more information, see [How it works]and [Create a flow in Amazon Bedrock] in the Amazon Bedrock User Guide.
//
// [How it works]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html
// [Create a flow in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html
func (c *Client) CreateFlow(ctx context.Context, params *CreateFlowInput, optFns ...func(*Options)) (*CreateFlowOutput, error) {
	if params == nil {
		params = &CreateFlowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFlow", params, optFns, c.addOperationCreateFlowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFlowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFlowInput struct {

	// The Amazon Resource Name (ARN) of the service role with permissions to create
	// and manage a flow. For more information, see [Create a service role for flows in Amazon Bedrock]in the Amazon Bedrock User Guide.
	//
	// [Create a service role for flows in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html
	//
	// This member is required.
	ExecutionRoleArn *string

	// A name for the flow.
	//
	// This member is required.
	Name *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// The Amazon Resource Name (ARN) of the KMS key to encrypt the flow.
	CustomerEncryptionKeyArn *string

	// A definition of the nodes and connections between nodes in the flow.
	Definition *types.FlowDefinition

	// A description for the flow.
	Description *string

	// Any tags that you want to attach to the flow. For more information, see [Tagging resources in Amazon Bedrock].
	//
	// [Tagging resources in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateFlowOutput struct {

	// The Amazon Resource Name (ARN) of the flow.
	//
	// This member is required.
	Arn *string

	// The time at which the flow was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the service role with permissions to create a
	// flow. For more information, see [Create a service role for flows in Amazon Bedrock]in the Amazon Bedrock User Guide.
	//
	// [Create a service role for flows in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html
	//
	// This member is required.
	ExecutionRoleArn *string

	// The unique identifier of the flow.
	//
	// This member is required.
	Id *string

	// The name of the flow.
	//
	// This member is required.
	Name *string

	// The status of the flow. When you submit this request, the status will be
	// NotPrepared . If creation fails, the status becomes Failed .
	//
	// This member is required.
	Status types.FlowStatus

	// The time at which the flow was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The version of the flow. When you create a flow, the version created is the
	// DRAFT version.
	//
	// This member is required.
	Version *string

	// The Amazon Resource Name (ARN) of the KMS key that you encrypted the flow with.
	CustomerEncryptionKeyArn *string

	// A definition of the nodes and connections between nodes in the flow.
	Definition *types.FlowDefinition

	// The description of the flow.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFlowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateFlow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateFlow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateFlow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateFlowMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateFlowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFlow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateFlow struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateFlow) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateFlowInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateFlowMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateFlow{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateFlow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateFlow",
	}
}
